/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.util.internal.CaseIgnoringComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpMessage
implements HttpMessage {
    private final HttpVersion version;
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(CaseIgnoringComparator.INSTANCE);
    private ChannelBuffer content = ChannelBuffers.EMPTY_BUFFER;

    protected DefaultHttpMessage(HttpVersion version) {
        if (version == null) {
            throw new NullPointerException("version");
        }
        this.version = version;
    }

    @Override
    public void addHeader(String name, String value) {
        DefaultHttpMessage.validateHeaderName(name);
        DefaultHttpMessage.validateHeaderValue(value);
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        if (this.headers.get(name) == null) {
            this.headers.put(name, new ArrayList(1));
        }
        this.headers.get(name).add(value);
    }

    @Override
    public void setHeader(String name, String value) {
        DefaultHttpMessage.validateHeaderName(name);
        DefaultHttpMessage.validateHeaderValue(value);
        if (value == null) {
            throw new NullPointerException("value");
        }
        ArrayList<String> values = new ArrayList<String>(1);
        values.add(value);
        this.headers.put(name, values);
    }

    @Override
    public void setHeader(String name, Iterable<String> values) {
        DefaultHttpMessage.validateHeaderName(name);
        if (values == null) {
            throw new NullPointerException("values");
        }
        int nValues = 0;
        for (String v : values) {
            DefaultHttpMessage.validateHeaderValue(v);
            ++nValues;
        }
        if (nValues == 0) {
            throw new IllegalArgumentException("values is empty.");
        }
        if (values instanceof List) {
            this.headers.put(name, (List)values);
        } else {
            LinkedList<String> valueList = new LinkedList<String>();
            for (String v : values) {
                valueList.add(v);
            }
            this.headers.put(name, valueList);
        }
    }

    private static void validateHeaderName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c > '\u007f') {
                throw new IllegalArgumentException("name contains non-ascii character: " + name);
            }
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    throw new IllegalArgumentException("name contains one of the following prohibited characters: =,;: \\t\\r\\n\\v\\f: " + name);
                }
            }
        }
    }

    private static void validateHeaderValue(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': {
                    throw new IllegalArgumentException("value contains one of the following prohibited characters: \\r\\n\\v\\f: " + value);
                }
            }
        }
    }

    @Override
    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    @Override
    public long getContentLength() {
        return this.getContentLength(0L);
    }

    @Override
    public long getContentLength(long defaultValue) {
        List<String> contentLength = this.headers.get("Content-Length");
        if (contentLength != null && contentLength.size() > 0) {
            return Long.parseLong(contentLength.get(0));
        }
        return defaultValue;
    }

    @Override
    public boolean isChunked() {
        List<String> chunked = this.headers.get("Transfer-Encoding");
        if (chunked == null || chunked.isEmpty()) {
            return false;
        }
        for (String v : chunked) {
            if (!v.equalsIgnoreCase("chunked")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isKeepAlive() {
        if ("close".equalsIgnoreCase(this.getHeader("Connection"))) {
            return false;
        }
        return !this.getProtocolVersion().equals(HttpVersion.HTTP_1_0) || "keep-alive".equalsIgnoreCase(this.getHeader("Connection"));
    }

    @Override
    public void clearHeaders() {
        this.headers.clear();
    }

    @Override
    public void setContent(ChannelBuffer content) {
        if (content == null) {
            content = ChannelBuffers.EMPTY_BUFFER;
        }
        this.content = content;
    }

    @Override
    public String getHeader(String name) {
        List<String> header = this.headers.get(name);
        return header != null && header.size() > 0 ? this.headers.get(name).get(0) : null;
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.headers.get(name);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    @Override
    public HttpVersion getProtocolVersion() {
        return this.version;
    }

    @Override
    public ChannelBuffer getContent() {
        return this.content;
    }
}

