/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.stream;

import java.util.Queue;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.stream.ChunkedInput;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.internal.LinkedTransferQueue;

@ChannelPipelineCoverage(value="one")
public class ChunkedWriteHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChunkedWriteHandler.class);
    private final Queue<MessageEvent> queue = new LinkedTransferQueue<MessageEvent>();
    private MessageEvent currentEvent;

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (!(e instanceof MessageEvent)) {
            ctx.sendDownstream(e);
            return;
        }
        this.queue.offer((MessageEvent)e);
        if (ctx.getChannel().isWritable()) {
            this.flushWriteEventQueue(ctx);
        }
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        ChannelStateEvent cse;
        if (e instanceof ChannelStateEvent && (cse = (ChannelStateEvent)e).getState() == ChannelState.INTEREST_OPS && ctx.getChannel().isWritable()) {
            this.flushWriteEventQueue(ctx);
        }
        ctx.sendUpstream(e);
    }

    private synchronized void flushWriteEventQueue(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.getChannel();
        do {
            if (this.currentEvent == null) {
                this.currentEvent = this.queue.poll();
            }
            if (this.currentEvent == null) break;
            Object m = this.currentEvent.getMessage();
            if (m instanceof ChunkedInput) {
                boolean last;
                Object chunk;
                ChunkedInput chunks = (ChunkedInput)m;
                try {
                    chunk = chunks.nextChunk();
                    last = !chunks.hasNextChunk();
                }
                catch (Throwable t) {
                    this.currentEvent.getFuture().setFailure(t);
                    Channels.fireExceptionCaught(ctx, t);
                    try {
                        chunks.close();
                    }
                    catch (Throwable t2) {
                        logger.warn("Failed to close a chunked input.", t2);
                    }
                    break;
                }
                if (chunk != null) {
                    ChannelFuture writeFuture;
                    final MessageEvent currentEvent = this.currentEvent;
                    if (last) {
                        this.currentEvent = null;
                        writeFuture = currentEvent.getFuture();
                        writeFuture.addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                ((ChunkedInput)currentEvent.getMessage()).close();
                            }
                        });
                    } else {
                        writeFuture = Channels.future(channel);
                        writeFuture.addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (!future.isSuccess()) {
                                    currentEvent.getFuture().setFailure(future.getCause());
                                    ((ChunkedInput)currentEvent.getMessage()).close();
                                }
                            }
                        });
                    }
                    Channels.write(ctx, writeFuture, chunk, currentEvent.getRemoteAddress());
                    continue;
                }
                this.currentEvent = null;
                continue;
            }
            ctx.sendDownstream(this.currentEvent);
            this.currentEvent = null;
        } while (channel.isWritable());
    }
}

