# Copyright (c) 2004 Divmod.
# See LICENSE for details.

from nevow import context
from nevow import tags
from nevow import compy
from nevow import inevow

from nevow.testutil import TestCase


class IStuff(compy.Interface): pass


class TestRememberLocate(TestCase):
    def test_basic(self):
        top = context.WovenContext()
        middle = context.WovenContext(top, tags.invisible())
        bottom = context.WovenContext(middle, tags.invisible())
        top.remember(0, IStuff)
        self.assertEquals(bottom.locate(IStuff), 0)
        middle.remember(1, IStuff)
        self.assertEquals(bottom.locate(IStuff), 1)
        self.assertEquals(bottom.locate(IStuff, depth=2), 0)

    def test_reverse(self):
        top = context.WovenContext().remember(0, IStuff)
        bottom = context.WovenContext(top, tags.invisible()).remember(1, IStuff)
        self.assertEquals(bottom.locate(IStuff, depth=-1), 0)

    def test_page(self):
        page = context.PageContext(tag=1)
        ctx = WovenContext(page, tags.invisible())
        self.assertEquals(ctx.locate(inevow.IData), 1)
        ## Right now this causes an infinite loop.
        self.assertEquals(ctx.locate(inevow.IData, depth=-1))
    test_page.skip = 'Infinite loop.'
