#!/usr/bin/env python2.3
# -*- test-case-name: "nevow.test -xformless.test" -*-

from distutils.command import install
from distutils.core import setup

for scheme in install.INSTALL_SCHEMES.values():
    scheme['data'] = scheme['purelib']

setup(
    author='Donovan Preston et al',
    author_email='dp@divmod.org',
    name='nevow',
    version='0.4.1',
    description='Web Application Construction Kit',
    url='http://www.nevow.com/',
    packages=['formless', 'formless.test', 'nevow', 'nevow.flat',
              'nevow.scripts', 'nevow.test', 'nevow.taglibrary'],
    scripts=['bin/nevow-xmlgettext'],
    data_files=[
        ['formless', [
            'formless/freeform-default.css']],
        ['nevow', [
            'nevow/liveevil.js',
            'nevow/liveglue.js',
            'nevow/livetest.js',
            'nevow/livetest-postscripts.js',
            'nevow/livetest.css',
            'nevow/Canvas.swf']],
        ['nevow/taglibrary', [
            'nevow/taglibrary/tabbedPane.js',
            'nevow/taglibrary/tabbedPane-layout.css',
            'nevow/taglibrary/tabbedPane-style.css']]])

