/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/CafCoreTypesXml/StatisticsXml.h"
#include "Doc/DocXml/ResponseXml/EventKeyCollectionXml.h"
#include "Doc/DocXml/ResponseXml/ResponseHeaderXml.h"

#include "Doc/CafCoreTypesDoc/CStatisticsDoc.h"
#include "Doc/ResponseDoc/CEventKeyCollectionDoc.h"
#include "Doc/ResponseDoc/CEventManifestDoc.h"
#include "Doc/ResponseDoc/CProviderEventResponseDoc.h"
#include "Doc/ResponseDoc/CResponseHeaderDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/ResponseXml/ProviderEventResponseXml.h"
#include "Doc/DocXml/ResponseXml/EventManifestXml.h"

using namespace Caf;

void ProviderEventResponseXml::add(
	const SmartPtrCProviderEventResponseDoc providerEventResponseDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProviderEventResponseXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(providerEventResponseDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string pmeIdVal = providerEventResponseDoc->getPmeId();
		CAF_CM_VALIDATE_STRING(pmeIdVal);
		thisXml->addAttribute("pmeId", pmeIdVal);

		const SmartPtrCResponseHeaderDoc responseHeaderVal =
			providerEventResponseDoc->getResponseHeader();
		if (! responseHeaderVal.IsNull()) {
			const SmartPtrCXmlElement responseHeaderXml =
				thisXml->createAndAddElement("responseHeader");
			ResponseHeaderXml::add(responseHeaderVal, responseHeaderXml);
		}

		const SmartPtrCEventManifestDoc manifestVal =
			providerEventResponseDoc->getManifest();
		CAF_CM_VALIDATE_SMARTPTR(manifestVal);

		const SmartPtrCXmlElement manifestXml =
			thisXml->createAndAddElement("manifest");
		EventManifestXml::add(manifestVal, manifestXml);

		const SmartPtrCEventKeyCollectionDoc eventKeyCollectionVal =
			providerEventResponseDoc->getEventKeyCollection();
		if (! eventKeyCollectionVal.IsNull()) {
			const SmartPtrCXmlElement eventKeyCollectionXml =
				thisXml->createAndAddElement("eventKeyCollection");
			EventKeyCollectionXml::add(eventKeyCollectionVal, eventKeyCollectionXml);
		}

		const SmartPtrCStatisticsDoc statisticsVal =
			providerEventResponseDoc->getStatistics();
		if (! statisticsVal.IsNull()) {
			const SmartPtrCXmlElement statisticsXml =
				thisXml->createAndAddElement("statistics");
			StatisticsXml::add(statisticsVal, statisticsXml);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCProviderEventResponseDoc ProviderEventResponseXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProviderEventResponseXml", "parse");

	SmartPtrCProviderEventResponseDoc providerEventResponseDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string pmeIdVal =
			thisXml->findRequiredAttribute("pmeId");

		const SmartPtrCXmlElement responseHeaderXml =
			thisXml->findOptionalChild("responseHeader");
		SmartPtrCResponseHeaderDoc responseHeaderVal;
		if (! responseHeaderXml.IsNull()) {
			responseHeaderVal = ResponseHeaderXml::parse(responseHeaderXml);
		}

		const SmartPtrCXmlElement manifestXml =
			thisXml->findRequiredChild("manifest");
		SmartPtrCEventManifestDoc manifestVal;
		if (! manifestXml.IsNull()) {
			manifestVal = EventManifestXml::parse(manifestXml);
		}

		const SmartPtrCXmlElement eventKeyCollectionXml =
			thisXml->findOptionalChild("eventKeyCollection");
		SmartPtrCEventKeyCollectionDoc eventKeyCollectionVal;
		if (! eventKeyCollectionXml.IsNull()) {
			eventKeyCollectionVal = EventKeyCollectionXml::parse(eventKeyCollectionXml);
		}

		const SmartPtrCXmlElement statisticsXml =
			thisXml->findOptionalChild("statistics");
		SmartPtrCStatisticsDoc statisticsVal;
		if (! statisticsXml.IsNull()) {
			statisticsVal = StatisticsXml::parse(statisticsXml);
		}

		providerEventResponseDoc.CreateInstance();
		providerEventResponseDoc->initialize(
			pmeIdVal,
			responseHeaderVal,
			manifestVal,
			eventKeyCollectionVal,
			statisticsVal);
	}
	CAF_CM_EXIT;

	return providerEventResponseDoc;
}

