/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/ProviderRequestXml/ProviderCollectInstancesCollectionXml.h"
#include "Doc/DocXml/ProviderRequestXml/ProviderInvokeOperationCollectionXml.h"

#include "Doc/ProviderRequestDoc/CProviderBatchDoc.h"
#include "Doc/ProviderRequestDoc/CProviderCollectInstancesCollectionDoc.h"
#include "Doc/ProviderRequestDoc/CProviderInvokeOperationCollectionDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/ProviderRequestXml/ProviderBatchXml.h"

using namespace Caf;

void ProviderBatchXml::add(
	const SmartPtrCProviderBatchDoc providerBatchDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProviderBatchXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(providerBatchDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string outputDirVal = providerBatchDoc->getOutputDir();
		CAF_CM_VALIDATE_STRING(outputDirVal);
		thisXml->addAttribute("outputDir", outputDirVal);

		const SmartPtrCProviderCollectInstancesCollectionDoc collectInstancesCollectionVal =
			providerBatchDoc->getCollectInstancesCollection();
		if (! collectInstancesCollectionVal.IsNull()) {
			const SmartPtrCXmlElement collectInstancesCollectionXml =
				thisXml->createAndAddElement("collectInstancesCollection");
			ProviderCollectInstancesCollectionXml::add(collectInstancesCollectionVal, collectInstancesCollectionXml);
		}

		const SmartPtrCProviderInvokeOperationCollectionDoc invokeOperationCollectionVal =
			providerBatchDoc->getInvokeOperationCollection();
		if (! invokeOperationCollectionVal.IsNull()) {
			const SmartPtrCXmlElement invokeOperationCollectionXml =
				thisXml->createAndAddElement("invokeOperationCollection");
			ProviderInvokeOperationCollectionXml::add(invokeOperationCollectionVal, invokeOperationCollectionXml);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCProviderBatchDoc ProviderBatchXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProviderBatchXml", "parse");

	SmartPtrCProviderBatchDoc providerBatchDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string outputDirStrVal =
			thisXml->findRequiredAttribute("outputDir");
		const std::string outputDirVal = outputDirStrVal;

		const SmartPtrCXmlElement collectInstancesCollectionXml =
			thisXml->findOptionalChild("collectInstancesCollection");

		SmartPtrCProviderCollectInstancesCollectionDoc collectInstancesCollectionVal;
		if (! collectInstancesCollectionXml.IsNull()) {
			collectInstancesCollectionVal = ProviderCollectInstancesCollectionXml::parse(collectInstancesCollectionXml);
		}

		const SmartPtrCXmlElement invokeOperationCollectionXml =
			thisXml->findOptionalChild("invokeOperationCollection");

		SmartPtrCProviderInvokeOperationCollectionDoc invokeOperationCollectionVal;
		if (! invokeOperationCollectionXml.IsNull()) {
			invokeOperationCollectionVal = ProviderInvokeOperationCollectionXml::parse(invokeOperationCollectionXml);
		}

		providerBatchDoc.CreateInstance();
		providerBatchDoc->initialize(
			outputDirVal,
			collectInstancesCollectionVal,
			invokeOperationCollectionVal);
	}
	CAF_CM_EXIT;

	return providerBatchDoc;
}

