/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocUtils/EnumConvertersXml.h"
#include "Doc/CafCoreTypesDoc/CafCoreTypesDocTypes.h"

#include "Doc/CafCoreTypesDoc/CRequestParameterDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafCoreTypesXml/RequestParameterXml.h"

using namespace Caf;

void RequestParameterXml::add(
	const SmartPtrCRequestParameterDoc requestParameterDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("RequestParameterXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(requestParameterDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string nameVal = requestParameterDoc->getName();
		CAF_CM_VALIDATE_STRING(nameVal);
		thisXml->addAttribute("name", nameVal);

		const std::string typeVal =
			EnumConvertersXml::convertParameterTypeToString(requestParameterDoc->getType());
		CAF_CM_VALIDATE_STRING(typeVal);
		thisXml->addAttribute("type", typeVal);

		const std::deque<std::string> valueVal =
			requestParameterDoc->getValue();
		CAF_CM_VALIDATE_STL(valueVal);

		if (! valueVal.empty()) {
			for (TConstIterator<std::deque<std::string> > valueIter(valueVal);
				valueIter; valueIter++) {
				const SmartPtrCXmlElement valueXml =
					thisXml->createAndAddElement("value");
				valueXml->setCDataValue(*valueIter);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCRequestParameterDoc RequestParameterXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("RequestParameterXml", "parse");

	SmartPtrCRequestParameterDoc requestParameterDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string nameStrVal =
			thisXml->findRequiredAttribute("name");
		const std::string nameVal = nameStrVal;

		const std::string typeStrVal =
			thisXml->findRequiredAttribute("type");
		PARAMETER_TYPE typeVal = PARAMETER_NONE;
		if (! typeStrVal.empty()) {
			typeVal = EnumConvertersXml::convertStringToParameterType(typeStrVal);
		}

		const CXmlElement::SmartPtrCElementCollection valueChildrenXml =
			thisXml->findRequiredChildren("value");

		std::deque<std::string> valueVal;
		if (! valueChildrenXml.IsNull() && ! valueChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> valueXmlIter(*valueChildrenXml);
				valueXmlIter; valueXmlIter++) {
				const SmartPtrCXmlElement valueXml = valueXmlIter->second;
				const std::string valueDoc = valueXml->getCDataValue();
				valueVal.push_back(valueDoc);
			}
		}

		requestParameterDoc.CreateInstance();
		requestParameterDoc->initialize(
			nameVal,
			typeVal,
			valueVal);
	}
	CAF_CM_EXIT;

	return requestParameterDoc;
}

