/* cipher.h
 *        Copyright (C) 2003 Timo Schulz
 *
 * This file is part of OpenCDK.
 *
 * OpenCDK is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * OpenCDK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenCDK; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef CDK_CIPHER_H
#define CDK_CIPHER_H

#include "mpi.h"

#define MAX_BLOCKSIZE 16


typedef int (*pk_generate_t) (int algo,
                              unsigned int nbits,
                              unsigned long use_e,
                              cdk_bignum_t *skey,
                              cdk_bignum_t **retfactors);
typedef int (*pk_check_secret_key_t) (int algo, cdk_bignum_t *skey);

typedef int (*pk_encrypt_t) (int algo,
                             cdk_bignum_t *resarr,
                             cdk_bignum_t data,
                             cdk_bignum_t *pkey,
                             int flags);

typedef int (*pk_decrypt_t) (int algo,
                             cdk_bignum_t *result,
                             cdk_bignum_t *data,
                             cdk_bignum_t *skey,
                             int flags);

typedef int (*pk_sign_t) (int algo,
                          cdk_bignum_t *resarr,
                          cdk_bignum_t data,
                          cdk_bignum_t *skey);

typedef int (*pk_verify_t) (int algo,
                            cdk_bignum_t hash,
                            cdk_bignum_t *data,
                            cdk_bignum_t *pkey,
                            int (*cmp)(void *, cdk_bignum_t),
                            void *opaquev);

typedef unsigned (*pk_get_nbits_t) (int algo, cdk_bignum_t *pkey);


typedef int (*cipher_setkey_t) (void *c,
                                const unsigned char *key,
                                unsigned keylen);

typedef void (*cipher_encrypt_t) (void *c,
                                  unsigned char *outbuf,
                                  const unsigned char *inbuf);

typedef void (*cipher_decrypt_t) (void *c,
                                  unsigned char *outbuf,
                                  const unsigned char *inbuf);

typedef struct {
    const char *name;
    char **sexp_names;
    int id;
    const char *elements_pkey;
    const char *elements_skey;
    const char *elements_enc;
    const char *elements_sig;
    const char *elements_grip;
    int use;
    pk_generate_t generate;
    pk_check_secret_key_t check_secret_key;
    pk_encrypt_t encrypt;
    pk_decrypt_t decrypt;
    pk_sign_t sign;
    pk_verify_t verify;
    pk_get_nbits_t get_nbits;  
} pubkey_spec_t;


typedef struct {
    const char *name;
    int id;
    size_t blocksize;
    size_t keylen;
    size_t contextsize;
    cipher_setkey_t setkey;
    cipher_encrypt_t encrypt;
    cipher_decrypt_t decrypt;
} cipher_spec_t;

extern cipher_spec_t cipher_spec_blowfish;
extern cipher_spec_t cipher_spec_twofish;
extern cipher_spec_t cipher_spec_3des;
extern cipher_spec_t cipher_spec_cast5;
extern cipher_spec_t cipher_spec_aes;
extern cipher_spec_t cipher_spec_aes192;
extern cipher_spec_t cipher_spec_aes256;

#endif /*CDK_CIPHER_H*/



