/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "OpenShiva/MetadataLexer_p.h"

class TestMetadataLexer : public GTLTest::Case {
  public:
    TestMetadataLexer() : GTLTest::Case("MetadataLexer") {}
    virtual void runTest()
    {
      std::istringstream iss(" < version: 0; info: < \"bouh\"; \"b\\\"o;\" 12.0 >");
      OpenShiva::MetadataLexer lng(&iss);
      TEST_FOR_TOKEN( INFERIOR );
      TEST_FOR_TOKEN_AND_VALUE_STRICT( IDENTIFIER, string, "version" );
      TEST_FOR_TOKEN( COLON );
      TEST_FOR_TOKEN_AND_VALUE_STRICT( INTEGER_CONSTANT, i, 0);
      TEST_FOR_TOKEN( SEMI );
      TEST_FOR_TOKEN_AND_VALUE_STRICT( IDENTIFIER, string, "info" );
      TEST_FOR_TOKEN( COLON );
      TEST_FOR_TOKEN( INFERIOR );
      TEST_FOR_TOKEN_AND_VALUE_STRICT( STRING_CONSTANT, string, "bouh" );
      TEST_FOR_TOKEN( SEMI );
      TEST_FOR_TOKEN_AND_VALUE_STRICT( STRING_CONSTANT, string, "b\\\"o;" );
      TEST_FOR_TOKEN_AND_VALUE( FLOAT_CONSTANT, f, 12.0);
    }
};
