/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _IMAGE_WRAP_P_H_
#define _IMAGE_WRAP_P_H_

#include "GTLCore/wrappers/StructWrap.h"
#include "OpenShiva/Export.h"

namespace GTLCore {
  class AbstractImage;
}

//---------------------- WARNING ----------------------//
// Whenever the following structure is edited,         //
// it's llvm declaration must be changed too in        //
// Wrapper::createImageType !                          //
//---------------------- WARNING ----------------------//
/**
 * @internal
 * @ingroup OpenShiva
 * Wrapping structure to manipulate an image
 */
struct ImageWrap {
  STRUCT_HEADER
  GTLCore::AbstractImage* image; ///< pointer to the image
  void* memToVec; ///< function to convert from memory to vector
  void* vecToMem; ///< function to convert from vector to memory
  /// Index of the members in the @p GTLCore::Type
  enum ImageIndexes {
    INDEX_IMAGE = 0, ///< index of the image pointer
    INDEX_MEM_TO_VEC = 1, ///< index of the function to convert from memory to vector
    INDEX_VEC_TO_MEM = 2 ///< index of function to convert from vector to memory
  };
  /// Position of member in the memory structure
  enum ImagePoses {
    POS_IMAGE = STRUCT_FIRST_ELEMENT + INDEX_IMAGE, ///< position of the image pointer
    POS_MEM_TO_VEC = STRUCT_FIRST_ELEMENT + INDEX_MEM_TO_VEC, ///< position of the function to convert from memory to vector
    POS_VEC_TO_MEM = STRUCT_FIRST_ELEMENT + INDEX_VEC_TO_MEM ///< position of function to convert from vector to memory
  };
};

extern "C" {
  /**
   * @internal
   * @ingroup OpenShiva
   * @return a pointer to the pixel at coordinated @p x and @p y
   */
  OPENSHIVA_EXPORT char* image_wrap_data( ImageWrap* _imageWrap, int _x, int _y );
  /**
   * @internal
   * @ingroup OpenShiva
   * @return a constant pointer to the pixel at coordinated @p x and @p y
   */
  OPENSHIVA_EXPORT const char* image_wrap_const_data( const ImageWrap* _imageWrap, int _x, int _y );
  /**
   * @internal
   * @ingroup OpenShiva
   * @return the alpha position of an image
   */
  OPENSHIVA_EXPORT int image_alpha_pos( ImageWrap* _imageWrap );
}

#endif
