/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _PIXEL_WRAP_P_H_
#define _PIXEL_WRAP_P_H_

#include "GTLCore/wrappers/StructWrap.h"

//---------------------- WARNING ----------------------//
// Whenever the following structure is edited,         //
// it's llvm declaration must be changed too in        //
// Wrapper::createPixelType !                          //
//---------------------- WARNING ----------------------//
/**
 * @internal
 * @ingroup OpenShiva
 * Wrap the information for a pixel.
 */
struct PixelWrap {
  STRUCT_HEADER
  void* data; ///< pointer to the vector of data (do not access)
  void* coord; ///< pointer to the vector of coordinates (do not access)
  int alphapos; ///< position of the alpha channel
  /**
   * Enum used to access an element
   */
  enum PixelIndexes {
    INDEX_DATA = 0,
    INDEX_COORD = 1,
    INDEX_ALPHAPOS = 2
  };
  /**
   * Position of an element in the structure memory
   */
  enum PixelPoses {
    POS_DATA = STRUCT_FIRST_ELEMENT + INDEX_DATA,
    POS_COORD = STRUCT_FIRST_ELEMENT + INDEX_COORD,
    POS_ALPHAPOS = STRUCT_FIRST_ELEMENT + INDEX_ALPHAPOS
  };
};

#endif
