/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _CONVERT_CENTER_H_
#define _CONVERT_CENTER_H_

#include <utility>

namespace GTLCore {
  namespace AST {
    class ConvertExpression;
    class Expression;
  }
  class Type;
  class ConvertExpressionFactory {
    public:
      ConvertExpressionFactory( );
      virtual ~ConvertExpressionFactory();
      virtual AST::ConvertExpression* create( AST::Expression* value, const GTLCore::Type* _dstType ) const = 0;
      virtual bool canConvertBetween( const GTLCore::Type* srcType, const GTLCore::Type* dstType) const = 0;
    private:
      struct Private;
      Private* const d;
  };
  class ConvertCenter {
    public:
      ConvertCenter();
      ~ConvertCenter();
      /**
       * Convert a value to a given type.
       * If the type of the \a value is allready \a _dstType , the function will return \a value .
       */
      AST::Expression* createConvertExpression( AST::Expression* value, const GTLCore::Type* _dstType ) const;
      /**
       * Create the conversions for binary operations:
       *  - first autoconvert type that needs to be autoconverted.
       *  - then convert the two given values to the highest priority type
       */
      std::pair<AST::Expression*, AST::Expression*> createConvertExpressions( AST::Expression* value1, AST::Expression* value2 ) const;
      void addConvertExpressionFactory( ConvertExpressionFactory* );
      void addAutoConversion( const GTLCore::Type* _srcType, const GTLCore::Type* _dstType );
      /**
       * @return the type to which \a _srcType needs to be converted
       */
      const GTLCore::Type* autoConvertType( const GTLCore::Type* _srcType ) const;
      /**
       */
    private:
      struct Private;
      Private* const d;
  };

}

#endif
