/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "ErrorMessages_p.h"
#include "ErrorMessage.h"

using namespace GTLCore;

ErrorMessage* ErrorMessages::unimplemented(const String& what)
{
  return new ErrorMessage("Unimplemented: " + what);
}

ErrorMessage* ErrorMessages::assigningValueToConstant()
{
  return new ErrorMessage("Can't assign a value to a constant after initialisation.");
}

ErrorMessage* ErrorMessages::variableIsPrimitive()
{
  return new ErrorMessage("The variable is a primitive type.");
}

ErrorMessage* ErrorMessages::variableIsArray()
{
  return new ErrorMessage("The variable is an array.");
}

ErrorMessage* ErrorMessages::variableIsStructure()
{
  return new ErrorMessage("The variable is a structure.");
}

ErrorMessage* ErrorMessages::unknownStructureMember(const String& member)
{
  return new ErrorMessage("Unknown structure member: " + member);
}
