/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "FunctionCaller_p.h"

using namespace GTLCore;

#include "Parameter.h"
#include "Function.h"
#include "GTLCore/Type.h"

#include "FunctionCaller_p_p.h"


struct FunctionCaller::Private {
  llvm::Function* function;
  void* functionPtr;
};

FunctionCaller::FunctionCaller(llvm::Function* llvmFunction, const Function* function) : d(new Private)
{
  d->function = llvmFunction;
  d->functionPtr = 0;
}

FunctionCaller::~FunctionCaller()
{
  delete d;
}

llvm::Function* FunctionCaller::function()
{
  return d->function;
}

FunctionCaller* FunctionCaller::createCaller(llvm::Function* llvmFunction, const Function* function)
{
  return createFunctionCaller( llvmFunction, function );
}

