/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "ModuleData_p.h"

#include "Debug.h"
#include "GTLCore/Function.h"
#include "TypeManager.h"

#include <llvm/Module.h>

using namespace GTLCore;

ModuleData::ModuleData( llvm::Module* llvmModule) : m_llvmModule(llvmModule), m_typeManager(new TypeManager)
{
  
}

ModuleData::~ModuleData()
{
  for( std::map<ScopedName, Function*>::iterator it = m_functions.begin();
       it != m_functions.end(); ++it)
  {
    delete it->second;
  }
  delete m_llvmModule;
  delete m_typeManager;
}

bool ModuleData::appendFunction(const ScopedName& name, Function* function)
{
  GTL_DEBUG(name);
  if( m_functions.find(name) != m_functions.end())
  {
    return false;
  }
  m_functions[name] = function;
  return true;
}

Function* ModuleData::function(const String& _currentNameSpace, const String& _name)
{
  for( std::map<ScopedName, Function*>::iterator it = m_functions.begin();
       it != m_functions.end(); ++it)
  {
    if( (it->first.nameSpace() == "" or it->first.nameSpace() == _currentNameSpace )
        and it->first.name() == _name )
    {
      return it->second;
    }
  }
  return 0;
}

Function* ModuleData::function(const ScopedName& name)
{
  std::map<ScopedName, Function*>::iterator it = m_functions.find(name);
  if( it == m_functions.end())
  {
    return 0;
  } else {
    return it->second;
  }
}

std::list<Function*> ModuleData::functions()
{
  std::list<Function*> functions;
  GTL_DEBUG( m_functions.size());
  for( std::map<ScopedName, Function*>::iterator it = m_functions.begin();
       it != m_functions.end(); ++it)
  {
    functions.push_back(it->second);
  }
  return functions;
}
