/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_WRAPPER_P_H_
#define _OPENSHIVA_WRAPPER_P_H_

#include "GTLCore/Type_p.h"

struct ImageWrap;

namespace llvm {
  class Function;
  class FunctionType;
  class Module;
}

namespace GTLCore {
  class ModuleData;
  class PixelDescription;
  class TypeManager;
  class AbstractImage;
  class ConvertCenter;
}

namespace OpenShiva {
  class Kernel;
  /**
   * @internal
   * This class allows all informations related to wrapped types of OpenShiva : imageX, pixelX and
   * region.
   * @ingroup OpenShiva
   */
  class Wrapper {
    public:
      Wrapper(Kernel* _kernel, GTLCore::ModuleData* _moduleData);
      ~Wrapper();
      ImageWrap* wrapImage(GTLCore::AbstractImage* _abstractImage);
    private:
      struct Private;
      Private* const d;
    public:
      static void fillTypeManager( GTLCore::ModuleData* _module, GTLCore::TypeManager*, GTLCore::ConvertCenter*, int _channels );
      static llvm::Function* image_wrap_dataFunction( llvm::Module* _module, const GTLCore::Type* _imageType );
      static llvm::FunctionType* image_wrap_sample_nearest_type( GTLCore::TypeManager* _typeManager, const GTLCore::Type* _imageType, const GTLCore::Type* _pixelType );
      static llvm::FunctionType* image_wrap_mem_to_vec_float_type( GTLCore::TypeManager* _typeManager, int _channels );
      static llvm::FunctionType* image_wrap_vec_float_to_mem_type( GTLCore::TypeManager* _typeManager, int _channels );
      /**
       * @return the vectory type associated to that number of _channels
       */
      static const GTLCore::Type* vectorType( GTLCore::TypeManager* _typeManager, int _channels );
    private:
      static void createRegionType( llvm::Module* _module, GTLCore::TypeManager* _typeManager );
      static const GTLCore::Type* createPixelType( llvm::Module* _module, GTLCore::TypeManager* _typeManager, GTLCore::ConvertCenter* _convertCenter, const GTLCore::String& _suffix, int _channels );
      static void createImageType( GTLCore::ModuleData* _moduleData, GTLCore::TypeManager* _typeManager, const GTLCore::String& _suffix, int _channels, const GTLCore::Type* _pixelType );
  };
}


#endif
