/*************************************************************************
 *
 *  $RCSfile: sdb.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <sdb.hxx>

#ifndef _SMART_COM_SUN_STAR_DATA_DATABASEPRIVILIGE_HXX_
#include <smart/com/sun/star/data/DatabasePrivilige.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASETABLEFACTORY_HXX_
#include <smart/com/sun/star/data/XDatabaseTableFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASETABLE_HXX_
#include <smart/com/sun/star/data/XDatabaseTable.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEWORKSPACEFACTORY_HXX_
#include <smart/com/sun/star/data/XDatabaseWorkspaceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEWORKSPACE_HXX_
#include <smart/com/sun/star/data/XDatabaseWorkspace.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASECONNECTION_HXX_
#include <smart/com/sun/star/data/XDatabaseConnection.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XCONNECTABLE_HXX_
#include <smart/com/sun/star/io/XConnectable.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XOUTPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XOutputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XDATAOUTPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XDataOutputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XACTIVEDATACONTROL_HXX_
#include <smart/com/sun/star/io/XActiveDataControl.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XDATAINPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XDataInputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XMARKABLESTREAM_HXX_
#include <smart/com/sun/star/io/XMarkableStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XINPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XInputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XSTREAMLISTENER_HXX_
#include <smart/com/sun/star/io/XStreamListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XACTIVEDATASINK_HXX_
#include <smart/com/sun/star/io/XActiveDataSink.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XACTIVEDATASOURCE_HXX_
#include <smart/com/sun/star/io/XActiveDataSource.hxx>
#endif

#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEENGINE_HXX_
#include <smart/com/sun/star/data/XDatabaseEngine.hxx>
#endif

#ifndef _SMART_COM_SUN_STAR_DATA_DATABASECURSOROPTION_HXX_
#include <smart/com/sun/star/data/DatabaseCursorOption.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASEDETAILEDEXCEPTION_HXX_
#include <smart/com/sun/star/data/DatabaseDetailedException.hxx>
#endif


inline BOOL isLessParameteredValue( 
	const AddressBookParameteredValue& rFirst, const AddressBookParameteredValue& rSecond )
{
	return isLessSequenceUString( rFirst.Parameters, rSecond.Parameters );
}

inline BOOL isEqual(
	const PropertyValue& r1, const PropertyValue& r2 )
{
 	return r1.Name == r2.Name && isEqual( r1.Value, r2.Value );
}


DECLARE_SEQEQUAL( PropertyValue )


UString mapToDBFieldName( 
	const AddressBookSourceSimpleDatabaseSchemaDefinition& rSchema,
	const UString& rField )
{
	const AddressBookSourceSimpleDatabaseFieldMapping* pFirst = 
		rSchema.FieldMappings.getConstArray();
	const AddressBookSourceSimpleDatabaseFieldMapping* pLast = 
		pFirst + rSchema.FieldMappings.getLen();
	for(; pFirst != pLast; pFirst++ )
		if( pFirst->Name == rField ) return pFirst->DatabaseName;
	THROW( NoSuchElementException() );
	return UString();
}


inline BOOL isLessFieldMapping( 
	const AddressBookSourceSimpleDatabaseFieldMapping& r1, 
	const AddressBookSourceSimpleDatabaseFieldMapping& r2 )
{
	return r1.Name < r2.Name || r1.Name == r2.Name && 
		isLessSequenceUString( r1.Parameters, r2.Parameters );
}

OAddressBookSourceSimpleDatabase::OAddressBookSourceSimpleDatabase(
	const XMultiServiceFactoryRef& xMgr ) :
	OPropertySet( 			
		m_aMutex, this,	
		OObjectClass<OAddressBookSourceSimpleDatabaseData>::getInstance(), false ),
	m_xMgr( xMgr )
{
	m_ServiceName = L"com.sun.star.address.AddressBookSourceSimpleDatabase";
}


inline BOOL isEqual( const AddressBookSourceSimpleDatabaseFieldMapping& r1, 
					 const AddressBookSourceSimpleDatabaseFieldMapping& r2 )
{
	return r1.Name == r2.Name && isEqual( r1.Parameters, r2.Parameters ) &&
		r1.DatabaseName == r2.DatabaseName && r1.Type->equals( r2.Type );
}

DECLARE_SEQEQUAL( AddressBookSourceSimpleDatabaseFieldMapping )

inline BOOL isEqual( const AddressBookSourceSimpleDatabaseSchemaDefinition& r1, 
					 const AddressBookSourceSimpleDatabaseSchemaDefinition& r2 )
{
	return r1.Table == r2.Table && r1.Name == r2.Name && isEqual( r1.FieldMappings, r2.FieldMappings );
}

DECLARE_SEQEQUAL( AddressBookSourceSimpleDatabaseSchemaDefinition )

void OAddressBookSourceSimpleDatabaseData::fillClassInfo(
	OObjectClassBase*& rpParentClass, 
	Sequence<OPropertyAccessor>& rProps )
{
	static OPropertyAccessor aProps[] = 
	{
		ADR_PROPERTY( 
			OAddressBookSourceSimpleDatabaseData, DatabaseName, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceSimpleDatabaseData, ConnectionParameters, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceSimpleDatabaseData, Schemata, PropertyAttribute_BOUND )
	};
	rProps = Sequence<OPropertyAccessor>( 
		aProps, sizeof( aProps )/ sizeof( OPropertyAccessor ) );
	rpParentClass = &OObjectClass<OAddressBookSourceData>::getInstance();
}

const AddressBookSourceSimpleDatabaseSchemaDefinition* OAddressBookSourceSimpleDatabaseData::getSchemaDefinition( 
	const UString& rName )
{
	const AddressBookSourceSimpleDatabaseSchemaDefinition* pBegin = 
		m_Schemata.getConstArray();
	const AddressBookSourceSimpleDatabaseSchemaDefinition* pEnd = 
		pBegin + m_Schemata.getLen();
	while( pBegin != pEnd )
	{
		if( pBegin->Name == rName ) return pBegin;
		pBegin++;
	}
	return 0;
}

static const AddressBookSourceSimpleDatabaseFieldMapping* findField( 
	const AddressBookSourceSimpleDatabaseSchemaDefinition& rSchema,
	const UString& rABName )
{
	const AddressBookSourceSimpleDatabaseFieldMapping* pFirst = 
		rSchema.FieldMappings.getConstArray();
	const AddressBookSourceSimpleDatabaseFieldMapping* pLast = 
		pFirst + rSchema.FieldMappings.getLen();
	for( ;pFirst != pLast; pFirst++ )
		if( pFirst->Name == rABName ) return pFirst;
	return 0;
}

static Sequence<UString> getDatabaseNames( 
	const AddressBookSourceSimpleDatabaseSchemaDefinition& rSchema )
{
	vector<UString> aResult;
	const AddressBookSourceSimpleDatabaseFieldMapping* pFirst = 
		rSchema.FieldMappings.getConstArray();
	const AddressBookSourceSimpleDatabaseFieldMapping* pLast = 
		pFirst + rSchema.FieldMappings.getLen();
	for( ;pFirst != pLast; pFirst++ )
		aResult.push_back(  pFirst->DatabaseName );
	sort( aResult.begin(), aResult.end(), isLess );
	aResult.erase( 
		unique( aResult.begin(), aResult.end(), UStringEqual() ), 
		aResult.end() );
	Sequence<UString> aSeq;
	copyContainerToSequence( aResult, aSeq );
	return aSeq;
}



XIdlClassRef OAddressBookSourceSimpleDatabase::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OAddressBookSourceSimpleDatabase", 
		OPropertySet::getStaticIdlClass(), 2,
		XAddressBookJobFactorySupplier_getReflection(),
		XJobFactory_getReflection()
		);
	return xClass;
}

BOOL OAddressBookSourceSimpleDatabase::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XAddressBookJobFactorySupplier );
	QUERYIFACE( XJobFactory );
	return OPropertySet::queryInterface( aUik, rOut );
}

Sequence<XIdlClassRef>	OAddressBookSourceSimpleDatabase::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

XJobFactoryRef OAddressBookSourceSimpleDatabase::getJobFactory()
{
	if( !m_xJobFactory.is() )
	{
		UsrAny aAny;
		aAny <<= XJobFactoryRef( this );
		m_xJobFactory = XJobFactoryRef(
			m_xMgr->createInstanceWithArguments( 
				L"com.sun.star.address.SynchronAndAsynchronJobFactory",
				Sequence<UsrAny>( &aAny, 1 ) ), USR_QUERY );
	}
	return m_xJobFactory;
}

XInterfaceRef OAddressBookSourceSimpleDatabase::createJob( 
	const UString& rType, const Sequence<UsrAny>& rArgs )
{
	if( rType == L"query" )
		return *new OAddressBookSourceSimpleDatabaseQueryJob(
			m_xMgr, this, rType, rArgs );
	else
		return *new OAddressBookSourceSimpleDatabaseSynchronJob(
			m_xMgr, this, rType, rArgs );
}

BOOL OAddressBookSourceSimpleDatabase::convertFastPropertyValue( 
	UsrAny & rConvertedValue, UsrAny & rOldValue, 
	INT32 nHandle, const UsrAny& rValue )
	THROWS( (IllegalArgumentException) )
{
	UString aProp;
	getInfoHelper().fillPropertyMembersByHandle( &aProp, 0, nHandle );
	// correct 
	if( aProp == L"Schemata" )
	{
		Sequence<AddressBookSourceSimpleDatabaseSchemaDefinition> aSeq;
		rValue >>= aSeq;
		AddressBookSourceSimpleDatabaseSchemaDefinition* pSeq = aSeq.getArray();
		for( INT32 nPos = aSeq.getLen(); nPos--; )
		{
			AddressBookSourceSimpleDatabaseSchemaDefinition& rDef = pSeq[ nPos ];
			AddressBookSourceSimpleDatabaseFieldMapping* pMaps = rDef.FieldMappings.getArray();
			for( INT32 n = rDef.FieldMappings.getLen(); n--; )
			{
				AddressBookSourceSimpleDatabaseFieldMapping& rMap = pMaps[ n ];
				sort( rMap.Parameters.getArray(), rMap.Parameters.getArray() + 
					  rMap.Parameters.getLen(), isLess );
			}
		}
		return OPropertySet::convertFastPropertyValue(
			rConvertedValue, rOldValue, nHandle, makeAny( aSeq ) );
	}
	else return OPropertySet::convertFastPropertyValue(
		rConvertedValue, rOldValue, nHandle, rValue );
}

void OAddressBookSourceSimpleDatabase::setFastPropertyValue_NoBroadcast( 
	INT32 nHandle, const UsrAny& rValue ) THROWS( (Exception) )
{
	OPropertySet::setFastPropertyValue_NoBroadcast( nHandle, rValue );
	m_aConnection = XInterfaceRef();
}

const XDatabaseConnectionRef OAddressBookSourceSimpleDatabase::getConnection()
{
	XDatabaseConnectionRef xConn;
	if( !m_aConnection.queryHardRef( 
	  XDatabaseConnection::getSmartUik(), xConn ) )
	{
		OAddressBookSourceSimpleDatabaseData aData;
		{
			OGuard aGuard( m_aMutex );
			aData = *this;
		}
		XDatabaseEngineRef xEngine(
			m_xMgr->createInstance(L"com.sun.star.data.DatabaseEngine"), USR_QUERY );
		if( !xEngine.Is() ) THROW( RuntimeException() );
		TRY
			{
				if( aData.m_ConnectionParameters.getLen() )
				{
					xConn = XDatabaseConnectionRef( xEngine->createConnection( 
						aData.m_ConnectionParameters ), USR_QUERY );
					m_aConnection = xConn;
				}
				else
				{
					XIndexAccessRef xInd( xEngine->getWorkspaces(), USR_QUERY );
					XDatabaseWorkspaceRef xWrk;
					extractInterface( xInd->getByIndex( 0 ), xWrk );
					if( xWrk.is() )
					{
						m_aConnection = xConn = XDatabaseConnectionRef(
							xWrk->open( aData.m_DatabaseName ), USR_QUERY );
					}
				}
			}
		CATCH( DatabaseException, e )
			{
			}
		END_CATCH;
		// for now we do hold a reference since there were problems with opening
		// several connections shortly after another
		m_xConnection = xConn;
	}
	return xConn;
}
	

const XAddressBookRecordContainerRef& OAddressBookSourceSimpleDatabase::getRecordContainer()
{
	if( !m_xRecordContainer.is() )
	{
		UsrAny aAny;
		aAny <<= XAddressBookJobFactorySupplierRef( this );
		m_xRecordContainer = XAddressBookRecordContainerRef(
			m_xMgr->createInstanceWithArguments( 
				L"com.sun.star.address.AddressBookSourceAccess",
				Sequence<UsrAny>( &aAny, 1 ) ), USR_QUERY );
	}
	return m_xRecordContainer;
}

UsrAny OAddressBookSourceSimpleDatabase::getAnyFromProperty( 
	const UString& rSchemaName,
	const AddressBookSourceSimpleDatabaseFieldMapping& rMap,
	const AddressBookParameteredValue& rValue )
{
	if( rMap.Name == L"Uid" )
	{
		UString aUid;
		if( rValue.Value >>= aUid )
			return UsrAny( UString( aUid + rSchemaName.len() + 1 ));
	}
	return rValue.Value;
}

UsrAny OAddressBookSourceSimpleDatabase::getPropertyFromAny( 
	const UString& rSchemaName,
	const AddressBookSourceSimpleDatabaseFieldMapping& rMap,
	const UsrAny& rValue )
{
	UsrAny aRet = rValue;
	if( aRet.getReflection() == XInputStream_getReflection() )
	{
		XDataInputStreamRef xStream( 
			*(const XInputStreamRef*)aRet.get(), USR_QUERY );
		aRet.setString(  xStream->readUTF() );
	}
	if( rMap.Name == L"Uid" )
	{
		UString aUid;
		if( aRet >>= aUid )	aRet.setString(
			OAddressBookSources::schemaAndBasisUidToUid(
				rSchemaName, aUid ) );
	}
	return aRet;
}


//////////////////////////////////////////////////////////

OAddressBookSourceSimpleDatabaseSynchronJob::OAddressBookSourceSimpleDatabaseSynchronJob( 
	const XMultiServiceFactoryRef& xMgr, 
	const OAddressBookSourceSimpleDatabaseRef& xSource, 
	const UString& rType, const Sequence<UsrAny>& rArgs )
	: m_xMgr( xMgr ), m_xSource( xSource ), m_aArgs( rArgs ), m_aType( rType )
{
}

XIdlClassRef OAddressBookSourceSimpleDatabaseSynchronJob::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OAddressBookSourceSimpleDatabaseSynchronJob", 
		UsrObject::getUsrObjectIdlClass(), 2,
		XCancellable_getReflection(),
		XSynchronJob_getReflection() );
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookSourceSimpleDatabaseSynchronJob::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookSourceSimpleDatabaseSynchronJob::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XJob );
	QUERYIFACE( XSynchronJob );
	QUERYIFACE( XCancellable );
	return UsrObject::queryInterface( aUik, rOut );
}

void OAddressBookSourceSimpleDatabaseSynchronJob::updateRecord( 
	const XDatabaseCursorRef& xCursor, 
	const AddressBookSourceSimpleDatabaseSchemaDefinition& rSchema, 
	const Sequence<AddressBookParameteredPropertyValue>& rValues )
{
	XPropertySetRef xProp = xCursor->getRecord();
	vector<AddressBookSourceSimpleDatabaseFieldMapping> aProperties;
	copySequenceToContainer( rSchema.FieldMappings, aProperties );
	stable_sort( 
		aProperties.begin(), aProperties.end(), isLessFieldMapping );
	
	// now distribute the values on the record of the cursor
	AddressBookSourceSimpleDatabaseFieldMapping aSearchMap;
	UsrAny aAny;
	const AddressBookParameteredPropertyValue* pFirstValue = 
		rValues.getConstArray();
	const AddressBookParameteredPropertyValue* pLastValue = 
		pFirstValue + rValues.getLen();
	const AddressBookParameteredPropertyValue* pCur;
	for( pCur = pFirstValue; pCur != pLastValue; pCur++ )
	{
		Sequence<AddressBookParameteredValue> aSeq =
			pCur->Values;
		const AddressBookParameteredValue* pFirstSubValue = 
			aSeq.getConstArray();
		const AddressBookParameteredValue* pLastSubValue = 
			pFirstSubValue + aSeq.getLen();
		aSearchMap.Name = pCur->Name;
		for( ; pFirstSubValue != pLastSubValue; pFirstSubValue++ )
		{
			aSearchMap.Parameters = pFirstSubValue->Parameters;
			pair<vector<AddressBookSourceSimpleDatabaseFieldMapping>::iterator,
				vector<AddressBookSourceSimpleDatabaseFieldMapping>::iterator >
				aPair = equal_range( 
					aProperties.begin(), aProperties.end(), aSearchMap,
					isLessFieldMapping );
			if( aPair.first == aPair.second )
				THROW( IllegalArgumentException() );
			aAny = OAddressBookSourceSimpleDatabase::getAnyFromProperty( 
				rSchema.Name, *aPair.first, *pFirstSubValue );
			xProp->setPropertyValue( 
				(*aPair.first).DatabaseName, aAny );
			aProperties.erase( aPair.first );
		}
	}
}


UsrAny OAddressBookSourceSimpleDatabaseSynchronJob::executeSynchron( )
{
	TRY
	{
		const UsrAny* pArr = m_aArgs.getConstArray();
		if( m_aType == L"getSchemata" )
		{
			Sequence<AddressBookSourceSimpleDatabaseSchemaDefinition> aSchemata = 
				m_xSource->getData().m_Schemata;
			
			OAddressBookSchemaData aSchema;
			AddressBookParameteredProperty aProperty;
			aProperty.Type = OUString_getReflection()->getIdlClass();
		
			// iterate over all schemata
			vector<Sequence<PropertyValue> > aRet;
		
			AddressBookSourceSimpleDatabaseSchemaDefinition* pDefinitions = 
				aSchemata.getArray();
			UString aName;
			INT32 nPos;
			for( nPos = aSchemata.getLen(); nPos--; )
			{
				XDatabaseConnectionRef xConnection = m_xSource->getConnection();
				aSchema.m_IsInsertable = FALSE;
				if( !xConnection.is() ) continue;
				XNameContainerRef xTables = xConnection->getTables();
				XPropertySetRef xTable;
				TRY
				{
					extractInterface( 
						xTables->getByName( pDefinitions[ nPos ].Table ), xTable );
				}
				CATCH( NoSuchElementException, e )
				{
				}
				END_CATCH;
				
				if( !xTable.is() ) continue;
				short nPrivs = 0;
				xTable->getPropertyValue( L"Priviliges" ) >>= nPrivs;
				BOOL bUpdatable = !!(nPrivs & DatabasePrivilige_UPDATE_DATA );
				BOOL bRemovable = !!(nPrivs & DatabasePrivilige_DELETE_DATA );
				if( nPrivs & DatabasePrivilige_INSERT_DATA )
					aSchema.m_IsInsertable = TRUE;
				
				XDatabaseFieldsSupplierRef xFieldSup( xTable, USR_QUERY );
				XNameAccessRef xFields = xFieldSup->getFields();

				aSchema.m_Name = pDefinitions[ nPos ].Name;
				Sequence<AddressBookSourceSimpleDatabaseFieldMapping>& rMapping = 
					pDefinitions[ nPos ].FieldMappings;
			
				// sort Mapping so that parameter combinations belonging
				// to the same property can be done sequencially 
				sort( rMapping.getArray(), rMapping.getArray() + rMapping.getLen(), 
					  isLessFieldMapping );
				aName = L"";
				Sequence<UString> aParameters;
			
				const AddressBookSourceSimpleDatabaseFieldMapping* pMap = 
					rMapping.getConstArray();
				vector<AddressBookParameteredProperty>   aProps;
				vector<AddressBookPropertyParameterInfo> aInfos;
				AddressBookPropertyParameterInfo aInfo;
			
				for( INT32 nPropPos = 0; nPropPos <= rMapping.getLen(); 
					 nPropPos++ )
				{
					const AddressBookSourceSimpleDatabaseFieldMapping& rMap = 
						pMap[ nPropPos ];
					XPropertySetRef xField;
					BOOL bRealProp = nPropPos != rMapping.getLen();
					if( bRealProp )
					{
						TRY
							{
								extractInterface( xFields->getByName( 
									rMap.DatabaseName ), xField );
							}
						CATCH( NoSuchElementException, e )
							{
							continue;
							}
						END_CATCH;
					}
					

					Sequence<UString> aNewParameters;
					if( bRealProp )
					{
						aNewParameters = rMap.Parameters;
						sort( aNewParameters.getArray(), 
								 aNewParameters.getArray() + aNewParameters.getLen(), isLess );
					}
					
					if( !bRealProp || aName != rMap.Name ||
						!isEqual( aParameters, aNewParameters ) )
					{
						// parameters or name changes -> next PropertyInfo
						if( aInfo.MaxCount != 0 ) 
						{
							aInfo.IsWritable = bUpdatable;
							
							if( aInfo.IsWritable ) aProperty.IsWritable = TRUE;
							
							INT32 nOldParCount = aProperty.Parameters.getLen();
							aProperty.Parameters.realloc( nOldParCount + aInfo.Parameters.getLen() );
							copy( aInfo.Parameters.getConstArray(), 
								  aInfo.Parameters.getConstArray() + aInfo.Parameters.getLen(),
								  aProperty.Parameters.getArray() + nOldParCount );
							inplace_merge( 
								aProperty.Parameters.getArray(),
								aProperty.Parameters.getArray() + nOldParCount,
								aProperty.Parameters.getArray() + 
								aProperty.Parameters.getLen(), isLess );
							aProperty.Parameters.realloc(
								unique(
									aProperty.Parameters.getArray(),
									aProperty.Parameters.getArray() +
									aProperty.Parameters.getLen(), 
									UStringEqual() ) -
								aProperty.Parameters.getArray() );
							
							aProperty.MaxCount += aInfo.MaxCount;
							aProperty.MinCount += aInfo.MinCount;
							aInfos.push_back( aInfo );
						}
						
						aInfo.MinCount = 0;
						aInfo.MaxCount = 0;
						aInfo.Parameters = aNewParameters;
						
						// property changes -> next property
						if( !bRealProp || aName != rMap.Name )
						{
							if( aName.len() )
							{
								// Name has changed so we have to append aProperty
								aProperty.Name = aName;
								copyContainerToSequence( 
									aInfos, aProperty.AllowedParameterCombinations );
								aProps.push_back( aProperty );
								aProperty.MinCount = 0;
								aProperty.MaxCount = 0;
								aProperty.IsWritable = FALSE;
								aInfos = vector<AddressBookPropertyParameterInfo>();
							}
							if( bRealProp ) aName = rMap.Name;
						}
					}
					
					if( !bRealProp ) continue;
					aInfo.MaxCount++;
					if( xField->getPropertyValue( L"IsRequired" ).getBOOL() )
						aInfo.MinCount++;
				}
				copyContainerToSequence( aProps, aSchema.m_Properties );
				aRet.push_back( 
					OObjectClass<OAddressBookSchemaData>::getInstance().
					getPropertyValues( &aSchema ) );
			}
			Sequence< Sequence< PropertyValue> > aRetSeq;
			copyContainerToSequence( aRet, aRetSeq );
			UsrAny aRetAny;
			aRetAny <<= aRetSeq;
			return aRetAny;
		}
		else if( m_aType == L"removeRecord" )
		{
			UString aUid;
			if( m_aArgs.getLen() != 1 || 
				!( m_aArgs.getConstArray()[ 0 ] >>= aUid ) )
				THROW( IllegalArgumentException() );

			OAddressBookSourceSimpleDatabaseData aData = m_xSource->getData();
			XDatabaseConnectionRef xCon = m_xSource->getConnection();
			if( !xCon.is() ) THROW( CantConnectException() );
			UniString aSql = L"delete from ";
			UString aSchema;
			UString aUBaseUid;
			OAddressBookSources::uidToSchemaAndBasisUid(
				aUid, aSchema, aUBaseUid );
			UniString aBaseUid( aUBaseUid );
			aBaseUid.SearchAndReplaceAll( "\'", "\\\'" );

			const AddressBookSourceSimpleDatabaseSchemaDefinition* pSchema = 
				aData.getSchemaDefinition( aSchema );
			( aSql += UniString( pSchema->Table )) += UniString( " where ");
			const AddressBookSourceSimpleDatabaseFieldMapping* pField = 
				findField( *pSchema, L"Uid" );
			if( ! pField ) THROW( IllegalArgumentException() );
			(( aSql += UniString( pField->DatabaseName ) ) += UniString( "=\'" )) += 
				aBaseUid;
			aSql += UniString( "\'" );
		
			m_xStatement = m_xSource->getConnection()->createStatement(
				UString( aSql ),FALSE );
			m_xStatement->execute();
			return UsrAny();
		}
		else if( m_aType == L"insertRecord" )
		{
			UString aSchema;
			Sequence<AddressBookParameteredPropertyValue> aValues;
			if( m_aArgs.getLen() != 2 || 
				!( pArr[ 0 ] >>= aSchema ) || !( pArr[ 1 ] >>= aValues ) )
				THROW( IllegalArgumentException() );

			OAddressBookSourceSimpleDatabaseData aData = m_xSource->getData();
			XDatabaseConnectionRef xCon = m_xSource->getConnection();
			if( !xCon.is() ) THROW( CantConnectException() );
		
			const AddressBookSourceSimpleDatabaseSchemaDefinition* pSchema = 
				aData.getSchemaDefinition( aSchema );
			Sequence<UString> aFields = getDatabaseNames( *pSchema );

			UString aFieldsStr;
			const UString* pFields = aFields.getConstArray();
			const UString* pLast = pFields + aFields.getLen();
			INT32 nLen = aFields.getLen();
			if( nLen-- ) aFieldsStr = *pFields++;
			UString aKomma = UString::createFromAscii( "," );
			while( nLen-- ) ( aFieldsStr += aKomma ) += *pFields++;
		
			UString aSql( UString::createFromAscii( "select " ) );
			( aSql += aFieldsStr ) += UString::createFromAscii( " from " );
			( aSql += pSchema->Table ) += UString::createFromAscii( " where 1=0" );

			m_xStatement = 
				m_xSource->getConnection()->createStatement(
					UString( aSql ), FALSE );
			XDatabaseCursorRef xCursor = m_xStatement->executeQuery( 
				DatabaseCursorType_KEYSET, DatabaseCursorOption_INSERTONLY );
			XDatabaseUpdateCursorRef xUpdate( xCursor, USR_QUERY );
			if( !xUpdate.is() ) THROW( IllegalArgumentException() );
			xUpdate->addRecord();
		
			AddressBookParameteredPropertyValue* pFirstValue = 
				aValues.getArray();
			AddressBookParameteredPropertyValue* pLastValue = 
				pFirstValue + aValues.getLen();
			AddressBookParameteredPropertyValue* pCur;
			for( pCur = pFirstValue; pCur != pLastValue; pCur++ )
				if( pCur->Name == L"Uid" ) break;
		
			// if we don't get a uid we have to generate one ourselves
			if( pCur == pLastValue || !pCur->Values.getLen())
			{
				Sequence<UString> aUids = m_xSource->getRecordContainer()->
					createUids( aSchema, 1 );
				aValues.realloc( aValues.getLen() + 1 );
				AddressBookParameteredPropertyValue& rValue = 
					aValues.getArray()[ aValues.getLen() - 1 ];
				rValue.Name = L"Uid";
				rValue.Values.realloc( 1 );
				rValue.Values.getArray()[ 0 ].Value <<= aUids.getConstArray()[ 0 ];
				pFirstValue = aValues.getArray();
				pLastValue = pFirstValue + aValues.getLen();
			}
			// if we do get one, wwe have to adjust it
			else
			{
				UsrAny& rAny = pCur->Values.getArray()[ 0 ].Value;
				UString aUid;
				if( rAny >>= aUid )
				{
					UString aSchema;
					UString aBasis;
					if( OAddressBookSources::uidToSchemaAndBasisUid( aUid, aSchema, aBasis ) )
						rAny <<= aBasis;
				}
			}
		
			updateRecord( xCursor, *pSchema, aValues );
			xUpdate->updateRecord();
			XComponentRef xComp( xCursor, USR_QUERY );
			xComp->dispose();
			return UsrAny();
		}
		else if( m_aType == L"updateRecord" )
		{
			UString aUid;
			Sequence<AddressBookParameteredPropertyValue> aValues;
			if( m_aArgs.getLen() != 2 || 
				!( pArr[ 0 ] >>= aUid ) || !( pArr[ 1 ] >>= aValues ) )
				THROW( IllegalArgumentException() );

			OAddressBookSourceSimpleDatabaseData aData = m_xSource->getData();
			XDatabaseConnectionRef xCon = m_xSource->getConnection();
			if( !xCon.is() ) THROW( CantConnectException() );
		
			UString aSchema;
			UString aUBaseUid;
			if( !OAddressBookSources::uidToSchemaAndBasisUid( aUid, aSchema, aUBaseUid ) )
				THROW( IllegalArgumentException() );
		
			const AddressBookSourceSimpleDatabaseSchemaDefinition* pSchema = 
				aData.getSchemaDefinition( aSchema );

			Sequence<UString> aFields = getDatabaseNames( *pSchema );

			UString aFieldsStr;
			const UString* pFields = aFields.getConstArray();
			const UString* pLast = pFields + aFields.getLen();
			INT32 nLen = aFields.getLen();
			if( nLen-- ) aFieldsStr = *pFields++;
			UString aKomma( UString::createFromAscii("," ));
			while( nLen-- ) ( aFieldsStr += aKomma ) += *pFields++;
		
			UString aSql( UString::createFromAscii("select " ) ); 
			( aSql += aFieldsStr ) += UString::createFromAscii(" from " );
			( aSql += pSchema->Table ) += UString::createFromAscii(" where " );
			aSql += findField( *pSchema, L"Uid" )->DatabaseName;
			aSql += UString::createFromAscii( "=\'" );
			UniString aBaseUid( aUBaseUid );
			aBaseUid.SearchAndReplaceAll( UniString( "\'" ), 
										  UniString( "\\\'" ));
			( aSql += UString( aBaseUid ) ) += UString::createFromAscii( "\'" );
		
			m_xStatement =
				m_xSource->getConnection()->createStatement(
					UString( aSql ), FALSE );
			XDatabaseCursorRef xCursor = m_xStatement->executeQuery( 
				DatabaseCursorType_KEYSET, DatabaseCursorOption_UPDATABLE );
			XDatabaseUpdateCursorRef xUpdate( xCursor, USR_QUERY );
			if( !xUpdate.is() ) THROW( IllegalArgumentException() );
			if( !xCursor->isValid() )
				THROW( IllegalArgumentException() );
			xUpdate->editRecord();

			UString aOldUid;
			const AddressBookSourceSimpleDatabaseFieldMapping* pField = 
				findField( *pSchema, L"Uid" );
			xCursor->getRecord()->getPropertyValue( 
				pField->DatabaseName ) >>= aOldUid;

			updateRecord( xCursor, *pSchema, aValues );
		
			if( aOldUid != UString( aBaseUid ) ) THROW( IllegalArgumentException() );
			xUpdate->updateRecord();
			XComponentRef xComp( xCursor, USR_QUERY );
			xComp->dispose();
			return UsrAny();
		}
		else if( m_aType == L"createUids" )
		{
			UString aSchema;
			INT32   nCount;
			if( m_aArgs.getLen() != 2 || !( pArr[ 0 ] >>= aSchema  ) )
				THROW( IllegalArgumentException() );
			nCount = OPropertyTypeConversion::toINT32( pArr[ 1 ] );

			Sequence<UString> aRet( nCount );
			UString* pRet = aRet.getArray();
			UString aUid;
			XUniqueIDFactoryRef xFac( m_xMgr->createInstance(
				L"com.sun.star.util.UniqueIDFactory" ), USR_QUERY );

			while( nCount-- )
			{
				static long nNr = 0;
				aUid += xFac->createUniqueID( );
				pRet[ nCount ] = OAddressBookSources::schemaAndBasisUidToUid( 
					aSchema, UString( aUid ) );
			}
			UsrAny aAny;
			aAny <<= aRet;
			return aAny;
		}
		else if( m_aType == L"getProperties" )
		{
			UsrAny aAny;
			aAny <<= Sequence<PropertyValue>();
			return aAny;
		}
		THROW( IllegalArgumentException() );
	}
	CATCH( DatabaseDetailedException, e )
	{
		if( e.ExceptionContext == DatabaseExceptionContext_SYNTAX )
		{
			THROW( IllegalArgumentException() );
		}
		else THROW( CantConnectException() );
	}
	AND_CATCH( DatabaseException, e )
	{
		THROW( CantConnectException() );
	}
	END_CATCH;
	return UsrAny();
}

void OAddressBookSourceSimpleDatabaseSynchronJob::cancel()
{
	XCancellableRef xCancel( m_xStatement, USR_QUERY );
	if( xCancel.is() ) xCancel->cancel();
}

//////////////////////////////////////////////////////////

OAddressBookSourceSimpleDatabaseQueryJob::OAddressBookSourceSimpleDatabaseQueryJob( 
	const XMultiServiceFactoryRef& xMgr, 
	const OAddressBookSourceSimpleDatabaseRef& xSource, 
	const UString& rType, const Sequence<UsrAny>& rArgs )
	: m_xMgr( xMgr ), m_xSource( xSource ), m_aArgs( rArgs ), m_aType( rType ), m_bCanceled( FALSE )
{
}

XIdlClassRef OAddressBookSourceSimpleDatabaseQueryJob::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OAddressBookSourceSimpleDatabaseQueryJob", 
		UsrObject::getUsrObjectIdlClass(), 2,
		XCancellable_getReflection(),
		XAsynchronJob_getReflection() );
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookSourceSimpleDatabaseQueryJob::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookSourceSimpleDatabaseQueryJob::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XJob );
	QUERYIFACE( XAsynchronJob );
	QUERYIFACE( XCancellable );
	return UsrObject::queryInterface( aUik, rOut );
}

void OAddressBookSourceSimpleDatabaseQueryJob::buildQueries( 
	const AddressBookSourceSimpleDatabaseSchemaDefinition& rDef,
	UniString& rQuery, const AddressBookQueryTerm& rTerm )
{
	switch( rTerm.Function )
	{
		// all functions that operate on a field have to be replicated into
		// n filters corresponding to the db fields the property is mapped onto
		case AddressBookQueryFunction_PRESENT:
		case AddressBookQueryFunction_EQUALITYMATCH:
		case AddressBookQueryFunction_SUBSTRINGS:
		case AddressBookQueryFunction_APPROXMATCH:
		case AddressBookQueryFunction_LESSOREQUAL:
		case AddressBookQueryFunction_GREATEROREQUAL:
		{
			AddressBookQueryTerm aTerm( rTerm );
			UsrAny* pArgs = aTerm.Arguments.getArray();
			UString aField;
			if( !(*pArgs >>= aField ) ) THROW( IllegalArgumentException() );
			
			if( rTerm.Function == AddressBookQueryFunction_EQUALITYMATCH &&
				aField == L"Uid" )
			{
				UString aValue;
				pArgs[ 1 ] >>= aValue;
				UString aSchema, aBasisUid;
				OAddressBookSources::uidToSchemaAndBasisUid( aValue, aSchema, aBasisUid );
				pArgs[ 1 ] <<= aBasisUid;
			}
			
			vector<UString> aMappings;
			const AddressBookSourceSimpleDatabaseFieldMapping* pBegin = rDef.FieldMappings.getConstArray();
			const AddressBookSourceSimpleDatabaseFieldMapping* pEnd = pBegin + rDef.FieldMappings.getLen();

			for( ;pBegin != pEnd; pBegin++ )
				if( pBegin->Name == aField ) aMappings.push_back( pBegin->DatabaseName );
			// if the addressbook property maps to only one ldap field, create one filter
			// if it does not map, this term is always false
			if( !aMappings.size() )
				rQuery += L"( 1 = 0 )";
			else if( aMappings.size() == 1 )
			{
				buildQuery( 
					rDef, rQuery, aMappings.size() == 0 ? 
					aField : aMappings[ 0 ], aTerm );
			}
			else
			{
				UniString aTerms;
				for( vector<UString>::const_iterator aIter = aMappings.begin();
					 aIter != aMappings.end(); aIter++ )
				{
					if( aTerms.Len() ) aTerms += L" OR ";
					buildQuery( rDef, aTerms, *aIter, rTerm );
					((rQuery += L'(' ) += aTerms ) += L") ";
				}
			}
			break;
		}
		default:
			buildQuery( rDef, rQuery, L"", rTerm );
	}

}

UString OAddressBookSourceSimpleDatabaseQueryJob::getQueryStringFromAny( 
	const UsrAny& rAny )
{
	UString aRet;
	if( rAny >>= aRet )
	{
		UniString aTmp( aRet );
		aTmp.SearchAndReplaceAll( UniString( "\'" ), UniString( "\\\'" ));
		UniString aResult( "\'" );
		( aResult += aTmp ) += UniString( "\'" );
		aRet = UString( aResult );
	}
	return aRet;
}


//Marker
void OAddressBookSourceSimpleDatabaseQueryJob::buildQuery( 
	const AddressBookSourceSimpleDatabaseSchemaDefinition& rDef,
	UniString& rQuery, const UString& rField, const AddressBookQueryTerm& aTerm )
{
	const UsrAny* pArgs = aTerm.Arguments.getConstArray();
	switch(aTerm.Function)
	{
		case AddressBookQueryFunction_AND:
		{
			AddressBookQueryTerm aTerm;
			UniString aQuery;
			for(INT32 i=0;i<aTerm.Arguments.getLen();++i)
			{
				if( pArgs[ i ] >>= aTerm )
				{
					if( aQuery.Len() ) aQuery += L" AND ";
					buildQueries( rDef, rQuery, aTerm );
				}
			}
			(( rQuery += L" ( " ) += aQuery ) += L" ) ";
			break;
		}
		case AddressBookQueryFunction_OR:
		{
			AddressBookQueryTerm aTerm;
			UniString aQuery;
			for(INT32 i=0;i<aTerm.Arguments.getLen();++i)
			{
				if( pArgs[ i ] >>= aTerm )
				{
					if( aQuery.Len() ) aQuery += L" OR ";
					buildQueries( rDef, rQuery, aTerm );
				}
			}
			(( rQuery += L" ( " ) += aQuery ) += L" ) ";
			break;
		}
		case AddressBookQueryFunction_NOT:
		{
			rQuery += L" not ( ";
			buildQueries( rDef, rQuery, aTerm );
			rQuery += ") ";
			break;
		}
		case AddressBookQueryFunction_SUBSTRINGS:
		{
			INT32 nLen = aTerm.Arguments.getLen();
			UString aValue;
			UString aStr;
			UString aPercent( UString::createFromAscii( "%" ) );
			for( INT32 i = 1; i<aTerm.Arguments.getLen() - 1; i++ )
			{
				pArgs[ i ] >>= aStr;
				( aValue += aStr ) += aPercent;
			}
			pArgs[ i ] >>= aStr;
			aValue += aStr;
			aStr = getQueryStringFromAny( UsrAny( UString( aValue ) ) );
			rQuery += UniString (rField);
			rQuery += UniString( " like " );
			rQuery += UniString( aStr );
			break;
		}
		case AddressBookQueryFunction_APPROXMATCH:
		case AddressBookQueryFunction_EQUALITYMATCH:
		{
			UString aValue = getQueryStringFromAny( pArgs[ 1 ] );
			rQuery += UniString( rField );
			rQuery += UniString( "=" );
			rQuery += UniString( aValue );
			break;
		}
		case AddressBookQueryFunction_GREATEROREQUAL:
		{
			UString aValue = getQueryStringFromAny( pArgs[ 1 ] );
			rQuery += UniString( rField );
			rQuery += UniString( ">=" );
			rQuery += UniString( aValue );
			break;
		}
		case AddressBookQueryFunction_LESSOREQUAL:
		{
			UString aValue = getQueryStringFromAny( pArgs[ 1 ] );
			rQuery += UniString( rField );
			rQuery += UniString( "<=" );
			rQuery += UniString( aValue );
			break;
		}
		case AddressBookQueryFunction_PRESENT:
		{
			rQuery += UniString( rField );
			rQuery += UniString( "=\'%\'" );
			rQuery += UniString( " " );
			break;
		}
	}
}

void OAddressBookSourceSimpleDatabaseQueryJob::cancel()
{
	m_bCanceled = TRUE;
	XCancellableRef xCancel( m_xStatement, USR_QUERY );
	if( xCancel.is() ) xCancel->cancel();
}

void OAddressBookSourceSimpleDatabaseQueryJob::executeAsynchron( 
	const XJobListenerRef& xCallback )
{
	TRY
	{
		if( m_aType == L"query" )
		{
			Sequence<UString> aProperties;
			UString aQuery;
			Sequence<AddressBookSortInfo> aSortInfo;
			Sequence<UString> aSchemata;
			const UsrAny* pArgs = m_aArgs.getConstArray();
			if( !(pArgs[ 0 ] >>= aProperties ) ||
				!(pArgs[ 1 ] >>= aQuery ) ||
				!(pArgs[ 2 ] >>= aSortInfo ) ||
				!(pArgs[ 3 ] >>= aSchemata ) )
				THROW( IllegalArgumentException() );

			// no schemata is all schemata
			OAddressBookSourceSimpleDatabaseData aData = m_xSource->getData();
			if( !aSchemata.getLen() ) 
			{
				aSchemata.realloc( aData.m_Schemata.getLen() );
				UString* pSchemata = aSchemata.getArray();
				const AddressBookSourceSimpleDatabaseSchemaDefinition* pFirst = 
					aData.m_Schemata.getConstArray();
				const AddressBookSourceSimpleDatabaseSchemaDefinition* pLast = 
					pFirst + aData.m_Schemata.getLen();
				for( ;pFirst!= pLast; pFirst++ )
					*pSchemata++ = pFirst->Name;
			}
			VOS_ENSHURE( 
				aSchemata.getLen() == 1, "more than one schema not yet supported" );

			// sorting can be done by the db if and only if every sorting field
			// touches only one db field
			BOOL bSortOnServer = TRUE;
			const AddressBookSortInfo* pFirstInfo = aSortInfo.getConstArray();
			const AddressBookSortInfo* pLastInfo = pFirstInfo + aSortInfo.getLen();
			for( ;pFirstInfo != pLastInfo && bSortOnServer; pFirstInfo++ )
			{
				const AddressBookSourceSimpleDatabaseSchemaDefinition* pFirst = 
					aData.m_Schemata.getConstArray();
				const AddressBookSourceSimpleDatabaseSchemaDefinition* pLast = 
					pFirst + aData.m_Schemata.getLen();
				for( ;pFirst!= pLast; pFirst++ )
				{
					const AddressBookSourceSimpleDatabaseFieldMapping* pFirstMap = 
						pFirst->FieldMappings.getConstArray();
					const AddressBookSourceSimpleDatabaseFieldMapping* pLastMap = 
						pFirstMap + pFirst->FieldMappings.getLen();
					vector<UString> aFields;
					for(;pLastMap!= pFirstMap; pFirstMap++ )
						aFields.push_back( pFirstMap->Name );
					sort( aFields.begin(), aFields.end(), isLess );
					pair<vector<UString>::iterator,vector<UString>::iterator> aPair = 
						equal_range( aFields.begin(), aFields.end(), pFirstInfo->Property,
									 isLess );
					if( aPair.first != aPair.second && 
						++aPair.first != aPair.second )
					{
						bSortOnServer = FALSE;
						break;
					}
				}
			}
		
			OResultSet* pResultSet = 0;
			if( !bSortOnServer )
				pResultSet = new OResultSet( aSortInfo );
		
			const AddressBookSourceSimpleDatabaseSchemaDefinition* pCur = 
				aData.m_Schemata.getConstArray();
			UString aSql(L"SELECT ");
		
			// select columns
			// collect all requested props
			const AddressBookSourceSimpleDatabaseFieldMapping* pBegin = 
				pCur->FieldMappings.getConstArray();
			const AddressBookSourceSimpleDatabaseFieldMapping* pEnd = 
				pBegin + pCur->FieldMappings.getLen();
			UString* pFirstProp = aProperties.getArray();
			UString* pLastProp = pFirstProp + aProperties.getLen();
			sort( pFirstProp, pLastProp, isLess );
			UString aCols;
			UString aComma( UString::createFromAscii( "," ) );
			for( ;pBegin != pEnd; pBegin++ ) 
			{
				pair< UString*, UString*> aPair;
				aPair = equal_range( 
					pFirstProp, pLastProp, pBegin->Name, isLess );
				if( aPair.first != aPair.second )
				{
					if( aCols.len() ) aCols += aComma;
					aCols += pBegin->DatabaseName;
				}
			}
		
			aSql += aCols;
		
			// from clause
			( aSql += UString::createFromAscii(" FROM " )) += pCur->Table;
		
			if( aQuery.len() )
			{
				XAddressBookQueryParserRef xParser( 
					m_xMgr->createInstance(L"com.sun.star.address.AddressBookQueryParser"),
					USR_QUERY);
				AddressBookQueryTerm aTerm = xParser->parseTerm( aQuery );
				// where condition
				UniString aQuery;
				buildQueries( *pCur, aQuery, aTerm );
				if( aQuery.Len() )
				{
					aSql += UString::createFromAscii(" WHERE " );
					aSql += UString( aQuery ); 
				}
			}
		
			if( bSortOnServer )
			{
				INT32 nLen = aSortInfo.getLen() ;
				UString aSorting;
				if( nLen )
				{
					const AddressBookSortInfo* pSort = aSortInfo.getConstArray();
					UString aComma( UString::createFromAscii( "," ) );
					for( INT32 i=0; i<nLen; i++)
					{
						UString aFieldName;
						TRY
							{
								aFieldName = mapToDBFieldName( *pCur, pSort[i].Property );
								if( aSorting.len() ) aSorting += aComma;
								( aSorting += aFieldName ) +=
									UString::createFromAscii(
										pSort[i].Ascending ? " ASC " : 
										" DESC " );
							}
						CATCH( NoSuchElementException, e )
							{
							}
						END_CATCH;
					}
				}
				if( aSorting.len() ) ( aSql += UString::createFromAscii(" ORDER BY " )) += aSorting;
			}
		
			XDatabaseCursorRef xCursor;

			XDatabaseConnectionRef xCon = m_xSource->getConnection();
			if( !xCon.is() ) THROW( CantConnectException() );
			m_xStatement = m_xSource->getConnection()->createStatement(
				UString( aSql ),FALSE ) ;
			xCursor =  m_xStatement->executeQuery( 
				DatabaseCursorType_FORWARD, DatabaseCursorOption_READONLY );
			// extract data
			XPropertySetRef xRecord = xCursor->getRecord();
			Sequence<Property> aFields = xRecord->getPropertySetInfo()->getProperties();
			INT32 nCount = aFields.getLen();
			const Property* pFields = aFields.getConstArray();


			XNameContainerRef xTables = xCon->getTables();
			XPropertySetRef xTable;
			TRY
			{
				extractInterface( 
					xTables->getByName( pCur->Table ), xTable );
			}
			CATCH( NoSuchElementException, e )
			{
			}
			END_CATCH;
				
			if( !xTable.is() ) THROW( IllegalArgumentException() );
			
			short nPrivs = 0;
			xTable->getPropertyValue( L"Priviliges" ) >>= nPrivs;
			BOOL bUpdatable = !!(nPrivs & DatabasePrivilige_UPDATE_DATA );
			BOOL bRemovable = !!(nPrivs & DatabasePrivilige_DELETE_DATA );
			
			XNameAccessRef xFields( xCursor->getRecord(), USR_QUERY );
			while( !m_bCanceled && xCursor->isValid() )
			{
				ORecord aRecord;
				UString aUid;
				aRecord.m_SchemaName = pCur->Name;
				aRecord.m_IsRemovable = bRemovable;
			
				vector<AddressBookParameteredPropertyValue>  aValues;
				AddressBookParameteredPropertyValue  aValue;
				Sequence<AddressBookParameteredValue>* pSequence;
			
						XAddressBookSchemataSupplierRef xSup(
					m_xSource->getRecordContainer(), USR_QUERY );
				UsrAny aProps = xSup->getSchemata()->getByName(
					pCur->Name );
				XPropertySetRef xProp;
				if( !(aProps >>= xProp ) ) THROW( RuntimeException() );
				xProp->getPropertyValue( L"Properties" ) >>= aRecord.m_Properties;
				const Sequence<AddressBookParameteredProperty>& aSchemaFields = 
					aRecord.m_Properties;
	
				AddressBookParameteredValue aPMValue;
				INT32 i;
				UsrAny aAny;
				// consider all db properties
				for ( i = 0; i < nCount; ++i )
				{
					aAny = xRecord->getPropertyValue( pFields[ i ].Name );
				
					const AddressBookSourceSimpleDatabaseSchemaDefinition* pSchemaDefinition = 
						aData.getSchemaDefinition( pCur->Name );
					INT32 nLen = pCur->FieldMappings.getLen();
					const AddressBookSourceSimpleDatabaseFieldMapping* pSchemaFields = 
						pCur->FieldMappings.getConstArray();
				
					// find corresponding addressbook field
					for( INT32 nPos = 0; nPos < nLen; nPos++ )
					{
						if( pSchemaFields[ nPos ].DatabaseName == pFields[ i ].Name )
						{
							aValue.Name = pSchemaFields[ nPos ].Name;
							// if we already have a property with this name, use it
							pSequence = 0;
							for( vector<AddressBookParameteredPropertyValue>::iterator 
									 aIter = aValues.begin();
								 aIter != aValues.end(); aIter++ )
								if( (*aIter).Name == aValue.Name )
								{
									pSequence = &(*aIter).Values;
									break;
								}
							if( !pSequence )
							{
								aValues.push_back( aValue );
								pSequence = &aValues.back().Values;
							}
							aPMValue.Parameters = pSchemaFields[ nPos ].Parameters;
							// append value to the sequence in the propertyvalue
							INT32 nLen = pSequence->getLen();
							pSequence->realloc( nLen + 1 );
							//! Type conversion
							aPMValue.Value = 
								OAddressBookSourceSimpleDatabase::
								getPropertyFromAny(
									pSchemaDefinition->Name,
									pSchemaFields[ nPos ], aAny );
							if( aValue.Name == L"Uid" )
								aPMValue.Value >>= aRecord.m_Uid;
							
							pSequence->getArray()[ nLen ] = aPMValue;
						}
					}
				}
				// copy values to sequence
				sort( aValues.begin(), aValues.end(), isLessPropertyValue );
				copyContainerToSequence( aValues, aRecord.m_Values );
			
				if( pResultSet ) pResultSet->appendRecord( aRecord);
				else
				{
					JobEvent aEvent;
					aEvent.Source = *this;
					aEvent.Type = JobEventType_DATA;
					aEvent.Data <<= 
						OObjectClass<ORecord>::getInstance().getPropertyValues(
							&aRecord );
					xCallback->updateJobState( aEvent );
				}
				xCursor->moveRelative( 1 );
			}
			if( pResultSet )
			{
				pResultSet->getRecords().sort();
				JobEvent aEvent;
				aEvent.Source = *this;
				aEvent.Type = JobEventType_DATA;
				for( list<ORecord>::iterator aIter = pResultSet->getRecords().begin();
					 aIter != pResultSet->getRecords().end(); aIter++ )
				{
					aEvent.Data <<= OObjectClass<ORecord>::getInstance().getPropertyValues(
						&*aIter );
					xCallback->updateJobState( aEvent );
				}
				delete pResultSet;
			}
			JobEvent aEvent;
			aEvent.Source = *this;
			aEvent.Type = JobEventType_DONE;
			xCallback->updateJobState( aEvent );
			XComponentRef xComp( xCursor, USR_QUERY );
			xComp->dispose();
		}
	}
	CATCH( DatabaseDetailedException, e )
	{
		if( e.ExceptionContext == DatabaseExceptionContext_SYNTAX )
		{
			THROW( IllegalArgumentException() );
		}
		else THROW( CantConnectException() );
	}
	AND_CATCH( DatabaseException, e )
	{
		THROW( CantConnectException() );
	}
	END_CATCH;
	if( m_bCanceled ) 
	{
		JobEvent aEvent;
		aEvent.Source = *this;
		aEvent.Type = JobEventType_ERROR;
		aEvent.Data <<= CancelledException();
		xCallback->updateJobState( aEvent );
	}
}
	

