/*************************************************************************
 *
 *  $RCSfile: indexentrysupplier_complex.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: khong $ $Date: 2002/07/25 04:53:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _I18N_INDEXENTRYSUPPLIER_CTL_HXX_
#define _I18N_INDEXENTRYSUPPLIER_CTL_HXX_

#include <indexentrysupplier_default.hxx>

namespace com { namespace sun { namespace star { namespace i18n {

//	----------------------------------------------------
//	class IndexEntrySupplier_CTL
//	----------------------------------------------------
class IndexEntrySupplier_CTL : public IndexEntrySupplier_Unicode {
public:
	IndexEntrySupplier_CTL( const com::sun::star::uno::Reference < com::sun::star::lang::XMultiServiceFactory >& rxMSF ) : IndexEntrySupplier_Unicode(rxMSF) {
		implementationName = "com.sun.star.i18n.IndexEntrySupplier_CTL";
	};

protected:
	virtual rtl::OUString SAL_CALL getIndexString( const sal_Unicode ch,
		const sal_Unicode idxStr[], sal_Unicode idxStart, sal_Unicode idxEnd) 
		throw (com::sun::star::uno::RuntimeException);
};

#define INDEXENTRYSUPPLIER_CTL( algorithm ) \
class IndexEntrySupplier_##algorithm : public IndexEntrySupplier_CTL {\
public:\
	IndexEntrySupplier_##algorithm (const com::sun::star::uno::Reference < com::sun::star::lang::XMultiServiceFactory >& rxMSF) : IndexEntrySupplier_CTL (rxMSF) {\
		implementationName = "com.sun.star.i18n.IndexEntrySupplier_"#algorithm;\
	};\
	virtual rtl::OUString SAL_CALL getIndexCharacter( const rtl::OUString& rIndexEntry,\
		const com::sun::star::lang::Locale& rLocale, const rtl::OUString& rSortAlgorithm ) throw (com::sun::star::uno::RuntimeException);\
};

INDEXENTRYSUPPLIER_CTL( ar_alphanumeric )
INDEXENTRYSUPPLIER_CTL( he_alphanumeric )
INDEXENTRYSUPPLIER_CTL( hi_alphanumeric )
INDEXENTRYSUPPLIER_CTL( th_alphanumeric )
#undef INDEXENTRYSUPPLIER_CTL

} } } } 
#endif
