/*************************************************************************
 *
 *  $RCSfile: searchcache.cxx,v $
 *
 *  $Revision: 1.2.94.3 $
 *
 *  last change: $Author: vg $ $Date: 2004/05/03 16:55:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "setup2/script.hxx"
#include "setup2/sifsys.hxx"

#include "protocol.hxx"
#include "scplink.hxx"

#include "searchcache.hxx"

// ============================================================================

extern Protocol* pLog;

IncludeList aIncLst;
LanguageList aLanguageList;
SearchOrderList aSearchOrderList;

#define ALL_LANG 33
const char* ppAllLang[ALL_LANG] = { "01", "03", "07", "26", "27", "28", "30", "31", "33", "34", "35", "36", "39", "42", "43",
	"45", "46", "47", "48", "49", "50", "53", "55", "77", "79", "81", "82", "86", "88", "90", "96", "97", "99" };

///////////////////////////////////////////////////////////////////////////////
//	search file include cache
///////////////////////////////////////////////////////////////////////////////
ByteString _FindSourcefile( const ByteString& rSearchname, USHORT nLang )
{
	USHORT x;
	for( x = 0; x < aSearchOrderList.Count(); ++x )
	{
		SearchOrder* pOrder = aSearchOrderList.GetObject(x);
		switch( pOrder->eTyp )
		{
			case srch_nolang:
			{
				Include* pInc = (Include*) pOrder->pList;
				for( USHORT xx = 0; xx < pInc->aFileLst.Count(); ++xx )
				{
					ByteString aFilename( *(pInc->aFileLst.GetObject(xx)) );
					if( aFilename.CompareIgnoreCaseToAscii(rSearchname) == COMPARE_EQUAL )
					{
						aFilename.Insert( pInc->aBaseDir, 0 );
						return aFilename;
					}
				}
			} break;

			case srch_lang:
			{
				LangId* pLangId = (LangId*) pOrder->pList;
				if( pLangId->nId == nLang )
				for( USHORT xx = 0; xx < pLangId->aIncLst.Count(); ++xx )
				{
					Include* pInc = pLangId->aIncLst.GetObject(xx);
					for( USHORT xxx = 0; xxx < pInc->aFileLst.Count(); ++xxx )
					{
						ByteString aFilename( *(pInc->aFileLst.GetObject(xxx)) );
						if( aFilename.CompareIgnoreCaseToAscii(rSearchname) == COMPARE_EQUAL )
						{
							aFilename.Insert( pInc->aBaseDir, 0 );
							return aFilename;
						}
					}
				}
			} break;
		}
	}
	return ByteString();
}

ByteString ExtNOCacheSearch( const ByteString& rSearchname,
							 const ByteString& rPathExtension, USHORT nLang )
{
	USHORT x;
	for( x = 0; x < aSearchOrderList.Count(); ++x )
	{
		SearchOrder* pOrder = aSearchOrderList.GetObject(x);
		switch( pOrder->eTyp )
		{
			case srch_nolang:
			{
				Include* pInc = (Include*) pOrder->pList;
				SiDirEntry aEntry( pInc->aBaseDir );
				aEntry += rPathExtension;
				aEntry += rSearchname;
				if( aEntry.Exists() )
					return aEntry.GetFull();
			} break;

			case srch_lang:
			{
				LangId* pLangId = (LangId*) pOrder->pList;
				if( pLangId->nId == nLang )
				for( USHORT xx = 0; xx < pLangId->aIncLst.Count(); ++xx )
				{
					Include* pInc = pLangId->aIncLst.GetObject(xx);
					SiDirEntry aEntry( pInc->aBaseDir );
					aEntry += rPathExtension;
					aEntry += rSearchname;
					if( aEntry.Exists() )
						return aEntry.GetFull();
				}
			} break;
		}
	}
	return ByteString();
}

ByteString FindSourcefile( const ByteString& rSearchname, USHORT nLang )
{
	ByteString aReturn( _FindSourcefile( rSearchname, nLang ) );
	if( !aReturn.Len() )
		for( USHORT i = 0; i < ALL_LANG; ++i )
			if( rSearchname.Search(ppAllLang[i]) != STRING_NOTFOUND )
			{
				ByteString aModSearchname( rSearchname );
				aModSearchname.SearchAndReplace( ppAllLang[i], "01" );
				aReturn = _FindSourcefile( aModSearchname, 1 );
				if( aReturn.Len() )
				{
					ByteString aMsg( "warning: '" );
					aMsg += rSearchname;
					aMsg += "' file not found use '";
					aMsg += aModSearchname;
					aMsg += "' instead!	";
					pLog->Log( aMsg );
				}
				break;
			}
	return aReturn;
}

ByteString FindSourcefile( SiFile* pFile, USHORT nLang )
{
	ByteString aSearchname = pFile->GetName();
	return FindSourcefile( aSearchname, nLang );
}

///////////////////////////////////////////////////////////////////////////////
//	include cache
///////////////////////////////////////////////////////////////////////////////
void _LogPreCache( const ByteString& rPath, ULONG nFiles )
{
	if( !pLog ) return;

	ByteString aMsg;
	aMsg = "precache include '";
	aMsg += rPath;
	aMsg += "' ";
	aMsg += ByteString::CreateFromInt32( nFiles );
	aMsg += " files.";

	pLog->Log( aMsg );
}

void _MakeDelimiter( ByteString& rPath )
{
	ByteString aDelim = ByteString( SiDirEntry::GetAccessDelimiter(), osl_getThreadTextEncoding() );
	if( rPath.GetChar(rPath.Len()-1) != aDelim.GetChar(0) )
		rPath += aDelim;
}

void ScanFileList( const ByteString& rPath, FileList& rLst )
{
	Dir aFiles( rPath, FSYS_KIND_FILE );
	for( USHORT i = 0; i < aFiles.Count(); ++i )
	{
		SiDirEntry aEntry(aFiles[i]);
		ByteString* pName = new ByteString(aEntry.GetName());
		rLst.Insert( pName, LIST_APPEND );
	}
}

void PreCacheIncludes(const ByteString& rIncParam)
{
	USHORT nDelimTok = 0;
	USHORT nTokCount = rIncParam.GetTokenCount(PARA_DELIM);

	for( USHORT x = 0; x < nTokCount; ++x )
	{
		ByteString aPath = rIncParam.GetToken(0, PARA_DELIM, nDelimTok);

		if( aPath.Search(META_LANG) == STRING_NOTFOUND )
		{
			_MakeDelimiter(aPath);

			Include* pInc = new Include;
			pInc->aBaseDir = aPath;
			ScanFileList( aPath, pInc->aFileLst );

			aIncLst.Insert( pInc, LIST_APPEND );

			SearchOrder* pOrder = new SearchOrder;
			pOrder->eTyp = srch_nolang;
			pOrder->pList = (List*) pInc;
			aSearchOrderList.Insert( pOrder, LIST_APPEND );

			_LogPreCache( aPath, pInc->aFileLst.Count() );
		}
		else
		{
			for( USHORT xx = 0; xx < aLanguageList.Count(); ++xx )
			{
				LangId* pLangId = aLanguageList.GetObject(xx);
				ByteString aLang( ByteString::CreateFromInt32(pLangId->nId) );
				ByteString aLangPath( aPath );

				if( aLang.Len() == 1) aLang.Insert( "0", 0 );
					while(aLangPath.SearchAndReplace(META_LANG, aLang) != STRING_NOTFOUND);

				_MakeDelimiter(aLangPath);

				Include* pInc = new Include;
				pInc->aBaseDir = aLangPath;
				ScanFileList( aLangPath, pInc->aFileLst );

				SearchOrder* pOrder = new SearchOrder;
				pOrder->eTyp = srch_lang;
				pOrder->pList = (List*) pLangId;
				aSearchOrderList.Insert( pOrder, LIST_APPEND );

				pLangId->aIncLst.Insert( pInc, LIST_APPEND );
				_LogPreCache( aLangPath, pInc->aFileLst.Count() );
			}
		}


	}

	if( pLog ) pLog->NewLine();
}

///////////////////////////////////////////////////////////////////////////////

void DeleteSearchCache()
{
	USHORT x;
	for( x = 0; x < aSearchOrderList.Count(); ++x )
	{
		SearchOrder* pSrch = aSearchOrderList.GetObject(x);
		delete pSrch;
	}
	aSearchOrderList.Clear();

	for( x = 0; x < aIncLst.Count(); ++x )
	{
		Include* pInc = aIncLst.GetObject(x);
		for( USHORT xx = 0; xx < pInc->aFileLst.Count(); ++xx )
			delete pInc->aFileLst.GetObject(xx);
		delete pInc;
	}

	for( x = 0; x < aLanguageList.Count(); ++x )
	{
		LangId* pLangId = aLanguageList.GetObject(x);
		for( USHORT xx = 0; xx < pLangId->aIncLst.Count(); ++xx )
		{
			Include* pInc = pLangId->aIncLst.GetObject(xx);
			for( USHORT xxx = 0; xxx < pInc->aFileLst.Count(); ++xxx )
				delete pInc->aFileLst.GetObject(xxx);
			delete pInc;
		}
		delete pLangId;
	}
}

