/*************************************************************************
 *
 *  $RCSfile: magenda.cxx,v $
 *
 *  $Revision: 1.22.114.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 18:52:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#include "main.hxx"
#include "mainwnd.hxx"
#include "magenda.hxx"
#include "action.hxx"
#include "critical.hxx"

#include "environ.hxx"
#include "script.hxx"

#include "insrtdsk.hxx"
#include "querydlg.hxx"
#include "overdlg.hxx"
#include "getpassdlg.hxx"
#include "strings.hrc"
#include "app.hrc"
#include "error.hrc"

UIAgendaCallback::UIAgendaCallback( SetupWindow* pWin, SiCompiledScript* pCS, SiEnvironment* pEnv )
{
	m_pMainWin			= pWin;
	m_pCS		   		= pCS;
	m_pEnv 				= pEnv;

	m_nOverwriteStatus	= STATUS_YES;

	m_bSlideShow 		= FALSE;
	m_nSlides			= 0;
	m_nCurrentSlide		= 0;
	m_eOldActionType	= AT_UNKNOWN;

	if( m_pEnv->IsFirstInstallation() )
	{
		SiSlide* pSlide = m_pCS->GetSlideList().GetObject(0);
		if( pSlide )
		{
			m_aSlidePath = m_pEnv->GetStartPath();
			m_nSlides = (USHORT) m_pCS->GetSlideList().Count();

			SiDirEntry aSlidefile( m_aSlidePath );
			aSlidefile += pSlide->GetBmpFileName();

			if( aSlidefile.Exists() )
				m_bSlideShow = TRUE;
		}
	}
	if ( m_pMainWin )
        m_pMainWin->GetLeftWin()->StartProgress();
}

UIAgendaCallback::~UIAgendaCallback()
{
	if ( m_pMainWin )
    {
        m_pMainWin->GetContWin()->Reset();
	    m_pMainWin->GetLeftWin()->ShowInstInfo( FALSE );
	    m_pMainWin->GetLeftWin()->StopProgress();
    }
}

void UIAgendaCallback::StartCompileHelp()
{
    if ( m_pMainWin )
    {
	    NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
	    m_pMainWin->GetLeftWin()->SetActionType( AT_HELP );
    }
}

void UIAgendaCallback::EndCompileHelp()
{
    if ( m_pMainWin )
    	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
}

void UIAgendaCallback::StartRegisterUNO()
{
    if ( m_pMainWin )
    {
        NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
        m_pMainWin->GetLeftWin()->SetActionType( AT_REGUNO );
    }
}

void UIAgendaCallback::EndRegisterUNO()
{
    if ( m_pMainWin )
        NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
}

void UIAgendaCallback::StartRegister()
{
    if ( m_pMainWin )
    {
	    NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
	    m_pMainWin->GetLeftWin()->SetActionType( AT_REGISTER );
    }
}

void UIAgendaCallback::EndRegister()
{
    if ( m_pMainWin )
    	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
}

void UIAgendaCallback::ProgressTransfer( USHORT nPercent )
{
    if ( m_pMainWin )
    {
	    NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	    m_pMainWin->GetLeftWin()->SetPercentage( nPercent );
	    if( m_bSlideShow && m_nSlides > 0 )
	    {
		    int nNextSlide = 1 + nPercent / (100 / m_nSlides);
		    if( m_nCurrentSlide != nNextSlide )
		    {
			    m_nCurrentSlide = nNextSlide;
			    if( m_pCS->GetSlideList().Count() != 0 &&
				    m_nCurrentSlide <= m_pCS->GetSlideList().Count() )
			    {
				    SiSlide* pSlide = m_pCS->GetSlideList().GetObject(m_nCurrentSlide-1);
				    if( m_pEnv->GetInstallType() == IT_WORKSTATION && m_nCurrentSlide != 1 )
					    return;
				    m_pMainWin->GetContWin()->AnimSlide( pSlide );
			    }
		    }
	    }
    }
}

void UIAgendaCallback::ProgressAction( SiActionType eType, USHORT nPercent, const ByteString& rMsg )
{
	if( m_pEnv->IsResponsefileMode() && m_pEnv->IsVerboseMode() )
	{
		if( rMsg.Len() || m_eOldActionType != eType )
		{
			m_eOldActionType = eType;
			switch( eType )
			{
				case AT_MAKEDIR:	fprintf( stderr, "\nmake directory: %s", rMsg.GetBuffer() ); break;
				case AT_RMDIR:		fprintf( stderr, "\nremove directory: %s", rMsg.GetBuffer() ); break;

				case AT_COPY:		fprintf( stderr, "\ncopy file: %s", rMsg.GetBuffer() ); break;
				case AT_UNZIP:		fprintf( stderr, "\nunpack file: %s", rMsg.GetBuffer() ); break;
				case AT_DELETE:		fprintf( stderr, "\ndelete files: %s", rMsg.GetBuffer() ); break;

				case AT_REGUNO:		fprintf( stderr, "\nregister uno component: %s", rMsg.GetBuffer() ); break;

				case AT_PROCEDURE:	fprintf( stderr, "\ncall procedure: %s", rMsg.GetBuffer() ); break;
				case AT_CUSTOM:		fprintf( stderr, "\nexecute custom plugin: %s", rMsg.GetBuffer() ); break;

				case AT_CONFIGURATION: fprintf( stderr, "\nregister configuration: " ); break;

				case AT_REGISTER:	fprintf( stderr, "\nwrite local configuration: " ); break;
				case AT_HELP:		fprintf( stderr, "\nbuild help files: " ); break;
				case AT_UNREGISTER:	fprintf( stderr, "\nunregister profiles: " ); break;
			}
		}
		else fprintf( stderr, "." );
	}

    if ( m_pMainWin )
    {
	    NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
        m_pMainWin->GetLeftWin()->SetActionType( eType );
    }

    ProgressTransfer( nPercent );
}

UIAgendaCallback::ChangedDisk UIAgendaCallback::ChangeDisk( const ByteString& rFilename,
															int nDiskNo, const ByteString& rDiskname )
{
	if ( m_pMainWin )
    {
        NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	    if( pSetupApp->IsResponseMode() )
		    Critical_Error( ERR_INSTFILENOTFOUND, rFilename );

	    SetupInsertDiskDialog *pDlg = new SetupInsertDiskDialog(
			    m_pMainWin->GetContWin(),
			    Point(50,50),
			    pSetupApp->GetEnvironment()->GetProductName(),
			    rDiskname,
			    m_pEnv->GetSourcePath() );
	    m_pMainWin->ToTop( TOTOP_RESTOREWHENMIN );

	    if( rFilename.Len() != 0 )
	    {
		    pDlg->SetError();
		    pDlg->SetFileText(rFilename);
	    }

	    USHORT nRet = pDlg->Execute();

	    if( nRet == RET_OK )
		    m_pEnv->SetSourcePath( ByteString(pDlg->GetSourcePath(), osl_getThreadTextEncoding()) );

	    delete pDlg;

	    if( nRet == RET_CANCEL &&
		    QueryBox(m_pMainWin, ResId(DLG_QUERYEXITBOX)).Execute() == RET_NO )
		    nRet = RET_OK;

	    return nRet == RET_OK ?		 CHANGEDDISK_OK
		    : (nRet == RET_CANCEL  ? CHANGEDDISK_CANCEL
							       : CHANGEDDISK_IGNORE );
    }
    else
        return SiAgendaCallback::ChangeDisk( rFilename, nDiskNo, rDiskname );
}

UIAgendaCallback::ExecErrorAction UIAgendaCallback::ErrorRegisterUnoComponent(const ByteString& rFilename)
{
	if ( m_pMainWin )
    {
        NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	    String aErrorText( ResId(ERR_REGISTERUNOCOMPONENT) );
	    aErrorText.SearchAndReplace( UniString::CreateFromAscii("%1"),
					    UniString::CreateFromAscii(rFilename.GetBuffer()) );


	    if(!pSetupApp->IsResponseMode() )
	    {
			SetupExecErrorDialog aDlg( m_pMainWin );
			m_pMainWin->ToTop( TOTOP_RESTOREWHENMIN );
			
			aDlg.SetErrorText( aErrorText );
			switch( aDlg.Execute() )
			{
		    case RET_CANCEL:	return EEA_CANCEL;
		    case RET_RETRY:		return EEA_RETRY;
		    case RET_OK:
		    default:			return EEA_IGNORE;
			}
		}
    	return EEA_IGNORE;
    }
    else
        return SiAgendaCallback::ErrorRegisterUnoComponent( rFilename );
}

UIAgendaCallback::ExecErrorAction UIAgendaCallback::ExecutionError( SiAction* pAction )
{
	String	anError;
	BOOL	bExecuteDlg = TRUE;

	if ( ! m_pEnv->HasVCL() || pSetupApp->IsResponseMode() )
    {
        switch( pAction->GetType() )
        {
	        case AT_COPY:   anError = String::CreateFromAscii( "An error occurred while copying the file %1 to %2" );
		        break;
	        case AT_UNZIP:  anError = String::CreateFromAscii( "An error occurred while unpacking the file %1" );
		        break;
	        case AT_MAKEDIR:anError = String::CreateFromAscii( "An error occured while creating directory: " );
		        break;
        }
    }
    else
    {
        NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
        switch( pAction->GetType() )
        {
	        case AT_COPY:       anError = String( ResId(ERR_COPYFILE) );
                break;
	        case AT_UNZIP:      anError = String( ResId(ERR_EXPLODEFILE) );
		        break;
	        case AT_MAKEDIR:    anError = String( ResId(ERR_MAKEDIR) );
		        break;
        }
    }

    switch( pAction->GetType() )
	{
		case AT_COPY:
		{
			const SiTransferAction* pTransAction = (const SiTransferAction*) pAction;

			SiDirEntry aDir  = m_pEnv->GetDestPath();
			           aDir += pTransAction->GetDestPath();

			anError.SearchAndReplace(UniString::CreateFromAscii("%1"), UniString::CreateFromAscii(pTransAction->GetDestFile().GetBuffer()) );
			anError.SearchAndReplace(UniString::CreateFromAscii("%2"), aDir.GetFullUni());

			if( pSetupApp->IsResponseMode() )
				Critical_Error( ERR_COPY_FILE, ByteString(anError, osl_getThreadTextEncoding()) );
			break;
		}

		case AT_UNZIP:
		{
			ByteString aFileName( ((SiTransferAction*)pAction)->GetDestFile() );
			SiDirEntry aEntry( aFileName );

			if( aEntry.GetExtension().CompareIgnoreCaseToAscii( "ttf" ) == COMPARE_EQUAL )
				bExecuteDlg = FALSE;

			anError.SearchAndReplace(UniString::CreateFromAscii("%1"),
							UniString::CreateFromAscii(aFileName.GetBuffer()) );

			if( pSetupApp->IsResponseMode() )
				Critical_Error( ERR_ZIP_FILE, ByteString(anError, osl_getThreadTextEncoding()) );
			break;
		}

		case AT_MAKEDIR:
		{
			SiDirEntry aDir  = m_pEnv->GetDestPath();
                       aDir += ((SiMakeDirAction*)pAction)->GetName();
			anError += aDir.GetFullUni();

			if( pSetupApp->IsResponseMode() )
				Critical_Error( ERR_MAKE_DIR, ByteString(anError, osl_getThreadTextEncoding()) );
			break;
		}

		default:
			return EEA_IGNORE;
	}

	if ( m_pMainWin )
    {
        NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	    if( bExecuteDlg && !pSetupApp->IsResponseMode() )
	    {
		    SetupExecErrorDialog aDlg( m_pMainWin );
		    m_pMainWin->ToTop( TOTOP_RESTOREWHENMIN );
		    aDlg.SetErrorText(anError);
		    switch( aDlg.Execute() )
		    {
			    case RET_CANCEL:	return EEA_CANCEL;
			    case RET_RETRY:		return EEA_RETRY;
			    case RET_OK:
			    default:			return EEA_IGNORE;
		    }
	    }
    	return EEA_IGNORE;
    }
    else
        return SiAgendaCallback::ExecutionError( pAction );
}

BOOL UIAgendaCallback::RequestBigFile( const ByteString& rDiskname )
{
	if( pSetupApp->IsResponseMode() || ! m_pMainWin )
    {
		Critical_Error( ERR_INSTFILENOTFOUND, "" );
        return SiAgendaCallback::RequestBigFile( rDiskname );
    }

    NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	SiDirEntry aEntry( m_pEnv->GetSourcePath() );
	aEntry.ToAbs();
	ByteString aFileName = aEntry.GetName();

	SiDirEntry temp = aEntry.GetPath();
	SetupInsertDiskDialog *pDlg = new SetupInsertDiskDialog(
			m_pMainWin->GetContWin(), Point(50,50), pSetupApp->GetEnvironment()->GetProductName(),
			rDiskname, temp.GetFull() );

	m_pMainWin->ToTop( TOTOP_RESTOREWHENMIN );

	pDlg->SetError();
	pDlg->SetFileText( aFileName );

	BOOL bFnd = FALSE;
	while( !bFnd )
	{
		USHORT nRet = pDlg->Execute();
		if( nRet == RET_CANCEL && QueryBox(m_pMainWin, ResId(DLG_QUERYEXITBOX)).Execute() == RET_NO ) {}
		if( nRet == RET_OK )
		{
			aEntry = pDlg->GetSourcePath();
			aEntry += aFileName;
			aEntry.ToAbs();
			if( aEntry.Exists() )
			{
				ArchDirectory* pArch = new ArchDirectory;
				pArch->SetArchFile(aEntry.GetFull().GetBuffer());

				m_pEnv->SetArchive( pArch, FindArch );
				m_pEnv->SetSourcePath( aEntry.GetFull() );

				bFnd = TRUE;
			}
		}
	}
	delete pDlg;

    return TRUE;
}

BOOL UIAgendaCallback::OverwriteFile( const ByteString& rFilename, const SiFile* pFile )
{
	if( pSetupApp->IsResponseMode() || ! m_pMainWin )
        return SiAgendaCallback::OverwriteFile( rFilename, pFile );

	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	SiDirEntry aEntry(rFilename);

	if( m_nOverwriteStatus == STATUS_EVER ||
        m_pEnv->IsUpdateOldVersion() ||
        m_pEnv->IsUpgradeOldVersion() || 
        m_pEnv->GetInstallMode() == IM_PATCH )
		return TRUE;
	else if( m_nOverwriteStatus == STATUS_NEVER )
		return FALSE;

	if( pFile->DontDelete() && !pFile->IsFontWarnIfExists() )
		return TRUE;

	if( pFile->Overwrite() )
		return TRUE;

	ULONG nSize = 0;
	if( !pFile->IsArchive() )
		nSize = pFile->GetSize();
	else
	{
		const SiSubfileList& rLst = pFile->GetSubfileList();
		for( ULONG i = 0; i < rLst.Count(); i++ )
		{
			SiSubfile* pSubfile = rLst.GetObject(i);
            xub_StrLen nStart = pSubfile->aFilename.Search( aEntry.GetName() );
			if( ( nStart != STRING_NOTFOUND ) && 
                ( nStart + aEntry.GetName().Len() == pSubfile->aFilename.Len() ) )
            {
				nSize =	pSubfile->nSize;
                break;
            }
		}
	}

	FileStat aStat(aEntry);
	ULONG nExistSize = aStat.GetSize();
	DateTime aExistDate = DateTime( aStat.DateModified(), aStat.TimeModified() );
	if( nSize == nExistSize &&
		DateTime(pFile->GetDate(), pFile->GetTime()) == aExistDate )
    {
        // Don't overwrite fonts if not necessary
        if ( pFile->IsFont() )
            return FALSE;
        else
            return TRUE;
    }

	// #97944# We don't want an overwrite warning for fonts, when they propably
    // hadn't changed. ( Ignore date, because fonts usualy dont change between office
    // versions, but file date does. )
    // #102578# Allways replace an old font when the new one is more than 10 times
    // bigger.
    if ( pFile->IsFont() )
    {
        if ( nSize == nExistSize )
            return FALSE;
        if ( nSize > 10 * nExistSize )
            return TRUE;
        if ( nSize * 10 < nExistSize )
            return FALSE;
    }
    
    OverwriteFileDialog aDlg(m_pMainWin);
	m_pMainWin->ToTop( TOTOP_RESTOREWHENMIN );

	aDlg.SetExistFile(aEntry);
	aDlg.SetSourceFile( nSize, pFile->GetDate(), pFile->GetTime() );
	aDlg.Execute();

	m_nOverwriteStatus = aDlg.GetStatus();

	if( m_nOverwriteStatus == STATUS_YES ||
		m_nOverwriteStatus == STATUS_EVER )
		return TRUE;

	return FALSE;
}

ByteString UIAgendaCallback::GetAdminPassword()
{
	if( m_pMainWin )
    {
	    GetAdminPasswordDlg aDlg(m_pMainWin);
	    aDlg.Execute();
	    return aDlg.GetPass();
    }
    else
        return SiAgendaCallback::GetAdminPassword();
}


