/*************************************************************************
 *
 *  $RCSfile: idochdl.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: tra $ $Date: 2002/08/26 10:53:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
 
#ifndef _IDOCHDL_HXX_
#define _IDOCHDL_HXX_

#ifndef _TYPES_HXX_
#include "types.hxx"
#endif

//------------------------------
// ISaxDocumentHandler interface
//------------------------------

class ISaxDocumentHandler  
{
public:	
	virtual ~ISaxDocumentHandler() {};
	
	virtual void StartDocument() = 0;
	
	virtual void EndDocument() = 0;

	virtual void StartElement(
		const std::wstring& RawName, 
		const std::wstring& LocalName, 
		const XmlTagAttributes_t& XmlAttributes) = 0;

	virtual void EndElement(
		const std::wstring& RawName, 
		const std::wstring& LocalName) = 0;

	virtual void Characters(
		const std::wstring& Character) = 0;

	virtual void IgnoreWhitespace(
		const std::wstring& Whitespaces) = 0;

	virtual void ProcessingInstruction(
		const std::wstring& Target, const std::wstring& Data) = 0;

	virtual void Comment(const std::wstring& Comment) = 0;
};

#endif

