/*************************************************************************
 *
 *  $RCSfile: ctxmenu.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CTXMENU_HXX
#define _CTXMENU_HXX

#ifndef _FASTFSYS_HXX
#include <fastfsys.hxx>
#endif

//************************************************************************
//* ImplSendToMenu
//************************************************************************

class ImplSendToMenu : public IfcContextMenu
{
public:
	virtual UINT32 GetItemCount();
	virtual BOOL GetMenuItem( UINT32 nIndex, MenuItem & rItem );
	virtual IfcContextMenu *GetSubMenu( UINT32 nIndex );
	virtual BOOL ExecuteCommand( String aCommand );

public:
	ImplSendToMenu( LPSHELLFOLDER, LPDATAOBJECT );
	virtual ~ImplSendToMenu();

protected:
	LPDATAOBJECT	m_pDataObject;

	// Instanzen der Quelle merken

	LPSHELLFOLDER	m_pSendToFolder;
	LPITEMIDLIST	m_pItems[2048];
	USHORT			m_nItems;
};


//************************************************************************
//* ImplContextMenu
//************************************************************************

class ImplContextMenu : public IfcContextMenu
{
public:
	virtual UINT32 GetItemCount();
	virtual BOOL GetMenuItem( UINT32 nIndex, MenuItem & rItem );
	virtual IfcContextMenu *GetSubMenu( UINT32 nIndex );
	virtual BOOL ExecuteCommand( String aCommand );

public:
	ImplContextMenu( LPCONTEXTMENU, LPDATAOBJECT = NULL, HMENU = NULL );
	virtual ~ImplContextMenu();

protected:
	LPCONTEXTMENU	m_pUIContextMenu;
	LPDATAOBJECT	m_pDataObject;
	HMENU			m_hMenu;
	BOOL			m_fValid;

	// Instanzen der Quelle merken

	friend class Folder;
};

//************************************************************************
//* ImplInternetExplorerMenu
//************************************************************************

class ImplInternetExplorer4Menu : public ImplContextMenu
{
public:
	ImplInternetExplorer4Menu( LPCONTEXTMENU pMenu, LPDATAOBJECT pData = NULL, HMENU hMenu = NULL ) :
	  ImplContextMenu( pMenu, pData, hMenu ) {}
	virtual BOOL ExecuteCommand( String aCommand );
	BOOL InvokeInternal( const String & crURL );
};

#endif // _CTXMENU_HXX
