#include <sys/types.h>
#include <string.h>
#include <stdio.h>

#include <berkeleydb/db.h>

#define DBFFIELDLEN_URL		200
#define DBFFIELDLEN_ID		19
#define DBFFIELDLEN_STORAGE	20
#define DBFFIELDLEN_TITLE	200

int main( int argc, char* argv[] )
{
	if ( argc < 3 )
	{
		fprintf( stderr, "Usage: DBF2DB dbf-filename berkeley-filename [/verbose] [/suppressstorage]" );
		return 1;
	}
	else
	{
		DB* dbp;
		DBT key, data;
		if ( db_create( &dbp, NULL, 0 ) )
		{
			fprintf( stderr, "Error initializing BDB" );
			return 2;
		}

		FILE* pDBFFile = fopen( argv[1], "rb" );
		if ( !pDBFFile )
		{
			fprintf( stderr, "Error open dbf file" );
			return 3;
		}
		
		if ( dbp->open( dbp, argv[2], NULL, DB_BTREE, DB_CREATE|DB_TRUNCATE, 0664 ) )
		{
			fprintf( stderr, "Error creating berkeley database file" );
			return 4;
		}

		int bVerbose = 0;
		int bSuppressStorage = 0;

		for ( int nArg = 3; nArg < argc; nArg++ )
		{
			if ( strcmp( argv[nArg], "/verbose" ) == 0 )
				bVerbose = 1;
			else if ( strcmp( argv[nArg], "/suppressstorage" ) == 0 )
				bSuppressStorage = 1;
		}
		
		char nDBFVersion = 0;
		unsigned short nHeaderLen;
		unsigned long nRecords = 0;
		char buffer[256];
				
		/* DBF
		fread( &nDBFVersion, 1, 1, pDBFFile );
		fread( buffer, 3, 1, pDBFFile );	// Date
		fread( &nRecords, 4, 1, pDBFFile );
		fread( &nHeaderLen, 2, 1, pDBFFile );	// Header Len
		fseek( pDBFFile, nHeaderLen, SEEK_SET );
		*/

		fprintf( stdout, "\nDBF-Version: %c\n\nImporting records...\n\n", nDBFVersion+'0' );

		// DBF: for ( unsigned long n = 0; n < nRecords; n++ )
		while ( !feof( pDBFFile ) && !ferror( pDBFFile ) ) 
		{
			char buffer_id[256];
			char buffer_data[4096];
			int nDataLen = 0;
			int nIdLen = 0;
			
			char* pStart;
			char* pEnd;
			int  nL;
			// DBF: fread( buffer, 1, 1, pDBFFile ); // Delete mark

			// --- URL ---
			fread( buffer, DBFFIELDLEN_URL, 1, pDBFFile );

			/* No DBF */ if ( feof( pDBFFile ) || ferror( pDBFFile ) )
			/* No DBF */ 	break;

			pStart = buffer;
			pEnd = buffer+DBFFIELDLEN_URL-1;
			// Skip trailing blanks
			while ( *pEnd == ' ' )
				pEnd--;
			pEnd++;
			nL = (pEnd-pStart);
			buffer_data[nDataLen++] = nL;
			memcpy( buffer_data+nDataLen, buffer, nL );
			nDataLen += nL;

			// --- ID ---
			fread( buffer_id, DBFFIELDLEN_ID, 1, pDBFFile );
			pStart = buffer_id;
			pEnd = pStart;
			while ( *pEnd != ' ' )
				pEnd++;
			nIdLen = (pEnd-pStart);
			
			// --- STORAGE ---
			fread( buffer, DBFFIELDLEN_STORAGE, 1, pDBFFile );
			pStart = buffer;
			if ( !bSuppressStorage )
			{
				pEnd = buffer+DBFFIELDLEN_STORAGE-1;
				// Skip trailing blanks
				while ( *pEnd == ' ' )
					pEnd--;
				pEnd++;
			}
			else
			{
				pEnd = pStart;
			}
			nL = (pEnd-pStart);
			buffer_data[nDataLen++] = nL;
			memcpy( buffer_data+nDataLen, buffer, nL );
			nDataLen += nL;
			
			// --- TITLE ---
			fread( buffer, DBFFIELDLEN_TITLE, 1, pDBFFile );
			pStart = buffer;
			pEnd = buffer+DBFFIELDLEN_TITLE-1;
			// Skip trailing blanks
			while ( *pEnd == ' ' )
				pEnd--;
			pEnd++;
			nL = (pEnd-pStart);
			buffer_data[nDataLen++] = nL;
			memcpy( buffer_data+nDataLen, buffer, nL );
			nDataLen += nL;

			buffer_id[nIdLen] = 0;
			buffer_data[nDataLen] = 0;
			
			if ( bVerbose )
				fprintf( stdout, "ID: %s, DATA: %s\n", buffer_id, buffer_data );

			memset(&key, 0, sizeof(key));
			memset(&data, 0, sizeof(data));
			key.data = buffer_id;
			key.size = nIdLen;
			data.data = buffer_data;
			data.size = nDataLen;
		
			if ( dbp->put(dbp, NULL, &key, &data, 0) )
			{
				fprintf( stderr, "Error storing into database!" );
				return 5;
			}
			
			/* No DBF */ fseek( pDBFFile, 1, SEEK_CUR ); // Skip '\0A'
			/* No DBF */ nRecords++;
		}

		fprintf( stdout, "Done - imported %lu records.\n\n", nRecords );

		dbp->close(dbp, 0);
	}
	return 0;
}
