/*************************************************************************
 *
 *  $RCSfile: pkgchk_configuration.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/28 13:26:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "pkgchk_env.h"
#include "cppuhelper/implbase1.hxx"

#include "com/sun/star/io/XActiveDataSink.hpp"
#include "com/sun/star/xml/sax/XDocumentHandler.hpp"


using namespace ::rtl;
using namespace ::osl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star;

namespace pkgchk
{

//==============================================================================
class SchemaDocHandler :
        public ::cppu::WeakImplHelper1< xml::sax::XDocumentHandler >
{
    bool m_inited;
    
public:
    inline SchemaDocHandler()
        : m_inited( false )
        {}
    
    OUString m_name;
    OUString m_package;
    
    // XDocumentHandler impl
    virtual void SAL_CALL startDocument()
        throw (xml::sax::SAXException, RuntimeException);
    virtual void SAL_CALL endDocument()
        throw (xml::sax::SAXException, RuntimeException);
    virtual void SAL_CALL startElement(
        OUString const & name,
        Reference< xml::sax::XAttributeList > const & xAttributes )
        throw (xml::sax::SAXException, RuntimeException);
    virtual void SAL_CALL endElement(
        OUString const & name )
        throw (xml::sax::SAXException, RuntimeException);
    virtual void SAL_CALL characters(
        OUString const & chars )
        throw (xml::sax::SAXException, RuntimeException);
    virtual void SAL_CALL ignorableWhitespace(
        OUString const & whitespaces )
        throw (xml::sax::SAXException, RuntimeException);
    virtual void SAL_CALL processingInstruction(
        OUString const & target, OUString const & data )
        throw (xml::sax::SAXException, RuntimeException);
    virtual void SAL_CALL setDocumentLocator(
        Reference< xml::sax::XLocator > const & xLocator )
        throw (xml::sax::SAXException, RuntimeException);
};

// XDocumentHandler impl

//______________________________________________________________________________
void SchemaDocHandler::startDocument()
    throw (xml::sax::SAXException, RuntimeException)
{
}

//______________________________________________________________________________
void SchemaDocHandler::endDocument()
    throw (xml::sax::SAXException, RuntimeException)
{
}

//______________________________________________________________________________
void SchemaDocHandler::startElement(
    OUString const & name,
    Reference< xml::sax::XAttributeList > const & xAttributes )
    throw (xml::sax::SAXException, RuntimeException)
{
    if (! m_inited)
    {
        // simple namespace matching...
        OUString prefix;
        OUString xmlns( RTL_CONSTASCII_USTRINGPARAM("xmlns:") );
        // get prefix for xmlns "http://openoffice.org/2001/registry"
        for ( sal_Int16 pos = xAttributes->getLength(); pos--; )
        {
            if (xAttributes->getValueByIndex( pos ).equalsAsciiL(
                    RTL_CONSTASCII_STRINGPARAM("http://openoffice.org/"
                                               "2001/registry") ))
            {
                OUString attribute( xAttributes->getNameByIndex( pos ) );
                if (attribute.match( xmlns ))
                {
                    prefix = attribute.copy( sizeof ("xmlns:") -1 );
                    break;
                }
            }
        }
        if (0 == prefix.getLength())
        {
            throw xml::sax::SAXException(
                OUSTR("cannot determine xmlns prefix of "
                      "\"http://openoffice.org/2001/registry\"!"),
                Reference< XInterface >(), Any() );
        }
        
        // "name" attribute
        m_name = xAttributes->getValueByName( prefix + OUSTR(":name") );
        if (0 == m_name.getLength())
        {
            throw xml::sax::SAXException(
                OUSTR("missing schema name attribute!"),
                Reference< XInterface >(), Any() );
        }
        // "package" attribute
        m_package = xAttributes->getValueByName( prefix + OUSTR(":package") );
        if (0 == m_package.getLength())
        {
            throw xml::sax::SAXException(
                OUSTR("missing schema package attribute!"),
                Reference< XInterface >(), Any() );
        }
        
        m_inited = true;
    }
}

//______________________________________________________________________________
void SchemaDocHandler::endElement(
    OUString const & name )
    throw (xml::sax::SAXException, RuntimeException)
{
}

//______________________________________________________________________________
void SchemaDocHandler::characters(
    OUString const & chars )
    throw (xml::sax::SAXException, RuntimeException)
{
}

//______________________________________________________________________________
void SchemaDocHandler::ignorableWhitespace(
    OUString const & whitespaces )
    throw (xml::sax::SAXException, RuntimeException)
{
}

//______________________________________________________________________________
void SchemaDocHandler::processingInstruction(
    OUString const & target, OUString const & data )
    throw (xml::sax::SAXException, RuntimeException)
{
}

//______________________________________________________________________________
void SchemaDocHandler::setDocumentLocator(
    Reference< xml::sax::XLocator > const & xLocator )
    throw (xml::sax::SAXException, RuntimeException)
{
}


//______________________________________________________________________________
void pkgchk_env::xcs_merge_in( OUString const & url ) const
{
    OUString path( expand_reg_url( url ) );
    FileStatus status( c_default_file_status_mask );
    path_get_status( &status, path, c_default_file_status_mask );
    FileStatus::Type file_type = status.getFileType();
    
    if (FileStatus::Directory == file_type)
    {
        Directory dir( path );
        dir_open( dir, path );
        while (true)
        {
            {
            DirectoryItem dirItem;
            Directory::RC rc = dir.getNextItem( dirItem );
            if (Directory::E_NOENT == rc)
                break;
            if (Directory::E_None != rc || !dirItem.is())
            {
                throw RuntimeException(
                    OUSTR("cannot get next dir item from ") + path,
                    Reference< XInterface >() );
            }
            diritem_get_status( &status, dirItem, c_default_file_status_mask );
            } // release dir item
            // recurse
            xcs_merge_in( status.getFileURL() );
        }
    }
    else if (ends_with_ignore_ascii_case(
                 path, RTL_CONSTASCII_STRINGPARAM(".xcs") ))
    {
        OUString config_path(
            path_concat(
                m_cache_path,
                RTL_CONSTASCII_STRINGPARAM("registry/data") ) );
        
        OUStringBuffer buf( 128 );
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("adding ") );
        buf.append( path );
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(" to ") );
        buf.append( config_path );
        
        try
        {
            // parse out schema package
            SchemaDocHandler * handler = new SchemaDocHandler();
            Reference< xml::sax::XDocumentHandler > xHandler( handler );
            xml_parse( path, xHandler );
            
            OUStringBuffer dest_buf( 128 );
            dest_buf.append( m_cache_path );
            dest_buf.appendAscii(
                RTL_CONSTASCII_STRINGPARAM("/registry/schema/") );
            dest_buf.append( handler->m_package.replace( '.', '/' ) );
            OUString dest_dir( dest_buf );
            dest_buf.append( (sal_Unicode) '/' );
            dest_buf.append( handler->m_name );
            dest_buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(".xcs") );
            OUString dest( dest_buf.makeStringAndClear() );
            
            if (path_exists( dest ))
            {
                buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(": schema file ") );
                buf.append( dest );
                buf.appendAscii(
                    RTL_CONSTASCII_STRINGPARAM(" already exists.") );
            }
            else
            {
                if (! path_exists( dest_dir ))
                {
                    sal_Int32 index = dest_dir.indexOf(
                        (sal_Unicode) '/',
                        m_cache_path.getLength() + sizeof ("/registry/") -1 );
                    while (index >= 0)
                    {
                        OUString dir( dest_dir.copy( 0, index ) );
                        if (! path_exists( dir ))
                            dir_create( dir );
                        index = dest_dir.indexOf( (sal_Unicode) '/', index +1 );
                    }
                    dir_create( dest_dir );
                }
                path_copy( dest, path, *this );
                buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(": ok.") );
            }
            
            log( buf.makeStringAndClear() );
        }
        catch (RuntimeException &)
        {
            throw;
        }
        catch (Exception & exc)
        {
            buf.appendAscii(
                RTL_CONSTASCII_STRINGPARAM(": failed!  exception occured: ") );
            buf.append( exc.Message );
            err( buf.makeStringAndClear() );
        }
    }
}

//______________________________________________________________________________
void pkgchk_env::xcu_merge_in( OUString const & url ) const
{
    OUString path( expand_reg_url( url ) );
    FileStatus status( c_default_file_status_mask );
    path_get_status( &status, path, c_default_file_status_mask );
    FileStatus::Type file_type = status.getFileType();
    
    if (FileStatus::Directory == file_type)
    {
        Directory dir( path );
        dir_open( dir, path );
        while (true)
        {
            {
            DirectoryItem dirItem;
            Directory::RC rc = dir.getNextItem( dirItem );
            if (Directory::E_NOENT == rc)
                break;
            if (Directory::E_None != rc || !dirItem.is())
            {
                throw RuntimeException(
                    OUSTR("cannot get next dir item from ") + path,
                    Reference< XInterface >() );
            }
            diritem_get_status( &status, dirItem, c_default_file_status_mask );
            } // release dir item
            // recurse
            xcu_merge_in( status.getFileURL() );
        }
    }
    else if (ends_with_ignore_ascii_case(
                 path, RTL_CONSTASCII_STRINGPARAM(".xcu") ))
    {
        OUString config_path(
            path_concat(
                m_cache_path,
                RTL_CONSTASCII_STRINGPARAM("registry") ) );
        
        OUStringBuffer buf( 128 );
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("merging ") );
        buf.append( path );
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(" into ") );
        buf.append( config_path );
        
        try
        {
            Reference< XComponentContext > const & xContext =
                get_component_context();
            if (! m_xMergeImporter.is())
            {
                m_xMergeImporter.set(
                    xContext->getServiceManager()->createInstanceWithContext(
                        OUSTR("com.sun.star.configuration."
                              "backend.MergeImporter"),
                        xContext ),
                    UNO_QUERY );
                if (! m_xMergeImporter.is())
                {
                    throw DeploymentException(
                        OUSTR("no configuration merge importer available!"),
                        Reference< XInterface >() );
                }
            }
            
            Reference< configuration::backend::XLayer > xLayer(
                xContext->getServiceManager()->createInstanceWithContext(
                    OUSTR("com.sun.star.configuration.backend.xml.LayerParser"),
                    xContext ),
                UNO_QUERY );
            if (! xLayer.is())
            {
                throw DeploymentException(
                    OUSTR("no configuration layer parser service available!"),
                    Reference< XInterface >() );
            }
            Reference< io::XActiveDataSink > xActiveDataSink(
                xLayer, UNO_QUERY );
            if (! xActiveDataSink.is())
            {
                throw RuntimeException(
                    OUSTR("configuration layer parser does not support "
                          "io.XActiveDataSink!"),
                    Reference< XInterface >() );
            }
            
            xActiveDataSink->setInputStream(
                get_simple_file_access()->openFileRead( path ) );
            m_xMergeImporter->importLayerForEntity( xLayer, config_path );
            
            buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(": ok.") );
            log( buf.makeStringAndClear() );
        }
        catch (RuntimeException &)
        {
            throw;
        }
        catch (Exception & exc)
        {
            buf.appendAscii(
                RTL_CONSTASCII_STRINGPARAM(": failed!  exception occured: ") );
            buf.append( exc.Message );
            err( buf.makeStringAndClear() );
        }
    }
}

//______________________________________________________________________________
void pkgchk_env::configuration_flush() const
{
    // ensure cache registry layer path
    dir_ensure(
        path_concat(
            m_cache_path,
            RTL_CONSTASCII_STRINGPARAM("registry") ) );
    
    // first schemata (xcs)
    if (!m_xcs_to_be_removed.empty() || !m_xcs_to_be_installed.empty())
    {
        if (m_xcs_to_be_removed.empty())
        {
            if (! m_xcs_to_be_installed.empty())
            {
                // merge in selected xcs files
                t_string_set::const_iterator iPos(
                    m_xcs_to_be_installed.begin() );
                t_string_set::const_iterator const iEnd(
                    m_xcs_to_be_installed.end() );
                for ( ; iPos != iEnd; ++iPos )
                {
                    xcs_merge_in( *iPos );
                }
            }
        }
        else // remove and merge up
        {
            path_erase(
                path_concat(
                    m_cache_path,
                    RTL_CONSTASCII_STRINGPARAM("registry/schema") ) );
            // merge up all cache packages xcs files
            xcs_merge_in(
                path_concat(
                    m_cache_path,
                    RTL_CONSTASCII_STRINGPARAM("uno_packages") ) );
        }
        
        log( OUSTR("updated configuration schema layer: ok.") );
    }
    
    // then data (xcu)
    if (!m_xcu_to_be_removed.empty() || !m_xcu_to_be_installed.empty())
    {
        if (m_xcu_to_be_removed.empty())
        {
            if (! m_xcu_to_be_installed.empty())
            {
                // merge in selected xcu files
                t_string_set::const_iterator iPos(
                    m_xcu_to_be_installed.begin() );
                t_string_set::const_iterator const iEnd(
                    m_xcu_to_be_installed.end() );
                for ( ; iPos != iEnd; ++iPos )
                {
                    xcu_merge_in( *iPos );
                }
            }
        }
        else // remove and merge up
        {
            path_erase(
                path_concat(
                    m_cache_path,
                    RTL_CONSTASCII_STRINGPARAM("registry/data") ) );
            // merge up all cache packages xcu files
            xcu_merge_in(
                path_concat(
                    m_cache_path,
                    RTL_CONSTASCII_STRINGPARAM("uno_packages") ) );
        }
        
        log( OUSTR("updated configuration data layer : ok.") );
    }
}

}
