/*************************************************************************
 *
 *  $RCSfile: importpages.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:03:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_IMPORTPAGES_HXX_
#define _EXTENSIONS_DBI_IMPORTPAGES_HXX_

//#ifndef _EXTENSIONS_DBI_WIZARDSTATEMACHINE_HXX_
//#include "wizardstatemachine.hxx"
//#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _SV_FIXED_HXX 
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_EDIT_HXX 
#include <vcl/edit.hxx>
#endif
#ifndef _SV_BUTTON_HXX 
#include <vcl/button.hxx>
#endif
#ifndef _SV_GROUP_HXX 
#include <vcl/group.hxx>
#endif
#ifndef _EXTENSIONS_DBI_URLCONTROL_HXX
#include "urlcontrol.hxx"
#endif
#ifndef _EXTENSIONS_DBI_FIXEDEDIT_HXX_
#include "fixededit.hxx"
#endif
#ifndef _COMPHELPER_STLTYPES_HXX_
#include <comphelper/stl_types.hxx>
#endif
#ifndef _SV_FIXED_HXX 
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_LSTBOX_HXX 
#include <vcl/lstbox.hxx>
#endif
#ifndef _EXTENSIONS_DBI_DBITYPES_HXX_
#include "dbitypes.hxx"
#endif
#ifndef _SVTOOLS_WIZARDMACHINE_HXX_
#include <svtools/wizardmachine.hxx>
#endif

//.........................................................................
namespace dbi
{
//.........................................................................

	class OImportSdbDialog;
	struct OImportSettings;
	class OSdbFileAccess;

	//=====================================================================
	//= OImportPage
	//=====================================================================
	typedef ::svt::OWizardPage OImportPage_Base;
	class OImportPage : public OImportPage_Base
	{
	protected:
		FixedBitmap		m_aPicture;

	public:
		OImportPage( OImportSdbDialog* _pParent, const ResId& _rId );

	protected:
		// helper
		OImportSdbDialog*	getDialog();
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >
								getORB();
		OImportSettings&		getSettings();
		const OSdbFileAccess&	getSdbInfo();

		// TabDialog overridables
		virtual void		DeactivatePage();
			// will automatically enable the NEXT button
	};

	//=====================================================================
	//= OSdbSelectionPage
	//=====================================================================
	class OSdbSelectionPage : public OImportPage
	{
	protected:
		FixedLine		m_aFrame;
		FixedText		m_aSdbSelectionLabel;
		OFileURLControl	m_aSdbSelection;
		PushButton		m_aBrowseSdb;
		FixedLine		m_aImportWarningSeparator;
		FixedText		m_aImportWarning;

	public:
		OSdbSelectionPage( OImportSdbDialog* _pParent );

	protected:
		DECL_LINK( OnBrowseSdbFile, PushButton* );
		DECL_LINK( OnEditModified, void* );

		// OWizardPage overridables
		virtual void		initializePage();
		virtual sal_Bool	commitPage(COMMIT_REASON _eReason);

		// TabDialog overridables
		virtual void		ActivatePage();
		virtual void		DeactivatePage();

		// OImportPage overridables
		virtual sal_Bool determineNextButtonState();
	};

	//=====================================================================
	//= OContentSelectionPage
	//=====================================================================
	class OContentSelectionPage : public OImportPage
	{
	protected:
		FixedLine		m_aSourceFrame;
		FixedMultiEdit	m_aSourceStatistics;

		FixedLine		m_aDestFrame;
		CheckBox		m_aCreateDatasource;
		CheckBox		m_aImportQueries;
		CheckBox		m_aImportForms;
		FixedMultiEdit	m_aSmallHelp;

		sal_Int32		m_nQueryCount;
		sal_Int32		m_nFormCount;

		String			m_sHelpDS;
		String			m_sHelpQueries;
		String			m_sHelpForms;
		String			m_sStatisticsBase;
		String			m_sPreviousHelp;

	public:
		OContentSelectionPage( OImportSdbDialog* _pParent );

	protected:
		DECL_LINK( OnCheckboxToggled, CheckBox* );

		// OWizardPage overridables
		virtual void		initializePage();
		virtual sal_Bool	commitPage(COMMIT_REASON _eReason);

		// TabDialog overridables
		virtual void	ActivatePage();

		// OImportPage overridables
		virtual sal_Bool determineNextButtonState();

	protected:
		virtual long	Notify( NotifyEvent& _rNEvt );

	protected:
		void setHelpText(const String& _rText);
	};

	//=====================================================================
	//= ODsnAdjustmentPage
	//=====================================================================
	class ODsnAdjustmentPage : public OImportPage
	{
	protected:
		FixedLine		m_aFrame;
		FixedText		m_aDescription;
		FixedText		m_aDesc2;
		FixedText		m_aOldLabel;
		FixedEdit		m_aOldDsn;
		FixedText		m_aNewLabel;
		Edit			m_aNewDsn;
		FixedText		m_aExample;

	public:
		ODsnAdjustmentPage( OImportSdbDialog* _pParent );
		
		// OWizardPage overridables
		virtual void		initializePage();
		virtual sal_Bool	commitPage(COMMIT_REASON _eReason);

		// TabDialog overridables
		virtual void	ActivatePage();
	};

	//=====================================================================
	//= OObjectSelectionPage
	//=====================================================================
	class OObjectSelectionPage : public OImportPage
	{
	protected:
		FixedLine		m_aFrame;
		ListBox			m_aObjectList;
		PushButton		m_aSelectAll;
		PushButton		m_aSelectNone;

	public:
		OObjectSelectionPage( OImportSdbDialog* _pParent, const ResId& _rId );

	protected:
		void	fillList(const StringArray& _rArray);
		void	checkItems(const StringArray& _rChecked);
		void	getCheckedItems(StringArray& /* [out] */ _rChecked);

		void	adjustZOrder();

		// check if the given object selection is valid
		// if _pMessagParent is NULL, no error messages will appear in case of invalidity
		static	sal_Bool checkSelection(const StringArray& _rChecked, Window* _pMessagParent);

	protected:
		DECL_LINK( OnSelectAll, PushButton* );
		DECL_LINK( OnSelectNone, PushButton* );
		DECL_LINK( OnEntrySelected, ListBox* );

		// OImportPage overridables
		virtual sal_Bool determineNextButtonState();
	};

	//=====================================================================
	//= OFormImportPage
	//=====================================================================
	class OFormImportPage : public OObjectSelectionPage
	{
	protected:
		FixedText		m_aPathLabel;
		OFileURLControl	m_aPath;
		PushButton		m_aBrowsePath;
		FixedText		m_aFormListLabel;

	public:
		OFormImportPage( OImportSdbDialog* _pParent );

		// check if the given settings are valid from the page's point of view
		// if _pMessagParent is NULL, no error messages will appear in case of invalidity
		static sal_Bool isValid(const OImportSettings& _rSettings, Window* _pMessagParent);

	protected:
		DECL_LINK( OnBrowsePath, PushButton* );
		DECL_LINK( OnPathModified, Edit* );

		// OWizardPage overridables
		virtual void		initializePage();
		virtual sal_Bool	commitPage(COMMIT_REASON _eReason);

		// OImportPage overridables
		virtual sal_Bool	determineNextButtonState();

		// TabDialog overridables
		virtual void	ActivatePage();
	};

	//=====================================================================
	//= OQueryImportPage
	//=====================================================================
	class OQueryImportPage : public OObjectSelectionPage
	{
	protected:
		FixedLine		m_aDSLine;
		FixedText		m_aDSSelectionLabel;
		ListBox			m_aDSSelection;
		FixedText		m_aDSSelectionDesc;
		FixedText		m_aLabel;

		String			m_sInsertIntoNewDS;

	public:
		OQueryImportPage( OImportSdbDialog* _pParent );

		// OWizardPage overridables
		virtual void		initializePage();
		virtual sal_Bool	commitPage(COMMIT_REASON _eReason);

		// TabDialog overridables
		virtual void	ActivatePage();

		// check if the given settings are valid from the page's point of view
		// if _pMessagParent is NULL, no error messages will appear in case of invalidity
		static sal_Bool isValid(const OImportSettings& _rSettings, Window* _pMessagParent);

	protected:
		DECL_LINK( OnDSSelected, ListBox* );
		void implDSSelected(sal_Bool _bBroadcast);

		// OImportPage overridables
		virtual sal_Bool determineNextButtonState();
	};

	//=====================================================================
	//= OFinalizationPage
	//=====================================================================
	class OFinalizationPage : public OImportPage
	{
	protected:
		FixedLine		m_aStatisticsFrame;
		FixedText		m_aSdbSelectionLabel;
		FixedEdit		m_aSdbSelection;
		FixedText		m_aQueriesLabel;
		FixedText		m_aQueriesNumbers;
		FixedText		m_aFormsLabel;
		FixedText		m_aFormsNumbers;
		FixedText		m_aFormsDestinationLabel;
		FixedEdit		m_aFormsDestination;
		FixedLine		m_aDSNFrame;
		FixedText		m_aDSNLabel;
		Edit			m_aDSN;
		CheckBox		m_aAdministration;
		FixedText		m_aMessage;

		String			m_sSelectionCount;
		String			m_sExistenceMessage;

		sal_Bool		m_bMovedControlsUp;

	public:
		OFinalizationPage( OImportSdbDialog* _pParent );

		static sal_Bool isValid(const OImportSettings& _rSettings, const StringBag& _rDSNames);

	protected:
		DECL_LINK( OnNewDsnName, Edit* );
		DECL_LINK( OnAsynFillNames, void* );

		// OWizardPage overridables
		virtual void		initializePage();
		virtual sal_Bool	commitPage(COMMIT_REASON _eReason);

		// TabDialog overridables
		virtual void	ActivatePage();
		virtual void	DeactivatePage();

		// OImportPage overridables
		virtual sal_Bool determineNextButtonState();

	private:
		void		implSetNumbers(FixedText* _pControl, sal_Int32 _nSelected, sal_Int32 _nOverall);
		sal_Bool	implCheckDsnName();

		void		implMoveControls(sal_Bool _bUp);
	};

//.........................................................................
}	// namespace dbi
//.........................................................................

#endif // _EXTENSIONS_DBI_IMPORTPAGES_HXX_

