/*************************************************************************
 *
 *  $RCSfile: dbbrowse.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:32:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_DBBROWSE_HXX
#define _SVX_DBBROWSE_HXX

#ifndef _REF_HXX //autogen
#include <tools/ref.hxx>
#endif

#ifndef _WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif

#ifndef _LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif

#ifndef _IMAGEBTN_HXX //autogen
#include <vcl/imagebtn.hxx>
#endif

#ifndef _SVX_BRWBOX_HXX //autogen
#include <svtools/brwbox.hxx>
#endif

#ifndef _SV_TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif

class CellControllerRef;
class Edit;
class ListBoxFrame;
class ButtonCtrl;

//==================================================================
class CellController : public SvRefBase
{
	friend class DbBrowseBox;

protected:
	Window* pWindow;

public:
	CellController(Window* pW);
	virtual ~CellController();			// zerstoert das Fenster

	Window& GetWindow() const {return *((CellController*) this)->pWindow;}

	virtual void ClearModified() = 0;
	virtual BOOL IsModified() const = 0;

protected:
	virtual BOOL MoveAllowed(const KeyEvent& rEvt) const;
	virtual void SetModifyHdl(const Link& rLink) = 0;
	virtual BOOL WantMouseEvent() const;
};

SV_DECL_IMPL_REF(CellController);

//==================================================================
class EditCellController : public CellController
{
public:
	EditCellController(Edit* pEdit);
	Edit& GetEditWindow() const {return (Edit &)GetWindow();}

	virtual BOOL IsModified() const;
	virtual void ClearModified();

protected:
	virtual BOOL MoveAllowed(const KeyEvent& rEvt) const;
	virtual void SetModifyHdl(const Link& rLink);
};

//==================================================================
class ComboBoxCtrl : public Window
{
	friend class ComboBoxCellController;

	Timer	aAutoCompleteTimer;
	BOOL	bAutoCompleteEnabled;
	Link	aModLink;
	Link	aSelLink;
	USHORT 	nTextLen;
	String	aTempText;

	ListBoxFrame*	pListBoxFrame;
	Edit*			pEdit;
	ButtonCtrl*		pButton;
	BOOL			bDropping;

public:
	ComboBoxCtrl(Window* pParent, WinBits nWinStyle = 0);
	~ComboBoxCtrl();

	void    SetText(const String& rStr);
	String  GetText() const;

	BOOL    IsModified() const;
	void    SetModifyFlag();
	void    ClearModifyFlag();

	USHORT  GetEntryPos( const String& rStr ) const;
	String  GetEntry( USHORT nPos ) const;

	USHORT  InsertEntry( const String& rStr, USHORT nPos = (USHORT)0xFFFF);
	void    RemoveEntry( const String& rStr );

	void    SetEntryData( USHORT nPos, void* pNewData );
	void*   GetEntryData( USHORT nPos ) const;

	USHORT  GetEntryCount() const;
	void    Clear();

	void    SetSelection( const Selection& rSelection );
	Selection GetSelection() const;

	void            SaveValue();
	const String&   GetSavedValue() const;

	DECL_LINK(SelectHdl,  ListBox *);
	ListBox& GetListBox() const;

	virtual void SetModifyHdl( const Link& rLink );
	virtual void SetSelectHdl( const Link& rLink );

protected:
	// Methode, um das EditFeld zu benachrichtigen
	virtual void OnSelect(const String& rText);

	virtual void GetFocus();
	virtual void LoseFocus();
	virtual void Resize();
	virtual long Notify( NotifyEvent& rNEvt );
	virtual long PreNotify( NotifyEvent& rNEvt );
	virtual void MouseButtonUp( const MouseEvent& rEvt );
	virtual void KeyInput(const KeyEvent& rKEvt);

	BOOL MoveAllowed(const KeyEvent& rEvt) const;

private:
	DECL_LINK(ModifyHdl, void* );
	DECL_LINK(AutoCompleteHdl, void* );

	DECL_LINK(DropDownHdl, ImageButton *);
	DECL_LINK(CloseHdl, ListBox *);

	void DropListBox();
	void HideListBox();
	BOOL IsDropDownOpen() const;

	static Bitmap GetComboBitmap();
};

class ComboBoxCellController : public CellController
{
public:
	ComboBoxCellController(ComboBoxCtrl* pParent);

	ComboBoxCtrl& GetComboBox() const {return (ComboBoxCtrl &)GetWindow();}

	virtual BOOL IsModified() const;
	virtual void ClearModified();

protected:
	virtual BOOL MoveAllowed(const KeyEvent& rEvt) const;
	virtual void SetModifyHdl(const Link& rLink);
};

//==================================================================
class DbBrowseBox: public BrowseBox
{
public:
	enum RowStatus
	{
		CLEAN		=	0,
		CURRENT		=	1,
		CURRENTNEW	=	2,
		MODIFIED	=	3,
		NEW			=	4,
		DELETED		=	5,
		PRIMARYKEY	=	6,
		CURRENT_PRIMARYKEY = 7
	};

	enum BrowseInfo
	{
		COLSELECT	=	1,
		ROWSELECT	=	2,
		ROWCHANGE	=	4,
		COLCHANGE	=	8
	};

private:
	class BrowserMouseEventPtr // sich merken eines MEvt, mit down,up siehe impl
	{
		BrowserMouseEvent* pEvent;
		BOOL bDown;

	public:
		BrowserMouseEventPtr():pEvent(NULL){}
		~BrowserMouseEventPtr(){Clear();}

		BOOL Is() const {return pEvent != NULL;}
		BOOL IsDown() const {return bDown;}
		const BrowserMouseEvent* operator->() const {return pEvent;}
		const BrowserMouseEvent& operator*() const {return *pEvent;}

		void Clear();
		void Set(const BrowserMouseEvent* pEvt, BOOL bIsDown);
	} aMouseEvent;

	ImageList	aStatusList;

	const BrowserMouseEvent* pMouseEvent;	// ist waehrend eines MouseEvents gesetzt
	CellControllerRef		 aController,
							 aOldController;

	ULONG	nStartEvent, nEndEvent, nCellModifiedEvent;		// EventIDs

	long	nEditRow, nOldEditRow;
	USHORT	nEditCol, nOldEditCol;

	BOOL	bHasFocus;

protected:
	virtual void ColumnResized(USHORT nColId);
	virtual void Resize();
	virtual void ArrangeControls(USHORT& nX, USHORT nY);

	virtual void GetFocus();
	virtual void LoseFocus();
	virtual void KeyInput(const KeyEvent& rEvt);
	virtual void MouseButtonDown(const BrowserMouseEvent& rEvt);
	virtual void MouseButtonUp(const BrowserMouseEvent& rEvt);

	virtual long PreParentNotify(NotifyEvent& rNEvt );
	virtual long ParentNotify(NotifyEvent& rNEvt);

	virtual void EndScroll();
	virtual void Select();

	// Zeichnen des Statusfeldes einer Zeile
	// sollte statt GetFieldRectPixel verwendet werden,
	// da diese Methode die Raender miteinbezieht
	Rectangle GetCellRect(long nRow, USHORT nColId, BOOL bRelToBrowser = TRUE) const;
	virtual ULONG GetTotalCellWidth(long nRow, USHORT nColId);
	virtual ULONG GetAutoColumnWidth(USHORT nColId);

	virtual void PaintStatusCell(OutputDevice& rDev, const Rectangle& rRect) const;
	virtual void PaintCell(OutputDevice& rDev, const Rectangle& rRect, USHORT nColId) const = 0;

	virtual RowStatus GetRowStatus(long nRow) const;

	// Zeilenwechsel
	// CursorMoving:	Cursor wird bewegt, GetCurRow() ... liefern aber noch die original Werte
	//					hier sollte alles vorgenommen werden, was das Painten noch beeinflut
	virtual void CursorMoving(long nNewRow, USHORT nNewCol);

	// Cursorbewegung ist durchgefuehrt worden
	virtual void CursorMoved();

	virtual void ActivateCell(long nRow, USHORT	nCol, BOOL bSetCellFocus = TRUE);
	virtual void DeactivateCell(long nRow, USHORT nCol);
	virtual BOOL QueryDeactivation(USHORT) const;

	virtual void CellModified(); // sobald eine Zelle modifiziert wird, erfolgt der Aufruf
	virtual BOOL SaveModified(); // wird aufgerufen vor einem Zellenwechsel
								 // return FALSE, verhindert Zellenwechsel

	virtual BOOL IsModified() const {return aController.Is() && aController->IsModified();}

	virtual CellController* GetController(long nRow, USHORT nCol);
	virtual void InitController(CellControllerRef& rController, long nRow, USHORT nCol);
	virtual void ResizeController(CellControllerRef& rController, const Rectangle&);
	virtual void ReleaseController(CellControllerRef& pController, long nRow, USHORT nCol);
	virtual void DoubleClick(const BrowserMouseEvent&);

	void ActivateCell() {ActivateCell(GetCurRow(), GetCurColumnId());}
	// beim Draggen muss diese notification aufgerufen werden!
	void OnStartDrag();
	// Image fuer einen RowStatus erfahren
	Image GetImage(RowStatus) const;

public:
	DbBrowseBox(Window* pParent, WinBits nBits = 0,BrowserMode nMode = 0 );
	DbBrowseBox(Window* pParent, const ResId& rId, BrowserMode nMode = 0 );
	~DbBrowseBox();

	BOOL IsEditing() const {return aController.Is();}
	void InvalidateRow( long nRow );
	void InvalidateCell(long nRow, USHORT nColId){Invalidate(GetFieldRectPixel(nRow, nColId, TRUE));}
	void InvalidateStatusCell(long nRow) {InvalidateCell(nRow, 0);Update();}
	void InvalidateHandleColumn();

	CellControllerRef Controller() const {return aController;}

private:
	BrowseBox::ReserveControlArea;

	virtual void PaintField(OutputDevice& rDev, const Rectangle& rRect,
							USHORT nColumnId ) const;
	virtual BOOL IsCursorMoveAllowed(long nNewRow, USHORT nNewColId) const;

	void DetermineFocus();

	DECL_LINK(ModifyHdl, void* );
	DECL_LINK(StartEditHdl, void* );
	DECL_LINK(EndEditHdl, void* );
	DECL_LINK(CellModifiedHdl, void* );
};

#endif // _SVX_DBBROWSE_HXX
