/*************************************************************************
 *
 *  $RCSfile: rscinst.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: pl $ $Date: 2001/11/05 14:44:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdlib.h>
#include <stdio.h>

#ifndef _DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _RSCHASH_HXX
#include <rschash.hxx>
#endif
#ifndef _RSCTOP_HXX
#include <rsctop.hxx>
#endif
#ifndef _RSCDB_HXX
#include <rscdb.hxx>
#endif
#ifndef _RSCRSC_HXX
#include <rscrsc.hxx>
#endif
#ifndef _RSCPAR_HXX
#include <rscpar.hxx>
#endif
#ifndef _RSCINST_HXX
#include <rscinst.hxx>
#endif
#include <rtl/textenc.h>

/*************** V a r i a b l e ****************************************/
static RscDataBase * pHackBase = NULL;

/*************** C o d e ************************************************/
/*************************************************************************
|*
|*	  GetHashString( HASHID nId )
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
const char * GetHashString( HASHID nId )
{
	return pHS->Get( nId );
}

/*************************************************************************
|*
|*	  HashId()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
HASHID HashId( const char * pStr )
{
	return pHS->Test( pStr );
}

/*************** R s c D a t a B a s e **********************************/
/*************************************************************************
|*
|*	  RscSrc::RscDataBase()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 29.10.91
|*
*************************************************************************/
RscDataBase :: RscDataBase( RscError *pErrHdl )
{
	nLangType	= LANGUAGE_DONTKNOW;

	pCmdLine	= new RscCmdLine();

	// Kein Preprozessor, kein linken
	pCmdLine->nCommands = NOPREPRO_FLAG | NOLINK_FLAG | NOSYNTAX_FLAG;
	pTC = new RscTypCont( pErrHdl, LANGUAGE_DONTKNOW,
						  pCmdLine->nByteOrder,
						  RTL_TEXTENCODING_ASCII_US,
						  pCmdLine->aPath,
						  pCmdLine->nCommands );


	pHackBase = this; // Hack fuer Sytem und Sprachabhaengigkeit
}

/*************************************************************************
|*
|*	  RscDataBase::~RscDataBase()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 29.10.91
|*
*************************************************************************/
RscDataBase::~RscDataBase()
{
	if( pHackBase == this )
		pHackBase = NULL;

	delete pTC;
	delete pCmdLine;
}

/*************************************************************************
|*
|*	  RscDataBase::SetLanguage()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 09.12.91
|*	  Letzte Aenderung	MM 09.12.91
|*
*************************************************************************/
void RscDataBase::SetLanguage( HASHID nId )
{
	INT32 lValue;
	if( pTC->aLangType.GetConstValue( nId, &lValue ) )
		nLangType = (LanguageType)lValue;
	else
		nLangType = LANGUAGE_DONTKNOW;
}

/*************************************************************************
|*
|*	  RscDataBase::GetLanguage()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 09.12.91
|*	  Letzte Aenderung	MM 09.12.91
|*
*************************************************************************/
HASHID RscDataBase::GetLanguage() const
{
	HASHID nId;
	if( !pTC->aLangType.GetValueConst( nLangType, &nId ) )
		nId = HASH_NONAME;
	return nId;
}

/*************************************************************************
|*
|*	  RscDataBase::GetPathList()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 09.12.91
|*	  Letzte Aenderung	MM 09.12.91
|*
*************************************************************************/
ByteString RscDataBase::GetPath() const
{
	return pTC->GetSearchPath();
}

/*************************************************************************
|*
|*	  RscDataBase::GetPathList()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 09.12.91
|*	  Letzte Aenderung	MM 09.12.91
|*
*************************************************************************/
void RscDataBase::SetPath( const ByteString & rPath )
{
	pCmdLine->aPath = rPath;
	pTC->SetSearchPath( rPath );
}

/*************************************************************************
|*
|*	  RscDataBase::GetClassType( HASHID nClassName )
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 28.10.91
|*	  Letzte Aenderung	MM 28.10.91
|*
*************************************************************************/
RscTop * RscDataBase::GetClassType( HASHID nClassName )
{
	RscTop * pType;

	pType = pTC->Search( nClassName );

	if( !pType )
	{
		if( pTC->aBool.GetId() == nClassName )
			pType = &pTC->aBool;
		else if( pTC->aShort.GetId() == nClassName )
			pType = &pTC->aShort;
		else if( pTC->aUShort.GetId() == nClassName )
			pType = &pTC->aUShort;
		else if( pTC->aIdUShort.GetId() == nClassName )
			pType = &pTC->aIdUShort;
		else if( pTC->aIdNoZeroUShort.GetId() == nClassName )
			pType = &pTC->aIdNoZeroUShort;
		else if( pTC->aNoZeroShort.GetId() == nClassName )
			pType = &pTC->aNoZeroShort;
		else if( pTC->aIdLong.GetId() == nClassName )
			pType = &pTC->aIdLong;
		else if( pTC->aString.GetId() == nClassName )
			pType = &pTC->aString;
		else if( pTC->aWinBits.GetId() == nClassName )
			pType = &pTC->aWinBits;
		else if( pTC->aLangType.GetId() == nClassName )
			pType = &pTC->aLangType;
	}
	return pType;
}

/*************************************************************************
|*
|*	  RscDataBase::MakeConsistent()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 29.10.91
|*
*************************************************************************/
BOOL RscDataBase::MakeConsistent( RscInconsList * pList ){
	return( pTC->MakeConsistent( pList ) );
}

/*************************************************************************
|*
|*	  RscDataBase::GetFileStruct()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 29.10.91
|*
*************************************************************************/
RscFile * RscDataBase::GetFileStruct( ULONG lKey ){
	return( pTC->aFileTab.Get( lKey ) );
}

/*************************************************************************
|*
|*	  RscDataBase::GetFileTab()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 29.10.91
|*
*************************************************************************/
RscFileTab * RscDataBase::GetFileTab(){
	return( &pTC->aFileTab );
}

/*************************************************************************
|*
|*	  RscDataBase::AddSrcFile()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 05.12.91
|*	  Letzte Aenderung	MM 04.12.91
|*
*************************************************************************/
ULONG RscDataBase::AddSrcFile( const ByteString & rFileName )
{
	return pTC->aFileTab.NewCodeFile( rFileName );
}

/*************************************************************************
|*
|*	  RscDataBase::AddHrcFile()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 05.12.91
|*	  Letzte Aenderung	MM 04.12.91
|*
*************************************************************************/
ULONG RscDataBase::AddHrcFile( const ByteString & rFileName )
{
	return pTC->aFileTab.NewIncFile( rFileName, ByteString() );
}

/*************************************************************************
|*
|*	  RscDataBase::RemoveFile()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 04.11.91
|*	  Letzte Aenderung	MM 04.11.91
|*
*************************************************************************/
void RscDataBase::RemoveFile( ULONG lKey ){
	pTC->Delete( lKey );
	pTC->aFileTab.DeleteFile( lKey );
}

/*************************************************************************
|*
|*	  RscDataBase::ScanForIncFiles();
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 05.12.91
|*	  Letzte Aenderung	MM 05.12.91
|*
*************************************************************************/
void RscDataBase::ScanForIncFiles( ULONG lFileKey ){
	RscFile * pFName;

	pFName = pTC->aFileTab.Get( lFileKey );
	if( pFName ){
		pTC->pEH->nErrors = 0;
		RscCompiler aCompiler( pCmdLine, pTC );

		aCompiler.IncludeParser( lFileKey );
	}
}

/*************************************************************************
|*
|*	  RscDataBase::FindDef()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.11.91
|*	  Letzte Aenderung	MM 22.11.91
|*
*************************************************************************/
RscDefine * RscDataBase::FindDef( const ByteString & rMacroName )
{
	return pTC->aFileTab.FindDef( rMacroName );
}

/*************************************************************************
|*
|*	  RscDataBase::GetFileKey()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 18.12.91
|*	  Letzte Aenderung	MM 18.12.91
|*
*************************************************************************/
ULONG RscDataBase::GetFileKey( const ByteString & rFileName )
{
	RscFile * pFName;

	pFName = pTC->aFileTab.First();
	while( pFName ){
		if( pFName->aFileName == rFileName ){
			//FileName gleich
			return pTC->aFileTab.GetIndex( pFName );
		}
		pTC->aFileTab.Seek( pFName );
		pFName = pTC->aFileTab.Next();
	};
	return NOFILE_INDEX;
}

/*************** R s c H r c ********************************************/
/*************************************************************************
|*
|*	  RscHrc::RscHrc()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
RscHrc::RscHrc( RscDataBase * pDBase, ULONG lKey ){
	pDataBase = pDBase;
	lFileKey = lKey;
}

/*************************************************************************
|*
|*	  RscHrc::~RscHrc()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
RscHrc::~RscHrc(){
}

/*************************************************************************
|*
|*	  RscHrc::ReadFile()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 06.01.92
|*
*************************************************************************/
ERRTYPE RscHrc::ReadFile(){
	RscFile 	* pFName;

	pFName = pDataBase->pTC->aFileTab.Get( lFileKey );
	if( pFName ){
		pDataBase->pTC->pEH->nErrors = 0;
		RscCompiler aCompiler( pDataBase->pCmdLine, pDataBase->pTC );

		return aCompiler.ParseOneFile( lFileKey );
	}
	return ERR_NOINPUT;
}


/*************************************************************************
|*
|*	  RscHrc::GetDependList()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 02.12.91
|*
*************************************************************************/
RscDependList * RscHrc::GetDependList(){
	return GetFileStruct();
}

/*************************************************************************
|*
|*	  RscHrc::InsertDepend()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 06.01.92
|*
*************************************************************************/
void RscHrc::InsertDepend( ULONG lKey, ULONG lPos ){
	RscFile * pFName = GetFileStruct();

	if( pFName )
		pFName->InsertDependFile( lKey, lPos );
}

/*************************************************************************
|*
|*	  RscHrc::GetDefineList()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 29.10.91
|*
*************************************************************************/
RscDefineList * RscHrc::GetDefineList(){
	RscFile * pFName = GetFileStruct();

	if( pFName )
		return( &pFName->aDefLst );
	return( NULL );
}

/*************************************************************************
|*
|*	  RscHrc::FindDef()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 29.10.91
|*
*************************************************************************/
RscDefine * RscHrc::FindDef( const ByteString & rName )
{
	return( pDataBase->pTC->aFileTab.FindDef( lFileKey, rName ) );
}

/*************************************************************************
|*
|*	  RscHrc::NewDef()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 04.11.91
|*
*************************************************************************/
ERRTYPE RscHrc::NewDef( const ByteString & rMacroName, long lValue,
						ULONG lPos )
{
	ERRTYPE 	  aError;
	KEY_STRUCT	  aKey;

	if( pDataBase->pTC->aNmTb.Get( pHS->Test( rMacroName.GetBuffer() ), &aKey ) )
		aError = ERR_RSCINST_RESERVEDNAME;
	else{
		if( !pDataBase->pTC->aFileTab.NewDef( lFileKey, rMacroName,
											  lValue, lPos ) )
			aError = ERR_ERROR;
	}

	return( aError );
}

/*************************************************************************
|*
|*	  RscHrc::NewDef()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 05.11.91
|*
*************************************************************************/
ERRTYPE RscHrc::NewDef( const ByteString & rMacroName, const ByteString & rMacro,
						ULONG lPos )
{
	ERRTYPE 	  aError;
	KEY_STRUCT	  aKey;
	RscExpression * pExp;
	RscFileInst   aFileInst( pDataBase->pTC, lFileKey, lFileKey, rMacro );

	if( pDataBase->pTC->aNmTb.Get( HashId( rMacroName.GetBuffer() ), &aKey ) )
		aError = ERR_RSCINST_RESERVEDNAME;
	else{
		pExp = ::MacroParser( aFileInst );
		aError = aFileInst.GetError();
		if( !pExp )
			aError = ERR_ERROR;
		if( aError.IsOk() )
			if( !pDataBase->pTC->aFileTab.NewDef( lFileKey, rMacroName,
												  pExp, lPos ) )
				aError = ERR_ERROR;
	}

	return( aError );
}

/*************************************************************************
|*
|*	  RscHrc::ChangeDef()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 04.11.91
|*	  Letzte Aenderung	MM 05.12.91
|*
*************************************************************************/
ERRTYPE RscHrc::ChangeDef( const ByteString & rMacroName, long lId )
{
	ERRTYPE 	  aError;

	if( !pDataBase->pTC->aFileTab.ChangeDef( rMacroName, lId ) )
		aError = ERR_ERROR;

	return( aError );
}

/*************************************************************************
|*
|*	  RscHrc::ChangeDef()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 04.11.91
|*	  Letzte Aenderung	MM 04.11.91
|*
*************************************************************************/
ERRTYPE RscHrc::ChangeDef( const ByteString & rMacroName,
						   const ByteString & rMacro )
{
	ERRTYPE 	  aError;
	RscExpression * pExp;
	RscFileInst   aFileInst( pDataBase->pTC, lFileKey, lFileKey, rMacro );

	pExp = ::MacroParser( aFileInst );
	aError = aFileInst.GetError();
	if( !pExp )
		aError = ERR_ERROR;
	if( aError.IsOk() )
		if( !pDataBase->pTC->aFileTab.ChangeDef( rMacroName, pExp ) )
			aError = ERR_ERROR;

	return( aError );
}

/*************************************************************************
|*
|*	  RscHrc::IsDefUsed()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.11.91
|*	  Letzte Aenderung	MM 05.12.91
|*
*************************************************************************/
BOOL RscHrc::IsDefUsed( const ByteString & rMacroName )
{
	return pDataBase->pTC->aFileTab.IsDefUsed( rMacroName );
}

/*************************************************************************
|*
|*	  RscHrc::DelteteDef()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.11.91
|*	  Letzte Aenderung	MM 05.12.91
|*
*************************************************************************/
void RscHrc::DeleteDef( const ByteString & rMacroName )
{
	pDataBase->pTC->aFileTab.DeleteDef( rMacroName );
}

/*************************************************************************
|*
|*	  RscHrc::ChangeDefName()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 04.11.91
|*	  Letzte Aenderung	MM 05.12.91
|*
*************************************************************************/
ERRTYPE RscHrc::ChangeDefName( const ByteString & rMacroName,
									const ByteString & rNewName )
{
	ERRTYPE 	  aError;
	KEY_STRUCT	  aKey;

	if( pDataBase->pTC->aNmTb.Get( pHS->Test( rNewName.GetBuffer() ), &aKey ) )
		aError = ERR_RSCINST_RESERVEDNAME;
	else{
		if( !pDataBase->pTC->aFileTab.ChangeDefName( rMacroName, rNewName ) )
			aError = ERR_ERROR;
	}

	return( aError );
}

/*************************************************************************
|*
|*	  RscHrc::GetFileStruct()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 29.10.91
|*
*************************************************************************/
RscFile * RscHrc::GetFileStruct(){
	return pDataBase->GetFileStruct( lFileKey );
}

/*************************************************************************
|*
|*	  RscHrc::WriteFile()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 29.10.91
|*
*************************************************************************/
ERRTYPE RscHrc::WriteFile()
{
	FILE*		fFile;
	RscFile*	pFName;
	ERRTYPE 	aError;

	pFName = GetFileStruct();
	if( pFName )
	{
		fFile = fopen( pFName->aPathName.GetBuffer(), "w" );
		if( !fFile )
			aError = ERR_OPENFILE;
		else
		{
			if( pFName->IsIncFile() )
			{
				fprintf( fFile, "/* resource header file */\n" );
				pFName->aDefLst.WriteAll( fFile );
			}
			else
			{
				fprintf( fFile, "/* resource file */\n" );
				pDataBase->pTC->WriteSrc( fFile, lFileKey, RTL_TEXTENCODING_UNICODE );
			}
			fclose( fFile );
		}
	}
	else
		aError = ERR_ERROR;
	return aError;
}

/*************************************************************************
|*
|*	  RscHrc::Set-IsDirty()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 29.10.91
|*
*************************************************************************/
void RscHrc::SetDirty( BOOL bSet )
{
	RscFile 	* pFName;

	pFName = GetFileStruct();

	if( pFName )
		pFName->bDirty = bSet;
}

BOOL RscHrc::IsDirty()
{
	RscFile 	* pFName;

	pFName = GetFileStruct();

	if( pFName )
		return( pFName->bDirty );

	return( FALSE );
}

/*************************************************************************
|*
|*	  RscHrc::Set-GetPathName()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 29.10.91
|*
*************************************************************************/
void RscHrc::SetPathName( const ByteString & rName )
{
	RscFile 	* pFName;

	pFName = GetFileStruct();

	if( pFName )
		pFName->aPathName = rName;
}

ByteString RscHrc::GetPathName()
{
	RscFile 	* pFName;

	pFName = GetFileStruct();

	if( pFName )
		return pFName->aPathName;

	return ByteString();
}

/*************************************************************************
|*
|*	  RscHrc::Set-GetFileName()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 29.10.91
|*
*************************************************************************/
void RscHrc::SetFileName( const ByteString & rName )
{
	RscFile 	* pFName;

	pFName = GetFileStruct();

	if( pFName )
		pFName->aFileName = rName;
}

ByteString RscHrc::GetFileName()
{
	RscFile 	* pFName;

	pFName = GetFileStruct();

	if( pFName )
		return pFName->aFileName;

	return ByteString();
}

/*************************************************************************
|*
|*	  RscSrc::RscSrc()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
RscSrc::RscSrc( RscDataBase * pDBase, ULONG _lFileKey )
			: RscHrc( pDBase, _lFileKey )
{
}

/*************************************************************************
|*
|*	  RscSrc::~RscSrc()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
RscSrc::~RscSrc()
{
}

/*************************************************************************
|*
|*	  RscSrc::CreateRscInst()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 29.10.91
|*	  Letzte Aenderung	MM 05.12.91
|*
*************************************************************************/
RscInstCopy RscSrc::CreateRscInst( RscTop * pClass )
{
	RSCINST 	aInst( pClass, NULL );

	if( pClass )
		aInst = pClass->Create( NULL, RSCINST() );

	return RscInstCopy( aInst );
}

/*************************************************************************
|*
|*	  RscSrc::DeleteRscInst()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 10.07.91
|*	  Letzte Aenderung	MM 10.07.91
|*
*************************************************************************/
ERRTYPE RscSrc::DeleteRscInst( RscTop * pClass,
							   const RscId & rInstName )
{
	if( pClass )
		pDataBase->pTC->Delete( pClass->GetId(), rInstName );

	return ERR_OK;
}

/*************************************************************************
|*
|*	  RscSrc::SetRscInst()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 23.04.91
|*	  Letzte Aenderung	MM 23.04.91
|*
*************************************************************************/
ERRTYPE RscSrc::SetRscInst( const RscId & rInstName, RscInstCopy & rInst ){
	RSCINST 	aTmpI;
	ObjNode *	pNode;

	if( rInst.IsInst() ){
		// Instanz loeschen wenn sie vorhanden war
		DeleteRscInst( rInst.GetClassType(), rInstName );

		aTmpI = rInst.aInst.pClass->Create( NULL, rInst.aInst );
		pNode = new ObjNode( rInstName, aTmpI.pData, GetFileKey() );

		if( !aTmpI.pClass->PutObjNode( pNode ) )
			return( ERR_ERROR );
		return( ERR_OK );
	};
	return( ERR_NORSCINST );
}

/*************************************************************************
|*
|*	  RscSrc::GetRscInst()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 23.04.91
|*	  Letzte Aenderung	MM 23.04.91
|*
*************************************************************************/
RscInst RscSrc::GetRscInst( RscTop * pClass, const RscId & rInstName ){
	RSCINST 	aTmpI;

	aTmpI.pClass = pClass;
	if( aTmpI.pClass ){
		aTmpI.pData = pDataBase->pTC->Search( pClass->GetId(), rInstName );
	}

	return RscInst( aTmpI );
}

/*************************************************************************
|*
|*	  RscSrc::FillNameIdList()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 23.04.91
|*	  Letzte Aenderung	MM 23.04.91
|*
*************************************************************************/
void RscSrc::FillNameIdList( REResourceList * pList ){
	pDataBase->pTC->FillNameIdList( pList, GetFileKey() );
}


/*************************************************************************
|*
|*	  RscSrc::WriteCxxFile()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
ERRTYPE RscSrc::WriteCxxFile( const ByteString & rCxxFile,
							  const ByteString & rHxxFile )
{
	FILE* fFile = fopen( rCxxFile.GetBuffer(), "w" );
	if( !fFile )
		return ERR_OPENFILE;
	ERRTYPE aError = pDataBase->pTC->WriteCxx( fFile, lFileKey, rHxxFile );
	fclose( fFile );
	return aError;
}

/*************************************************************************
|*
|*	  RscSrc::WriteHxxFile()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
ERRTYPE RscSrc::WriteHxxFile( const ByteString & rHxxFile )
{
	FILE* fFile = fopen( rHxxFile.GetBuffer(), "w" );
	if( !fFile )
		return ERR_OPENFILE;
	ERRTYPE aError = pDataBase->pTC->WriteHxx( fFile, lFileKey );
	fclose( fFile );
	return( aError );
}

/************** R s c I n s t *******************************************/
/*************************************************************************
|*
|*	  RscInst::MakeCopy()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 10.10.91
|*	  Letzte Aenderung	MM 10.10.91
|*
*************************************************************************/
void RscInst::MakeCopy( RSCINST aTmpI )
{
/*
	// kopieren
	if( aInst.IsInst() ){
		aInst.pClass->Destroy( aInst );
		((RscMem *)0)->Free( aInst.pData );
	}
	if( aTmpI.IsInst() )
		aInst = aTmpI.pClass->Create( NULL, aTmpI );
	else
		aInst = RSCINST();
*/
	// nicht kopieren
	aInst = aTmpI;
}

/*************************************************************************
|*
|*	  RscInst::GetSysLangInst()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 23.12.92
|*	  Letzte Aenderung	MM
|*
*************************************************************************/
RSCINST RscInst::GetSysLangInst( RSCINST & rInst )
{
	RSCINST aTmpI( rInst );

	if( rInst.IsInst() && pHackBase )
	{
		if( (rInst.pClass->GetTypeClass() == &pHackBase->pTC->aLangType)
		  && (LANGUAGE_DONTKNOW != pHackBase->nLangType) )
		{
			rInst.pClass->GetValueEle( rInst, pHackBase->nLangType, NULL,
										&aTmpI );
		}
	}
	return aTmpI;
}

/*************************************************************************
|*
|*	  RscInst::RscInst()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 24.07.91
|*	  Letzte Aenderung	MM 24.07.91
|*
*************************************************************************/
RscInst::RscInst(){
	aInst = RSCINST();
}

/*************************************************************************
|*
|*	  RscInst::RscInst()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
RscInst::RscInst( RSCINST aTmpI ){
	aInst = RSCINST();
	MakeCopy( aTmpI );
}

/*************************************************************************
|*
|*	  RscInst::RscInst()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
RscInst::RscInst( const RscInst & rInst ){
	aInst = RSCINST();
	MakeCopy( rInst.aInst );
}

/*************************************************************************
|*
|*	  RscInst::=
|*
|*	  Ersterstellung	  MM 29.05.91
|*	  Letzte Aenderung	  DV 29.05.91
|*
*************************************************************************/
RscInst& RscInst::operator = ( const RscInst& rInst ){
	MakeCopy( rInst.aInst );
	return *this;
}

/*************************************************************************
|*
|*	  RscInst::~RscInst()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
RscInst::~RscInst(){
/*
	// kopiert also loeschen
	if( IsInst() ){
		aInst.pClass->Destroy( aInst );
		((RscMem *)0)->Free( aInst.pData );
	}
*/
	aInst = RSCINST();
}

/*************************************************************************
|*
|*	  RscInst::OverWrite()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 13.01.92
|*	  Letzte Aenderung	MM 13.01.92
|*
*************************************************************************/
void RscInst::OverWrite( RscInstCopy & rInst )
{
	if( IsInst() && rInst.IsInst() )
	{
		aInst.pClass->Destroy( aInst );
		aInst = aInst.pClass->Create( &aInst, rInst.aInst );
	};
}

/*************************************************************************
|*
|*	  RscInst::SetElement()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
ERRTYPE RscInst::SetElement( const RscId & rName, RscInstCopy & rInst )
{
	RSCINST aTmpI, aDepInst;
	ERRTYPE aError;

	if( IsInst() && rInst.IsInst() )
	{
		aDepInst = GetSysLangInst( aInst );
		aError = aDepInst.pClass->GetElement( aDepInst, rName,
										   rInst.aInst.pClass,
										   rInst.aInst, &aTmpI );
	}
	else
		aError = ERR_NORSCINST;

	return( aError );
}

/*************************************************************************
|*
|*	  RscInst::SetPosEle()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 17.05.91
|*	  Letzte Aenderung	MM 17.05.91
|*
*************************************************************************/
ERRTYPE RscInst::SetPosEle( USHORT nPos, RscInstCopy & rInst ){
	RSCINST aTmpI, aDepInst;

	if( IsInst() && rInst.IsInst() )
	{
		aDepInst = GetSysLangInst( aInst );
		aTmpI = aDepInst.pClass->GetPosEle( aDepInst, nPos );

		// Daten werden kopiert
		if( aTmpI.IsInst() ){
			aTmpI.pClass->Destroy( aTmpI );
			aTmpI = aTmpI.pClass->Create( &aTmpI, rInst.aInst );
			return( ERR_OK );
		};
		return( ERR_CONT_INVALIDPOS );
	};

	return( ERR_NORSCINST );
}

/*************************************************************************
|*
|*	  RscInst::SetPosRscId()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 30.09.91
|*	  Letzte Aenderung	MM 30.09.91
|*
*************************************************************************/
ERRTYPE RscInst::SetPosRscId( USHORT nPos, const RscId & rId ){
	if( IsInst() )
	{
		RSCINST aDepInst = GetSysLangInst( aInst );

		return aDepInst.pClass->SetPosRscId( aDepInst, nPos, rId );
	}

	return( ERR_NORSCINST );
}

/*************************************************************************
|*
|*	  RscInst::GetInfoEle()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 17.05.91
|*	  Letzte Aenderung	MM 17.05.91
|*
*************************************************************************/
SUBINFO_STRUCT	RscInst::GetInfoEle( USHORT nPos )
{
	if( IsInst() )
	{
		RSCINST aDepInst = GetSysLangInst( aInst );

		return aDepInst.pClass->GetInfoEle( aDepInst, nPos );
	}
	return SUBINFO_STRUCT();
}

/*************************************************************************
|*
|*	  RscInst::GetCount()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 17.05.91
|*	  Letzte Aenderung	MM 17.05.91
|*
*************************************************************************/
USHORT RscInst::GetCount()
{
	if( IsInst() )
	{
		RSCINST aDepInst = GetSysLangInst( aInst );

		return( aDepInst.pClass->GetCount( aDepInst ) );
	}
	return( 0 );
}

/*************************************************************************
|*
|*	  RscInst::GetElement()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 17.05.91
|*	  Letzte Aenderung	MM 17.05.91
|*
*************************************************************************/
RscInst RscInst::GetElement( RscTop * pClass, const RscId & rRscId ){
	RSCINST aTmpI;
	ERRTYPE aError;

	if( IsInst() )
	{
		RSCINST aDepInst = GetSysLangInst( aInst );

		aError = aDepInst.pClass->GetElement( aDepInst, rRscId,
											pClass, RSCINST(), &aTmpI );
		if( aError.IsError() )
			aTmpI = RSCINST();
	}

	return RscInst( aTmpI );
}

/*************************************************************************
|*
|*	  RscInst::GetPosEle()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 17.05.91
|*	  Letzte Aenderung	MM 17.05.91
|*
*************************************************************************/
RscInst RscInst::GetPosEle( USHORT nId ){
	RSCINST aTmpI;

	if( IsInst() )
	{
		RSCINST aDepInst = GetSysLangInst( aInst );

		aTmpI = aDepInst.pClass->GetPosEle( aDepInst, nId );
	}

	return RscInst( aTmpI );
}

/*************************************************************************
|*
|*	  RscInst::MovePosEle()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 23.10.91
|*	  Letzte Aenderung	MM 23.10.91
|*
*************************************************************************/
ERRTYPE RscInst::MovePosEle( USHORT nDestPos, USHORT nSourcePos ){
	if( IsInst() )
	{
		RSCINST aDepInst = GetSysLangInst( aInst );

		return( aDepInst.pClass->MovePosEle( aDepInst, nDestPos, nSourcePos ) );
	}

	return ERR_ERROR;
}

/*************************************************************************
|*
|*	  RscInst::DeleteElement()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 10.07.91
|*	  Letzte Aenderung	MM 10.07.91
|*
*************************************************************************/
ERRTYPE RscInst::DeleteElement( RscTop * pClass, const RscId & rRscId ){
	if( IsInst() )
	{
		RSCINST aDepInst = GetSysLangInst( aInst );

		aDepInst.pClass->Delete( aDepInst, pClass, rRscId );
	}
	return ERR_OK;
}

/*************************************************************************
|*
|*	  RscInst::DeletePosEle()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 10.07.91
|*	  Letzte Aenderung	MM 10.07.91
|*
*************************************************************************/
ERRTYPE RscInst::DeletePosEle( USHORT nPos )
{
	if( IsInst() )
	{
		RSCINST aDepInst = GetSysLangInst( aInst );

		aDepInst.pClass->DeletePos( aDepInst, nPos );
	}
	return ERR_OK;
}


/*************************************************************************
|*
|*	  RscInst::SetVar()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
ERRTYPE RscInst::SetVar( HASHID nVarName, RscInstCopy & rInst )
{
	if( IsInst() && rInst.IsInst() )
	{
		RSCINST aTmpI;
		aTmpI = aInst.pClass->GetVariable( aInst, nVarName, rInst.aInst );

		if( !aTmpI.IsInst() )
			return( ERR_RSCINST_NOVARNAME );
		return( ERR_OK );
	}
	return( ERR_NORSCINST );
}

/*************************************************************************
|*
|*	  RscInst::SetConst()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
ERRTYPE RscInst::SetConst( HASHID nVarName, HASHID nConstName )
{
	RSCINST aTmpI;

	if( IsInst() )
	{
		aTmpI = aInst.pClass->GetVariable( aInst, nVarName, RSCINST() );
		if( !aTmpI.IsInst() )
			return( ERR_RSCINST_NOVARNAME );

		RSCINST aDepInst = GetSysLangInst( aTmpI );

		// Wert einsetzten
		DBG_ERROR( "not full implemented" )
		return( aDepInst.pClass->SetConst( aDepInst, nConstName, 0 ) );
	}
	return( ERR_NORSCINST );
}

/*************************************************************************
|*
|*	  RscInst::SetConst()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 28.10.91
|*	  Letzte Aenderung	MM 28.10.91
|*
*************************************************************************/
ERRTYPE RscInst::SetConst( HASHID nConstName )
{
	if( IsInst() )
	{
		RSCINST aDepInst = GetSysLangInst( aInst );

		DBG_ERROR( "not full implemented" )
		return( aDepInst.pClass->SetConst( aDepInst, nConstName, 0 ) );
	}
	return( ERR_NORSCINST );
}

/*************************************************************************
|*
|*	  RscInst::SetBool()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
ERRTYPE RscInst::SetBool( HASHID nVarName, BOOL nBool )
{
	RSCINST aTmpI;

	if( IsInst() ){
		aTmpI = aInst.pClass->GetVariable( aInst, nVarName, RSCINST() );
		if( !aTmpI.IsInst() )
			return( ERR_RSCINST_NOVARNAME );
		// Wert einsetzten

		RSCINST aDepInst = GetSysLangInst( aTmpI );

		return( aDepInst.pClass->SetBool( aDepInst, nBool ) );
	}
	return( ERR_NORSCINST );
}

/*************************************************************************
|*
|*	  RscInst::SetBool()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 28.10.91
|*	  Letzte Aenderung	MM 28.10.91
|*
*************************************************************************/
ERRTYPE RscInst::SetBool( BOOL nBool ){
	if( IsInst() )
	{
		RSCINST aDepInst = GetSysLangInst( aInst );

		return( aDepInst.pClass->SetBool( aDepInst, nBool ) );
	}
	return( ERR_NORSCINST );
}

/*************************************************************************
|*
|*	  RscInst::SetNumber()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
ERRTYPE RscInst::SetCorrectValues( RSCINST & rInst, RSCINST & rVarInst,
									long lValue, USHORT nTupelIdx )
{
	if( pHackBase->nLangType == LANGUAGE_DONTKNOW )
	{
		return rVarInst.pClass->SetNumber( rVarInst, lValue );
	}
	else
	{
		RSCINST aTmpI, aTmpI1, aLangDelta, aSysDelta;
		long lMaster, lLangDelta;

		rVarInst.pClass->GetNumber( rVarInst, &lMaster );

		// Sprachdelta holen
		aTmpI1 = rInst.pClass->GetVariable( rInst, nRsc_DELTALANG, RSCINST() );
		aTmpI1.pClass->GetValueEle( aTmpI1, pHackBase->nLangType, NULL, &aTmpI );
		aLangDelta = aTmpI.pClass->GetTupelVar( aTmpI, nTupelIdx, RSCINST() );
		aLangDelta.pClass->GetNumber( aLangDelta, &lLangDelta );
		if( pHackBase->nLangType != LANGUAGE_DONTKNOW )
		{ // Language Delta setzen
			lLangDelta = lValue - lMaster;
			return aLangDelta.pClass->SetNumber( aLangDelta, lLangDelta );
		}
	}
	return ERR_RSCRANGE;
}

ERRTYPE RscInst::SetNumber( HASHID nVarName, long lValue )
{
	RSCINST aTmpI;

	if( IsInst() )
	{
		aTmpI = aInst.pClass->GetVariable( aInst, nVarName, RSCINST() );
		if( !aTmpI.IsInst() )
			return( ERR_RSCINST_NOVARNAME );

		// Wert einsetzten
		if( nRsc_X == nVarName )
		{
			 return SetCorrectValues( aInst, aTmpI, lValue, 0 );
		}
		else if( nRsc_Y == nVarName )
		{
			 return SetCorrectValues( aInst, aTmpI, lValue, 1 );
		}
		else if( nRsc_WIDTH == nVarName )
		{
			 return SetCorrectValues( aInst, aTmpI, lValue, 2 );
		}
		else if( nRsc_HEIGHT == nVarName )
		{
			 return SetCorrectValues( aInst, aTmpI, lValue, 3 );
		}
		else
		{
			RSCINST aDepInst = GetSysLangInst( aTmpI );

			return( aDepInst.pClass->SetNumber( aDepInst, lValue ) );
		}
	}
	return( ERR_NORSCINST );
}

/*************************************************************************
|*
|*	  RscInst::SetNumber()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 28.10.91
|*	  Letzte Aenderung	MM 28.10.91
|*
*************************************************************************/
ERRTYPE RscInst::SetNumber( long lValue )
{
	if( IsInst() )
	{
		RSCINST aDepInst = GetSysLangInst( aInst );

		return( aDepInst.pClass->SetNumber( aDepInst, lValue ) );
	}
	return( ERR_NORSCINST );
}

/*************************************************************************
|*
|*	  RscInst::SetString()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 16.05.91
|*	  Letzte Aenderung	MM 16.05.91
|*
*************************************************************************/
ERRTYPE RscInst::SetString( HASHID nVarName, const char * pValue )
{
	RSCINST aTmpI;

	if( IsInst() )
	{
		aTmpI = aInst.pClass->GetVariable( aInst, nVarName, RSCINST() );
		if( !aTmpI.IsInst() )
			return( ERR_RSCINST_NOVARNAME );

		RSCINST aDepInst = GetSysLangInst( aTmpI );
		// Wert einsetzten
		return( aDepInst.pClass->SetString( aDepInst, (char *)pValue ) );
	}
	return( ERR_NORSCINST );
}

/*************************************************************************
|*
|*	  RscInst::SetString()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 28.10.91
|*	  Letzte Aenderung	MM 28.10.91
|*
*************************************************************************/
ERRTYPE RscInst::SetString( const char * pValue )
{
	if( IsInst() )
	{
		RSCINST aDepInst = GetSysLangInst( aInst );

		return( aDepInst.pClass->SetString( aDepInst, (char *)pValue ) );
	}
	return( ERR_NORSCINST );
}

/*************************************************************************
|*
|*	  RscInst::SetRef()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
ERRTYPE RscInst::SetRef( const RscId & rValue )
{
	if( IsInst() )
	{
		RSCINST aDepInst = GetSysLangInst( aInst );

		// Wert einsetzten
		return( aDepInst.pClass->SetRef( aDepInst, rValue ) );
	}
	return( ERR_NORSCINST );
}

/*************************************************************************
|*
|*	  RscInst::SetDefault()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
ERRTYPE RscInst::SetDefault( HASHID nVarName )
{
	if( IsInst() )
	{
		RSCINST aDepInst = GetSysLangInst( aInst );

		//Es gibt nur einen Default pro Klasse
		aDepInst.pClass->SetDefault( aDepInst, nVarName );

		return( ERR_OK );
	}
	return( ERR_NORSCINST );
}

/*************************************************************************
|*
|*	  RscInst::GetVar()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
RscInst RscInst::GetVar( HASHID nVarName )
{
	RSCINST aTmpI;

	if( IsInst() )
		aTmpI = aInst.pClass->GetVariable( aInst, nVarName, RSCINST(), TRUE );

	return RscInst( aTmpI );
}

/*************************************************************************
|*
|*	  RscInst::GetConst()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
HASHID RscInst::GetConst( HASHID nVarName )
{
	RSCINST aTmpI;
	HASHID	nHash = HASH_NONAME;

	if( IsInst() )
	{
		if( HASH_NONAME == nVarName )
			aTmpI = aInst;
		else
			aTmpI = aInst.pClass->GetCopyVar( aInst, nVarName );

		if( aTmpI.IsInst() )
		{
			RSCINST aDepInst = GetSysLangInst( aTmpI );

			aDepInst.pClass->GetConst( aDepInst, &nHash );
		}
	}
	return( nHash );
}

/*************************************************************************
|*
|*	  RscInst::GetConstPos()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 18.07.91
|*	  Letzte Aenderung	MM 18.07.91
|*
*************************************************************************/
USHORT RscInst::GetConstPos( HASHID nVarName )
{
	RSCINST aTmpI;
	HASHID	nHash;
	USHORT	nPos;

	if( IsInst() ){
		if( HASH_NONAME == nVarName )
			aTmpI = aInst;
		else
			aTmpI = aInst.pClass->GetCopyVar( aInst, nVarName );

		if( aTmpI.IsInst() )
		{
			RSCINST aDepInst = GetSysLangInst( aTmpI );

			if( aDepInst.pClass->GetConst( aDepInst, &nHash ).IsOk() )
			{
				nPos = 0;
				while( aDepInst.pClass->GetConstant( nPos ) != nHash )
					nPos++;
				return( nPos );
			}
		}
	}
	return( 0 );
}

/*************************************************************************
|*
|*	  RscInst::GetBool()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
BOOL RscInst::GetBool( HASHID nVarName ){
	RSCINST aTmpI;
	BOOL	bBool = FALSE;

	if( IsInst() )
	{
		if( HASH_NONAME == nVarName )
			aTmpI = aInst;
		else
			aTmpI = aInst.pClass->GetCopyVar( aInst, nVarName );

		if( aTmpI.IsInst() )
		{
			RSCINST aDepInst = GetSysLangInst( aTmpI );

			aDepInst.pClass->GetBool( aDepInst, &bBool );
		}
	}
	return( bBool );
}

/*************************************************************************
|*
|*	  RscInst::GetNumber()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
long RscInst::GetCorrectValues( RSCINST & rInst, RSCINST & rVarInst,
								USHORT nTupelIdx )
{
	long lMaster;

	if( pHackBase->nLangType == LANGUAGE_DONTKNOW )
	{
		rVarInst.pClass->GetNumber( rVarInst, &lMaster );
		return lMaster;
	}
	else
	{
		RSCINST aTmpI, aTmpI1, aLangDelta, aSysDelta;
		long lLangDelta;

		rVarInst.pClass->GetNumber( rVarInst, &lMaster );

		// Sprachdelta holen
		aTmpI1 = rInst.pClass->GetVariable( rInst, nRsc_DELTALANG, RSCINST() );
		aTmpI1.pClass->GetValueEle( aTmpI1, pHackBase->nLangType, NULL, &aTmpI );
		aLangDelta = aTmpI.pClass->GetTupelVar( aTmpI, nTupelIdx, RSCINST() );
		aLangDelta.pClass->GetNumber( aLangDelta, &lLangDelta );
		return lMaster + lLangDelta;
	}
}

long RscInst::GetNumber( HASHID nVarName )
{
	RSCINST aTmpI;
	long	lNumber = 0L;

	if( IsInst() )
	{
		if( HASH_NONAME == nVarName )
			aTmpI = aInst;
		else
			aTmpI = aInst.pClass->GetCopyVar( aInst, nVarName );

		if( aTmpI.IsInst() )
		{
			if( nRsc_X == nVarName )
				 lNumber = GetCorrectValues( aInst, aTmpI, 0 );
			else if( nRsc_Y == nVarName )
				 lNumber = GetCorrectValues( aInst, aTmpI, 1 );
			else if( nRsc_WIDTH == nVarName )
				 lNumber = GetCorrectValues( aInst, aTmpI, 2 );
			else if( nRsc_HEIGHT == nVarName )
				 lNumber = GetCorrectValues( aInst, aTmpI, 3 );
			else
			{
				RSCINST aDepInst = GetSysLangInst( aTmpI );

				aDepInst.pClass->GetNumber( aDepInst, &lNumber );
			}
		}
	}
	return( lNumber );
}

/*************************************************************************
|*
|*	  RscInst::GetString()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
const char * RscInst::GetString( HASHID nVarName )
{
	RSCINST aTmpI;
	char *	pStr = NULL;

	if( IsInst() )
	{
		if( HASH_NONAME == nVarName )
			aTmpI = aInst;
		else
			aTmpI = aInst.pClass->GetCopyVar( aInst, nVarName );

		if( aTmpI.IsInst() )
		{
			RSCINST aDepInst = GetSysLangInst( aTmpI );

			aDepInst.pClass->GetString( aDepInst, &pStr );
		}
	}
	return( pStr );
}

/*************************************************************************
|*
|*	  RscInst::GetRef()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
RscId RscInst::GetRef()
{
	RscId aRscId;

	if( IsInst() )
	{
		RSCINST aDepInst = GetSysLangInst( aInst );

		aDepInst.pClass->GetRef( aDepInst, &aRscId );
	}

	return aRscId;
}

/*************************************************************************
|*
|*	  RscInst::IsDefault()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
BOOL RscInst::IsDefault( HASHID nVarName )
{
	RSCINST aTmpI;

	if( IsInst() )
	{
		aTmpI = aInst.pClass->GetCopyVar( aInst, nVarName );
		if( aTmpI.IsInst() )
			return( aTmpI.pClass->IsDefault( aTmpI ) );
	}
	return( FALSE );
}

/*************************************************************************
|*
|*	  RscInst::IsConsistent
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 23.09.91
|*	  Letzte Aenderung	MM 23.09.91
|*
*************************************************************************/
BOOL RscInst::IsConsistent( RscInconsList * pList ){
	if( IsInst() )
		return( aInst.pClass->IsConsistent( aInst, pList ) );
	return( FALSE );
}

/*************************************************************************
|*
|*	  RscInst::GetClassEnum()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 15.07.91
|*	  Letzte Aenderung	MM 15.07.91
|*
*************************************************************************/
HASHID RscInst::GetClassEnum( HASHID nVarName, USHORT nPos )
{
	RSCINST aTmpI;

	if( IsInst() )
	{
		aTmpI = aInst.pClass->GetCopyVar( aInst, nVarName );
		if( aTmpI.IsInst() )
		{
			RSCINST aDepInst = GetSysLangInst( aTmpI );

			return( aDepInst.pClass->GetConstant( nPos ) );
		}
	}
	return HASH_NONAME;
}

/*************************************************************************
|*
|*	  RscInst::GetClassEnum()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 05.12.91
|*	  Letzte Aenderung	MM 05.12.91
|*
*************************************************************************/
HASHID RscInst::GetClassEnum( USHORT nPos )
{
	RSCINST aDepInst = GetSysLangInst( aInst );

	return aDepInst.pClass->GetConstant( nPos );
}

/*************************************************************************
|*
|*	  RscInst::GetClassName()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 11.09.91
|*	  Letzte Aenderung	MM 11.09.91
|*
*************************************************************************/
HASHID RscInst::GetClassName()
{
	if( IsInst() )
		return( aInst.pClass->GetId() );
	return HASH_NONAME;
}

/*************************************************************************
|*
|*	  RscInst::EnumClassVariables()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 11.09.91
|*	  Letzte Aenderung	MM 11.09.91
|*
*************************************************************************/
void RscInst::EnumClassVariables( void * pData,
									VarEnumCallbackProc pProc ) const
{
	if( IsInst() )
		aInst.pClass->EnumVariables( pData, pProc );
}

/*************************************************************************
|*
|*	  RscInst::WriteRc()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
ERRTYPE RscInst::WriteRc( RscWriteRc & aMem )
{
	ERRTYPE 	aError;
	if( IsInst() )
	{
		LanguageType eOldLang;

		if( pHackBase )
		{
			eOldLang = pHackBase->pTC->ChangeLanguage( pHackBase->nLangType );
		}

		aError = aInst.pClass->WriteRcHeader( aInst, aMem, NULL, RscId(),
												0, FALSE );
		if( pHackBase )
		{
			pHackBase->pTC->ChangeLanguage( eOldLang );
		}
	}
	else
		aError = ERR_NORSCINST;

	return( aError );
}

/************** R s c I n s t C o p y ***********************************/
/*************************************************************************
|*
|*	  RscInstCopy::MakeCopy()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 10.10.91
|*	  Letzte Aenderung	MM 10.10.91
|*
*************************************************************************/
void RscInstCopy::MakeCopy( RSCINST aTmpI ){
	if( aInst.IsInst() ){
		aInst.pClass->Destroy( aInst );
		((RscMem *)0)->Free( aInst.pData );
	}
	if( aTmpI.IsInst() )
		aInst = aTmpI.pClass->Create( NULL, aTmpI );
	else
		aInst = RSCINST();
}

/*************************************************************************
|*
|*	  RscInstCopy::RscInstCopy()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 24.07.91
|*	  Letzte Aenderung	MM 24.07.91
|*
*************************************************************************/
RscInstCopy::RscInstCopy() : RscInst()
{
}

/*************************************************************************
|*
|*	  RscInstCopy::RscInstCopy()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
RscInstCopy::RscInstCopy( RSCINST aTmpI ) : RscInst()
{
	MakeCopy( aTmpI );
}

/*************************************************************************
|*
|*	  RscInstCopy::RscInstCopy()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
RscInstCopy::RscInstCopy( const RscInstCopy & rInst ) : RscInst()
{
	MakeCopy( rInst.aInst );
}

RscInstCopy::RscInstCopy( const RscInst & rInst ) : RscInst()
{
	MakeCopy( rInst.aInst );
}

/*************************************************************************
|*
|*	  RscInstCopy::RscInstCopy()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
RscInstCopy::RscInstCopy( RscTop * pNewType, const RscInst & rInst )
				 : RscInst()
{
	if( rInst.IsInst() && pNewType )
	{
		aInst = pNewType->Create( NULL, ((RscInst&)rInst).aInst );
	}
}

/*************************************************************************
|*
|*	  RscInstCopy::=
|*
|*	  Ersterstellung	  MM 29.05.91
|*	  Letzte Aenderung	  DV 29.05.91
|*
*************************************************************************/
RscInstCopy& RscInstCopy::operator = ( const RscInstCopy & rInst )
{
	MakeCopy( rInst.aInst );
	return *this;
}

RscInstCopy& RscInstCopy::operator = ( const RscInst & rInst )
{
	MakeCopy( rInst.aInst );
	return *this;
}

/*************************************************************************
|*
|*	  RscInstCopy::~RscInstCopy()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.04.91
|*	  Letzte Aenderung	MM 22.04.91
|*
*************************************************************************/
RscInstCopy::~RscInstCopy()
{
	if( IsInst() )
	{
		aInst.pClass->Destroy( aInst );
		((RscMem *)0)->Free( aInst.pData );
	}
}

