/*************************************************************************
 *
 *  $RCSfile: critical.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: dv $ $Date: 2002/07/12 14:20:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _CRITICAL_HXX
#define _CRITICAL_HXX

#ifndef SETUP_SISTREAM_HXX
#include "sistream.hxx"
#endif

#define ERR_NOERROR									0
#define ERR_RESFILE_NOTFOUND						1
#define ERR_RESPONSEFILE_NOTFOUND					2
#define ERR_WRONG_INSATALLATIONMODE					3
#define ERR_WRONG_INSATALLATIONTYPE					4
#define ERR_OLDSCRIPTVERSION						5
#define ERR_WRONGPARAMETER							6
#define ERR_SCRIPT_NOTFOUND							7
#define ERR_SETUPSCRIPT								8
#define ERR_INSTALLINFOMISSING						9
#define ERR_UIPROCNOTFOUND							10
#define ERR_NOMODULES								11
#define ERR_NOUPDATEVERSIONFOUND					12
#define ERR_NOUPDATETRYBUY                          13
#define ERR_XTERMNOTFOUND							14
#define ERR_COULDNOTSTARTXTERM						15
#define ERR_XTERMERRORCODE							16
#define ERR_INSTFILENOTFOUND						17
#define ERR_COPY_FILE								18
#define ERR_ZIP_FILE								19
#define ERR_MAKE_DIR								20
#define ERR_NONETWORKINSTALLTION					21
#define ERR_WHILEREADINGPROCEDURES					22
#define ERR_VERSIONALLREADYINSTALLED				23
#define ERR_NOFIRSTFREE								24
#define ERR_NOHOME									25
#define ERR_DISK_FULL								26
#define ERR_INVALID_DESTPATH						27
#define ERR_MODULENOTFOUND							28
#define ERR_VERSIONNOTINSTALLED                     29
#define ERR_INSTALLPROCEDURE_NOTFOUND				30
#define ERR_INSTALLMODULESET_NOTFOUND				31
#define ERR_DEINSTALLPROCEDURE_NOTFOUND				32
#define ERR_DEINSTALLMODULESET_NOTFOUND				33
#define ERR_INVALID_LICENSEKEY						34
#define ERR_INVALID_LICENSE							35
#define ERR_INVALID_APPLICAT_RDB                    36
#define ERR_WRONG_UPDATEMODE                        37
#define ERR_UPDATE_WRONG_LANGUAGE                   38
#define ERR_UPDATE_NO_RIGHTS                        39

#define ERR_END										ERR_UPDATE_NO_RIGHTS + 1

class Critical
{
    BOOL				bDebug      : 1;
    BOOL				bStdOut     : 1;
    BOOL				bLog        : 1;
    BOOL				bNoExit     : 1;
    BOOL                bHasConsole : 1;
	ByteString			aLogFile;

public:
		Critical();

	void		SetDebug(BOOL bNew) 				{ bDebug = bNew; }
	BOOL		IsDebug()			 				{ return bDebug; }

	void		SetNoExit(BOOL bNew) 				{ bNoExit = bNew; }
	BOOL		IsNoExit()			 				{ return bNoExit; }

	void		SetStdOut(BOOL bNew) 				{ bStdOut = bNew; }
	BOOL		IsStdOut()			 				{ return bStdOut; }

	void		SetLogFile(const ByteString& rNew)	{ aLogFile = rNew; bLog = TRUE; }
	BOOL		IsLog()				 				{ return bLog; }

	void		WriteLog( ByteString& rMsg );
	void		Error( USHORT nErrCode, const ByteString& rMsg );

	// static Instance
	static void				AllocStaticInstance();
	static void				DeleteStaticInstance();
	static Critical* 		GetStaticInstance();
};


#define Critical_Error( id, msg ) {		\
	if( Critical::GetStaticInstance() )	\
		Critical::GetStaticInstance()->Error( id, msg ); }

#define Critical_Log( message ) {		\
	if( Critical::GetStaticInstance() )	\
		Critical::GetStaticInstance()->WriteLog(message); }

#endif

