/*************************************************************************
 *
 *  $RCSfile: worient.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 15:01:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop
#include "worient.hxx"

struct SvxWinOrientation_Impl
{
    Link                maTxtStackedClickHdl;
	ImageButton			aBtnTxtStacked;
	SvxCtrDial			aCtrDial;
	FixedText			aOrientFieldLabel;
	SvxOrientationField	aOrientField;
	FixedText			aVSLockModeLabel;
	ValueSet			aVSLockMode;
    FixedLine           aFlAlign;
	Color				aLast_BtnTxtStacked_Color;
	Window&				rParent;
	BOOL				bFlagEnabled;

	SvxWinOrientation_Impl(
					Window* pParent,
					const ResId& rResIdForCtrDial,
					const ResId& rResIdForBtnStackedText,
					const ResId& rResIdForOrientLabel,
					const ResId& rResIdForOrientField,
					const ResId& rResIdForVSLockModeLabel,
					const ResId& rResIdForVSLockMode,
                    const ResId& rResIdForFixedLine);

	DECL_LINK( OrientModifyHdl, void * );
	DECL_LINK( LostActiveHdl, void * );

	void			Enable();
	void			Disable();
	void			SetStackedTxt(BOOL bOnOff);
	void			SetDegrees(short alpha);
    void            SetNoDegrees();

	void			Update_BtnTxtStacked_Colors( void );
};

SvxWinOrientation_Impl::SvxWinOrientation_Impl( Window * pParent,
					const ResId & rResIdForCtrDial,
					const ResId & rResIdForImageButton,
					const ResId & rResIdForFixedText,
					const ResId & rResIdForOrientField,
					const ResId & rResIdForVSLockModeLabel,
					const ResId & rResIdForVSLockMode,
                    const ResId & rResIdForFixedLine) :
	aCtrDial( pParent,rResIdForCtrDial),
	aOrientFieldLabel( pParent, rResIdForFixedText),
	aOrientField(pParent, rResIdForOrientField),
	aBtnTxtStacked	( pParent, rResIdForImageButton),
	aVSLockModeLabel( pParent, rResIdForVSLockModeLabel),
	aVSLockMode( pParent, rResIdForVSLockMode),
    aFlAlign( pParent, rResIdForFixedLine),
	aLast_BtnTxtStacked_Color( COL_BLACK ),
	rParent( *pParent )
{
	bFlagEnabled = TRUE;

	Link			aLink = LINK( this, SvxWinOrientation_Impl, OrientModifyHdl );
	Link			a2Link = LINK( this, SvxWinOrientation_Impl, LostActiveHdl );

	// Mit Handler verbinden
	aCtrDial.SetCtrModifiedHdl( aLink );
	aCtrDial.SetMouseUpHdl( a2Link );
	aOrientField.SetPrivatModifyHdl( aLink );
	aOrientField.SetLoseFocusHdl(a2Link);
	aBtnTxtStacked.SetClickHdl( aLink);

	// change black text color to actual text color for Button for Stacked Text option
	// aLast_BtnTxtStacked_Color was set to COL_BLACK initially
	Update_BtnTxtStacked_Colors();

	OrientModifyHdl( NULL );
}

void SvxWinOrientation_Impl::Enable()
{
	if( !bFlagEnabled  )
	{
		bFlagEnabled = TRUE;
		aCtrDial.Enable();
		aCtrDial.Invalidate();
		aBtnTxtStacked.Enable();
		aOrientFieldLabel.Enable();
		aOrientField.Enable();
		aVSLockModeLabel.Enable();
		aVSLockMode.Enable();
        aFlAlign.Enable();
	}
}

void SvxWinOrientation_Impl::Disable()
{
	if( bFlagEnabled )
	{
		bFlagEnabled = FALSE;
		aCtrDial.Disable();
		aCtrDial.Invalidate();
		aBtnTxtStacked.Disable();
		aOrientFieldLabel.Disable();
		aOrientField.Disable();
		aVSLockModeLabel.Disable();
		aVSLockMode.Disable();
        aFlAlign.Disable();
	}
}

void SvxWinOrientation_Impl::SetStackedTxt( BOOL bOnOff )
{
	aBtnTxtStacked.Check( bOnOff );
    aCtrDial.SetOrientation( aCtrDial.GetOrientation() );

	if( bOnOff || !aBtnTxtStacked.IsEnabled() )
	{
		aCtrDial.Disable();
		aCtrDial.Invalidate();
		aOrientFieldLabel.Disable();
		aOrientField.Disable();
		aVSLockModeLabel.Disable();
		aVSLockMode.Disable();
	}
	else
	{
		aCtrDial.Enable();
		aCtrDial.Invalidate();
		aOrientFieldLabel.Enable();
		aOrientField.Enable();
		aVSLockModeLabel.Enable();
		aVSLockMode.Enable();
	}

    maTxtStackedClickHdl.Call( this );
}

void SvxWinOrientation_Impl::SetDegrees( short alpha )
{
	aCtrDial.SetOrientation( alpha );
	aOrientField.SetText( UniString::CreateFromInt32( alpha ) );
}

void SvxWinOrientation_Impl::SetNoDegrees()
{
    aCtrDial.SetNoOrientation();
    aOrientField.SetText( UniString() );
    aBtnTxtStacked.Check( FALSE );
    maTxtStackedClickHdl.Call( this );
}

IMPL_LINK( SvxWinOrientation_Impl, OrientModifyHdl, void*, ctrPtr )
{
	if( ctrPtr != NULL )
	{
		if(	&aCtrDial == ctrPtr)
			aOrientField.SetOrientation( aCtrDial.GetOrientation() );
		else
		{
			if(	&aOrientField == ctrPtr)
			{
				aCtrDial.SetOrientation( aOrientField.GetOrientation() );
				aCtrDial.Invalidate();
				aCtrDial.Update();
			}
			else
			{
				if( ctrPtr == &aBtnTxtStacked )
				{
                    aCtrDial.SetOrientation( aCtrDial.GetOrientation() );
					if( aBtnTxtStacked.IsChecked() )
					{
						aBtnTxtStacked.Check( FALSE );
						aCtrDial.Enable();
						aCtrDial.Invalidate();
						aOrientFieldLabel.Enable();
						aOrientField.Enable();
						aVSLockModeLabel.Enable();
						aVSLockMode.Enable();
					}
					else
					{
						aBtnTxtStacked.Check();
						aCtrDial.Disable();
						aCtrDial.Invalidate();
						aOrientFieldLabel.Disable();
						aOrientField.Disable();
						aVSLockModeLabel.Disable();
						aVSLockMode.Disable();
					}
                    maTxtStackedClickHdl.Call( this );
				}
			}
		}
	}

	return 0L;
}

IMPL_LINK( SvxWinOrientation_Impl, LostActiveHdl, void *, ctrPtr )
{
	if( ( SvxCtrDial* ) ctrPtr == &aCtrDial )
		aOrientField.GrabFocus();
	else if( ( SvxOrientationField* ) ctrPtr == &aOrientField )
		aOrientField.SetOrientation( aCtrDial.GetOrientation() );

	return 0L ;
}

void SvxWinOrientation_Impl::Update_BtnTxtStacked_Colors( void )
{
	const Image&	rTmpImg = aBtnTxtStacked.GetImage();
	Bitmap			aTmpBmp( rTmpImg.GetBitmap() );

	Color			aNewColor = rParent.GetSettings().GetStyleSettings().GetButtonTextColor();

	aTmpBmp.Replace( aLast_BtnTxtStacked_Color, aNewColor );
	aBtnTxtStacked.SetImage( Image( aTmpBmp, rTmpImg.GetMaskColor() ) );

	aLast_BtnTxtStacked_Color = aNewColor;
}


SvxWinOrientation::SvxWinOrientation(
					Window* pParent,
					const ResId& rResIdForCtrDial,
					const ResId& rResIdForImageButton,
					const ResId& rResIdForFixedText,
					const ResId& rResIdForOrientField,
					const ResId& rResIdForVSLockModeLabel,
					const ResId& rResIdForVSLockMode,
                    const ResId& rResIdForFixedLine)
	: Link(),
	pImpl( new SvxWinOrientation_Impl( pParent, rResIdForCtrDial, rResIdForImageButton, rResIdForFixedText, rResIdForOrientField, rResIdForVSLockModeLabel, rResIdForVSLockMode, rResIdForFixedLine ) )

{
}

SvxWinOrientation::~SvxWinOrientation()
{
	delete pImpl;
}

void SvxWinOrientation::Enable()
{
	pImpl->Enable();
}

void SvxWinOrientation::Disable()
{
	pImpl->Disable();
}

BOOL SvxWinOrientation::IsEnabled()
{
	return pImpl->bFlagEnabled;
}

BOOL SvxWinOrientation::IsStackedTxt()
{
	return pImpl->aBtnTxtStacked.IsChecked();
}

void SvxWinOrientation::SetStackedTxt( BOOL bOnOff )
{
	pImpl->SetStackedTxt( bOnOff );
}

BOOL SvxWinOrientation::HasDegrees()
{
    return pImpl->aCtrDial.HasOrientation();
}

void SvxWinOrientation::SetDegrees( short alpha )
{
	pImpl->SetDegrees( alpha );
}

void SvxWinOrientation::SetNoDegrees()
{
    pImpl->SetNoDegrees();
}

short SvxWinOrientation::GetDegrees()
{
	return pImpl->aCtrDial.GetOrientation();
}

SvxRotateMode SvxWinOrientation::GetRotateMode()
{
	SvxRotateMode	nRetVal;
	USHORT			nSelId = pImpl->aVSLockMode.GetSelectItemId();

	switch( nSelId )
	{
		case 1:		nRetVal = SVX_ROTATE_MODE_BOTTOM;	break;
		case 2:		nRetVal = SVX_ROTATE_MODE_TOP;		break;
		default:	nRetVal = SVX_ROTATE_MODE_STANDARD;	break;
	}

	return nRetVal;
}

void SvxWinOrientation::SetRotateMode( SvxRotateMode nVal )
{
	short nItem;

	switch( nVal )
	{
		case SVX_ROTATE_MODE_BOTTOM:	nItem = 1; break;
		case SVX_ROTATE_MODE_TOP:		nItem = 2; break;
		default:						nItem = 3; break;
	}
	pImpl->aVSLockMode.SelectItem( nItem );
}

ValueSet& SvxWinOrientation::GetVSLockMode()
{
	return pImpl->aVSLockMode;
}

BOOL SvxWinOrientation::IsSelRotateMode()
{
	return !pImpl->aVSLockMode.IsNoSelection();
}

void SvxWinOrientation::SetNoSelRotateMode()
{
    pImpl->aVSLockMode.SetNoSelection();
}

void SvxWinOrientation::SetTxtStackedClickHdl( const Link& rLink )
{
    pImpl->maTxtStackedClickHdl = rLink;
}

const Link& SvxWinOrientation::GetTxtStackedClickHdl() const
{
    return pImpl->maTxtStackedClickHdl;
}

void SvxWinOrientation::HandleUpdatedSystemsettings( void )
{
	pImpl->Update_BtnTxtStacked_Colors();
}
