/*************************************************************************
 *
 *  $RCSfile: sw3num.cxx,v $
 *
 *  $Revision: 1.16 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 14:20:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#include "swerror.h"
#include "doc.hxx"
#include "pam.hxx"
#include "ndtxt.hxx"
#ifndef _DOCARY_HXX
#include "docary.hxx"
#endif

#ifndef _SVX_BRSHITEM_HXX //autogen
#include <svx/brshitem.hxx>
#endif
#ifndef _SVX_LRSPITEM_HXX //autogen
#include <svx/lrspitem.hxx>
#endif
#ifndef _SVX_TSPTITEM_HXX //autogen
#include <svx/tstpitem.hxx>
#endif

#ifndef _SV_FONTTYPE_HXX //autogen
#include <vcl/fonttype.hxx>
#endif
#ifndef _SV_FONT_HXX //autogen
#include <vcl/font.hxx>
#endif
#ifndef _TOOLS_TENCCVT_HXX //autogen
#include <tools/tenccvt.hxx>
#endif

#ifndef _FMTORNT_HXX //autogen
#include <fmtornt.hxx>
#endif
#ifndef _CHARFMT_HXX //autogen
#include <charfmt.hxx>
#endif
#ifndef _POOLFMT_HXX
#include <poolfmt.hxx>
#endif
#ifndef _FRMATR_HXX
#include <frmatr.hxx>
#endif

#include "sw3imp.hxx"
#include "numrule.hxx"
#include "ftninfo.hxx"
#include "pagedesc.hxx"
#ifndef _SWSTYLENAMEMAPPER_HXX
#include <SwStyleNameMapper.hxx>
#endif

////////////////////////////////////////////////////////////////////////////

SV_IMPL_OP_PTRARR_SORT(Sw3NumRuleInfos, Sw3NumRuleInfoPtr)

// Konvertierung BYTE/BOOL von SwNumFmt::GetUpperLever fuer SW3.1/4.0
BOOL lcl_sw3io__IsInclUpperLevel( BYTE nUpperLevel )
{
	 return 1 < nUpperLevel;
}

BYTE lcl_sw3io__GetIncludeUpperLevel( BOOL bInclUpperLevel )
{
	return bInclUpperLevel ? MAXLEVEL : 1;
}

// Numerierungs-Format einlesen
void Sw3IoImp::InNumFmt( SwNumFmt& rFmt )
{
	// Flags:
	// 0x10 - Bullet-Font gueltig
	BYTE cFlags, eType, eNumAdjust;
	sal_Char cBullet8;
	USHORT nFmt, nStart;
	String aFontName, aFontStyle, sPrefix, sPostfix;
	BYTE eFamily, ePitch, eCharSet;
	INT32 nLSpace, nFirstLineOffset;
	BYTE nUpperLevel;
	OpenRec( SWG_NUMFMT );
	InString( *pStrm, sPrefix );
	InString( *pStrm, sPostfix );
	InString( *pStrm, aFontName );
	InString( *pStrm, aFontStyle );
	*pStrm >> nFmt
		   >> eType
		   >> cBullet8;

	// nUpperLevel war bis zur 5.0 nur ein Flag.
	if( IsVersion(SWG_LONGIDX) )
	{
		*pStrm >> nUpperLevel;
	}
	else
	{
		BYTE bInclUpperLevel;
		*pStrm >> bInclUpperLevel;
		nUpperLevel = lcl_sw3io__GetIncludeUpperLevel( bInclUpperLevel );
	}

	*pStrm >> nStart
		   >> eNumAdjust
		   >> nLSpace
		   >> nFirstLineOffset
		   >> eFamily
		   >> ePitch
		   >> eCharSet;
	if(RTL_TEXTENCODING_DONTKNOW== eCharSet)
		eCharSet = RTL_TEXTENCODING_SYMBOL;
	else if( RTL_TEXTENCODING_SYMBOL != eCharSet )
		eCharSet = GetSOLoadTextEncoding( rtl_TextEncoding( eCharSet ),
								   pStrm->GetVersion() );
	cFlags = OpenFlagRec();
	CloseFlagRec();

	sal_Bool bBatsToSymbol = sal_False;
	sal_Bool bMathToSymbol = sal_False;
	if( (cFlags & 0x10) != 0 && RTL_TEXTENCODING_SYMBOL == eCharSet )
	{
		if( aFontName.EqualsIgnoreCaseAscii( sStarBats ) )
			bBatsToSymbol = sal_True;
		else if( aFontName.EqualsIgnoreCaseAscii( sStarMath ) )
			bMathToSymbol = sal_True;
	}

	rFmt.SetNumberingType((sal_Int16)eType );
	if( bBatsToSymbol )
		rFmt.SetBulletChar( ConvStarBatsCharToStarSymbol( cBullet8 ) );
	else if( bMathToSymbol )
		rFmt.SetBulletChar( ConvStarMathCharToStarSymbol( cBullet8 ) );
	else
		rFmt.SetBulletChar( ByteString::ConvertToUnicode( cBullet8, eCharSet ) );
	rFmt.SetIncludeUpperLevels( nUpperLevel );
	rFmt.SetStart( nStart );
	rFmt.SetNumAdjust( SvxAdjust( eNumAdjust ));
	rFmt.SetAbsLSpace( (USHORT)nLSpace );
	rFmt.SetFirstLineOffset( (short)nFirstLineOffset );
	rFmt.SetSuffix( sPostfix );
	rFmt.SetPrefix( sPrefix );

	// Nur im spaeten 3.1-Format steht hier die Zeichen-Vorlage,
	// ab dem 4.0-Format steht sie dann wieder oeben.
	if( IsVersion( SWG_NEWNUMRULE, SWG_EXPORT31 ) )
	{
		*pStrm >> nFmt;
	}

	// erst das Format setzen
	if( nFmt != IDX_NO_VALUE )
		rFmt.SetCharFmt( (SwCharFmt*) FindFmt( nFmt, SWG_CHARFMT ) );

	// Relative Abstaende gab es in spaeten 3.1- und im 4.0-Format, aber
	// nicht mehr im 5.0 Format.
	if( IsVersion( SWG_NEWNUMRULE, SWG_EXPORT31, SWG_DESKTOP40, SWG_LONGIDX ) )
	{
		BYTE bRelSpace;
		INT32 nRelLSpace;

		*pStrm >> bRelSpace
			   >> nRelLSpace;
	}

	// Den Rest gibt es in spaeten 3.1-Formaten und seit dem 4.0-Format
	if( IsVersion( SWG_NEWNUMRULE, SWG_EXPORT31, SWG_DESKTOP40 ) )
	{
		USHORT nTextOffset;
		*pStrm >> nTextOffset;

		rFmt.SetCharTextDistance( nTextOffset );

		if( SVX_NUM_BITMAP == rFmt.GetNumberingType() )
		{
			BYTE cF;
			Size aSz;

			*pStrm >> aSz.Width() >> aSz.Height();

			*pStrm >> cF;
			if( cF )
			{
				SvxBrushItem* pBrush = 0;
				SwFmtVertOrient* pVOrient = 0;
				USHORT nVer;

				if( cF & 1 )
				{
					*pStrm >> nVer;
					pBrush = (SvxBrushItem*)GetDfltAttr( RES_BACKGROUND )
											->Create( *pStrm, nVer );
				}

				if( cF & 2 )
				{
					*pStrm >> nVer;
					pVOrient = (SwFmtVertOrient*)GetDfltAttr( RES_VERT_ORIENT )
											->Create( *pStrm, nVer );
				}
				SvxFrameVertOrient eOrient = SVX_VERT_NONE;
				if(pVOrient)
					eOrient = (SvxFrameVertOrient)pVOrient->GetVertOrient();
				rFmt.SetGraphicBrush( pBrush, &aSz, pVOrient ? &eOrient : 0);

				// Ggf. Grafik holen, damit nicht neu numeriert wird,
				// wenn die Grafik (spaeter) geladen wird.
				//if( pBrush && rFmt.GetCharFmt() )
				//	rFmt.GetGraphic();
			}
		}

	}

	if( cFlags & 0x10 )
	{
		Font aFont;
		aFont.SetName( aFontName );
		aFont.SetStyleName( aFontStyle );
		aFont.SetFamily( FontFamily( eFamily ) );
		aFont.SetPitch( FontPitch( ePitch ) );
		aFont.SetCharSet( eCharSet );
		if( bMathToSymbol || bBatsToSymbol )
		{
			aFont = SwNumRule::GetDefBulletFont();
		}
		else
		{
			aFont.SetName( aFontName );
			aFont.SetStyleName( aFontStyle );
			aFont.SetFamily( FontFamily( eFamily ) );
			aFont.SetPitch( FontPitch( ePitch ) );
			aFont.SetCharSet( rtl_TextEncoding( eCharSet ) );
			aFont.SetCharSet( 
				GetSOLoadTextEncoding( rtl_TextEncoding( eCharSet ),
									   pStrm->GetVersion() ) );
		}
		// muss sein...
		aFont.SetTransparent( TRUE );
		rFmt.SetBulletFont( &aFont );

		// JP 13.10.95: kleiner BugFix fuer vordefinierte benannte NumRules
		//				aus der Configuration: diese lasen Bullet Fonts nicht
		//				richtig ein - Prefix/PostFixString koennen dadurch
		//				ungueltig sein. AMA kommt damit leicht durcheinander
		if( sPrefix.Len() > 50 )		// Max-Length vom Dialog
			rFmt.SetPrefix( aEmptyStr );
		if( sPostfix.Len() > 50 )		// Max-Length vom Dialog
			rFmt.SetSuffix( aEmptyStr );
	}

	CloseRec( SWG_NUMFMT );
}

// Numerierungs-Format ausgeben


void Sw3IoImp::OutNumFmt( const SwNumFmt& rFmt, USHORT nPrvAbsLSpace )
{
	USHORT nFmt = IDX_NO_VALUE;

	// Wegen eines Bugs in alten Readern, wird die Zeichen-Vorlage erst
	// im 4.0-Format hier geschrieben
	const SwCharFmt* pCharFmt = rFmt.GetCharFmt();
	if( !IsSw31Export() && pCharFmt )
		nFmt = aStringPool.Add( pCharFmt->GetName(), pCharFmt->GetPoolFmtId() );

	const Font* pFont = rFmt.GetBulletFont();
	String aFontName, aFontStyle;
	BYTE cFamily = 0, cPitch = 0;
	rtl_TextEncoding eEnc = RTL_TEXTENCODING_DONTKNOW;
	BYTE cFlags = 0;
	sal_Bool bToBats = sal_False;
	if( pFont )
	{
		cFlags  |= 0x10;
		cFamily  = (BYTE) pFont->GetFamily();
		cPitch   = (BYTE) pFont->GetPitch();
		aFontName = pFont->GetName();
		bToBats =
			aFontName == sStarSymbol || aFontName == sOpenSymbol;
		if( bToBats )
			aFontName = sStarBats;
		aFontStyle = pFont->GetStyleName();

		eEnc = (bToBats ? RTL_TEXTENCODING_SYMBOL 
						: GetSOStoreTextEncoding( pFont->GetCharSet(),
												  pStrm->GetVersion() ) );
	}

	sal_Int16 eType = rFmt.GetNumberingType();
	if( SVX_NUM_BITMAP == eType && IsSw31Export() )
		eType = SVX_NUM_CHAR_SPECIAL;

	sal_Char cBullet;
	if( bToBats )
		cBullet = ConvStarSymbolCharToStarBats( rFmt.GetBulletChar() );
	else
		cBullet = ByteString::ConvertFromUnicode( rFmt.GetBulletChar(),
				((pFont && RTL_TEXTENCODING_DONTKNOW !=  pFont->GetCharSet())
				 		 ? eEnc 
						 : eSrcSet ), FALSE);
	if( !cBullet )
		cBullet = ByteString::ConvertFromUnicode( rFmt.GetBulletChar(),
												  RTL_TEXTENCODING_SYMBOL );
	OpenRec( SWG_NUMFMT );
	OutString( *pStrm, rFmt.GetPrefix() );
	OutString( *pStrm, rFmt.GetSuffix() );
	OutString( *pStrm, aFontName );
	OutString( *pStrm, aFontStyle );
	*pStrm << (UINT16) nFmt
		   << (BYTE)   eType
		   << cBullet;

	// GetIncludeUpperLevel war bis zur 4.0 (inkl) nur ein Flag
	if( IsSw31Or40Export() )
		*pStrm << (BYTE)lcl_sw3io__IsInclUpperLevel( rFmt.GetIncludeUpperLevels() );
	else
		*pStrm << (BYTE)rFmt.GetIncludeUpperLevels();

	*pStrm << (UINT16) rFmt.GetStart()
		   << (BYTE)   rFmt.GetNumAdjust()
		   << (INT32)  rFmt.GetAbsLSpace()
		   << (INT32)  rFmt.GetFirstLineOffset()
		   << (BYTE)   cFamily
		   << (BYTE)   cPitch
		   << (BYTE)   eEnc
		   << (BYTE)   cFlags;

	// MIB 13.11.96: im 4.0-Format wird die Zeichen-Vorlage an der alten
	// Position geschrieben.
	// *pStrm << (UINT16) nFmt

	// Im 4.0-Format gab es mal relative Werte fuer den Abstand.
	// Im 3.1-Format noch nicht um im 5.0 nicht mehr.
	if( IsSw40Export() )
	{
		*pStrm << (BYTE)   FALSE
			   << (INT32)  (rFmt.GetAbsLSpace() - nPrvAbsLSpace);
	}

	// Den Rest gibt es seit der 4.0
	if( !IsSw31Export() )
	{
		*pStrm << (UINT16) rFmt.GetCharTextDistance();

		if( SVX_NUM_BITMAP == rFmt.GetNumberingType() )
		{
			*pStrm << (INT32)rFmt.GetGraphicSize().Width()
				   << (INT32)rFmt.GetGraphicSize().Height();
			BYTE cFlg = ( 0 != rFmt.GetBrush() ? 1 : 0 ) +
						( 0 != rFmt.GetGraphicOrientation() ? 2 : 0 );
			*pStrm << cFlg;

			if( rFmt.GetBrush() )
			{
				USHORT nVersion = rFmt.GetBrush()->GetVersion( (USHORT)pStrm->GetVersion() );
				*pStrm << nVersion;
				rFmt.GetBrush()->Store( *pStrm, nVersion );
			}
			if( rFmt.GetGraphicOrientation() )
			{
				USHORT nVersion = rFmt.GetGraphicOrientation()->GetVersion( (USHORT)pStrm->GetVersion() );
				*pStrm << nVersion;
				rFmt.GetGraphicOrientation()->Store( *pStrm, nVersion );
			}
		}
	}

	CloseRec( SWG_NUMFMT );
}

// Numerierungs-Regelwerk einlesen


SwNumRule* Sw3IoImp::InNumRule( BYTE cType )
{
	BYTE eType, nFmt, cFmt[ MAXLEVEL ];
	OpenRec( cType );

	// Den Flag-Record und Pool-Ids gibt's erst seit der 5.0. Anderenfalls
	// ist das Invalid-Flag immer zu setzen.
	USHORT nStrIdx = IDX_NO_VALUE, nPoolId = USHRT_MAX, nPoolHelpId;
	BYTE cFlags = 0x20, nPoolHlpFileId;
	if( IsVersion(SWG_LONGIDX) )
	{
		cFlags = OpenFlagRec();

		*pStrm >> nStrIdx;

		if( cFlags & 0x10 )
		{
			*pStrm >> nPoolId
				   >> nPoolHelpId
				   >> nPoolHlpFileId;
		}
	}

	*pStrm >> eType;

	if( IsVersion(SWG_LONGIDX) )
		CloseFlagRec();

	*pStrm >> nFmt;

	// C 8.0 bug:
	SwNumRuleType eTemp = (SwNumRuleType) eType;
	String aName;
	if( (cFlags & 0x10) != 0 &&
		nPoolId >= RES_POOLNUMRULE_BEGIN &&
		nPoolId < RES_POOLNUMRULE_END )
	{
		// Name der Pool-Vorlage vom Dok holen.
		SwStyleNameMapper::FillUIName( nPoolId, aName );
	}
	else if( nStrIdx != IDX_NO_VALUE )
	{
		aName = aStringPool.Find( nStrIdx );

		// NumRule ist in jedem Fall Benutzer-Definiert.
		nPoolId = USHRT_MAX;
	}
	else if( SWG_OUTLINE == cType )
		aName.AssignAscii( SwNumRule::GetOutlineRuleName() );
	else
		aName = pDoc->GetUniqueNumRuleName();

	SwNumRule* pRule = new SwNumRule( aName, eTemp, (cFlags & 0x10)==0 );

	if( (cFlags & 0x10) != 0 )
	{
		pRule->SetPoolFmtId( nPoolId );
		pRule->SetPoolHelpId( nPoolHelpId );
		pRule->SetPoolHlpFileId( nPoolHlpFileId );
	}
	pRule->SetInvalidRule( (cFlags & 0x20) != 0 || !bNormal || bInsert );
	pRule->SetContinusNum( (cFlags & 0x40) != 0 );
#ifdef NUM_RELSPACE
	pRule->SetAbsSpaces( IsVersion(SWG_NUMRELSPACE) && (cFlags & 0x80) != 0 );
#endif

	// in Zukunft koennten auch mal mehr als MAXLEVEL Formate geschrieben
	// werden, wir kennen aber maximal MAXLEVEL Formate davon
	BYTE nKnownFmt = nFmt > MAXLEVEL ? MAXLEVEL : nFmt;
	BYTE nRead = 0;

	for( int i = 0; i < nKnownFmt; i++ )
	{
		BYTE nFmtLvl;
		*pStrm >> nFmtLvl;
		nRead++;

		if( nFmtLvl < MAXLEVEL  )
		{
			cFmt[ i ] = nFmtLvl;
		}
		else
		{
			// wenn das Format zu einer Ebene gehoert, die wir nicht kennen
			// muessen wir dieses und alle Formate hiernach ignorieren.
			nKnownFmt = i;
			break;
		}
	}

	// noch nicht gelesene Format-Nummern ueberlesen
	for( i=nRead; i<nFmt; i++ )
	{
		BYTE nFmtLvl;
		*pStrm >> nFmtLvl;
	}

	for( i = 0; Good() && i < nKnownFmt; i++ )
	{
		SwNumFmt aFmt;
		InNumFmt( aFmt );
		if( SWG_OUTLINE == cType && !IsVersion(SWG_LONGIDX) )
		{
			// In der 3.1/4.0 wurden diese Werte ignoriert
			aFmt.SetAbsLSpace( 0U );
			aFmt.SetFirstLineOffset( 0 );
		}

		pRule->Set( (USHORT) cFmt[ i ], aFmt );
	}

	// falls es nicht unterstuetzte Formate koennte man sie ueberlesen.
	// Da danach aber nicht sinnvolles kommt, lassen wir das erstmal
#if 0
	for( i = nKnownFmt; Good() && i < nFmt; i++ )
		SkipRec();
#endif

#ifdef NUM_RELSPACE
	if( SWG_OUTLINE == cType && !IsVersion(SWG_NUMRELSPACE) )
	{
		// In 3.1-/4.0-Doks muss die Outline-Numerierung noch an
		// die Vorlagen angepasst werden und anschliessend noch das
		// LRSpace-Item in der Vorlage geloescht werden.

		const SwTxtFmtColls *pColls = pDoc->GetTxtFmtColls();
		USHORT nArrLen = pColls->Count();
		for( USHORT i=0; i<nArrLen; i++ )
		{
			SwTxtFmtColl* pColl = (*pColls)[i];
			BYTE nLevel = pColl->GetOutlineLevel();
			if( NO_NUMBERING != nLevel )
			{
				nLevel = GetRealLevel( nLevel );
				const SvxLRSpaceItem& rLRSpace = pColl->GetLRSpace();
				sal_Int32 nOldLSpace = rLRSpace.GetTxtLeft();
				const SwNumFmt& rNumFmt = pRule->Get( nLevel );
				if( IsVersion(SWG_NEWFIELDS) || rLRSpace.GetPropLeft() == 100U )
				{
					// absoluter linker Absatz-Einzug oder 5.0-Dok (dort
					// wurde der relative Wert nicht beachtet)

					// In 3.1- und 4.0-Dokumenten den linken und
					// Ertzeilen-Einzug in die NumRule uebernehmen. In
					// 5.0-Dokumenten steht er dort schon.
					if( !IsVersion(SWG_NEWFIELDS) &&
						(rNumFmt.GetAbsLSpace() != rLRSpace.GetTxtLeft() ||
						 rNumFmt.GetFirstLineOffset() !=
										rLRSpace.GetTxtFirstLineOfst()) )
					{
						SwNumFmt aNumFmt( rNumFmt );
						aNumFmt.SetAbsLSpace( (USHORT)rLRSpace.GetTxtLeft() );
						aNumFmt.SetFirstLineOffset(
							rLRSpace.GetTxtFirstLineOfst() );
						pRule->Set( nLevel, aNumFmt );
					}

					// Den linken-Einzug in der Vorlage auf 0 setzen, damit
					// er nicht doppelt gezaehlt wird. Wenn das
					SvxLRSpaceItem aLRSpace( rLRSpace );
					aLRSpace.SetTxtFirstLineOfst( 0 );
					aLRSpace.SetTxtLeft( 0U );
					SwFmt *pParFmt = pColl->DerivedFrom();
					if( pParFmt && pParFmt->GetLRSpace() == aLRSpace )
						pColl->ResetAttr( RES_LR_SPACE );
					else if( aLRSpace != rLRSpace )
						pColl->SetAttr( aLRSpace );
					if( nOldLSpace != 0 )
					{
						const SfxPoolItem* pItem;
						if( SFX_ITEM_SET == pColl->GetAttrSet().GetItemState(
											RES_PARATR_TABSTOP, TRUE, &pItem ))
						{
							SvxTabStopItem aTStop( *(SvxTabStopItem*)pItem );
							lcl_sw3io__ConvertNumTabStop( aTStop, nOldLSpace );
							pColl->SetAttr( aTStop );
						}
					}
				}
				else
				{
					// relativer linker Absatz-Einzug in 3.1- oder 4.0-Dok

					// Die Vorlage nicht aendern sondern stattdessen
					// den linken Abstand und den Erstzeilen-Einzug
					// in der NumRule auf 0 setzen. Da der Erstzeilen-Einzug
					// der Vorlage nicht ausgewertet wird, geht er verloren.
					if( rNumFmt.GetAbsLSpace() != 0U ||
						rNumFmt.GetFirstLineOffset() != 0 )
					{
						SwNumFmt aNumFmt( rNumFmt );
						aNumFmt.SetAbsLSpace( 0U );
						aNumFmt.SetFirstLineOffset( 0 );
						pRule->Set( nLevel, aNumFmt );
					}
				}
			}
		}
	}
#else
	if( SWG_OUTLINE == cType && !IsVersion(SWG_NEWFIELDS) )
	{
		// In 3.1-/4.0-Doks muss die Outline-Numerierung noch an
		// die Vorlagen angepasst werden und anschliessend noch das
		// LRSpace-Item in der Vorlage gloescht werden.

		const SwTxtFmtColls *pColls = pDoc->GetTxtFmtColls();
		USHORT nArrLen = pColls->Count();
		for( USHORT i=0; i<nArrLen; i++ )
		{
			SwTxtFmtColl* pColl = (*pColls)[i];
			BYTE nLevel = pColl->GetOutlineLevel();
			if( NO_NUMBERING != nLevel &&
				GetRealLevel(nLevel) < MAXLEVEL )
			{
				const SwNumFmt& rFmt = pRule->Get( GetRealLevel(nLevel) );
				const SvxLRSpaceItem& rLRSpace = pColl->GetLRSpace();
				if( rFmt.GetAbsLSpace() != rLRSpace.GetTxtLeft() ||
					rFmt.GetFirstLineOffset() != rLRSpace.GetTxtFirstLineOfst())
				{
					SwNumFmt aFmt( rFmt );
					aFmt.SetAbsLSpace( rLRSpace.GetTxtLeft() );
					aFmt.SetFirstLineOffset( rLRSpace.GetTxtFirstLineOfst() );
					pRule->Set( nLevel, aFmt );
				}
			}
		}
	}
#endif

	CloseRec( cType );
	if( !Good() )
		delete pRule, pRule = NULL;
	return pRule;
}

void Sw3IoImp::InOutlineExt()
{
	OpenRec( SWG_OUTLINEEXT );

	BYTE nFmts;
	OpenFlagRec();
	*pStrm >> nFmts;
	CloseFlagRec();

	const SwNumRule *pOutline = pDoc->GetOutlineNumRule();
	ASSERT( pOutline, "Wo ist die Outline-NumRule?" );

	// Hier stehen jetzt die Original-linken-Abstaende der Outline-NumRule.
	for( BYTE i=0; i<nFmts; i++ )
	{
		BYTE nLevel;
		UINT16 nAbsLSpace;

		*pStrm >> nLevel >> nAbsLSpace;

		if( pOutline && nLevel < MAXLEVEL )
		{
			ASSERT( pOutline->GetNumFmt(nLevel), "Format nicht gesetzt?" );
			short nFirstLineOffset = pOutline->Get(nLevel).GetFirstLineOffset();
			pDoc->SetOutlineLSpace( nLevel, nFirstLineOffset, nAbsLSpace );
		}
	}

	CloseRec( SWG_OUTLINEEXT );
}

// Numerierungs-Regelwerk ausgeben

typedef const SwTxtFmtColl *Sw3TxtFmtCollPtrConst;

void Sw3IoImp::OutNumRule( BYTE cType, const SwNumRule& rRule )
{
	OpenRec( cType );

	// Ein-Flag-Record mit Pool-Ids gibt's seit der 5.0
	// 0x10: keine automatische Vorlage
	// 0x02: invalid Rule
	// 0x40: continus Num
	BYTE cFlags = 0x03;
	if( !IsSw31Or40Export() )
	{
		// Nur nicht-automatische Numerierungs-Regeln haben Pool-Ids
		if( cType != SWG_OUTLINE && !rRule.IsAutoRule() )
			cFlags += 0x15;

		if( rRule.IsInvalidRule() )
			cFlags += 0x20;

		if( rRule.IsContinusNum() )
			cFlags += 0x40;

#ifdef NUM_RELSPACE
		if( rRule.IsAbsSpaces() )
			cFlags += 0x80;
#endif

		*pStrm << (BYTE)cFlags
			   << (UINT16)aStringPool.Find( rRule.GetName(),
											rRule.GetPoolFmtId() );

		if( cFlags & 0x10 )
		{
			*pStrm << (UINT16) rRule.GetPoolFmtId()
				   << (UINT16) rRule.GetPoolHelpId()
				   << (BYTE)   rRule.GetPoolHlpFileId();
		}
	}

	// Der Rule Type steht im 5.0-Format noch im Flag-Record, auch wenn
	// es nicht so aussieht.
	*pStrm << (BYTE)rRule.GetRuleType();

	// Tabelle der definierten Formate aufbauen
	USHORT nMaxLevel = IsSw31Or40Export() ? OLD_MAXLEVEL : MAXLEVEL;
	short nFmt = 0;
	for( USHORT i = 0; i < nMaxLevel; i++ )
	{
		const SwNumFmt* pFmt = rRule.GetNumFmt( i );
		if( pFmt ) nFmt++;
	}
	*pStrm << (BYTE) nFmt;
	for( i = 0; i < nMaxLevel; i++ )
	{
		const SwNumFmt* pFmt = rRule.GetNumFmt( i );
		if( pFmt )
			*pStrm << (BYTE) i;
	}

	BOOL bOutline = SWG_OUTLINE == cType;
	Sw3TxtFmtCollPtrConst* ppTxtColls = 0;
	if( bOutline && nFmt && !rRule.IsAbsSpaces() && !IsSw31Or40Export()  )
	{
		const SwTxtFmtColls& rColls = *pDoc->GetTxtFmtColls();
		for( i=0; i<rColls.Count(); i++ )
		{
			const SwTxtFmtColl *pColl = rColls[i];
			BYTE nLevel = pColl->GetOutlineLevel();
			if( NO_NUMBERING != nLevel )
			{
				nLevel = GetRealLevel(nLevel);
				if( nLevel < nMaxLevel )
				{
					if(!ppTxtColls)
					{
						ppTxtColls = new Sw3TxtFmtCollPtrConst[MAXLEVEL];
						for( USHORT j=0; j < MAXLEVEL; j++ )
							ppTxtColls[j] = 0;
					}

					ppTxtColls[nLevel] = pColl;
				}
			}
		}
	}

	// Formate ausgeben
	BOOL bFirst = TRUE;
	USHORT nPrvAbsLSpace = 0;
	BYTE nAbsLSpaceChanged = 0;
	for( i = 0; i < nMaxLevel; i++ )
	{
		const SwNumFmt* pFmt = rRule.GetNumFmt( i );
		if( pFmt )
		{
			BOOL bOutFmt = TRUE;
#ifdef NUM_RELSPACE
			if( ppTxtColls && ppTxtColls[i] != 0 )
			{
				// Im 5.0-Format wird der linke Abstand der Vorlage auf
				// den Wert der NumRule addiert und der Original-Wert
				// getrennt gespeichert.
				ASSERT( !IsSw31Or40Export(), "Doch 3.1/4.0-Export?" );
				ASSERT( !rRule.IsAbsSpaces(), "Doch absolute Abstaende?" );
				ASSERT( bOutline, "Doch keine Kapitel-Numerierung?" );
				const SvxLRSpaceItem& rLRSpace = ppTxtColls[i]->GetLRSpace();
				if( rLRSpace.GetTxtLeft() > 0 )
				{
					SwNumFmt aFmt( *pFmt );
					aFmt.SetAbsLSpace( (USHORT)(aFmt.GetAbsLSpace() +
													rLRSpace.GetTxtLeft()) );
					USHORT nTmp = bFirst ? aFmt.GetAbsLSpace() : nPrvAbsLSpace;
					OutNumFmt( aFmt, nTmp );
					nPrvAbsLSpace = aFmt.GetAbsLSpace();

					bOutFmt = FALSE;
					nAbsLSpaceChanged++;
				}
				else
				{
					ppTxtColls[i] = 0;
				}
			}
			else if( bOutline && IsSw31Or40Export() &&
					 (pFmt->GetAbsLSpace() > 0U ||
					  pFmt->GetFirstLineOffset() != 0) )
			{
				// Im 3.1- oder 4.0-Format gab es noch keinen linken Abstand
				// und keinen Erstzeilen-Einzug. Er wird ggf. bei den Vorlagen
				// exportiert.
				SwNumFmt aFmt( *pFmt );
				aFmt.SetAbsLSpace( 0U );
				aFmt.SetFirstLineOffset( 0 );
				USHORT nTmp = bFirst ? aFmt.GetAbsLSpace() : nPrvAbsLSpace;
				OutNumFmt( aFmt, nTmp );
				nPrvAbsLSpace = aFmt.GetAbsLSpace();

				bOutFmt = FALSE;
			}
#endif
			if( bOutFmt )
			{
				USHORT nTmp = bFirst ? pFmt->GetAbsLSpace() : nPrvAbsLSpace;
				OutNumFmt( *pFmt, nTmp );
				nPrvAbsLSpace = pFmt->GetAbsLSpace();
			}
			bFirst = FALSE;
		}
		else if( ppTxtColls )
			ppTxtColls[i] = 0;
	}
	CloseRec( cType );

#ifdef NUM_RELSPACE
	if( ppTxtColls && nAbsLSpaceChanged > 0 )
	{
		ASSERT( !IsSw31Or40Export(), "Doch 3.1/4.0-Export?" );
		ASSERT( !rRule.IsAbsSpaces(), "Doch absolute Abstaende?" );

		OpenRec( SWG_OUTLINEEXT );
		*pStrm  << (BYTE)0x01
				<< (BYTE)nAbsLSpaceChanged;

		for( BYTE j=0; j < MAXLEVEL; j++ )
		{
			if( ppTxtColls[j] )
				*pStrm << (BYTE)j << (UINT16)rRule.Get(j).GetAbsLSpace();
		}
		CloseRec( SWG_OUTLINEEXT );
	}

	delete ppTxtColls;
#endif
}

// Numerierungs-Regelwerk einlesen

void lcl_sw3io__copyNumRule( const SwNumRule& rSrc, SwNumRule& rDst )
{
	rDst.SetRuleType( rSrc.GetRuleType() );
	rDst.SetPoolHelpId( rSrc.GetPoolHelpId() );
	rDst.SetPoolHlpFileId( rSrc.GetPoolHlpFileId() );
	rDst.SetContinusNum( rSrc.IsContinusNum() );

	ASSERT( rDst.GetPoolFmtId() == rSrc.GetPoolFmtId(),
			"NumRule-PoolIds sind unterschiedlich" );
	ASSERT( rDst.IsAutoRule() == rSrc.IsAutoRule(),
			"NumRule-Auto-Flags sind unterschiedlich" );
	ASSERT( rDst.GetName() == rSrc.GetName(),
			"NumRule-Namen sind unterschiedlich" );

	rDst.SetInvalidRule( TRUE );
}


void Sw3IoImp::InNumRules()
{
	InHeader( TRUE );
	if( !Good() )
		return;

	InStringPool( SWG_STRINGPOOL, aStringPool );

	SwNumRule* pRule;
	BOOL bDone = FALSE;
	while( !bDone )
	{
		BYTE cType = Peek();
		if( !Good() || pStrm->IsEof() )
			bDone = TRUE;
		else switch( cType )
		{
			case SWG_EOF:
				bDone = TRUE;
				break;

			case SWG_NUMRULE:
				pRule = InNumRule( cType );
				if( pRule )
				{
					BOOL bInsertRule = FALSE;
					if( pRule->IsAutoRule() )
					{
						// Automatische Rules werden nur beim normalen
						// Laden und Laden von Seitenvorlagen eingelesen,
						// aber nicht, wenn nur Num-Vorl. gelesen werden.
						if( bNormal || bPageDescs )
						{
							bInsertRule = TRUE;

							// Auto-NumRule ggf. umbenennen, wenn es sie
							// schon gibt und ausserdem den Namen merken,
							// damit unbenutzte Rules entfernt werden
							// koennen.
							String aOldName( pRule->GetName() );
							// Nur wenn Vorlagen geladen werden (!bNormal)
							// oder im Einfuege-Modus (bInsert) kann es die
							// NumRule schon geben.
							if( !bNormal || bInsert )
							{
								pRule->SetName(
									pDoc->GetUniqueNumRuleName( &aOldName ) );
							}
							aNumRuleInfos.Insert(
								new Sw3NumRuleInfo( aOldName, pRule->GetName() ) );
						}
					}
					else
					{
						// Nicht-automatische Vorlagen werden nur eingefuegt,
						// wenn normale Dokumente oder Num-Vorl. geladen
						// werden, nicht aber, wenn nur Seiten-Vorlagen
						// geladen werden.
						// Beim Einfuegen oder Num-Vorlagen-Laden ohne
						// ueberschreiben die NumRule nur einfuegen, wenn
						// es sie noch nicht gibt. (bAdditive ist TRUE
						// wenn eingefuegt wird) und sonst nur invalidieren.
						if( ( bNormal || bNumRules ) )
						{
							if( bAdditive )
							{
								SwNumRule *pDocRule =
									pDoc->FindNumRulePtr( pRule->GetName() );
								if( pDocRule )
									pDocRule->SetInvalidRule( TRUE );
								else
									bInsertRule = TRUE;
							}
							else if( bNumRules )
							{
								SwNumRule *pDocRule =
									pDoc->FindNumRulePtr( pRule->GetName() );
								if( pDocRule )
								{
									pDoc->ChgNumRuleFmts( *pRule );
									lcl_sw3io__copyNumRule( *pRule, *pDocRule );
								}
								else
									bInsertRule = TRUE;
							}
							else
							{
								bInsertRule = TRUE;
							}
						}
					}

					if( bInsertRule )
					{
						ASSERT( !pDoc->FindNumRulePtr( pRule->GetName() ),
								"NumRule existiert bereits" );
						pDoc->MakeNumRule( pRule->GetName(), pRule );
					}
					delete pRule;
				}
				break;

			case SWG_OUTLINE:
				if( bNormal && !bInsert )
				{
					pRule = InNumRule( cType );
					if( pRule )
					{
#if 0
						if( nVersion < SWG_DELETEOLE )
						{
							//JP 18.01.96: Alle Ueberschriften sind normalerweise
							//	ohne Kapitelnummer. Darum hier explizit abschalten
							//	weil das Default jetzt wieder auf AN ist.
							// und UeberschirftBasis ohne Einrueckung!
							SwTxtFmtColl* pCol = pDoc->GetTxtCollFromPool(
												RES_POOLCOLL_HEADLINE_BASE );
							pCol->ResetAttr( RES_LR_SPACE );

							for( short i = 0; i < MAXLEVEL; i++ )
							{
								if( !pRule->GetNumFmt( i ) )
								{
									SwNumFmt aFmt( pRule->Get( i ) );
									aFmt.eType = NUMBER_NONE;
									pRule->Set( i, aFmt );
								}
							}
						}
#endif
						pDoc->SetOutlineNumRule( *pRule );
					}
					delete pRule;
				}
				else
				{
					SkipRec();
				}
				break;

#ifdef NUM_RELSPACE
			case SWG_OUTLINEEXT:
				if( bNormal && !bInsert )
					InOutlineExt();
				else
					SkipRec();
				break;
#endif
#ifdef TEST_HUGE_DOCS
			case SWG_TESTHUGEDOCS:
				InHugeRecord();
#endif

			default:
				SkipRec();
				break;
		}
	}
}

// Numerierungs-Regelwerk ausgeben

void Sw3IoImp::OutNumRules( BOOL bUsed )
{
	OutHeader();

	// Stringpool (nur mit den wirklioch benoetigten) Namen fuellen.
	aStringPool.SetupForNumRules( *pDoc, pStrm->GetVersion() );
	OutStringPool( SWG_STRINGPOOL, aStringPool );

	// Die Outline-Numerierung schreiben
	if( pDoc->GetOutlineNumRule() )
		OutNumRule( SWG_OUTLINE, *pDoc->GetOutlineNumRule() );

	// Und alle Numerierungen schreiben
	USHORT nArrLen = pDoc->GetNumRuleTbl().Count();
	for( USHORT n=0; n<nArrLen; n++ )
	{
		const SwNumRule *pNumRule = pDoc->GetNumRuleTbl()[n];
		if( !bUsed || pDoc->IsUsed( *pNumRule ) )
			OutNumRule( SWG_NUMRULE, *pNumRule );
	}

#ifdef TEST_HUGE_DOCS
	BOOL b = FALSE;
	if( b )
		OutHugeRecord( 1024, 32*1024 );
#endif
}

// Absatz-Numerierung einlesen (seit 5.0)

void Sw3IoImp::InNodeNum( SwNodeNum& rNodeNum )
{
	OpenRec( SWG_NODENUM );

	BYTE nLevel;
	UINT16 nSetValue;

	// 0x10: Start-Flag ist gesetzt.
	// 0x20: Start-Wert ist vorhanden.
	BYTE cFlags = OpenFlagRec();

	*pStrm	>> nLevel;
	if( (cFlags & 0x20) != 0 )
		*pStrm	>> nSetValue;

	CloseFlagRec();

	BYTE nRealLevel = 0;
	if( nLevel != NO_NUMBERING )
	{
		nRealLevel = GetRealLevel(nLevel);
		if( nRealLevel >= MAXLEVEL )
		{
			BYTE cTmp = MAXLEVEL-1;
			if( nLevel & NO_NUMLEVEL )
				cTmp |= NO_NUMLEVEL;
			nLevel = cTmp;
		}
	}

	rNodeNum.SetLevel( nLevel );
	rNodeNum.SetStart( (cFlags & 0x10)!=0 );
	if( (cFlags & 0x20) != 0 )
		rNodeNum.SetSetValue( nSetValue );

	if( nLevel != NO_NUMBERING )
	{
		USHORT *pLevelVal = rNodeNum.GetLevelVal();
		UINT16 nVal;
		for( BYTE i=0; i<=nRealLevel; i++ )
		{
			*pStrm >> nVal;
			if( i < MAXLEVEL )
				pLevelVal[i] = nVal;
			else
				Warning();
		}
	}

	CloseRec( SWG_NODENUM );
}

// Absatz-Numerierung ausgeben (seit 5.0)

void Sw3IoImp::OutNodeNum( const SwNodeNum& rNodeNum )
{
	OpenRec( SWG_NODENUM );

	BYTE nLevel = rNodeNum.GetLevel();

	// 0x10: Start-Flag ist gesetzt.
	// 0x20: Start-Wert ist vorhanden.
	BYTE cFlags = rNodeNum.IsStart() ? 0x11 : 0x01;
	if( rNodeNum.GetSetValue() != USHRT_MAX )
		cFlags += 0x22;

	*pStrm	<< (BYTE)   cFlags
			<< (BYTE)   nLevel;
	if( (cFlags & 0x20) != 0 )
		*pStrm << (UINT16)rNodeNum.GetSetValue();

	if( nLevel != NO_NUMBERING )
	{
		BYTE nRealLevel = GetRealLevel( nLevel );
		const USHORT *pLevelVal = rNodeNum.GetLevelVal();
		for( BYTE i=0; i<=nRealLevel; i++ )
		{
			*pStrm << (UINT16)pLevelVal[i];
		}
	}

	CloseRec( SWG_NODENUM );
}


// globale Fussnoten-Info einlesen

void Sw3IoImp::InEndNoteInfo( SwEndNoteInfo &rENInf )
{
	BYTE cFlags = OpenFlagRec();
	BYTE eType;
	UINT16 nPageIdx, nCollIdx, nFtnOffset = 0,
			nChrIdx = IDX_NO_VALUE, nAnchorChrIdx = IDX_NO_VALUE;
	String sPrefix, sSuffix;
	*pStrm >> eType >> nPageIdx >> nCollIdx >> nFtnOffset;
	if( IsVersion(SWG_HTMLCOLLCHG) )
		*pStrm >> nChrIdx;
	if( IsVersion( SWG_FTNANCHORFMT ) && ( 0x10 & cFlags ))
		*pStrm >> nAnchorChrIdx;
	CloseFlagRec();

	if( IsVersion(SWG_HTMLCOLLCHG) )
	{
		InString( *pStrm, sPrefix );
		InString( *pStrm, sSuffix );
	}

	if( nCollIdx != IDX_NO_VALUE )
	{
		SwTxtFmtColl* pColl = FindTxtColl( nCollIdx );
		if( pColl )
			rENInf.SetFtnTxtColl( *pColl );
	}
	// PageDesc suchen
	if( nPageIdx < IDX_SPEC_VALUE )
	{
		SwPageDesc *pPageDesc = FindPageDesc( nPageIdx );
		if( pPageDesc )
			rENInf.ChgPageDesc( pPageDesc );
	}
	if( nChrIdx != IDX_NO_VALUE )
	{
		SwCharFmt *pChrFmt = (SwCharFmt *)FindFmt( nChrIdx, SWG_CHARFMT );
		if( pChrFmt )
			rENInf.SetCharFmt( pChrFmt );
	}
	if( nAnchorChrIdx != IDX_NO_VALUE )
	{
		SwCharFmt *pChrFmt = (SwCharFmt *)FindFmt( nAnchorChrIdx, SWG_CHARFMT );
		if( pChrFmt )
			rENInf.SetAnchorCharFmt( pChrFmt );
	}
	rENInf.aFmt.SetNumberingType(eType);
	rENInf.nFtnOffset = nFtnOffset;
	rENInf.SetPrefix( sPrefix );
	rENInf.SetSuffix( sSuffix );
}


// globale Fussnoten-Info ausgeben

void Sw3IoImp::OutEndNoteInfo( const SwEndNoteInfo &rENInf )
{
	SwTxtFmtColl* pColl = rENInf.GetFtnTxtColl();
	USHORT nCollIdx = pColl ? aStringPool.Add( pColl->GetName(),
											   pColl->GetPoolFmtId() )
							: IDX_NO_VALUE;

	const SwPageDesc *pDesc = (const SwPageDesc *)rENInf.GetPageDescDep()
									->GetRegisteredIn();
	USHORT nPageIdx = pDesc ? aStringPool.Find( pDesc->GetName(),
												pDesc->GetPoolFmtId() )
							: IDX_NO_VALUE;

	const SwCharFmt *pCharFmt = (const SwCharFmt *)rENInf.GetCharFmtDep()
									->GetRegisteredIn();
	USHORT nChrIdx = pCharFmt ? aStringPool.Find( pCharFmt->GetName(),
												  pCharFmt->GetPoolFmtId() )
							  : IDX_NO_VALUE;

	BYTE nFlags = 0x09;		// 9 bytes of data
	pCharFmt = (const SwCharFmt *)rENInf.GetAnchorCharFmtDep()->GetRegisteredIn();
	USHORT nAnchorChrIdx = pCharFmt ? aStringPool.Find( pCharFmt->GetName(),
									  				pCharFmt->GetPoolFmtId() )
									: IDX_NO_VALUE;
	if( IDX_NO_VALUE != nAnchorChrIdx && nAnchorChrIdx !=
		( rENInf.IsEndNoteInfo() ? RES_POOLCHR_FOOTNOTE_ANCHOR
								 : RES_POOLCHR_ENDNOTE_ANCHOR ))
		nFlags += 0x12;

	*pStrm << nFlags
		   << (BYTE) rENInf.aFmt.GetNumberingType()
		   << (UINT16) nPageIdx
		   << (UINT16) nCollIdx
		   << (UINT16) rENInf.nFtnOffset
		   << (UINT16) nChrIdx;

	if( 0x10 & nFlags )
		   *pStrm << (UINT16) nAnchorChrIdx;

	OutString( *pStrm, rENInf.GetPrefix() );
	OutString( *pStrm, rENInf.GetSuffix() );
}

void Sw3IoImp::InEndNoteInfo()
{
	OpenRec( SWG_ENDNOTEINFO );
	SwEndNoteInfo aENInf( pDoc->GetEndNoteInfo() );
	InEndNoteInfo( aENInf );
	pDoc->SetEndNoteInfo( aENInf );
	CloseRec( SWG_ENDNOTEINFO );
}


void Sw3IoImp::OutEndNoteInfo()
{
	OpenRec( SWG_ENDNOTEINFO );
	OutEndNoteInfo( pDoc->GetEndNoteInfo() );
	CloseRec( SWG_ENDNOTEINFO );
}

void Sw3IoImp::InFtnInfo()
{
	if( !IsVersion(SWG_LONGIDX) )
	{
		InFtnInfo40();
		return;
	}

	OpenRec( SWG_FOOTINFO );
	SwFtnInfo aFtn( pDoc->GetFtnInfo() );
	InEndNoteInfo( aFtn );

	OpenFlagRec();
	BYTE ePos, eNum;
	*pStrm >> ePos
		   >> eNum;
	CloseFlagRec();

	InString( *pStrm, aFtn.aQuoVadis );
	InString( *pStrm, aFtn.aErgoSum );

	aFtn.ePos = (SwFtnPos) ePos;
	aFtn.eNum = (SwFtnNum) eNum;

	//#91003# don't allow counting of footnotes by chapter and end-of-document position 
	if(FTNPOS_CHAPTER == aFtn.ePos && FTNNUM_CHAPTER == aFtn.eNum)
        aFtn.eNum = FTNNUM_DOC;
	pDoc->SetFtnInfo( aFtn );
	CloseRec( SWG_FOOTINFO );
}

void Sw3IoImp::OutFtnInfo()
{
	if( IsSw31Or40Export() )
	{
		OutFtnInfo40();
		return;
	}

	const SwFtnInfo& rFtn = pDoc->GetFtnInfo();

	OpenRec( SWG_FOOTINFO );
	OutEndNoteInfo( rFtn );
	*pStrm << (BYTE)0x02
		   << (BYTE) rFtn.ePos
		   << (BYTE) rFtn.eNum;
	OutString( *pStrm, rFtn.aQuoVadis );
	OutString( *pStrm, rFtn.aErgoSum );
	CloseRec( SWG_FOOTINFO );
}

void Sw3IoImp::InFtnInfo40()
{
	OpenRec( SWG_FOOTINFO );
	SwFtnInfo aFtn( pDoc->GetFtnInfo() );
	InString( *pStrm, aFtn.aQuoVadis );
    InString( *pStrm, aFtn.aErgoSum );
	OpenFlagRec();
	BYTE ePos, eNum, eType;
	UINT16 nPageIdx, nCollIdx, nFtnOffset = 0;
	*pStrm >> ePos >> eNum >> eType >> nPageIdx >> nCollIdx;
	if( nVersion>SWG_DELETEOLE )
		*pStrm >> nFtnOffset;
	CloseFlagRec();
	if( nCollIdx != IDX_NO_VALUE )
	{
		SwTxtFmtColl* pColl = FindTxtColl( nCollIdx );
		if( pColl )
			aFtn.SetFtnTxtColl( *pColl );
	}
	// PageDesc suchen
	if( nPageIdx < IDX_SPEC_VALUE )
	{
		SwPageDesc *pPageDesc = FindPageDesc( nPageIdx );
		if( pPageDesc )
			aFtn.ChgPageDesc( pPageDesc );
	}
	aFtn.ePos = (SwFtnPos) ePos;
	aFtn.eNum = (SwFtnNum) eNum;
	aFtn.aFmt.SetNumberingType(eType);
	aFtn.nFtnOffset = nFtnOffset;
	pDoc->SetFtnInfo( aFtn );
	CloseRec( SWG_FOOTINFO );
}

void Sw3IoImp::OutFtnInfo40()
{
	const SwFtnInfo& rFtn = pDoc->GetFtnInfo();
	SwTxtFmtColl* pColl = rFtn.GetFtnTxtColl();
	USHORT nCollIdx = pColl ? aStringPool.Add( pColl->GetName(),
											   pColl->GetPoolFmtId() )
							: IDX_NO_VALUE;
	const SwPageDesc *pDesc = (const SwPageDesc *)rFtn.GetPageDescDep()
									->GetRegisteredIn();
	USHORT nPageIdx = pDesc ? aStringPool.Find( pDesc->GetName(),
												pDesc->GetPoolFmtId() )
							: IDX_NO_VALUE;
	OpenRec( SWG_FOOTINFO );
	OutString( *pStrm, rFtn.aQuoVadis );
	OutString( *pStrm, rFtn.aErgoSum );
    *pStrm << (BYTE) 0x09		// 9 bytes of data
		   << (BYTE) rFtn.ePos
		   << (BYTE) rFtn.eNum
		   << (BYTE) rFtn.aFmt.GetNumberingType()
		   << (UINT16) nPageIdx
		   << (UINT16) nCollIdx
		   << (UINT16) rFtn.nFtnOffset;
	CloseRec( SWG_FOOTINFO );
}

// Oeffnen eines Numerierungsregel-Bereichs


void Sw3IoImp::OpenNumRange40( const SwNodeIndex& rPos )
{
	CloseNumRange40( rPos );
	pCurNumRange = new SwPaM( rPos );
	pCurNumRange->SetMark();
	pCurNumRule = InNumRule( SWG_NUMRULE );
}

// Schliessen eines Numerierungsregel-Bereichs
// Der Index zeigt auf den Node HINTER dem letzten zu numerierenden Node!


void Sw3IoImp::CloseNumRange40( const SwNodeIndex& rPos )
{
	if( pCurNumRange )
	{
		SwNodeIndex& rNodePos = pCurNumRange->GetPoint()->nNode;
		rNodePos = rPos.GetIndex() - 1;
		SwCntntNode* pCntNd =
			pDoc->GetNodes()[ rNodePos ]->GetCntntNode();
		if( !pCntNd )
			pCntNd = pDoc->GetNodes().GoPrevious( &rNodePos );
		pCurNumRange->GetPoint()->nContent.Assign( pCntNd, 0 );
		pCurNumRange->GetMark()->nContent.Assign
			( pCurNumRange->GetMark()->nNode.GetNode().GetCntntNode(), 0 );
		pDoc->SetNumRule( *pCurNumRange, *pCurNumRule );

		// Es wurde ein NO_NUM in der aktuellen Numerierung eingelesen.
		// Das muss jetzt noch in ein NO_NUMLEVEL umgewandelt werden.
		BYTE nPrevLevel = 0;
		for( ULONG n = pCurNumRange->GetMark()->nNode.GetIndex(),
			nEnd = rPos.GetIndex(); n < nEnd; ++n )
		{
			SwTxtNode* pTxtNd = pDoc->GetNodes()[n]->GetTxtNode();
			if( pTxtNd && pTxtNd->GetNum() )
			{
				SwNodeNum* pNum = (SwNodeNum*)pTxtNd->GetNum();
				if( bConvertNoNum )
				{
					if( NO_NUM == pNum->GetLevel() )
						pNum->SetLevel( nPrevLevel | NO_NUMLEVEL );
					else
						nPrevLevel = GetRealLevel( pNum->GetLevel() );
				}
#ifdef NUM_RELSPACE
				lcl_sw3io__ConvertNumLRSpace( *pTxtNd, *pCurNumRule,
											  pNum->GetLevel(), TRUE );
#endif
			}
		}

		delete pCurNumRange, pCurNumRange = 0;
		delete pCurNumRule, pCurNumRule = 0;
		bConvertNoNum = FALSE;
	}
}

void lcl_sw3io__ConvertNumTabStop( SvxTabStopItem& rTStop, long nOffset )
{
	for( USHORT n = 0; n < rTStop.Count(); ++n )
	{
		SvxTabStop& rTab = (SvxTabStop&)rTStop[ n ];
		if( SVX_TAB_ADJUST_DEFAULT != rTab.GetAdjustment() &&
			rTab.GetTabPos() )
		{
			rTab.GetTabPos() += nOffset;
		}
	}
}

void lcl_sw3io__ConvertNumTabStop( SwTxtNode& rTxtNd, long nOffset,
								   BOOL bDeep )
{
	const SfxPoolItem* pItem;
	if( SFX_ITEM_SET == rTxtNd.GetSwAttrSet().GetItemState( RES_PARATR_TABSTOP,
															bDeep, &pItem ) )
	{
		SvxTabStopItem aTStop( *(SvxTabStopItem*)pItem );
		lcl_sw3io__ConvertNumTabStop( aTStop, nOffset );
		rTxtNd.SwCntntNode::SetAttr( aTStop );
	}
}

void lcl_sw3io__ConvertNumLRSpace( SwTxtNode& rTxtNd, const SwNumRule& rNumRule,
								   BYTE nLevel, BOOL bTabStop )
{
	if( nLevel == NO_NUMBERING )
		return;

	nLevel = GetRealLevel( nLevel );
	USHORT nNumLSpace = rNumRule.Get( nLevel ).GetAbsLSpace();

	// Wenn im Absatz der Einzug eingestellt ist, dann will
	// man den wieder Erreichen, sonst den der NumRule.
	const SfxPoolItem *pItem;
	const SvxLRSpaceItem *pParaLRSpace = 0;
	const SwAttrSet *pAttrSet = rTxtNd.GetpSwAttrSet();
	if( pAttrSet &&
		SFX_ITEM_SET == pAttrSet->GetItemState( RES_LR_SPACE, FALSE, &pItem ) )
		pParaLRSpace = (const SvxLRSpaceItem *)pItem;
	USHORT nWishLSpace = pParaLRSpace ? pParaLRSpace->GetTxtLeft() : nNumLSpace;

	// Dazu muss man den folgenden Wert im Absatz einstellen
	const SvxLRSpaceItem& rCollLRSpace = rTxtNd.GetAnyFmtColl().GetLRSpace();
	USHORT nOldLSpace = pParaLRSpace ? pParaLRSpace->GetTxtLeft()
									 : rCollLRSpace.GetTxtLeft();
	USHORT nNewLSpace;
	if( rNumRule.IsAbsSpaces() )
		nNewLSpace = rCollLRSpace.GetTxtLeft();
	else
		nNewLSpace = nWishLSpace > nNumLSpace ? nWishLSpace - nNumLSpace : 0U;

	// Wenn der neue Wert zufaellig der der Vorlage ist und der
	// rechte Einzug auch mit dem der Vorlage ueberseinstimmt,
	// dann braucht bzw. darf man das Absatz-Attribut nicht
	// setzen, sonst muss man es setzen.
	if( nNewLSpace == rCollLRSpace.GetTxtLeft() &&
		(!pParaLRSpace || pParaLRSpace->GetRight() == rCollLRSpace.GetRight()) )
	{
		if( pParaLRSpace )
			rTxtNd.ResetAttr( RES_LR_SPACE );
	}
	else
	{
		if( !pParaLRSpace )
			pParaLRSpace = &rCollLRSpace;
		SvxLRSpaceItem aLRSpace( *pParaLRSpace );
		short nFirst = aLRSpace.GetTxtFirstLineOfst();
		if( nFirst < 0 && (USHORT)-nFirst > nNewLSpace )
			aLRSpace.SetTxtFirstLineOfst( -(short)nNewLSpace );
		aLRSpace.SetTxtLeft( nNewLSpace );
		((SwCntntNode&)rTxtNd).SetAttr( aLRSpace );
	}

	if( bTabStop && nOldLSpace != nNewLSpace )
		lcl_sw3io__ConvertNumTabStop( rTxtNd,
									  (long)nOldLSpace - (long)nNewLSpace,
									  TRUE );
}

