/*************************************************************************
 *
 *  $RCSfile: splwrp.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: tl $ $Date: 2000/10/27 12:17:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SPLWRP_HXX
#define _SPLWRP_HXX

#ifndef _SVX_SPLWRAP_HXX //autogen
#include <svx/splwrap.hxx>
#endif


class SpellCheck;
#ifndef _COM_SUN_STAR_LINGUISTIC2_XSPELLCHECKER1_HPP_
#include <com/sun/star/linguistic2/XSpellChecker1.hpp>
#endif
class SwView;
class SwTextBlocks;

/*--------------------------------------------------------------------
	 Beschreibung: Der SpellWrapper
 --------------------------------------------------------------------*/

class SwSpellWrapper : public SvxSpellWrapper {
private:
	SwView*			pView;
	SwTextBlocks*   pBlocks;
	USHORT 			nOldLang;
	USHORT			nPageCount;		// Seitenanzahl fuer Progressanzeige
	USHORT			nPageStart;		// 1. gepruefte Seite
	BOOL 			bDrawObj : 1;	// Pruefen wir z.Z. Sonderbereiche?
	BOOL 			bDelBlocks : 1; // Muss der TextBlock geloescht werden?
	BOOL			bInSelection : 1; // Pruefung von selektiertem Text
	BOOL			bInfoBox : 1;	// InfoBox beim Beenden anzeigen
	BOOL 			bLastRet : 1;
	BOOL			bAllRight	: 1; // falsche Woerter in geignetes Woerterbuch
							 		 // aufnehmen und nicht den Dialog starten.
public:
	SwSpellWrapper( SwView* pVw, 
					::com::sun::star::uno::Reference< 
						::com::sun::star::linguistic2::XSpellChecker1> &xSpl, 
					BOOL bStart, BOOL bIsAllRIght, BOOL bOther, BOOL bSelect );
	~SwSpellWrapper();
	inline BOOL IsDrawObj(){ return( bDrawObj ); }
	inline void SetDrawObj( BOOL bNew ){ bDrawObj = bNew; }
protected:
	virtual	BOOL HasOtherCnt( );
	virtual	void SpellStart( SvxSpellArea eSpell );
	virtual	BOOL SpellContinue();
	virtual void ReplaceAll( const String &rNewText, INT16 nLanguage );
	virtual	void SpellEnd( );
	virtual	BOOL SpellMore();
	virtual	void ScrollArea();
	virtual void ChangeWord( const String& rNewWord, const USHORT nLang );
	virtual String GetThesWord();
	virtual void ChangeThesWord( const String& rNewWord );
	virtual void SetLanguage( const USHORT nLang );
	virtual void AutoCorrect( const String& rAktStr, const String& rNewStr );
};


#endif //
