/*************************************************************************
 *
 *  $RCSfile: pluginacceptthread.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: sb $ $Date: 2001/04/24 10:24:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCB_MAIN_PLUGINACCEPTTHREAD_HXX_
#define _UCB_MAIN_PLUGINACCEPTTHREAD_HXX_

#ifndef _COM_SUN_STAR_LANG_XEVENTLISTENER_HPP_
#include <com/sun/star/lang/XEventListener.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _VOS_CONDITN_HXX_
#include <vos/conditn.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _UCB_MAIN_ACCEPTTHREAD_HXX_
#include "acceptthread.hxx"
#endif
#ifndef _UCB_MAIN_MACHINE_HXX_
#include "machine.hxx"
#endif

namespace com { namespace sun { namespace star {
	namespace connection { class XAcceptor; }
} } }

namespace ucb_main {

//============================================================================
	class PluginAcceptThread: public AcceptThread,
							  public Machine,
							  public com::sun::star::lang::XEventListener
{
public:
	PluginAcceptThread( 
		com::sun::star::uno::Reference<
		        com::sun::star::lang::XMultiServiceFactory > const &
		    rTheServiceFactory,
		com::sun::star::uno::Reference< 
		        com::sun::star::bridge::XBridgeFactory > const &
		    rTheBridgeFactory,
		com::sun::star::uno::Reference< 
		        com::sun::star::bridge::XInstanceProvider > const &
		    rTheInstanceProvider,
		rtl::OUString const & rTheConnection,
		rtl::OUString const & rTheProtocol,
		MachineControl * pControl);

	//========================================================================
	// com::sun::star::uno::XInterface:

	virtual com::sun::star::uno::Any SAL_CALL
	queryInterface(com::sun::star::uno::Type const & rType)
		throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw ();

    virtual void SAL_CALL release() throw ();

	//========================================================================
	// vos::OThread:

	virtual void SAL_CALL run();

	//========================================================================
	// ucb_main::Machine:

	virtual void tryStop();

	virtual void doStop(bool bStop);

	//========================================================================
	// com::sun::star::lang::XEventListener:

	virtual void SAL_CALL
	disposing(com::sun::star::lang::EventObject const & rSource) 
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// Implementation:

	void timedOut();

private:
	enum State
	{
		STATE_INIT,
		STATE_INIT_TRY_STOP,
		STATE_RUNNING,
		STATE_TRY_STOP,
		STATE_STOPPED
	};

	vos::OMutex m_aMutex;
	vos::OCondition m_aDoStop;
	vos::OCondition m_aDisposed;
	com::sun::star::uno::Reference< com::sun::star::connection::XAcceptor >
	    m_xAcceptor;
	com::sun::star::uno::Reference< com::sun::star::connection::XAcceptor >
	    m_xAcceptor2;
	State m_eState;
};

}

#endif // _UCB_MAIN_PLUGINACCEPTTHREAD_HXX_
