/*************************************************************************
 *
 *  $RCSfile: rapofflinecontent.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:58:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINECONTENT_HXX
#include "rapofflinecontent.hxx"
#endif

#ifndef INCLUDED_UCB_RAPOFFLINECOMMANDINFO_HXX
#include "rapofflinecommandinfo.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINECONTENTTYPEDATA_HXX
#include "rapofflinecontenttypedata.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINEDYNAMICRESULTSET_HXX
#include "rapofflinedynamicresultset.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINEINTERACTIONREQUEST_HXX
#include "rapofflineinteractionrequest.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINEPROPERTYVALUESET_HXX
#include "rapofflinepropertyvalueset.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINERESULTSETDATASUPPLIER_HXX
#include "rapofflineresultsetdatasupplier.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINESTORAGE_HXX
#include "rapofflinestorage.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINESTORAGEERROR_HXX
#include "rapofflinestorageerror.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINESTORAGENODE_HXX
#include "rapofflinestoragenode.hxx"
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTY_HPP_
#include "com/sun/star/beans/Property.hpp"
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include "com/sun/star/beans/PropertyValue.hpp"
#endif
#ifndef _COM_SUN_STAR_LANG_NOSUPPORTEXCEPTION_HPP_
#include "com/sun/star/lang/NoSupportException.hpp"
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASINK_HPP_
#include "com/sun/star/io/XActiveDataSink.hpp"
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASTREAMER_HPP_
#include "com/sun/star/io/XActiveDataStreamer.hpp"
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include "com/sun/star/io/XOutputStream.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_INSERTCOMMANDARGUMENT_HPP_
#include "com/sun/star/ucb/InsertCommandArgument.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVEBADTRANSFERURLEXCEPTION_HPP_
#include "com/sun/star/ucb/InteractiveBadTransferURLException.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_OPENCOMMANDARGUMENT2_HPP_
#include "com/sun/star/ucb/OpenCommandArgument2.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_OPENMODE_HPP_
#include "com/sun/star/ucb/OpenMode.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_TRANSFERINFO_HPP_
#include "com/sun/star/ucb/TransferInfo.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_XINTERFACE_HPP_
#include "com/sun/star/uno/XInterface.hpp"
#endif
#ifndef _COM_SUN_STAR_UTIL_DATETIME_HPP_
#include "com/sun/star/util/DateTime.hpp"
#endif
#ifndef _CPPUHELPER_QUERYINTERFACE_HXX_
#include "cppuhelper/queryinterface.hxx"
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include "cppuhelper/typeprovider.hxx"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include "osl/diagnose.h"
#endif
#ifndef _OSL_INTERLOCK_H_
#include "osl/interlck.h"
#endif
#ifndef _OSL_MUTEX_HXX_
#include "osl/mutex.hxx"
#endif
#ifndef _OSL_TIME_H_
#include "osl/time.h"
#endif
#ifndef _RTL_REF_HXX_
#include "rtl/ref.hxx"
#endif
#ifndef _RTL_URI_HXX_
#include "rtl/uri.hxx"
#endif
#ifndef _RTL_USTRING_HXX_
#include "rtl/ustring.hxx"
#endif
#ifndef _UCBHELPER_CONTENTIDENTIFIER_HXX_
#include "ucbhelper/contentidentifier.hxx"
#endif

#ifndef INCLUDED_MEMORY
#include <memory>
#define INCLUDED_MEMORY
#endif

using namespace com::sun;
using ucprmt::offline::CommandInfo;
using ucprmt::offline::CommandMap;
using ucprmt::offline::CommandProcessor;
using ucprmt::offline::Content;
using ucprmt::offline::ContentContainer;
using ucprmt::offline::ContentTypeData;
using ucprmt::offline::createPropertyValueSet;
using ucprmt::offline::DynamicResultSet;
using ucprmt::offline::handleInteractionRequest;
using ucprmt::offline::ResultSetDataSupplier;
using ucprmt::offline::Storage;
using ucprmt::offline::StorageError;
using ucprmt::offline::StorageNode;

namespace {

//TODO! generalize
rtl::OUString makeId(rtl::OUString const & rParent,
                     rtl::OUString const & rTitle)
{
    rtl::OUString aId;
    if (rParent.getLength() > 0 && rTitle.getLength() > 0)
    {
        aId = rParent;
        if (aId.getStr()[aId.getLength() - 1] != '/')
            aId += rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("/"));
        aId += rtl::Uri::encode(rTitle,
                                rtl_UriCharClassPchar,
                                rtl_UriEncodeIgnoreEscapes,
                                RTL_TEXTENCODING_UTF8);
    }
    return aId;
}

//TODO! generalize
rtl::OUString normalizeId(rtl::OUString const & rId)
{
    return rId.getLength() == 0
           || rId.getStr()[rId.getLength() - 1] != '/'
           || rId.equalsIgnoreAsciiCase(
                      rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("file://")))
           || rId.equalsIgnoreAsciiCase(
                      rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                        "vnd.sun.star.wfs://"))) ?
                  rId : rId.copy(0, rId.getLength() - 1);
        //TODO! more things need to be normalized
}

void pump(star::uno::Reference< star::io::XInputStream > const & rInput,
          star::uno::Reference< star::io::XOutputStream > const & rOutput)
    SAL_THROW((star::io::IOException, star::uno::RuntimeException))
{
    OSL_ASSERT(rInput.is());
    OSL_ASSERT(rOutput.is());
    for (sal_Int32 const nSize = 32768;;)
    {
        star::uno::Sequence< sal_Int8 > aData;
        sal_Int32 nRead = rInput->readBytes(aData, nSize);
        OSL_ASSERT(nRead >= 0 && nRead <= nSize);
        OSL_ASSERT(aData.getLength() == nRead);
        rOutput->writeBytes(aData);
        if (nRead != nSize)
        {
            rInput->closeInput();
            rOutput->closeOutput();
            break;
        }
    }
}

}

inline
Content::Content(rtl::Reference< ContentContainer > const & rContainer,
                 rtl::OUString const & rId,
                 rtl::Reference< StorageNode > const & rStorageNode):
    CommandProcessor(*this, this),
    m_xContainer(rContainer),
    m_nRefCount(0),
    m_aId(rId),
    m_xStorageNode(rStorageNode)
{
    OSL_ASSERT(m_xContainer.is());
    OSL_ASSERT(m_xStorageNode.is());
}

inline Content::~Content() SAL_THROW(())
{}

inline Content::operator star::uno::Reference< star::uno::XInterface >()
    SAL_THROW(())
{
    return static_cast< star::lang::XTypeProvider * >(this);
        // this has to be the same line of derivation as in queryInterface()
}

void
Content::checkUninserted(
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    if (m_xStorageNode->isUninserted())
        handleInteractionRequest(
            star::uno::makeAny(
                star::ucb::CommandAbortedException(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM(
                            "ucprmt::offline::Content::checkUninserted():"
                                " uninserted")),
                    *this)),
            rEnvironment);
}

void
Content::checkDeleted(
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    if (!m_xStorageNode->isUninserted())
    {
        try
        {
            if (!m_xStorageNode->isDeleted())
                return;
        }
        catch (StorageError &)
        {
            handleInteractionRequest(
                star::uno::makeAny(
                    star::ucb::CommandAbortedException(
                        rtl::OUString(
                            RTL_CONSTASCII_USTRINGPARAM(
                                "ucprmt::offline::Content::checkDeleted():"
                                    " storage error")),
                        *this)),
                rEnvironment);
        }
        handleInteractionRequest(
            star::uno::makeAny(
                star::ucb::CommandAbortedException(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM(
                            "ucprmt::offline::Content::checkDeleted():"
                                " deleted")),
                    *this)),
            rEnvironment);
    }
}

star::uno::Reference< star::io::XStream >
Content::getStream(
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::RuntimeException))
{
    star::uno::Reference< star::io::XStream > xStream;
    try
    {
        xStream = m_xStorageNode->getStream();
    }
    catch (StorageError &)
    {
        OSL_ASSERT(false);
    }
    if (!xStream.is())
        handleInteractionRequest(
            star::uno::makeAny(
                star::ucb::CommandAbortedException(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM(
                            "ucprmt::offline::Content::getStream:"
                                " null xStream")),
                    *this)),
            rEnvironment);
    return xStream;
}

rtl::OUString Content::getParentId() SAL_THROW((StorageError))
{
    return m_xStorageNode->getCurrentParent();
}

void Content::addChildId(rtl::OUString const & rId)
{
    m_xStorageNode->addChild(rId);
}

void Content::removeChildId(rtl::OUString const & rId)
{
    m_xStorageNode->removeChild(rId);
}

void Content::insert(rtl::OUString const & rId)
{
    //TODO! mutex
    if (m_xStorageNode->isUninserted())
    {
        m_xContainer->m_xStorage->getNodes()->
                                      insert(m_xStorageNode, rId, true);
        m_aId = rId;
    }
    else
        ; //TODO!
}

void Content::rebind(rtl::OUString const & rId,
                     rtl::Reference< StorageNode > const & rNode)
{
    //TODO! mutex
    if (m_xStorageNode->isUninserted())
    {
        m_aId = rId;
        m_xStorageNode = rNode;
    }
    else
        ; //TODO!
}

void Content::reset(rtl::Reference< StorageNode > const & rNode)
{
    OSL_ASSERT(rNode.is());
    //TODO!
}

star::uno::Any SAL_CALL Content::queryInterface(star::uno::Type const & rType)
    throw (star::uno::RuntimeException)
{
    return cppu::queryInterface(
               rType,
               static_cast< star::uno::XInterface * >(
                   static_cast< star::lang::XTypeProvider * >(this)),
               static_cast< star::lang::XTypeProvider * >(this),
               static_cast< star::ucb::XContent * >(this),
               static_cast< star::lang::XComponent * >(this),
               static_cast< star::ucb::XCommandProcessor * >(this),
               static_cast< star::beans::XPropertiesChangeNotifier * >(this),
               static_cast< star::ucb::XContentCreator * >(this),
               static_cast< star::container::XChild * >(this));
}

void SAL_CALL Content::acquire() throw ()
{
    osl_incrementInterlockedCount(&m_nRefCount);
}

void SAL_CALL Content::release() throw ()
{
    if (osl_decrementInterlockedCount(&m_nRefCount) == 0)
    {
        m_xContainer->releaseElement(this);
        delete this;
    }
}

star::uno::Sequence< star::uno::Type > SAL_CALL Content::getTypes()
    throw (star::uno::RuntimeException)
{
    static cppu::OTypeCollection * pCollection = 0;
    if (!pCollection)
    {
        osl::MutexGuard aGuard(osl::Mutex::getGlobalMutex());
        if (!pCollection)
        {
            static cppu::OTypeCollection
                aCollection(
                    getCppuType(
                        static_cast<
                            star::uno::Reference<
                                star::lang::XTypeProvider > const * >(0)),
                    getCppuType(
                        static_cast<
                            star::uno::Reference<
                                star::ucb::XContent > const * >(0)),
                    getCppuType(
                        static_cast<
                            star::uno::Reference<
                                star::lang::XComponent > const * >(0)),
                    getCppuType(
                        static_cast<
                            star::uno::Reference<
                                star::ucb::XCommandProcessor > const * >(0)),
                    getCppuType(
                        static_cast<
                            star::uno::Reference<
                       star::beans::XPropertiesChangeNotifier > const * >(0)),
                    getCppuType(
                        static_cast<
                            star::uno::Reference<
                                star::ucb::XContentCreator > const * >(0)),
                    getCppuType(
                        static_cast<
                            star::uno::Reference<
                                star::container::XChild > const * >(0)));
            pCollection = &aCollection;
        }
    }
    return pCollection->getTypes();
}

star::uno::Sequence< sal_Int8 > SAL_CALL Content::getImplementationId()
    throw (star::uno::RuntimeException)
{
    static cppu::OImplementationId const * pId = 0;
    if (!pId)
    {
        osl::MutexGuard aGuard(osl::Mutex::getGlobalMutex());
        if (!pId)
        {
            static cppu::OImplementationId const aId(false);
            pId = &aId;
        }
    }
    return pId->getImplementationId();
}

star::uno::Reference< star::ucb::XContentIdentifier > SAL_CALL
Content::getIdentifier()
    throw (star::uno::RuntimeException)
{
    return new ucb::ContentIdentifier(m_aId);
}

rtl::OUString SAL_CALL Content::getContentType()
    throw (star::uno::RuntimeException)
{
    try
    {
        return m_xStorageNode->getContentType();
    }
    catch (StorageError &)
    {
        OSL_ASSERT(false);
        return rtl::OUString();
    }
}

void SAL_CALL
Content::addContentEventListener(
    star::uno::Reference< star::ucb::XContentEventListener > const &
        rListener)
    throw (star::uno::RuntimeException)
{
    //TODO!
}

void SAL_CALL
Content::removeContentEventListener(
    star::uno::Reference< star::ucb::XContentEventListener > const &
        rListener)
    throw (star::uno::RuntimeException)
{
    //TODO!
}

void SAL_CALL Content::dispose() throw (star::uno::RuntimeException)
{
    //TODO!
}

void SAL_CALL
Content::addEventListener(
    star::uno::Reference< star::lang::XEventListener > const & rListener)
    throw (star::uno::RuntimeException)
{
    //TODO!
}

void SAL_CALL
Content::removeEventListener(
    star::uno::Reference< star::lang::XEventListener > const & rListener)
    throw (star::uno::RuntimeException)
{
    //TODO!
}

void SAL_CALL
Content::addPropertiesChangeListener(
    star::uno::Sequence< rtl::OUString > const & rPropertyNames,
    star::uno::Reference< star::beans::XPropertiesChangeListener > const &
        rListener)
    throw (star::uno::RuntimeException)
{
    //TODO!
}

void SAL_CALL
Content::removePropertiesChangeListener(
    star::uno::Sequence< rtl::OUString > const & rPropertyNames,
    star::uno::Reference< star::beans::XPropertiesChangeListener > const &
        rListener)
    throw (star::uno::RuntimeException)
{
    //TODO!
}

star::uno::Sequence< star::ucb::ContentInfo > SAL_CALL
Content::queryCreatableContentsInfo()
    throw (star::uno::RuntimeException)
{
    rtl::OUString aContentType;
    try
    {
        aContentType = m_xStorageNode->getContentType();
    }
    catch (StorageError &)
    {
        OSL_ASSERT(false);
    }
    return m_xContainer->m_xContentTypeData->
                             getCreatableContentsInfo(aContentType);
}

star::uno::Reference< star::ucb::XContent > SAL_CALL
Content::createNewContent(star::ucb::ContentInfo const & rInfo)
    throw (star::uno::RuntimeException)
{
    if (m_xStorageNode->isUninserted())
        return 0;
    rtl::OUString aContentType;
    try
    {
        aContentType = m_xStorageNode->getContentType();
    }
    catch (StorageError &)
    {
        OSL_ASSERT(false);
    }
    if (aContentType.
            equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
                             "application/vnd.sun.staroffice.fsys-folder")))
    {
        bool bDocument;
        if (rInfo.Type.
                      equalsAsciiL(
                          RTL_CONSTASCII_STRINGPARAM(
                              "application/vnd.sun.staroffice.fsys-file")))
            bDocument = true;
        else if (rInfo.
                     Type.
                         equalsAsciiL(
                             RTL_CONSTASCII_STRINGPARAM(
                               "application/vnd.sun.staroffice.fsys-folder")))
            bDocument = false;
        else
            return 0;
        TimeValue aTimeValue;
        oslDateTime aOslDateTime;
        star::util::DateTime aDateTime;
        if (osl_getSystemTime(&aTimeValue)
            && osl_getDateTimeFromTimeValue(&aTimeValue, &aOslDateTime))
        {
            aDateTime.HundredthSeconds
                = static_cast< sal_Int16 >(aOslDateTime.NanoSeconds
                                               / 10000000);
            aDateTime.Seconds = aOslDateTime.Seconds;
            aDateTime.Minutes = aOslDateTime.Minutes;
            aDateTime.Hours = aOslDateTime.Hours;
            aDateTime.Day = aOslDateTime.Day;
            aDateTime.Month = aOslDateTime.Month;
            aDateTime.Year = aOslDateTime.Year;
        }
        return
            m_xContainer->
                createNewContent(star::uno::Sequence< rtl::OUString >(),
                                 m_aId,
                                 rInfo.Type,
                                 rtl::OUString(),
                                 aDateTime,
                                 !bDocument,
                                 bDocument,
                                 false);
    }
    return 0;
}

star::uno::Reference< star::uno::XInterface > SAL_CALL Content::getParent()
    throw (star::uno::RuntimeException)
{
    try
    {
        return m_xContainer->queryContent(getParentId());
    }
    catch (StorageError &)
    {
        OSL_ASSERT(false);
        return 0;
    }
}

void SAL_CALL
Content::setParent(star::uno::Reference< star::uno::XInterface > const &
                       rParent)
    throw (star::lang::NoSupportException, star::uno::RuntimeException)
{
    throw
        star::lang::NoSupportException(
            rtl::OUString(
                RTL_CONSTASCII_USTRINGPARAM(
                    "ucprmt::offline::Content::setParent(): not supported")),
            *this);
}

rtl::Reference< CommandMap > Content::getCommandMap()
{
    rtl::OUString aContentType;
    try
    {
        aContentType = m_xStorageNode->getContentType();
    }
    catch (StorageError &)
    {
        OSL_ASSERT(false);
    }
    return m_xContainer->m_xContentTypeData->getCommandMap(aContentType);
}

star::uno::Any
Content::executeGetCommandInfo(
    void * pContent,
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    OSL_ASSERT(pContent);
    return static_cast< Content * >(pContent)->
               executeGetCommandInfo(rArgument, rEnvironment);
}

star::uno::Any
Content::executeGetCommandInfo(
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    checkDeleted(rEnvironment);
    if (!(rArgument.getValueType() == getVoidCppuType()))
        handleInteractionRequest(
            star::uno::makeAny(
                star::lang::IllegalArgumentException(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM(
                            "ucprmt::offline::Content::executeGetCommandInfo:"
                                " not void")),
                    *this,
                    0)),
            rEnvironment);
    return star::uno::makeAny(star::uno::Reference< star::ucb::XCommandInfo >(
                                  new CommandInfo(getCommandMap())));
}

star::uno::Any
Content::executeGetPropertySetInfo(
    void * pContent,
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    OSL_ASSERT(pContent);
    return static_cast< Content * >(pContent)->
               executeGetPropertySetInfo(rArgument, rEnvironment);
}

star::uno::Any
Content::executeGetPropertySetInfo(
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    checkDeleted(rEnvironment);
    if (!(rArgument.getValueType() == getVoidCppuType()))
        handleInteractionRequest(
            star::uno::makeAny(
                star::lang::IllegalArgumentException(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM(
                        "ucprmt::offline::Content::executeGetPropertySetInfo:"
                                " not void")),
                    *this,
                    0)),
            rEnvironment);
    return star::uno::Any(); //TODO!
}

star::uno::Any
Content::executeGetPropertyValues(
    void * pContent,
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    OSL_ASSERT(pContent);
    return static_cast< Content * >(pContent)->
               executeGetPropertyValues(rArgument, rEnvironment);
}

star::uno::Any
Content::executeGetPropertyValues(
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    checkDeleted(rEnvironment);
    star::uno::Sequence< star::beans::Property > aArg;
    if (!(rArgument >>= aArg))
        handleInteractionRequest(
            star::uno::makeAny(
                star::lang::IllegalArgumentException(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM(
                         "ucprmt::offline::Content::executeGetPropertyValues:"
                                " not com::sun::star::uno::Sequence<"
                                " com::sun::star::beans::Property >")),
                    *this,
                    0)),
            rEnvironment);
    return
        star::uno::makeAny(star::uno::Reference< star::sdbc::XRow >(
                               createPropertyValueSet(m_xContainer->
                                                          m_xServiceFactory,
                                                      m_xStorageNode,
                                                      aArg)));
}

star::uno::Any
Content::executeSetPropertyValues(
    void * pContent,
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    OSL_ASSERT(pContent);
    return static_cast< Content * >(pContent)->
               executeSetPropertyValues(rArgument, rEnvironment);
}

star::uno::Any
Content::executeSetPropertyValues(
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    checkDeleted(rEnvironment);
    star::uno::Sequence< star::beans::PropertyValue > aArg;
    if (!(rArgument >>= aArg))
        handleInteractionRequest(
            star::uno::makeAny(
                star::lang::IllegalArgumentException(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM(
                         "ucprmt::offline::Content::executeSetPropertyValues:"
                                " not com::sun::star::uno::Sequence<"
                                " com::sun::star::beans::PropertyValue >")),
                    *this,
                    0)),
            rEnvironment);
    for (sal_Int32 i = 0; i < aArg.getLength(); ++i)
        if (aArg[i].Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("Title")))
        {
            rtl::OUString aTitle;
            if (!(aArg[i].Value >>= aTitle))
                handleInteractionRequest(
                    star::uno::makeAny(
                        star::lang::IllegalArgumentException(
                            rtl::OUString(
                                RTL_CONSTASCII_USTRINGPARAM(
                         "ucprmt::offline::Content::executeSetPropertyValues:"
                                        " Title property not rtl::OUString")),
                            *this,
                            0)),
                    rEnvironment);
            if (m_xStorageNode->isUninserted())
                m_xStorageNode->setTitle(aTitle);
            else
                ; //TODO!
        }
        else
            ; //TODO!
    return star::uno::Any();
}

star::uno::Any
Content::executeOpen(
    void * pContent,
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    OSL_ASSERT(pContent);
    return static_cast< Content * >(pContent)->executeOpen(rArgument,
                                                           rEnvironment);
}

star::uno::Any
Content::executeOpen(
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    checkUninserted(rEnvironment);
    checkDeleted(rEnvironment);
    star::ucb::OpenCommandArgument2 aArg;
    if (!(rArgument >>= aArg))
        handleInteractionRequest(
            star::uno::makeAny(
                star::lang::IllegalArgumentException(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM(
                            "ucprmt::offline::Content::executeOpen: not "
                                "com::sun::star::ucb::OpenComamndArgument2")),
                    *this,
                    0)),
            rEnvironment);

    switch (aArg.Mode)
    {
    case star::ucb::OpenMode::ALL:
    case star::ucb::OpenMode::FOLDERS:
    case star::ucb::OpenMode::DOCUMENTS:
        return star::uno::makeAny(
                   star::uno::Reference< star::ucb::XDynamicResultSet >(
                       new DynamicResultSet(m_xContainer->m_xServiceFactory,
                                            aArg,
                                            rEnvironment,
                                            new ResultSetDataSupplier(
                                                    m_xContainer->
                                                        m_xServiceFactory,
                                                    aArg.Mode,
                                                    aArg.Properties,
                                                    m_xStorageNode,
                                                    m_xContainer->m_xStorage,
                                                    m_xContainer))));
            //TODO! aArg.SortingInfo?

    case star::ucb::OpenMode::DOCUMENT:
    case star::ucb::OpenMode::DOCUMENT_SHARE_DENY_NONE:
    case star::ucb::OpenMode::DOCUMENT_SHARE_DENY_WRITE:
        {
            //TODO! differentiate among different modes

            star::uno::Reference< star::io::XActiveDataStreamer >
                xStreamer(aArg.Sink, star::uno::UNO_QUERY);
            if (xStreamer.is())
            {
                xStreamer->setStream(getStream(rEnvironment));
                return star::uno::Any();
            }

            star::uno::Reference< star::io::XActiveDataSink >
                xSink(aArg.Sink, star::uno::UNO_QUERY);
            if (xSink.is())
            {
                xSink->setInputStream(getStream(rEnvironment)->
                                          getInputStream());
                return star::uno::Any();
            }

            star::uno::Reference< star::io::XOutputStream >
                xOutput(aArg.Sink, star::uno::UNO_QUERY);
            if (xOutput.is())
            {
                star::uno::Reference< star::io::XInputStream >
                    xInput(getStream(rEnvironment)->getInputStream());
                if (!xInput.is())
                    handleInteractionRequest(
                        star::uno::makeAny(
                            star::ucb::CommandAbortedException(
                                rtl::OUString(
                                    RTL_CONSTASCII_USTRINGPARAM(
                                      "ucprmt::offline::Content::executeOpen:"
                                            " null xInput")),
                                *this)),
                        rEnvironment);
                try
                {
                    pump(xInput, xOutput);
                }
                catch (star::io::IOException & rException)
                {
                    handleInteractionRequest(star::uno::makeAny(rException),
                                             rEnvironment);
                }
                return star::uno::Any();
            }

            handleInteractionRequest(
                star::uno::makeAny(
                    star::lang::IllegalArgumentException(
                        rtl::OUString(
                            RTL_CONSTASCII_USTRINGPARAM(
                                "ucprmt::offline::Content::executeOpen: bad "
                           "com::sun::star::ucb::OpenComamndArgument2.Sink")),
                        *this,
                        0)),
                rEnvironment);
            return star::uno::Any();
        }

    default:
        handleInteractionRequest(
            star::uno::makeAny(
                star::ucb::CommandAbortedException(
                    rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                      "ucprmt::offline::Content::executeOpen:"
                                          " unknown Mode")),
                    *this)),
            rEnvironment);
        return star::uno::Any();
    }
}

star::uno::Any
Content::executeUpdate(
    void * pContent,
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    OSL_ASSERT(pContent);
    return static_cast< Content * >(pContent)->executeUpdate(rArgument,
                                                             rEnvironment);
}

star::uno::Any
Content::executeUpdate(
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    checkUninserted(rEnvironment);
    checkDeleted(rEnvironment);
    if (!(rArgument.getValueType()
              == getCppuType(
                     static_cast< star::ucb::OpenCommandArgument2 const * >(
                         0))))
        handleInteractionRequest(
            star::uno::makeAny(
                star::lang::IllegalArgumentException(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM(
                            "ucprmt::offline::Content::executeUpdate: not "
                                "com::sun::star::ucb::OpenComamndArgument2")),
                    *this,
                    0)),
            rEnvironment);
    return star::uno::Any();
}

star::uno::Any
Content::executeDelete(
    void * pContent,
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    OSL_ASSERT(pContent);
    return static_cast< Content * >(pContent)->executeDelete(rArgument,
                                                             rEnvironment);
}

star::uno::Any
Content::executeDelete(
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    checkUninserted(rEnvironment);
    checkDeleted(rEnvironment);
    if (!(rArgument.getValueType() == getBooleanCppuType()))
        handleInteractionRequest(
            star::uno::makeAny(
                star::lang::IllegalArgumentException(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM(
                            "ucprmt::offline::Content::executeDelete:"
                                " not sal_Bool")),
                    *this,
                    0)),
            rEnvironment);
    if (!m_xContainer->deleteContent(this))
        handleInteractionRequest(
            star::uno::makeAny(
                star::ucb::CommandAbortedException(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM(
                            "ucprmt::offline::Content::executeDelete:"
                                " cannot remove")),
                    *this)),
            rEnvironment);
    return star::uno::Any();
}

star::uno::Any
Content::executeInsert(
    void * pContent,
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    OSL_ASSERT(pContent);
    return static_cast< Content * >(pContent)->executeInsert(rArgument,
                                                             rEnvironment);
}

star::uno::Any
Content::executeInsert(
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    checkDeleted(rEnvironment);
    star::ucb::InsertCommandArgument aArg;
    if (!(rArgument >>= aArg))
        handleInteractionRequest(
            star::uno::makeAny(
                star::lang::IllegalArgumentException(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM(
                            "ucprmt::offline::Content::executeInsert: not "
                               "com::sun::star::ucb::InsertCommandArgument")),
                    *this,
                    0)),
            rEnvironment);
    if (m_xStorageNode->isUninserted())
    {
        rtl::OUString aId(makeId(m_xStorageNode->getCurrentParent(),
                                 m_xStorageNode->getCurrentTitle()));
        if (aId.getLength() == 0)
            handleInteractionRequest(
                star::uno::makeAny(
                    star::ucb::CommandAbortedException(
                        rtl::OUString(
                            RTL_CONSTASCII_USTRINGPARAM(
                                "ucprmt::offline::Content::executeInsert:"
                                    " cannot make ID")),
                        *this)),
                rEnvironment);
        if (!m_xContainer->
                 moveContent(this, aId, aArg.ReplaceExisting != false))
            handleInteractionRequest(
                star::uno::makeAny(
                    star::ucb::CommandAbortedException(
                        rtl::OUString(
                            RTL_CONSTASCII_USTRINGPARAM(
                                "ucprmt::offline::Content::executeInsert:"
                                    " cannot move content")),
                        *this)),
                rEnvironment);
    }
    if (aArg.Data.is())
    {
        star::uno::Reference< star::io::XStream >
            xStream(m_xStorageNode->getStream());
        star::uno::Reference< star::io::XOutputStream > xOutput;
        if (xStream.is())
            xOutput = xStream->getOutputStream();
        OSL_ASSERT(xOutput.is());
        if (xOutput.is())
            try
            {
                pump(aArg.Data, xOutput);
            }
            catch (star::io::IOException & rException)
            {
                handleInteractionRequest(star::uno::makeAny(rException),
                                         rEnvironment);
            }
    }
    return star::uno::Any();
}

star::uno::Any
Content::executeTransfer(
    void * pContent,
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    OSL_ASSERT(pContent);
    return static_cast< Content * >(pContent)->executeTransfer(rArgument,
                                                               rEnvironment);
}

star::uno::Any
Content::executeTransfer(
    star::uno::Any const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    SAL_THROW((star::uno::Exception))
{
    checkUninserted(rEnvironment);
    checkDeleted(rEnvironment);
    star::ucb::TransferInfo aArg;
    if (!(rArgument >>= aArg))
        handleInteractionRequest(
            star::uno::makeAny(
                star::lang::IllegalArgumentException(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM(
                            "ucprmt::offline::Content::executeTransfer:"
                                " not com::sun::star::ucb::TransferInfo")),
                    *this,
                    0)),
            rEnvironment);
    //TODO!
    handleInteractionRequest(
        star::uno::makeAny(
            star::ucb::InteractiveBadTransferURLException(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM(
                            "ucprmt::offline::Content::executeTransfer:"
                                " not supported")),
                    *this)),
        rEnvironment);
    return star::uno::Any();
}

ContentContainer::~ContentContainer() SAL_THROW(())
{}

void ContentContainer::releaseElement(Content * pElement) SAL_THROW(())
{
    OSL_ASSERT(pElement);
    osl::MutexGuard aGuard(m_aMutex);
    if (pElement->m_aContainerIt != m_aMap.end())
        m_aMap.erase(pElement->m_aContainerIt);
}

rtl::Reference< Content > ContentContainer::find(rtl::OUString const & rId)
    SAL_THROW((StorageError))
{
    if (rId.getLength() == 0)
        return 0;
    else
    {
        osl::MutexGuard aGuard(m_aMutex);
        Map::iterator aIt(m_aMap.find(rId));
        if (aIt != m_aMap.end())
        {
            if (osl_incrementInterlockedCount(&aIt->second->m_nRefCount) > 1)
            {
                rtl::Reference< Content > xElement(aIt->second);
                osl_decrementInterlockedCount(&aIt->second->m_nRefCount);
                return xElement;
            }
            osl_decrementInterlockedCount(&aIt->second->m_nRefCount);
            aIt->second->m_aContainerIt = m_aMap.end();
        }
        rtl::Reference< StorageNode >
            xStorageNode(m_xStorage->getNodes()->find(rId));
        if (!xStorageNode.is())
            return 0;
        std::auto_ptr< Content >
            xElement(new Content(this, rId, xStorageNode));
        aIt = m_aMap.insert(Map::value_type(rId, xElement.get())).first;
        aIt->second->m_aContainerIt = aIt;
        xElement.release();
        return aIt->second;
    }
}

bool ContentContainer::moveContent(rtl::Reference< Content > const & rContent,
                                   rtl::OUString const & rId,
                                   bool bReplaceExisting)
{
    OSL_ASSERT(rContent.is());
    //TODO! mutex!!!
    rtl::Reference< Content > xExisting(find(rId));
    if (xExisting.is())
        if (bReplaceExisting)
        {
            xExisting->reset(rContent->m_xStorageNode);
            rContent->rebind(rId, xExisting->m_xStorageNode);
            return true;
        }
        else
            return false;
    else
    {
        {
            osl::MutexGuard aGuard(m_aMutex);
            if (rContent->m_aContainerIt != m_aMap.end())
            {
                m_aMap.erase(rContent->m_aContainerIt);
                rContent->m_aContainerIt = m_aMap.end();
                    // in case the following insert() fails, though this
                    // recovery strategy is not very good...
            }
            rContent->m_aContainerIt
                = m_aMap.insert(Map::value_type(rId, rContent.get())).first;
        }
        rContent->insert(rId);
        rtl::Reference< Content >
            xParent(find(rContent->getParentId()));
        if (xParent.is())
            xParent->addChildId(rId);
            //TODO! notify INSERTED
        return true;
    }
}

bool
ContentContainer::deleteContent(rtl::Reference< Content > const & rContent)
{
    OSL_ASSERT(rContent.is());
    //TODO! mutex?
    rtl::OUString aId(rContent->m_aId);
    rtl::Reference< Content > xParent(find(rContent->getParentId()));
    if (!m_xStorage->getNodes()->remove(aId, true))
        return false;
    //TODO! notify DELETED
    if (xParent.is())
        xParent->removeChildId(aId);
        //TODO! notify REMOVED
    return true;
}

ContentContainer::ContentContainer(
    star::uno::Reference< star::lang::XMultiServiceFactory > const &
        rServiceFactory,
    rtl::Reference< Storage > const & rStorage,
    rtl::Reference< ContentTypeData > const & rContentTypeData):
    m_xServiceFactory(rServiceFactory),
    m_xStorage(rStorage),
    m_xContentTypeData(rContentTypeData)
{
    OSL_ASSERT(m_xStorage.is());
    OSL_ASSERT(m_xContentTypeData.is());
}

star::uno::Reference< star::ucb::XContent >
ContentContainer::queryContent(rtl::OUString const & rId)
    SAL_THROW((StorageError, star::uno::RuntimeException))
{
    return find(normalizeId(rId)).get();
}

star::uno::Reference< star::ucb::XContent >
ContentContainer::createNewContent(
    star::uno::Sequence< rtl::OUString > const & rChildren,
    rtl::OUString const & rParent,
    rtl::OUString const & rContentType,
    rtl::OUString const & rTitle,
    star::util::DateTime const & rDateCreated,
    bool bFolder,
    bool bDocument,
    bool bReadOnly)
    SAL_THROW((StorageError))
{
    Content * pElement
        = new Content(this,
                      rtl::OUString(),
                      m_xStorage->getNodes()->create(rChildren,
                                                     rParent,
                                                     rContentType,
                                                     rTitle,
                                                     rDateCreated,
                                                     bFolder,
                                                     bDocument,
                                                     bReadOnly));
    pElement->m_aContainerIt = m_aMap.end();
    return pElement;
}
