/*************************************************************************
 *
 *  $RCSfile: rapofflinedbadapter.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:58:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINEDBADAPTER_HXX
#include "rapofflinedbadapter.hxx"
#endif

#ifndef INCLUDED_UCB_RAPOFFLINESTORAGENODE_HXX
#include "rapofflinestoragenode.hxx"
#endif

#ifndef _COM_SUN_STAR_IO_XSTREAM_HPP_
#include "com/sun/star/io/XStream.hpp"
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include "com/sun/star/lang/XMultiServiceFactory.hpp"
#endif
#ifndef _COM_SUN_STAR_SYNC_CHANGES_HPP_
#include "com/sun/star/sync/Changes.hpp"
#endif
#ifndef _COM_SUN_STAR_SYNC_INDEXCONTAINABLE_HPP_
#include "com/sun/star/sync/IndexContainable.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include "com/sun/star/uno/Sequence.hxx"
#endif
#ifndef _RTL_USTRING_HXX_
#include "rtl/ustring.hxx"
#endif

using namespace com::sun;
using ucprmt::offline::DBAdapter;
using ucprmt::offline::StorageNodeContainer;

DBAdapter::DBAdapter(
    star::uno::Reference< star::lang::XMultiServiceFactory > const &
        rServiceFactory,
    rtl::Reference< StorageNodeContainer > const & rNodes):
    m_xServiceFactory(rServiceFactory),
    m_xNodes(rNodes)
{}

DBAdapter::~DBAdapter()
{}

sal_Bool SAL_CALL DBAdapter::dbaOpen(rtl::OUString const & rUserId)
    throw (star::uno::RuntimeException)
{
    //TODO! use rUserId
    return m_xNodes.is();
}

star::sync::IndexContainable SAL_CALL
DBAdapter::dbaGetEntry(rtl::OUString const & rId)
    throw (star::uno::RuntimeException)
{
    rtl::Reference< StorageNode > xNode;
    if (m_xNodes.is())
        xNode = m_xNodes->find(rId);
    if (!xNode.is())
        return star::sync::IndexContainable(); //TODO! better error reporting
    star::sync::IndexContainable aResult;
    aResult.Id = rId;
    aResult.Type = xNode->getContentType();
    aResult.Parent = xNode->getCurrentParent();
    aResult.Properties.realloc(7);
    aResult.Properties[0].Name
        = rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("ContentType"));
    aResult.Properties[0].Value <<= xNode->getContentType();
    aResult.Properties[1].Name
        = rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("IsFolder"));
    aResult.Properties[1].Value
        <<= static_cast< sal_Bool >(xNode->getFolder());
    aResult.Properties[2].Name
        = rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("IsDocument"));
    aResult.Properties[2].Value
        <<= static_cast< sal_Bool >(xNode->getDocument());
    aResult.Properties[3].Name
        = rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("Title"));
    aResult.Properties[3].Value <<= xNode->getCurrentTitle();
    aResult.Properties[4].Name
        = rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("DateCreated"));
    aResult.Properties[4].Value <<= xNode->getDateCreated();
    aResult.Properties[5].Name
        = rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("DateModified"));
    aResult.Properties[5].Value <<= xNode->getDateModified();
    aResult.Properties[6].Name
        = rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("IsReadOnly"));
    aResult.Properties[6].Value
        <<= static_cast< sal_Bool >(xNode->getReadOnly());
    star::uno::Reference< star::io::XStream > xStream(xNode->getStream());
        //TODO! but don't create one
    if (xStream.is())
        aResult.Stream = xStream->getInputStream();
    aResult.Children = xNode->getCurrentChildren();
    return aResult;
}

void SAL_CALL
DBAdapter::dbaAddEntry(star::sync::IndexContainable const & rContainable)
    throw (star::uno::RuntimeException)
{
    //TODO!
}

void SAL_CALL
DBAdapter::dbaUpdateEntry(star::sync::IndexContainable const & rContainable)
    throw (star::uno::RuntimeException)
{
    //TODO!
}

void SAL_CALL DBAdapter::dbaDeleteEntry(rtl::OUString const & rId)
    throw (star::uno::RuntimeException)
{
    //TODO!
}

void SAL_CALL DBAdapter::dbaClose() throw (star::uno::RuntimeException)
{}

star::uno::Sequence< star::sync::Changes > SAL_CALL DBAdapter::dbaGetChanged()
    throw (star::uno::RuntimeException)
{
    star::uno::Sequence< star::sync::Changes > aResult;
    if (m_xNodes.is())
        for (StorageNodeContainerIterator aIt(m_xNodes); !aIt.empty(); ++aIt)
        {
            StorageNode & rNode = *aIt->second;
            if (rNode.isModified())
            {
                aResult.realloc(aResult.getLength() + 1);
                star::sync::Changes & rChanges
                    = aResult[aResult.getLength() - 1];
                rChanges.OldIdentifier = rNode.getOriginalUrl();
                rChanges.NewIdentifier = aIt->first;
                rChanges.OldParent = rNode.getOriginalParent();
                rChanges.NewParent = rNode.getCurrentParent();
                rChanges.OldType = rNode.getContentType();
                rChanges.NewType = rChanges.OldType;
                rChanges.OldChildren = rNode.getOriginalChildren();
                rChanges.NewChildren = rNode.getCurrentChildren();
//TODO!         rChanges.PropertyChanged = ...;
                rChanges.StreamChanged = rNode.isStreamModified();
                //TODO! ContentDeleted is always false---is that field
                // necessary?
            }
        }
    return aResult;
}

star::uno::Sequence< rtl::OUString > SAL_CALL DBAdapter::dbaGetAdded()
    throw (star::uno::RuntimeException)
{
    star::uno::Sequence< rtl::OUString > aResult;
    if (m_xNodes.is())
        for (StorageNodeContainerIterator aIt(m_xNodes); !aIt.empty(); ++aIt)
            if (aIt->second->isInserted())
            {
                aResult.realloc(aResult.getLength() + 1);
                aResult[aResult.getLength() - 1] = aIt->first;
            }
    return aResult;
}

star::uno::Sequence< rtl::OUString > SAL_CALL DBAdapter::dbaGetDeleted()
    throw (star::uno::RuntimeException)
{
    star::uno::Sequence< rtl::OUString > aResult;
    if (m_xNodes.is())
        for (StorageNodeContainerIterator aIt(m_xNodes); !aIt.empty(); ++aIt)
            if (aIt->second->isDeleted())
            {
                aResult.realloc(aResult.getLength() + 1);
                aResult[aResult.getLength() - 1] = aIt->first;
            }
    return aResult;
}
