/*************************************************************************
 *
 *  $RCSfile: VectorBtreeIterator.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:02:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.db;

public final class VectorBtreeIterator {
  private VectorBtree _btree;
  private int         _VECLEN;
  private byte[]      _vector;
  private byte[]      _highPrefix;
  private byte[]      _buffer;
  private int         _next;	// index within buffer
  private int         _prefLen;
  private int         _commLen;
  private BlockStack  _stack = new BlockStack();

  public VectorBtreeIterator(VectorBtree bt, byte[] result) {
    _btree = bt;
    _VECLEN = bt.getVectorLength();
    _vector = result;
    _highPrefix = new byte[_VECLEN];
    _buffer = new byte[bt.getIteratorBufferLength()];
  }
  
  public byte[] first(byte[] prefix, int prefLen) throws Exception {
    return init(prefix, prefix, prefLen) ? next() : null;
  }
  
  public byte[] next() throws Exception {
    if ((_buffer[_next]&0xFF) >= _commLen) {
      System.arraycopy(_buffer, _next + 1, _vector, _buffer[_next]&0xFF,
		       _VECLEN - (_buffer[_next]&0xFF));
      _next += _VECLEN + 1 - (_buffer[_next]&0xFF);
      return _vector;
    }
    else if (_stack.size() > 0) {
      _btree.FindVectors2(_vector, _highPrefix, _commLen, _prefLen,
			  _buffer, _stack);
      _next = 0;
      return next();
    }
    else
      return null;
  }
  
  private boolean init(byte[] lPrefix, byte[] hPrefix, int prefLen)
    throws Exception {
      for (_commLen = 0; _commLen < prefLen; _commLen++)
	if (lPrefix[_commLen] != hPrefix[_commLen])
	  break;
      if (_btree.FindVectors1(lPrefix, hPrefix, _commLen, _prefLen = prefLen,
			      _buffer, _stack))
	{
	  System.arraycopy(hPrefix, 0, _highPrefix, 0, _VECLEN);
	  System.arraycopy(lPrefix, 0, _vector, 0, _VECLEN);
	  _next = 0;
	  return true;
	}
      else
	return false;
  }
}
