/*************************************************************************
 *
 *  $RCSfile: XmlTreeNodeImpl.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.tree;

import javax.swing.tree.TreeNode;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.Name;
import java.util.Enumeration;
import java.util.Vector;
import java.util.Hashtable;

public class XmlTreeNodeImpl implements XmlTreeNode, java.io.Serializable {
    private static Hashtable TreeNodes = new Hashtable();
    private final Node2 _node;

    public static void clear() {
	TreeNodes.clear();
    }

    private XmlTreeNodeImpl(Node2 node) {
	_node = node;
    }

    /** from Node to XmlTreeNode */
    public static XmlTreeNode makeNode(Node node) {
	XmlTreeNode built = (XmlTreeNode)TreeNodes.get(node);
	if (built == null)
	    TreeNodes.put(node, built = new XmlTreeNodeImpl((Node2) node));
	return built;
    }

    public Node2 getRepresentation() {
	return _node;
    }

    public TreeNode getParent() {
	Node parent = _node.getParent();
	return parent != null ? makeNode(parent) : null;
    }

    public final Name getName() {
	return _node.getName();
    }

    public final String toString() {
	return _node.toString();
    }

    public final boolean isLeaf() { return _node.isLeaf(); }
    public final int getChildCount() { return _node.getChildCount(); }
    public final TreeNode getChildAt(int n) { return _node.getChildAt(n); }
    public final Enumeration children() { return _node.children(); }
    public final int getIndex(TreeNode node) { return -1; }
    public final void getSubelementsByTagName(Name name, Vector result) {
	_node.getSubelementsByTagName(name, result);
    }
    public final boolean getAllowsChildren() {
	return _node.getAllowsChildren();
    }

    public final int getNodeType() {
	switch (_node.getNodeType()) {
	case Node.ELEMENT: return XmlTreeNode.ELEMENT;
	case Node.TEXT:    return XmlTreeNode.TEXT_NODE;
	default:           return XmlTreeNode.UNKNOWN;
	}
    }
}
