/*************************************************************************
 *
 *  $RCSfile: accessor.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:17:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_ACCESSOR_HXX
#define CONFIGMGR_ACCESSOR_HXX

#ifndef CONFIGMGR_POINTER_HXX
#include "pointer.hxx"
#endif

#ifndef _OSL_INTERLOCK_H_
#include <osl/interlck.h>
#endif
namespace configmgr
{
// -----------------------------------------------------------------------------
    namespace memory
    {
    // -------------------------------------------------------------------------
        class Segment;
    // -------------------------------------------------------------------------
        /// class mediating read-only access to a data::Segment
        class Accessor
        {
            struct Impl
            {
                Impl(Segment const * segment);
                Impl(Segment const * segment, void const * base);

                ~Impl();

                bool is() const { return m_segment != NULL; }

                Segment const * m_segment;
                char    const * m_base;
                oslInterlockedCount m_refs;
            private:
                // disallow copying
                Impl(Impl&);
                void operator=(Impl&);
            };
                
            // need not be interlocked: Accessor objects must not cross thread boundaries
            void acquireImpl() const { ++m_impl->m_refs; }
            void releaseImpl() const { if (--m_impl->m_refs == 0) delete m_impl; }

            Impl * m_impl;
        public:
            /// type of addresses used in the Segment
            typedef Pointer AddressType;

            /// constructs an accessor on the given Segment
            explicit Accessor(Segment const * _pSegment) : m_impl(new Impl(_pSegment)) {}

            /// Copies an Accessor
            Accessor(Accessor const& _aOther); 
            Accessor& operator=(Accessor const& _aOther);

            ~Accessor() { releaseImpl(); }
            
            void swap(Accessor & _rOther);

            bool is() const { return m_impl->is(); }
            void clear();

            AddressType address(void const * _p) const
            { return (this->is()) ? reduce(_p) : Pointer();}

            void const * access(AddressType _p) const
            { return (this->is()) ? resolve(_p) : failNull();}

            void const * validate(AddressType _p) const
            { return (this->is() && _p.is()) ? resolve(_p) : failNull(); }

        private:
            char    const * base_()    const { return m_impl->m_base; }
            Segment const * segment_() const { return m_impl->m_segment; }

            void const * resolve(AddressType _p) const;
            AddressType  reduce(void const * _p) const;

            friend class UpdateAccessor;
            Accessor(Segment * _s, void const * _b, __sal_NoAcquire) : m_impl(new Impl(_s,_b)) {}
            static void * failNull();
        };

    // -------------------------------------------------------------------------

  #if OSL_DEBUG_LEVEL == 0
        inline 
        void const * Accessor::resolve(AddressType _p) const 
        { return _p.is() ? this->base_() + _p.value() : NULL; }

        inline 
        Pointer  Accessor::reduce(void const * _p) const 
        { return _p ? Pointer(static_cast<char const *>(_p) - this->base_()) : Pointer(); }
  #endif // OSL_DEBUG_LEVEL

    // -------------------------------------------------------------------------
    }
// -----------------------------------------------------------------------------
} // namespace configmgr

#endif // CONFIGMGR_ACCESSOR_HXX

