/*************************************************************************
 *
 *  $RCSfile: treeaddress.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jb $ $Date: 2002/03/28 08:47:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_TREEADDRESS_HXX
#define CONFIGMGR_TREEADDRESS_HXX

#ifndef CONFIGMGR_POINTER_HXX
#include "pointer.hxx"
#endif

#ifndef INCLUDED_SHARABLE_TREEFRAGMENT_HXX
#include "treefragment.hxx"
#endif


namespace configmgr
{
// -----------------------------------------------------------------------------	
    class INode;
// -----------------------------------------------------------------------------	
    namespace data
    {
    // -------------------------------------------------------------------------	
        class TreeAddress
	    {
            friend class TreeAccessor;
        public:
            typedef sharable::TreeFragment  DataType;
            typedef memory::Pointer         AddressType;
        public:
            TreeAddress() : m_pData() {}

            explicit
            TreeAddress(AddressType _aNodeData) : m_pData(_aNodeData) {}

            bool is()       const { return m_pData.is(); }
            bool isNull()   const { return m_pData.isNull(); }

            AddressType::RawAddress addressValue() const { return m_pData.value(); }

            friend bool operator == (TreeAddress const& lhs, TreeAddress const& rhs)
            { return lhs.m_pData == rhs.m_pData; }

            friend bool operator != (TreeAddress const& lhs, TreeAddress const& rhs)
            { return lhs.m_pData != rhs.m_pData; }

        private:
		    AddressType m_pData;
        };
    // -------------------------------------------------------------------------
    }
// -----------------------------------------------------------------------------	
} // namespace configmgr

#endif // CONFIGMGR_TREEADDRESS_HXX

