/*************************************************************************
 *
 *  $RCSfile: propertyhelper.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/19 17:52:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBA_CORE_PROPERTYHELPER_HXX_
#include "propertyhelper.hxx"
#endif
#ifndef _COMPHELPER_PROPERTY_HXX_
#include <comphelper/property.hxx>
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#include <algorithm>

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::comphelper;

//--------------------------------------------------------------------------
void mergePropertySequencesByName( Sequence< Property >& _rDestAndSource1, const Sequence< Property >& _rSource2)
{
	sal_Int32 i=0;
	sal_Int32 nSeqLen1 = _rDestAndSource1.getLength();
	sal_Int32 nSeqLen2 = _rSource2.getLength();
	// ensure that the sequences are sorted
	Property* pProps = _rDestAndSource1.getArray();
	Property* pCompare = nSeqLen1 ? pProps + 1 : NULL;
	for (i=1; i<nSeqLen1; ++i, ++pCompare, ++pProps)
	{
		if (pProps->Name > pCompare->Name)
		{
			OSL_ENSURE(sal_False,  "mergePropertySequencesByName : the first sequence is not sorted" );
			Property* pDest = _rDestAndSource1.getArray();
			::std::sort( pDest, pDest + nSeqLen1,  PropertyCompareByName() );
			break;
		}
	}
	// ...
	pProps = const_cast< Sequence< Property >& >(_rSource2).getArray();
	pCompare = nSeqLen2 ? pProps + 1 : NULL;
	for (i=1; i<nSeqLen2; ++i, ++pCompare, ++pProps)
	{
		if (pProps->Name > pCompare->Name)
		{
			OSL_ENSURE(sal_False,  "mergePropertySequencesByName : the first sequence is not sorted" );
			Property* pDest = const_cast< Sequence< Property >& >(_rSource2).getArray();
			::std::sort( pDest, pDest + nSeqLen2,  PropertyCompareByName() );
			break;
		}
	}

	// now merge them
	_rDestAndSource1.realloc(nSeqLen1 + nSeqLen2);

	// (merge sort)
	pProps = _rDestAndSource1.getArray() + nSeqLen1 + nSeqLen2 - 1;
	const Property* pSource1Props = _rDestAndSource1.getConstArray() + nSeqLen1 - 1;
	const Property* pSource2Props = _rSource2.getConstArray() + nSeqLen2 - 1;
	sal_Int32 nSource1Left = nSeqLen1;
	sal_Int32 nSource2Left = nSeqLen2;
	while (pProps > pSource1Props)
	{
		if ((nSource2Left != 0) && ((nSource1Left == 0) || (pSource2Props->Name > pSource1Props->Name)))
		{
			*pProps = *pSource2Props;
			--pProps;
			--pSource2Props;
			--nSource2Left;
		}
		else
		{
			*pProps = *pSource1Props;
			--pProps;
			--pSource1Props;
			--nSource1Left;
		}
	}

#ifdef DBG_UTIL
	// check the uniqueness of the handles
	pProps = _rDestAndSource1.getArray();
	for (sal_Int32 nA = 1; nA < _rDestAndSource1.getLength(); ++nA, ++pProps)
	{
		pCompare = pProps + 1;
		for (sal_Int32 nB = nA + 1; nB < _rDestAndSource1.getLength(); ++nB, ++pCompare)
			OSL_ENSURE(pProps->Handle != pCompare->Handle, "mergePropertySequencesByName : the dervied class uses some handles which are mine !");
	}
#endif
}




