/*************************************************************************
 *
 *  $RCSfile: regcnt.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <content.hxx>
#include <usr/services.hxx>
#include <usr/reflserv.hxx>
#include <usr/factoryhlp.hxx>

#ifdef _USE_NAMESPACE
using namespace vos;
using namespace usr;
#endif

extern "C" BOOL EXTERN_SERVICE_CALLTYPE exService_writeRegEntry(
	const UNO_INTERFACE( XRegistryKey )* xUnoKey )
{
	XRegistryKeyRef xKey;
	XRegistryKeyRef xCreateKey;
	uno2smart( xKey, *xUnoKey );

	xKey->createKey( L"/com.sun.star.address.AddressBookRootContent.V10/UNO/SERVICES/com.sun.star.address.AddressBookRootContent" );
	xKey->createKey( L"/com.sun.star.address.AddressBookSourceContent.V10/UNO/SERVICES/com.sun.star.address.AddressBookSourceContent" );
	xKey->createKey(L"/com.sun.star.address.ResourceInternationalizer.V10/UNO/SERVICES/com.sun.star.address.ResourceInternationalizer"); // Impl Name
	xKey->createKey(L"/com.sun.star.address.IdentityInternationalizer.V10/UNO/SERVICES/com.sun.star.address.IdentityInternationalizer"); // Impl Name

	return TRUE;
}


extern "C" UNO_INTERFACE(XInterface) EXTERN_SERVICE_CALLTYPE exService_getFactory
(
	const sal_Unicode* implementationName,
	const UNO_INTERFACE(XMultiServiceFactory)* xUnoFact,
	const UNO_INTERFACE(XRegistryKey)* xUnoKey )
{
	UString implName( implementationName );
	XMultiServiceFactoryRef xMan;
	XRegistryKeyRef xKey;
	uno2smart( xMan, *xUnoFact );
	uno2smart( xKey, *xUnoKey );
	
	XInterfaceRef 			xRet;

	if( 0 );
	else if (implName == L"com.sun.star.address.IdentityInternationalizer.V10")
	{
		Sequence<UString> aServices(1);
		aServices.getArray()[ 0 ] = 
			L"com.sun.star.address.IdentityInternationalizer";
		xRet = createOneInstanceFactory( 
			xMan, implementationName,
			OIdentityInternationalizer::create, aServices );
	}
	else if (implName == L"com.sun.star.address.ResourceInternationalizer.V10")
	{
		Sequence<UString> aServices(1);
		aServices.getArray()[ 0 ] = 
			L"com.sun.star.address.ResourceInternationalizer";
		xRet = createOneInstanceFactory( 
			xMan, implementationName,
			OResourceInternationalizer::create, aServices );
	}
	else if (implName == L"com.sun.star.address.AddressBookRootContent.V10")
	{
		Sequence<UString> aServices(1);
		aServices.getArray()[ 0 ] = 
			L"com.sun.star.address.AddressBookRootContent";
		xRet = createSingleFactory( 
			xMan, implementationName,
			OContentRoot::createInstance, aServices );
	}
	else if (implName == L"com.sun.star.address.AddressBookSourceContent.V10")
	{
		Sequence<UString> aServices(1);
		aServices.getArray()[ 0 ] = 
			L"com.sun.star.address.AddressBookSourceContent";
		xRet = createSingleFactory( 
			xMan, implementationName,
			OContentSource::createInstance, aServices );
	}
	UNO_INTERFACE(XInterface) xUnoRet = {0, 0};
	if( xRet.is() ) smart2uno( xRet, xUnoRet );
	return xUnoRet;
}

extern "C" void __LOADONCALLAPI initialize()
{
}

