/*************************************************************************
 *
 *  $RCSfile: fielddsc.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _ADR_FIELDDSC_HXX
#define _ADR_FIELDDSC_HXX

#ifndef _USR_USTRING_HXX
#include <usr/ustring.hxx>
#endif

#ifndef _SV_TABPAGE_HXX //autogen
#include <sv/tabpage.hxx>
#endif

#ifndef _SMART_COM_SUN_STAR_ADDRESS_CANCELLEDEXCEPTION_HXX_
#include <smart/com/sun/star/address/CancelledException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKSOURCEDEFINITION_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookSourceDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPFIELDMAPPING_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPFieldMapping.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDPROPERTYVALUE_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredPropertyValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDVALUE_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPROPERTYPARAMETERINFO_HXX_
#include <smart/com/sun/star/address/AddressBookPropertyParameterInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XSYNCHRONJOB_HXX_
#include <smart/com/sun/star/address/XSynchronJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_JOBEVENTTYPE_HXX_
#include <smart/com/sun/star/address/JobEventType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKQUERYFUNCTION_HXX_
#include <smart/com/sun/star/address/AddressBookQueryFunction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKSCHEMATASUPPLIER_HXX_
#include <smart/com/sun/star/address/XAddressBookSchemataSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKTABLEDEFINITION_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookTableDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOB_HXX_
#include <smart/com/sun/star/address/XJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKQUERYPARSER_HXX_
#include <smart/com/sun/star/address/XAddressBookQueryParser.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCESIMPLEDATABASEFIELDMAPPING_HXX_
#include <smart/com/sun/star/address/AddressBookSourceSimpleDatabaseFieldMapping.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPSCHEMADEFINITION_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPSchemaDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKJOBFACTORYSUPPLIER_HXX_
#include <smart/com/sun/star/address/XAddressBookJobFactorySupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOBLISTENER_HXX_
#include <smart/com/sun/star/address/XJobListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKRECORDCONTAINER_HXX_
#include <smart/com/sun/star/address/XAddressBookRecordContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKTABLEFIELD_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookTableField.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKQUERYWRITER_HXX_
#include <smart/com/sun/star/address/XAddressBookQueryWriter.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_JOBEVENT_HXX_
#include <smart/com/sun/star/address/JobEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XASYNCHRONJOB_HXX_
#include <smart/com/sun/star/address/XAsynchronJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDPROPERTY_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredProperty.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCESIMPLEDATABASESCHEMADEFINITION_HXX_
#include <smart/com/sun/star/address/AddressBookSourceSimpleDatabaseSchemaDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKQUERYTERM_HXX_
#include <smart/com/sun/star/address/AddressBookQueryTerm.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSORTINFO_HXX_
#include <smart/com/sun/star/address/AddressBookSortInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_CANTCONNECTEXCEPTION_HXX_
#include <smart/com/sun/star/address/CantConnectException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPSCOPE_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPScope.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKRESULTSETDESCRIPTORFACTORY_HXX_
#include <smart/com/sun/star/address/XAddressBookResultSetDescriptorFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOBFACTORY_HXX_
#include <smart/com/sun/star/address/XJobFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_MERGECONFLICTEXCEPTION_HXX_
#include <smart/com/sun/star/registry/MergeConflictException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HXX_
#include <smart/com/sun/star/registry/XSimpleRegistry.hxx>
#endif

#ifndef _SVARRAY_HXX
#include <svtools/svarray.hxx>
#endif


#ifndef _SV_EDIT_HXX
#include <vcl/edit.hxx>
#endif

#ifndef _ADR_DATMAN_HXX
#include "datman.hxx"
#endif

class AdrFieldDescription
{
private:

	Edit*						pField;
	Window*						pTitle;
	AdrDataManagerHdl			ppDatMan;		
	UString						aClassName;
	Sequence<UString>			seqParas;
	INT32						nNo;
	BOOL						bRefreshed;
	AddressBookParameteredValue aValue;
	BOOL						bModified;
	
	DECL_LINK( ModifyHdl, Edit* );
		
public:
								AdrFieldDescription();
								
								AdrFieldDescription(Edit* pF,AdrDataManagerHdl pDM, 
												const UString& aCName,const Sequence<UString>& seqPa);
								
								AdrFieldDescription(AdrDataManagerHdl pDM,const UString& aCName,
												const Sequence<UString>& seqPa);
								
	void						Initilize(Edit* pF,AdrDataManagerHdl pDM, const UString& aCName,
												const Sequence<UString>& seqPa);
								
	void						Initilize(AdrDataManagerHdl pDM,const UString& aCName,const Sequence<UString>& seqPa);
								
	void						SetField(Edit* pF);
	Window*						GetField();
	void						SetTitleWin(Window*	pTitleWin){pTitle=pTitleWin;}
	Window*						GetTitleWin() {return pTitle;}

	BOOL						IsConnected();
	virtual void				UpdateData();
	virtual void				RefreshField();
	virtual void				SaveField();
								
	INT32						GetNumber() { return nNo;}
	void						SetNumber(INT32	n) { nNo = n;}
								
	UString&					ClassName(){ return aClassName;}
	Sequence<UString>*			GetParaList(){ return &seqParas;}
};

typedef AdrFieldDescription* AdrFieldDescriptionPtr;
SV_DECL_PTRARR( AdrFieldDescList, AdrFieldDescriptionPtr, 8, 1 );

class AdrFieldList : protected AdrFieldDescList
{
private:

	AdrDataManagerHdl		ppDatMan;		

protected:

	void					GenerateFieldList();
	void					CreateFieldDescriptions(const AddressBookParameteredProperty* pProp);
	void					CreateFieldDescription(const AddressBookPropertyParameterInfo* pProp);

public:
							AdrFieldList(AdrDataManagerHdl pDM);
							~AdrFieldList();

	virtual void			UpdateData();
	virtual void			RefreshFields();
	virtual void			SaveFields();

	void					Clear();

	short					ConnectField(Edit* pF, const UString& aCName,const Sequence<UString>& seqPa);
	BOOL					IsConnected(const UString& aCName,
										const Sequence<UString>& seqPa, short nNo);

	BOOL					IsAllowedField(const UString& aClassName, 
										const Sequence<UString>& seqParas);

	AdrFieldDescriptionPtr	InsertField(Edit* pField, const UString& aClassName, 
										const Sequence<UString>& seqParas,Window* pTitle=NULL);

	void					RemoveField(AdrFieldDescriptionPtr* );


	BOOL					EqualSeq(const Sequence<UString>& seqParas,
										const Sequence<UString>& aSubSet);

	AdrFieldDescriptionPtr	Search(const UString& aClassName,const Sequence<UString>& seqPa, short nNo);
	
	INT32					GetFieldCount();
	INT32					GetFieldCount(const UString& aCName,const Sequence<UString>& seqPa);
};


#endif


