/*************************************************************************
 *
 *  $RCSfile: registry.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _ADR_REGISTRY_HXX
#define _ADR_REGISTRY_HXX

#ifndef _SMART_COM_SUN_STAR_FORM_XUPDATEBROADCASTER_HXX_
#include <smart/com/sun/star/form/XUpdateBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XCONFIRMDELETEBROADCASTER_HXX_
#include <smart/com/sun/star/form/XConfirmDeleteBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEFORMUPDATE_HXX_
#include <smart/com/sun/star/form/XDatabaseFormUpdate.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XUPDATELISTENER_HXX_
#include <smart/com/sun/star/form/XUpdateListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_DATASELECTIONTYPE_HXX_
#include <smart/com/sun/star/form/DataSelectionType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XERRORLISTENER_HXX_
#include <smart/com/sun/star/form/XErrorListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XRESTORELISTENER_HXX_
#include <smart/com/sun/star/form/XRestoreListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_DATABASEPARAMETEREVENT_HXX_
#include <smart/com/sun/star/form/DatabaseParameterEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XINSERTLISTENER_HXX_
#include <smart/com/sun/star/form/XInsertListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDELETELISTENER_HXX_
#include <smart/com/sun/star/form/XDeleteListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_DATABASEDELETEEVENT_HXX_
#include <smart/com/sun/star/form/DatabaseDeleteEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XPOSITIONINGLISTENER_HXX_
#include <smart/com/sun/star/form/XPositioningListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XBOUNDCOMPONENT_HXX_
#include <smart/com/sun/star/form/XBoundComponent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEPARAMETERLISTENER_HXX_
#include <smart/com/sun/star/form/XDatabaseParameterListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XLOADLISTENER_HXX_
#include <smart/com/sun/star/form/XLoadListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_NAVIGATIONBARMODE_HXX_
#include <smart/com/sun/star/form/NavigationBarMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XCONFIRMDELETELISTENER_HXX_
#include <smart/com/sun/star/form/XConfirmDeleteListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XERRORBROADCASTER_HXX_
#include <smart/com/sun/star/form/XErrorBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_ERROREVENT_HXX_
#include <smart/com/sun/star/form/ErrorEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_LISTSOURCETYPE_HXX_
#include <smart/com/sun/star/form/ListSourceType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEPARAMETERBROADCASTER_HXX_
#include <smart/com/sun/star/form/XDatabaseParameterBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_TABULATORCYCLE_HXX_
#include <smart/com/sun/star/form/TabulatorCycle.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEFORM_HXX_
#include <smart/com/sun/star/form/XDatabaseForm.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XBOUNDCONTROL_HXX_
#include <smart/com/sun/star/form/XBoundControl.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HXX_
#include <smart/com/sun/star/frame/XFrameActionListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HXX_
#include <smart/com/sun/star/frame/XComponentLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAME_HXX_
#include <smart/com/sun/star/frame/XFrame.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTIONEVENT_HXX_
#include <smart/com/sun/star/frame/FrameActionEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTION_HXX_
#include <smart/com/sun/star/frame/FrameAction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XOBJECTINPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XObjectInputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XPERSISTOBJECT_HXX_
#include <smart/com/sun/star/io/XPersistObject.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XOBJECTOUTPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XObjectOutputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_MERGECONFLICTEXCEPTION_HXX_
#include <smart/com/sun/star/registry/MergeConflictException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HXX_
#include <smart/com/sun/star/registry/XSimpleRegistry.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_WINDOWDESCRIPTOR_HXX_
#include <smart/com/sun/star/awt/WindowDescriptor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_INVALIDATESTYLE_HXX_
#include <smart/com/sun/star/awt/InvalidateStyle.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XTOOLKIT_HXX_
#include <smart/com/sun/star/awt/XToolkit.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XWINDOWPEER_HXX_
#include <smart/com/sun/star/awt/XWindowPeer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_WINDOWCLASS_HXX_
#include <smart/com/sun/star/awt/WindowClass.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XSYSTEMDEPENDENTWINDOWPEER_HXX_
#include <smart/com/sun/star/awt/XSystemDependentWindowPeer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_WINDOWATTRIBUTE_HXX_
#include <smart/com/sun/star/awt/WindowAttribute.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XPOINTER_HXX_
#include <smart/com/sun/star/awt/XPointer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_SYSTEMPOINTER_HXX_
#include <smart/com/sun/star/awt/SystemPointer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XPropertySet.hxx>
#endif





class AdrRegistryKey: public XRegistryKey, public XPropertySet, public UsrObject
{
private:

		XRegistryKeyRef				xRegistryKey;

public:
		AdrRegistryKey(const XRegistryKeyRef& aRegKey);

		SMART_UNO_DECLARATION( AdrRegistryKey, UsrObject );

		static RegistryValueType	giveValueType(const UsrAny& rValue);
		static XIdlClassRef			giveClassRef(RegistryValueType eValueType);
		//XInterface
	    virtual BOOL 				queryInterface( UsrUik aUIK, XInterfaceRef& );

		// XRegistryKey
		virtual UString				getKeyName(void) const THROWS( (UsrSystemException) );
		virtual BOOL				isReadOnly(void) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual BOOL				isValid(void) THROWS( (UsrSystemException) );
		virtual RegistryKeyType		getKeyType(const UString& rKeyName) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual RegistryValueType	getValueType(void) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual INT32				getLongValue(void) THROWS( (InvalidRegistryException, InvalidValueException, UsrSystemException) );
		virtual void				setLongValue(INT32 value) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual Sequence< INT32 >	getLongListValue(void) THROWS( (InvalidRegistryException, InvalidValueException, UsrSystemException) );
		virtual void				setLongListValue(const Sequence< INT32 >& seqValue) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual UString				getAsciiValue(void) THROWS( (InvalidRegistryException, InvalidValueException, UsrSystemException) );
		virtual void				setAsciiValue(const UString& value) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual Sequence< UString > getAsciiListValue(void) THROWS( (InvalidRegistryException, InvalidValueException, UsrSystemException) );
		virtual void				setAsciiListValue(const Sequence< UString >& seqValue) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual UString				getStringValue(void) THROWS( (InvalidRegistryException, InvalidValueException, UsrSystemException) );
		virtual void				setStringValue(const UString& value) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual Sequence< UString > getStringListValue(void) THROWS( (InvalidRegistryException, InvalidValueException, UsrSystemException) );
		virtual void				setStringListValue(const Sequence< UString >& seqValue) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual Sequence< BYTE >	getBinaryValue(void) THROWS( (InvalidRegistryException, InvalidValueException, UsrSystemException) );
		virtual void				setBinaryValue(const Sequence< BYTE >& value) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual XRegistryKeyRef		openKey(const UString& aKeyName) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual XRegistryKeyRef		createKey(const UString& aKeyName) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual void				closeKey(void) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual void				deleteKey(const UString& rKeyName) THROWS( (InvalidRegistryException, UsrSystemException) );

		virtual Sequence< XRegistryKeyRef > openKeys(void) THROWS( (InvalidRegistryException, UsrSystemException) );

		virtual Sequence< UString > getKeyNames(void) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual BOOL				createLink(const UString& aLinkName, const UString& aLinkTarget) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual void				deleteLink(const UString& rLinkName) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual UString				getLinkTarget(const UString& rLinkName) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual UString				getResolvedName(const UString& aKeyName) THROWS( (InvalidRegistryException, UsrSystemException) );

		// XPropertySet
	    virtual XPropertySetInfoRef getPropertySetInfo(void) const THROWS( (UsrSystemException) );
		virtual void				setPropertyValue(const UString& aPropertyName, const UsrAny& aValue) THROWS( (UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException, UsrSystemException) );
		virtual UsrAny				getPropertyValue(const UString& PropertyName) const THROWS( (UnknownPropertyException, WrappedTargetException, UsrSystemException) );
		virtual void				addPropertyChangeListener(const UString& aPropertyName, const XPropertyChangeListenerRef& xListener) THROWS( (UnknownPropertyException, WrappedTargetException, UsrSystemException) );
		virtual void				removePropertyChangeListener(const UString& aPropertyName, const XPropertyChangeListenerRef& aListener) THROWS( (UnknownPropertyException, WrappedTargetException, UsrSystemException) );
		virtual void				addVetoableChangeListener(const UString& PropertyName, const XVetoableChangeListenerRef& aListener) THROWS( (UnknownPropertyException, WrappedTargetException, UsrSystemException) );
		virtual void				removeVetoableChangeListener(const UString& PropertyName, const XVetoableChangeListenerRef& aListener) THROWS( (UnknownPropertyException, WrappedTargetException, UsrSystemException) );


		XPersistObjectRef			registry2Object(const XRegistryKeyRef& rKey) const;
		void						object2Registry(const XRegistryKeyRef& rKey, const XPersistObjectRef& rObject) const;

};

class AdrRegistryKeyInfo: public XPropertySetInfo, public UsrObject
{
private:

		XRegistryKeyRef				xAdrRegistryKey;		

public:
		SMART_UNO_DECLARATION( AdrRegistryKeyInfo, UsrObject );

		AdrRegistryKeyInfo(const XRegistryKeyRef&);
		
		//XInterface
	    virtual BOOL 				queryInterface( UsrUik aUIK, XInterfaceRef& );

		// XPropertySetInfo
	    virtual Sequence< Property >getProperties(void) const THROWS( (UsrSystemException) );
	    virtual Property			getPropertyByName(const UString& aName) const THROWS( (UnknownPropertyException, UsrSystemException) );
		virtual BOOL				hasPropertyByName(const UString& Name) const THROWS( (UsrSystemException) );

};

class AdrRegistry: public XSimpleRegistry, public UsrObject
{
private:
		XSimpleRegistryRef      xRegistry;
	
		UString					aActivDataSource;

protected:

		void					InitRegistry();
public:

								AdrRegistry();
								~AdrRegistry();

		SMART_UNO_DECLARATION( AdrRegistry, UsrObject );
	

		//XSimpleRegistry
	    virtual UString			getURL(void) const THROWS( (UsrSystemException) );
	    virtual void			open(const UString& rURL, BOOL bReadOnly, BOOL bCreate) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual BOOL			isValid(void) THROWS( (UsrSystemException) );
		virtual void			close(void) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual void			destroy(void) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual XRegistryKeyRef getRootKey(void) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual	BOOL			isReadOnly(void) THROWS( (InvalidRegistryException, UsrSystemException) );
		virtual	void			mergeKey(const UString& aKeyName, const UString& aUrl) THROWS( (InvalidRegistryException, MergeConflictException, UsrSystemException) );

		//XInterface
	    virtual BOOL 			queryInterface( UsrUik aUIK, XInterfaceRef& );

		//Additionals
		XRegistryKeyRef			openSectionKey(const UString&);
		XRegistryKeyRef			openSectionSubKey(const XRegistryKeyRef& rKey,const UString&);

};



#endif
