/*************************************************************************
 *
 *  $RCSfile: testpacker.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stardiv/uno/repos/implementationregistration.hxx>
#include <stardiv/uno/script/script.hxx>

#include <rtl/ustring.hxx>
#include <vos/dynload.hxx>
#include <vos/diagnose.hxx>
#include <usr/services.hxx>
#include <vcl/svapp.hxx>

#ifndef _USR_UNO_HXX
#include <usr/uno.hxx>
#endif
#ifndef _USR_SEQU_HXX
#include <usr/sequ.hxx>
#endif
#ifndef __STARDIV_UNO_IO_STREAM_HXX__
#include <stardiv/uno/io/stream.hxx>
#endif
#ifndef __STARDIV_UNO_BEANS_PROPSET_HXX__
#include <stardiv/uno/beans/propset.hxx>
#endif
#ifndef __STARDIV_ONE_UTIL_PACKER_HXX_
#include <stardiv/one/util/packer.hxx>
#endif

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#ifdef _USE_NAMESPACE
using namespace rtl;
using namespace vos;
using namespace usr;
#endif														 


class SimpleErrorHandler : public XSimpleErrorHandler , public UsrObject
{
public:
	SMART_REFLECTION_DECLARATION( SimpleErrorHandler, UsrObject );

//	void acquire(void) { UsrObject::acquire(); }
//	void release(void) { UsrObject::release(); }
	virtual BOOL queryInterface(UsrUik aUik,XInterfaceRef& rOut) { return UsrObject::queryInterface(aUik,rOut); }

	virtual BOOL handleError( const UsrAny& Exception ) THROWS( (UsrSystemException) );
};

BOOL SimpleErrorHandler::handleError( const UsrAny& Exception )
{
	if( Exception.getReflection() == DiskFullException_getReflection() )
	{
			ErrorBox aErrorBox( NULL, WB_RETRY_CANCEL, "DiskFullException" );
			return aErrorBox.Execute() == BUTTONID_RETRY;
	}
	else if( Exception.getReflection() == FileIOException_getReflection() )
	{
			ErrorBox aErrorBox(NULL, WB_RETRY_CANCEL, "FileIOException");
			return aErrorBox.Execute() == BUTTONID_RETRY;
	}
	else
		return FALSE;
};

SMART_REFLECTION_IMPLEMENTATION( SimpleErrorHandler, UsrObject, L"SimpleErrorHandler" );

class MyApp : public Application
{
public:
	void		Main();

	void syntax( void );
	void extract( XArchiverRef xPacker );
	void add( XArchiverRef xPacker );
	void list( XArchiverRef xPacker );

};

MyApp aMyApp;

// -----------------------------------------------------------------------

#define S2U(x) StringToOUString(x,CHARSET_SYSTEM)

void MyApp::syntax( void )
{

}

void MyApp::extract( XArchiverRef xPacker )
{
	XSimpleErrorHandlerRef rErrorHandler( (XSimpleErrorHandler*)new SimpleErrorHandler() );

	Sequence<PropertyValue> aArgs(1);
	aArgs.getArray()[0].Name = L"ErrorHandler";
	aArgs.getArray()[0].Value.set( &rErrorHandler, XSimpleErrorHandler_getReflection() );
	Sequence< UString > files(0);

	xPacker->unpack( S2U(GetCommandLineParam(2)), S2U(GetCommandLineParam(1)), files, aArgs );
}

void MyApp::add( XArchiverRef xPacker )
{
	XSimpleErrorHandlerRef rErrorHandler( (XSimpleErrorHandler*)new SimpleErrorHandler() );
/*
	BOOL bCompress = FALSE;
	BOOL bChunk = FALSE;
	UINT32 nVolumneSize = 0;

	const USHORT nParamCount = GetCommandLineParamCount();
	String aParam;

	USHORT nParam = 1;
	while( nParam < nParamCount && (aParam = GetCommandLineParam(nParam)).GetChar(0) == '-' )
	{
		if( aParam = "-c" )
			bCompress = TRUE;
		else if( aParam.GetChar(1) == 'v' )
		{
			aParam.Erase( 0, 2 );
			if( aParam.Len() != 0 )
			{
				nVolumneSize = atoi( aParam );
			}
			else
			{
				nVolumneSize = (144 * 1024) / 100;
			}
		}
		nParam++;
	}
*/
	Sequence< UString > input(3);
	input.getArray()[0] = L"file1.bin";
	input.getArray()[1] = L"file2.bin";
	input.getArray()[2] = L"file3.bin";

	Sequence<PropertyValue> aArgs(4);
	aArgs.getArray()[0].Name = L"RootDirectory";
	aArgs.getArray()[0].Value.setString( L"f:\\temp\\ziptest" );
	aArgs.getArray()[1].Name = L"ErrorHandler";
	aArgs.getArray()[1].Value.set( &rErrorHandler, XSimpleErrorHandler_getReflection() );
	aArgs.getArray()[2].Name = L"Compression";
	aArgs.getArray()[2].Value.setUINT16( 1 );
	aArgs.getArray()[3].Name = L"VolumeSize";
	aArgs.getArray()[3].Value.setUINT32( 100 );

	xPacker->pack( input, L"f:\\temp\\ziptest\\test.spk", aArgs );
}

void MyApp::list( XArchiverRef xPacker )
{
}

void MyApp::Main()
{
	XMultiServiceFactoryRef xSMgr = createRegistryServiceManager();
	registerUsrServices( xSMgr );
	setProcessServiceManager( xSMgr );

	XArchiverRef xPacker( xSMgr->createInstance( L"stardiv.one.util.Archiver" ), USR_QUERY );
	if( xPacker.is() )
	{
		const USHORT nParamCount = GetCommandLineParamCount();
		if( nParamCount < 1 )
		{
			syntax();
			return;
		}
		
		String aCommando( GetCommandLineParam( 0 ) );
		if( aCommando == "x" )
		{
			extract( xPacker );
		}
		else if( aCommando == "a" )
		{
			add( xPacker );
		}
		else if( aCommando == "l" )
		{
			list( xPacker );
		}
		else
		{
			syntax();
		}
	}
}

