/*************************************************************************
 *
 *  $RCSfile: sysplug.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 16:17:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <tools/debug.hxx>

#include <plugin/impl.hxx>

extern NPNetscapeFuncs aNPNFuncs;

//--------------------------------------------------------------------------------------------------
PluginComm_Impl::PluginComm_Impl( const UString& rMIME, const UString& rName, HWND hWnd ) : PluginComm(rName)
{
        CHAR   szBuffer[CCHMAXPATHCOMP];
        String aStr(OUStringToString( rName, CHARSET_SYSTEM ));

        _NPPfuncs.version = 0;
        _NPPfuncs.size = sizeof(_NPPfuncs);

        if(NO_ERROR != DosLoadModule(szBuffer, sizeof(szBuffer), aStr.GetStr(), &m_hMod))
            m_hMod = NULLHANDLE;

	DBG_ASSERT( m_hMod, "### loading plugin dll failed!" );

	NPError nErr;
	NPError (APIENTRY * pEntry)( NPPluginFuncs* );
	if (m_hMod && retrieveFunction( "NP_GetEntryPoints", (void**)&pEntry ))
	{
		nErr = (*pEntry)( &_NPPfuncs );

		DBG_ASSERT( nErr == NPERR_NO_ERROR, "### NP_GetEntryPoints() failed!" );
		DBG_ASSERT( (_NPPfuncs.version >> 8) >= NP_VERSION_MAJOR,
                            "### version failure!" );

		NPError (APIENTRY * pInit)( NPNetscapeFuncs* );
                if ((nErr == NPERR_NO_ERROR && (_NPPfuncs.version >> 8) >= NP_VERSION_MAJOR &&
                     retrieveFunction( "NP_Initialize", (void**)&pInit ) ||
                     retrieveFunction( "NP_PluginInit", (void**)&pInit )))
		{
			nErr = (*pInit)( &aNPNFuncs );
			DBG_ASSERT( nErr == NPERR_NO_ERROR, "### NP_Initialize() failed!" );

// WIN obsolete: called by NP_Initialize()
//  			nErr = NPP_Initialize();
//  			DBG_ASSERT( nErr == NPERR_NO_ERROR, "### NPP_Initialize() failed!" );
		}
	}
}

//--------------------------------------------------------------------------------------------------
PluginComm_Impl::~PluginComm_Impl()
{
	if (m_hMod)
	{
//  		NPP_Shutdown();

		NPError (APIENTRY * pShutdown)();
		if (retrieveFunction( "NP_Shutdown", (void**)&pShutdown ))
		{
			NPError nErr = (*pShutdown)();
			DBG_ASSERT( nErr == NPERR_NO_ERROR, "### NP_Shutdown() failed!" );
		}

		BOOL bRet = NO_ERROR == DosFreeModule( m_hMod );
		DBG_ASSERT( bRet, "### unloading plugin dll failed!" );
		m_hMod = NULL;
	}
}

//--------------------------------------------------------------------------------------------------
BOOL PluginComm_Impl::retrieveFunction( PSZ pszName, void** ppFunc ) const
{
	if (NO_ERROR != DosQueryProcAddr(m_hMod, 0, pszName, (PFN *) ppFunc))
	{
#if OSL_DEBUG_LEVEL > 1
		String aMsg( "### cannot retrieve function " );
		aMsg += String(pszName);
		aMsg += String("() from dll!");
		DBG_ERROR( aMsg.GetStr() );
#endif
	}

	return (*ppFunc != NULL);
}

//--------------------------------------------------------------------------------------------------
NPError PluginComm_Impl::NPP_Destroy( NPP instance, NPSavedData** save )
{
	DBG_ASSERT( _NPPfuncs.destroy, "### NPP_Destroy(): null pointer in NPP functions table!" );
	return (_NPPfuncs.destroy
			? (*_NPPfuncs.destroy)( instance, save )
			: NPERR_GENERIC_ERROR);
}

//--------------------------------------------------------------------------------------------------
NPError PluginComm_Impl::NPP_DestroyStream( NPP instance, NPStream* stream, NPError reason )
{
	DBG_ASSERT( _NPPfuncs.destroystream, "### NPP_DestroyStream(): null pointer in NPP functions table!" );
	return (_NPPfuncs.destroystream
			? (*_NPPfuncs.destroystream)( instance, stream, reason )
			: NPERR_GENERIC_ERROR);
}

//--------------------------------------------------------------------------------------------------
NPError PluginComm_Impl::NPP_New( NPMIMEType pluginType, NPP instance, uint16 mode, int16 argc,
								  char* argn[], char* argv[], NPSavedData *saved )
{
	DBG_ASSERT( _NPPfuncs.newp, "### NPP_New(): null pointer in NPP functions table!" );
	return (_NPPfuncs.newp
			? (*_NPPfuncs.newp)( pluginType, instance, mode, argc, argn, argv, saved )
			: NPERR_GENERIC_ERROR);
}

//--------------------------------------------------------------------------------------------------
NPError PluginComm_Impl::NPP_NewStream( NPP instance, NPMIMEType type, NPStream* stream,
										NPBool seekable, uint16* stype )
{
	DBG_ASSERT( _NPPfuncs.newstream, "### NPP_NewStream(): null pointer in NPP functions table!" );
	return (_NPPfuncs.newstream
			? (*_NPPfuncs.newstream)( instance, type, stream, seekable, stype )
			: NPERR_GENERIC_ERROR);
}

//--------------------------------------------------------------------------------------------------
void PluginComm_Impl::NPP_Print( NPP instance, NPPrint* platformPrint )
{
	DBG_ASSERT( _NPPfuncs.print, "### NPP_Print(): null pointer in NPP functions table!" );
	if (_NPPfuncs.print)
		(*_NPPfuncs.print)( instance, platformPrint );
}

//--------------------------------------------------------------------------------------------------
NPError PluginComm_Impl::NPP_SetWindow( NPP instance, NPWindow* window )
{
    DBG_ASSERT( _NPPfuncs.setwindow, "### NPP_SetWindow(): null pointer in NPP functions table!" );

    if(window && window->window)
        WinShowWindow((HWND) window->window, TRUE);

	return (_NPPfuncs.setwindow
			? (*_NPPfuncs.setwindow)( instance, window )
			: NPERR_GENERIC_ERROR);
}

//--------------------------------------------------------------------------------------------------
void PluginComm_Impl::NPP_StreamAsFile( NPP instance, NPStream* stream, const char* fname )
{
	DBG_ASSERT( _NPPfuncs.asfile, "### NPP_StreamAsFile(): null pointer in NPP functions table!" );
	if (_NPPfuncs.asfile)
		(*_NPPfuncs.asfile)( instance, stream, fname );
}

//--------------------------------------------------------------------------------------------------
void PluginComm_Impl::NPP_URLNotify( NPP instance, const char* url, NPReason reason, void* notifyData )
{
	DBG_ASSERT( _NPPfuncs.urlnotify, "### NPP_URLNotify(): null pointer in NPP functions table!" );
	if (_NPPfuncs.urlnotify)
		(*_NPPfuncs.urlnotify)( instance, url, reason, notifyData );
}

//--------------------------------------------------------------------------------------------------
int32 PluginComm_Impl::NPP_Write( NPP instance, NPStream* stream, int32 offset, int32 len, void* buffer )
{
	DBG_ASSERT( _NPPfuncs.write, "### NPP_Write(): null pointer in NPP functions table!" );
	return (_NPPfuncs.write
			? (*_NPPfuncs.write)( instance, stream, offset, len, buffer )
			: 0);
}

//--------------------------------------------------------------------------------------------------
int32 PluginComm_Impl::NPP_WriteReady( NPP instance, NPStream* stream )
{
	DBG_ASSERT( _NPPfuncs.writeready, "### NPP_WriteReady(): null pointer in NPP functions table!" );
	return (_NPPfuncs.writeready
			? (*_NPPfuncs.writeready)( instance, stream )
			: 0);
}

//--------------------------------------------------------------------------------------------------
NPError PluginComm_Impl::NPP_GetValue( NPP instance, NPPVariable variable, void *ret_alue )
{
	DBG_ASSERT( _NPPfuncs.getvalue, "### NPP_GetValue(): null pointer in NPP functions table!" );
	return (_NPPfuncs.getvalue
			? (*_NPPfuncs.getvalue)( instance, variable, ret_alue )
			: NPERR_GENERIC_ERROR);
}

//--------------------------------------------------------------------------------------------------
NPError PluginComm_Impl::NPP_SetValue( NPP instance, NPNVariable variable, void *ret_alue )
{
	DBG_ASSERT( _NPPfuncs.setvalue, "### NPP_SetValue(): null pointer in NPP functions table!" );
	return (_NPPfuncs.setvalue
			? (*_NPPfuncs.setvalue)( instance, variable, ret_alue )
			: NPERR_GENERIC_ERROR);
}

//--------------------------------------------------------------------------------------------------
jref PluginComm_Impl::NPP_GetJavaClass()
{
	DBG_ERROR( "no java class available!" );
	return 0;
}

//--------------------------------------------------------------------------------------------------
NPError PluginComm_Impl::NPP_Initialize()
{
	return NPERR_NO_ERROR;
}

//--------------------------------------------------------------------------------------------------
void PluginComm_Impl::NPP_Shutdown()
{
	NPP_ShutdownUPP pFunc;
	if (retrieveFunction( "NPP_Shutdown", (void**)&pFunc ))
		(*pFunc)();
}

