/*************************************************************************
 *
 *  $RCSfile: indexentrysupplier_complex.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: khong $ $Date: 2002/06/18 22:29:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <indexentrysupplier_complex.hxx>

namespace com { namespace sun { namespace star { namespace i18n {

rtl::OUString SAL_CALL IndexEntrySupplier_CTL::getIndexString( const sal_Unicode ch,
	const sal_Unicode idxStr[], sal_Unicode idxStart, sal_Unicode idxEnd)
	throw (com::sun::star::uno::RuntimeException) {
	return rtl::OUString(&idxStr[(ch >= idxStart && ch <= idxEnd) ? ch - idxStart : 0], 1);
}

static sal_Unicode idxStr_ar_alphanumeric[] = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 0600-0F
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 0610-1F
	0x0000, 0x0000, 0x0627, 0x0627, 0x0648, 0x0627, 0x064A, 0x0627, 0x0628, 0x0629, 0x062A, 0x062B, 0x062C, 0x062D, 0x062E, 0x062F,   // 0620-2F
	0x0630, 0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x0637, 0x0638, 0x0639, 0x063A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 0630-3F
	0x0000, 0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0646, 0x0646, 0x0648, 0x0649, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 0640-4F
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 0650-5F
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 0660-6F
	0x0000, 0x0627, 0x0627, 0x0627, 0x0000, 0x0627, 0x0648, 0x06C7, 0x064A, 0x0679, 0x067A, 0x067B, 0x062A, 0x062A, 0x067E, 0x067F,   // 0670-7F
	0x0680, 0x062D, 0x062D, 0x0683, 0x0684, 0x062D, 0x0686, 0x0687, 0x0688, 0x062F, 0x062F, 0x062F, 0x068C, 0x068D, 0x068E, 0x062F,   // 0680-8F
	0x062F, 0x0691, 0x0631, 0x0631, 0x0631, 0x0631, 0x0631, 0x0631, 0x0698, 0x0631, 0x0633, 0x0633, 0x0633, 0x0635, 0x0635, 0x0637,   // 0690-9F
	0x0639, 0x0641, 0x0641, 0x0641, 0x06A4, 0x0641, 0x06A6, 0x0642, 0x0642, 0x06A9, 0x06AA, 0x0643, 0x0643, 0x06AD, 0x0643, 0x06AF,   // 06A0-AF
	0x06AF, 0x06B1, 0x06AF, 0x06B3, 0x06AF, 0x0644, 0x0644, 0x0644, 0x0644, 0x0646, 0x0646, 0x06BB, 0x0646, 0x0646, 0x06BE, 0x0686,   // 06B0-BF
	0x06BE, 0x06C1, 0x06C1, 0x06C3, 0x0648, 0x06C5, 0x06C6, 0x06C7, 0x06C8, 0x06C9, 0x0648, 0x06CB, 0x06CC, 0x06CC, 0x06CC, 0x0648,   // 06C0-CF
	0x06D0, 0x06CC, 0x06D2, 0x06D2, 0x0000, 0x06D5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 06D0-DF
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 06E0-EF
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0634, 0x0636, 0x063A, 0x0000, 0x0000, 0x0000,   // 06F0-FF
};

rtl::OUString SAL_CALL IndexEntrySupplier_ar_alphanumeric::getIndexCharacter( const rtl::OUString& rIndexEntry,
	const com::sun::star::lang::Locale& rLocale, const rtl::OUString& rSortAlgorithm ) throw (com::sun::star::uno::RuntimeException) {
	return IndexEntrySupplier_CTL::getIndexString(rIndexEntry.toChar(), idxStr_ar_alphanumeric, 0x600, 0x6FF);
}

static sal_Unicode idxStr_he_alphanumeric[] = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 0590-9F
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 05A0-AF
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 05B0-BF
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 05C0-CF
	0x05D0, 0x05D1, 0x05D2, 0x05D3, 0x05D4, 0x05D5, 0x05D6, 0x05D7, 0x05D8, 0x05D9, 0x05DB, 0x05DB, 0x05DC, 0x05DE, 0x05DE, 0x05E0,   // 05D0-DF
	0x05E0, 0x05E1, 0x05E2, 0x05E4, 0x05E4, 0x05E6, 0x05E6, 0x05E7, 0x05E8, 0x05E9, 0x05EA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 05E0-EF
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 05F0-FF
};

rtl::OUString SAL_CALL IndexEntrySupplier_he_alphanumeric::getIndexCharacter( const rtl::OUString& rIndexEntry,
	const com::sun::star::lang::Locale& rLocale, const rtl::OUString& rSortAlgorithm ) throw (com::sun::star::uno::RuntimeException) {
	return IndexEntrySupplier_CTL::getIndexString(rIndexEntry.toChar(), idxStr_he_alphanumeric, 0x590, 0x5FF);
}

static sal_Unicode idxStr_hi_alphanumeric[] = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0905, 0x0906, 0x0907, 0x0908, 0x0909, 0x090A, 0x090B, 0x090C, 0x090D, 0x090D, 0x090F,   // 0900-0F
	0x0910, 0x0911, 0x0911, 0x0913, 0x0914, 0x0915, 0x0916, 0x0917, 0x0918, 0x0919, 0x091A, 0x091B, 0x091C, 0x091D, 0x091E, 0x091F,   // 0910-1F
	0x0920, 0x0921, 0x0922, 0x0923, 0x0924, 0x0925, 0x0926, 0x0927, 0x0928, 0x0928, 0x092A, 0x092B, 0x092C, 0x092D, 0x092E, 0x092F,   // 0920-2F
	0x0930, 0x0930, 0x0932, 0x0933, 0x0933, 0x0935, 0x0936, 0x0937, 0x0938, 0x0939, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 0930-3F
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 0940-4F
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0915, 0x0916, 0x0917, 0x091C, 0x0921, 0x0922, 0x092B, 0x092F,   // 0950-5F
	0x0960, 0x0961, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 0960-6F
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 0970-7F
};

rtl::OUString SAL_CALL IndexEntrySupplier_hi_alphanumeric::getIndexCharacter( const rtl::OUString& rIndexEntry,
	const com::sun::star::lang::Locale& rLocale, const rtl::OUString& rSortAlgorithm ) throw (com::sun::star::uno::RuntimeException) {
	return IndexEntrySupplier_CTL::getIndexString(rIndexEntry.toChar(), idxStr_hi_alphanumeric, 0x900, 0x97F);
}

static sal_Unicode idxStr_th_alphanumeric[] = {
	0x0000, 0x0E01, 0x0E02, 0x0E03, 0x0E04, 0x0E05, 0x0E06, 0x0E07, 0x0E08, 0x0E09, 0x0E0A, 0x0E0B, 0x0E0C, 0x0E0D, 0x0E0E, 0x0E0F,   // 0E00-0F
	0x0E10, 0x0E11, 0x0E12, 0x0E13, 0x0E14, 0x0E15, 0x0E16, 0x0E17, 0x0E18, 0x0E19, 0x0E1A, 0x0E1B, 0x0E1C, 0x0E1D, 0x0E1E, 0x0E1F,   // 0E10-1F
	0x0E20, 0x0E21, 0x0E22, 0x0E23, 0x0E24, 0x0E25, 0x0E26, 0x0E27, 0x0E28, 0x0E29, 0x0E2A, 0x0E2B, 0x0E2C, 0x0E2D, 0x0E2E, 0x0000,   // 0E20-2F
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 0E30-3F
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 0E40-4F
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 0E50-5F
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 0E60-6F
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,   // 0E70-7F
};

rtl::OUString SAL_CALL IndexEntrySupplier_th_alphanumeric::getIndexCharacter( const rtl::OUString& rIndexEntry,
	const com::sun::star::lang::Locale& rLocale, const rtl::OUString& rSortAlgorithm ) throw (com::sun::star::uno::RuntimeException) {
	return IndexEntrySupplier_CTL::getIndexString(rIndexEntry.toChar(), idxStr_th_alphanumeric, 0xE00, 0xE7F);
}

} } } }
