/*************************************************************************
 *
 *  $RCSfile: MethodTypeDescription.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.comp.typedescriptionmanager;

import com.sun.star.uno.*;
import com.sun.star.uno.RuntimeException;
import com.sun.star.reflection.XInterfaceMethodTypeDescription;
import com.sun.star.reflection.XInterfaceMemberTypeDescription;
import com.sun.star.reflection.XTypeDescription;
import com.sun.star.reflection.XMethodParameter;


//==================================================================================================
class MethodTypeDescription extends TypeDescription implements XInterfaceMethodTypeDescription
{
	private String				_memberName;
	private XTypeDescription	_xReturnType;
	private int					_nPos;
	private boolean				_bOneway;
	private XMethodParameter[]	_params;
	private XTypeDescription[]	_exceptions;
	
	//______________________________________________________________________________________________
	public MethodTypeDescription( String name, String memberName,
								  XTypeDescription xReturnType, int nPos, boolean bOneway,
								  XMethodParameter[] params, XTypeDescription[] exceptions )
	{
		super( name, TypeClass.INTERFACE_METHOD );
		this._memberName  = memberName;
		this._xReturnType = xReturnType;
		this._nPos		  = nPos;
		this._bOneway	  = bOneway;
		this._params	  = (params == null ? new XMethodParameter[0] : params);
		this._exceptions  = (exceptions == null ? new XTypeDescription[0] : exceptions);
	}
	
	// XInterfaceMemberTypeDescription
	//______________________________________________________________________________________________
	public String getMemberName()
		throws RuntimeException
	{
		return _memberName;
	}
	//______________________________________________________________________________________________
	public int getPosition()
		throws RuntimeException
	{
		return _nPos;
	}
	// XInterfaceMethodTypeDescription
	//______________________________________________________________________________________________
	public XTypeDescription getReturnType()
		throws RuntimeException
	{
		return _xReturnType;
	}
	//______________________________________________________________________________________________
	public boolean isOneway()
		throws RuntimeException
	{
		return _bOneway;
	}
	//______________________________________________________________________________________________
	public XMethodParameter[] getParameters()
		throws RuntimeException
	{
		return _params;
	}
	//______________________________________________________________________________________________
    public XTypeDescription[] getExceptions()
		throws RuntimeException
	{
		return _exceptions;
	}
}

