/*************************************************************************
 *
 *  $RCSfile: javainfo.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/12 09:17:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "jvmaccess/javainfo.hxx"

#include "javainfoimpl.hxx"
#include "sunversion.hxx"

#include "osl/file.hxx"

using jvmaccess::JavaInfo;
using jvmaccess::impl::SunVersion;
using namespace osl;

#define OUSTR( x )  ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM( x ))
namespace  jvmaccess{

/* The first element has the highest version
 */
void bubbleSortVersion(std::vector<JavaInfo>& vec)
{
    if(vec.size() == 0)
        return;
    int size= vec.size() - 1;
    int cIter= 0;
    // sort for version
    for(int i= 0; i < size; i++)
    {
        for(int j= size; j > 0 + cIter; j--)
        {
            JavaInfo& cur= vec.at(j);
            JavaInfo& next= vec.at(j-1);
            SunVersion curVersion(cur.getVersion());
            SunVersion nextVersion(next.getVersion());
                // comparing invalid SunVersion s is possible, they will be less than a
                // valid version
            if(curVersion
               >  nextVersion)
            {
                JavaInfo less= next;
                vec.at(j-1)= cur;
                vec.at(j)= less;
            }
        }
        cIter++;
    }
}



JavaInfo::InitException::InitException()
{}

JavaInfo::InitException::InitException(InitException const &)
{}

JavaInfo::InitException::~InitException()
{}

JavaInfo::InitException &
JavaInfo::InitException::operator =(InitException const &)
{
    return *this;
}


JavaInfo::UnsupportedException::UnsupportedException()
{}

JavaInfo::UnsupportedException::UnsupportedException(const UnsupportedException &)
{}

JavaInfo::UnsupportedException::~UnsupportedException()
{}

JavaInfo::UnsupportedException &
JavaInfo::UnsupportedException::operator =(const UnsupportedException &)
{
    return *this;
}

JavaInfo::JavaInfo(): pImpl(NULL)
{
}

JavaInfo::JavaInfo(const rtl::OUString& sDirectory):
    pImpl(NULL)
{
    // may throw an InitException
    pImpl= new Impl(sDirectory);
}

JavaInfo::JavaInfo(const rtl::OUString& sVersion, int  nFlags):
    pImpl(NULL)
{
    std::vector<Impl*> vecImpls;
    Impl::createImpl(vecImpls, sVersion, nFlags, false);
    OSL_ASSERT(vecImpls.size() <= 1);
    if(vecImpls.size() == 1)
        pImpl= vecImpls[0];
    else
        throw InitException();
}

JavaInfo::JavaInfo(const JavaInfo& info):
    pImpl(NULL)
{
    // may throw InitException
    pImpl= new Impl(*info.pImpl);
}

JavaInfo& JavaInfo::operator = (const JavaInfo& info)
{
    if( &info != this)
    {
        delete pImpl;
        pImpl= new Impl(*info.pImpl);
    }
    return *this;
}

JavaInfo::~JavaInfo()
{
    delete pImpl;
}

void JavaInfo::createAllInfo(std::vector<JavaInfo> *infos)
{
    std::vector<Impl*> vecImpls;
    //create imple may return incomplete objects, which have no valid version
    // (Blackdown)
    Impl::createImpl(vecImpls, rtl::OUString(), 0, true);
    // now sift out the Impls with an invalid version.
    std::vector<Impl*> vecImplsVerified; 
    typedef std::vector<Impl*>::iterator IT_Impl;
    for (IT_Impl i = vecImpls.begin(); i != vecImpls.end(); i++)
    {
        if ( (*i)->version)
            vecImplsVerified.push_back(*i);
    }

    for(IT_Impl j = vecImplsVerified.begin(); j != vecImplsVerified.end(); j++)
    {
        JavaInfo info;
        info.pImpl= *j;
        infos->push_back(info);
    }
    bubbleSortVersion(*infos);
}

JavaInfo JavaInfo::createBestInfo(bool bAccessibility)
{
    std::vector<JavaInfo> vec;
    createAllInfo(&vec);
    std::vector<JavaInfo>::const_iterator it(vec.begin());
    if (bAccessibility)
    {
        for (;; ++it)
        {
            if (it == vec.end())
            {
                it = vec.begin();
                break;
            }
            else
            {
                try
                {
                    if (it->supportsAccessibility())
                        break;
                }
                catch (UnsupportedException& e)
                {
                }
            }
        }
    }
    if (it == vec.end())
        throw InitException();
    return *it;
}

bool JavaInfo::isSame(const JavaInfo& info) const
{
    if(&info == this)
        return true;
    if(pImpl->usRuntimeLib.equalsIgnoreAsciiCase(info.pImpl->usRuntimeLib))
        return true;
    return false;
}
// May throw UnsupportedException.
bool JavaInfo::isEqual(const JavaInfo& info) const
{
    bool ret= false;
    // calling supportsAccessibility may throw an UnsupportedException
    if( isSame(info))
        return true;
    bool bAccessibleKnown1 = false;
    bool bAccessibleKnown2 = false;

    try
    {
         supportsAccessibility();
         bAccessibleKnown1 = true;
    }
    catch (UnsupportedException& e)
    {
    }
    try
    {
        supportsAccessibility();
        bAccessibleKnown2 = true;
    }
    catch (UnsupportedException& e)
    {
    }

    // If boths objects dont know any capabilities then we cannot
    // determine if they are equal
    if (bAccessibleKnown1 == false && bAccessibleKnown2 == false
        &&
        ( ! pImpl->version && ! info.pImpl->version )
        &&
        ( ! pImpl->type  && ! info.pImpl->type))
        throw UnsupportedException();
    
    
    if( compareVersions(info) == 0
        && pImpl->type == info.pImpl->type)
    {
        if (bAccessibleKnown1 && bAccessibleKnown1
            && supportsAccessibility() && info.supportsAccessibility())
            ret = true;
    }
    return ret;
}

// May throw UnsupportedException
int JavaInfo::compareVersions(const JavaInfo& info) const
{
    if ( ! pImpl->version || ! info.pImpl->version)
        throw UnsupportedException();
    
    if(this == &info)
        return 0;
    if(pImpl->version > info.pImpl->version)
        return 1;
    else if(pImpl->version == info.pImpl->version)
        return 0;
    else
        return -1;
}

// May throw UnsupportedException
const rtl::OUString& JavaInfo::getVersion() const
{
    return pImpl->getVersion();
}

const rtl::OUString& JavaInfo::getInstallationLocation() const
{
    return pImpl->usJavaHome;
}

// May throw UnsupportedException
const rtl::OUString& JavaInfo::getType() const
{
    if (pImpl->usType.getLength() == 0)
        throw UnsupportedException();
    return pImpl->usType;
}

const rtl::OUString& JavaInfo::getRuntimeLibLocation() const
{
    return pImpl->usRuntimeLib;
}
// May throw UnsupportedException
bool JavaInfo::supportsAccessibility() const
{
    return pImpl->supportsAccessibility();
}

const rtl::OUString&  JavaInfo::getLibLocations() const
{
    return pImpl->usLibLocations;
}

rtl::OUString JavaInfo::getJarFilePath(const rtl::OUString& sName) const
{
    rtl::OUString ret;
#if defined UNX
    if(sName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("javaplugin.jar"))
       || sName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("plugin.jar")))
    {
        if(pImpl->type == Impl::SDK_TYPE)
        {
            ret= pImpl->usJavaHome
                + rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("/jre/lib/"))
                + sName;
        }
        else if(pImpl->type == Impl::JRE_TYPE)
        {
            ret= pImpl->usJavaHome
                + rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("/lib/"))
                + sName;
        }
        else
        {
            //try both
            DirectoryItem item;
            rtl::OUString jarPath(pImpl->usJavaHome + OUSTR("/jre/lib/") 
                                  + sName);
            if(DirectoryItem::get(jarPath, item) == File::E_None)
            {
                ret = jarPath;
            }
            else
            {
                rtl::OUString jarPath2(pImpl->usJavaHome + OUSTR("/lib/") 
                                      + sName);
                if(DirectoryItem::get(jarPath2, item) == File::E_None)
                {
                    ret = jarPath2;
                }

            }

        }
    }
#endif // UNX
    return ret;
}

bool JavaInfo::isComplete()
{
    return pImpl->isComplete();
}

}
