package org.netbeans.modules.openoffice.wizard.util;


import org.openide.src.Identifier;
import org.openide.filesystems.Repository;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.cookies.SourceCookie;
import org.openide.src.ClassElement;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.MultiFileSystem;
import org.netbeans.modules.openoffice.wizard.IDLInterface;
import org.netbeans.modules.openoffice.wizard.IDLMethod;
import org.netbeans.modules.openoffice.OOTools;


import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.FileReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.openide.src.MethodElement;
import org.openide.src.Type;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;


public class OOIDLParser implements FilenameFilter{
    
    private IDLInterface aIDLInterface ;
    private String stringIDLContent;
    private String [] aTokens;
    
    public OOIDLParser() {
        
    }
    
    public OOIDLParser(FileObject File) 
    {
            
            stringIDLContent = getReducedIDLContent( File );
        
    }
//    public OOIDLParser(String stringIDLName) {
//        
//        stringIDLContent = getReducedIDLContent( stringIDLName );
//        
//    }
    
    
    
    public boolean accept(File pathname,String Name) {
        if (Name.indexOf(".idl") != -1) return true;
        else return false;
    }
    
    private final String getReducedIDLContent( FileObject File ) 
    {
    
        BufferedReader bufferedreader = null;
        
        try 
        {
            bufferedreader = new BufferedReader(new InputStreamReader(File.getInputStream()));
        }
        catch( Exception e ) {
            
        }
//    private final String getReducedIDLContent( String stringIDLName ) {
//        
//        BufferedReader bufferedreader = null;
//        
//        try {
//            bufferedreader = new BufferedReader(new FileReader(
//            stringIDLName ));
//        }
//        catch( Exception e ) {
//            System.out.println( e );
//        }
        
        String stringIDLContent = "";
        
        try {
            String stringLine = bufferedreader.readLine();
            while ( stringLine != null ) {
                if ( ( !stringLine.trim().startsWith( "//" ) )
                && ( !stringLine.trim().startsWith( "#" ) )
                ) {
                    stringIDLContent += stringLine;
                    
                }
                stringLine = bufferedreader.readLine();
            }
            
        }
        catch( IOException ioexception ) {
            System.out.println( ioexception );
        }
        
        int intIndexBeginComment = 
        stringIDLContent.indexOf( "/*" );
        
        while ( intIndexBeginComment != -1 ) {
            int intIndexEndComment =
            stringIDLContent.indexOf( "*/", intIndexBeginComment );
            
            stringIDLContent = 
            stringIDLContent.substring( 0, intIndexBeginComment )
            + stringIDLContent.substring( intIndexEndComment + 2 );
            
            intIndexBeginComment = stringIDLContent.indexOf( "/*" );
        }
        
        return( stringIDLContent );
    }
    
    public IDLInterface createIDLInterface() {
        String QualifierString = "";
        IDLInterface bIDLInterface = new IDLInterface();
        StringTokenizer st1 = new StringTokenizer(stringIDLContent,"{");
        
        // here we should get n tokens
        // n-2 tokens are standing for the names of a modul
        // the token with the index n-1 could contain the interface description if an interface is defined in the current
        // IDL file
        // the token with the index n contains the rest of the IDL file, in case of an interface we will find the
        // descriptions of the methods in this token
        
        int  tokens = st1.countTokens();
        for(int i=0; i< tokens-2; i++) {
            // creating the name package in which the interface is located
            QualifierString = QualifierString + st1.nextToken().trim().substring(7)+".";
        }
        
        // I have to store the next token into a variable, because it could be a description of an
        // interface. If the token does not start with the key word interface,
        // then the IDL file doe not contain an interface and wie have to return a null pointer
        
        String Description_of_Inter = st1.nextToken();
        
        // test if the IDL file contains an interface
        
        
        if (!Description_of_Inter.trim().startsWith("interface")) return null;
        
        StringTokenizer st2 = new StringTokenizer(Description_of_Inter,":");
        
        // st2 contains two or more tokens
        // - first token - keyword interface and the name of the interface
        // - second and following tokens - parts of the names of all the interfaces form which the interface has inherited his behavior
        // - the program should not touch those tokens, because the content makes no sense
        
        // only the name will be copyed into the Qulifierstring
        QualifierString = QualifierString + st2.nextToken().trim().substring(10);
        
        bIDLInterface.setName(Identifier.create(QualifierString));
        
        // split the rest of the IDL file into pieces
        StringTokenizer st3 = new StringTokenizer(st1.nextToken(),"}");
        
        // st3 should countain at least m = n-1 tokens(n-1 comes from the st1), because we have the closing bracets for the module and the interfaces
        // in the first token we will find the body of the interface which contains the definition of methodes and attributes
        
        // split the  body of the interface into lines
        StringTokenizer st4 = new StringTokenizer(st3.nextToken(),";");
        
        // each token of static st4 should contain a line of the interface description
        // the means the token can consast out of a method descripption and a comment od
        // out of an attribute definition and a comment or only a methode descripotion or
        // only an attribute description
        // The comment belongs to the line before, and will appear at the start of the next line
        // the Token with the index n is an empty string
        
        // that means - the first step we have to do is to remove the comments at the end of the line
        // and store the lines into an array
        
        tokens = st4.countTokens();
        
        aTokens = new String[tokens-1];
        for(int z=0; z < tokens-1; z++) {
            aTokens[z] = st4.nextToken();
            
        }
        
        
        // the next step is to run through every element of the array and check if it is a Methode
        // if the line ends with ); - than the line contains a methode defenition
        
        for(int j=0; j < aTokens.length ; j++) {
            
            //we will parse methods only
            if  (aTokens[j].endsWith(")")) {
                String s5;
                
                MethodElement aMethodeElement = new MethodElement();
                
                // at first we have to take care of the exception
                if  (aTokens[j].indexOf("raises") != -1) {
                    s5 = aTokens[j].substring(0,aTokens[j].indexOf("raises")-2);
                    String s5b = aTokens[j].substring(aTokens[j].indexOf("raises") + 6);
                    
                    //if s5b not 0 - then we have to deal with the exceptions
                    if (s5b.length() != 0 ) {
                        String s6 = s5b.trim().substring(1);
                        s6 = s6.substring(0,s6.length()-1);
                        StringTokenizer stt6 = new StringTokenizer(s6,",");
                        int btokens =  stt6.countTokens();
                        Identifier[] aExceptions = new Identifier[btokens];
                        for(int a=0; a <  btokens;a++) {
                            aExceptions[a] = Identifier.create(OOTools.replaceSubStrings(stt6.nextToken().trim(),"::", "."));
                        }
                        try {
                            aMethodeElement.setExceptions(aExceptions);
                        }catch (Exception e){
                            System.out.println( e );
                        }
                    }
                } else  s5 = aTokens[j].substring(0,aTokens[j].length()-1);
                
                // s5 contains only the methode without an exception
                // it is possible the the line starts with a comment
                // which was inserted at the end of the line before
                
                StringTokenizer st5 = new StringTokenizer(s5,"(");
                
                // if we have a methode with has no parameter - st5 will contain only one token
                // it does no matter if the method raises a eception or not.
                // that means we have to test the token count
                // we have to care about the parameters only if the count is 2
                
                StringTokenizer st6 = new StringTokenizer(st5.nextToken().trim()," ");
                
                
                // after we have created st6 - n tokens
                // n should be the name of the function
                // n - 1 is definitely the return type of the function
                // n - 2 could be a modifier or the keyword oneway or simply a
                // word of a comment
                // n-3 to 0 all stuff we do not need
                
                
                int ctokens = st6.countTokens();
                
                String returnType = null;
                
                try {
                    if (ctokens > 3)
                    { for(int b=0; b < ctokens-3;b++) {
                          st6.nextToken();
                      }
                    }
                    if (ctokens>=3) {
                        // this could be the modifier
                        String ModifierString = st6.nextToken();
                        if ((ModifierString=="public") || (ModifierString=="protected") || (ModifierString=="private")) {
                            if (ModifierString=="public") aMethodeElement.setModifiers(java.lang.reflect.Modifier.PUBLIC);
                            if (ModifierString=="protected") aMethodeElement.setModifiers(java.lang.reflect.Modifier.PROTECTED);
                            if (ModifierString=="private") aMethodeElement.setModifiers(java.lang.reflect.Modifier.PRIVATE);
                        }else{aMethodeElement.setModifiers(java.lang.reflect.Modifier.PUBLIC); }
                        
                    }
                    if (ctokens==2) aMethodeElement.setModifiers(java.lang.reflect.Modifier.PUBLIC);
                    returnType = st6.nextToken();
                    aMethodeElement.setName(Identifier.create(st6.nextToken()));
                    String sss = this.mapParameterTypes(returnType);
                    aMethodeElement.setReturn(Type.parse(this.mapParameterTypes(returnType)));
                    
                    
                }catch (Exception e){
                    System.out.println( e );
                };
                
                // test how many tokens are left over in st5
                if (st5.countTokens()== 1) {
                    // due to the fact that st5 still contains one token, we have to take care of the parameters
                    st6 = new StringTokenizer(st5.nextToken(),",");
                    tokens = st6.countTokens();
                    
                    org.openide.src.MethodParameter[] aMethodeParameters = new org.openide.src.MethodParameter[tokens];
                    for(int k=0; k < tokens;k++)
                    {  String aTypeString;
                       StringTokenizer st7 = new StringTokenizer(st6.nextToken().trim()," ");
                       // now we have the certain parameter
                       String Direction = st7.nextToken();
                       
                       if (Direction.indexOf("out")!= -1) aTypeString = "sequence<" + st7.nextToken()+">";
                       else   aTypeString = st7.nextToken();
                       String bString = st7.nextToken();
                       aMethodeParameters[k] = new org.openide.src.MethodParameter(bString, Type.parse(this.mapParameterTypes(aTypeString)), false);
                    }
                    try {
                        aMethodeElement.setParameters(aMethodeParameters);
                    } catch (Exception e){
                        System.out.println( e );
                    }
                }
                try {
                    // Define an empty return command.
                    String stringReturnCommand = "";
                    
                    // Test if return type is not void.
                    if ( !returnType.equals( "void" ) ) {
                        // Get the Java type of the method.
                        String stringJavaType = this.mapParameterTypes(
                        returnType );
                        
                        if ( ( stringJavaType.equals( "short" )
                        || ( stringJavaType.equals( "int" ) )
                        || ( stringJavaType.equals( "long" ) )
                        || ( stringJavaType.equals( "float" ) )
                        || ( stringJavaType.equals( "double" ) )
                        || ( stringJavaType.equals( "char" ) )
                        || ( stringJavaType.equals( "byte" ) ) ) ) {
                            stringReturnCommand = "\nreturn 0;\n";
                        }
                        else if ( stringJavaType.equals( "boolean" ) ) {
                            stringReturnCommand = "\nreturn false;\n";
                        }
                        else {
                            stringReturnCommand = "\nreturn null;\n";
                        }
                    }
                    
                    aMethodeElement.setBody(
                    "\n\n\n// ToDo: Please insert your implementation code "
                    + "here.\n\n" + stringReturnCommand );
                    IDLMethod aIDLMethod = new IDLMethod();
                    aIDLMethod.setMethod(aMethodeElement);
                    bIDLInterface.addIDLMethod(aIDLMethod);
                } catch (Exception e){
                    System.out.println( e );
                }
                
            }
        }
        
        return bIDLInterface;
        
    }
    
    public String mapParameterTypes(String TypeString) {
        Hashtable hashtableIDLJava = new Hashtable();
        hashtableIDLJava.put( "boolean", "boolean" );
        hashtableIDLJava.put( "short", "short" );
        hashtableIDLJava.put( "unsigned short", "short" );
        hashtableIDLJava.put( "long", "int" );
        hashtableIDLJava.put( "unsigned long", "int" );
        hashtableIDLJava.put( "hyper", "long" );
        hashtableIDLJava.put( "unsigned hyper", "long" );
        hashtableIDLJava.put( "float", "float" );
        hashtableIDLJava.put( "double", "double" );
        hashtableIDLJava.put( "char", "char" );
        hashtableIDLJava.put( "byte", "byte" );
        hashtableIDLJava.put( "string", "java.lang.String" );
        //        hashtableIDLJava.put( "any", "com.sun.star.uno.Any" );
        hashtableIDLJava.put( "any", "java.lang.Object" );
        hashtableIDLJava.put( "type", "com.sun.star.uno.Type" );
        hashtableIDLJava.put( "void", "void" );
        hashtableIDLJava.put( "com.sun.star.uno.XInterface", 
        "java.lang.Object" );
        
        String stringJavaType;
        String stringJavaType1;
        
        stringJavaType = OOTools.replaceSubStrings(TypeString,"::",".");
        if (stringJavaType.startsWith("sequence")) {
            stringJavaType = stringJavaType.substring(9);
            stringJavaType = stringJavaType.substring(0,stringJavaType.length()-1);
            stringJavaType1 = ( String ) hashtableIDLJava.get( stringJavaType );
            if (stringJavaType1 == null) {
                return ( stringJavaType + "[]");
            }else {
                return ( stringJavaType1 + "[]");
            }
        }
        stringJavaType1 = ( String ) hashtableIDLJava.get( stringJavaType );
        if (stringJavaType1 == null) {
            
            return ( stringJavaType);
        }else {
            return ( stringJavaType1);
        }
        
    }
    
}

