/*************************************************************************
 *
 *  $RCSfile: sbadb.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:32:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SBA_SBADB_HXX
#define _SBA_SBADB_HXX

#include <sdb/sdbdb.hxx>

#ifndef _SDB_SDBCONT_HXX //autogen
#include <sdb/sdbcont.hxx>
#endif

#ifndef _SBA_DBOBJENU_HXX
#include "dbobjenu.hxx"
#endif

// Url Definitionen
// Datenbank
/**/
#define SDB_DATABASE_OLD_MARK "explorer/database/"
#define SDB_DATABASE_QUERY_URL "file:///*.sdb#db:Query;*"	// Abfrage
#define SDB_DATABASE_STATEMENT_URL "file:///*.sdb#db:Statement;*"	// SQLStatement zum Ausfuehren in einer datenbank
#define SDB_DATABASE_URL "file:///*.sdb"	// Datenbank
#define SDB_DATABASE_TABLES_URL "file:///*.sdb#db:Table" // TabellenOrdner
#define SDB_DATABASE_TABLE_URL "file:///*.sdb#db:Table;*"	// Tabelle
#define SDB_DATABASE_FORMS_URL "file:///*.sdb#db:Form" // TabellenOrdner
#define SDB_DATABASE_FORM_URL "file:///*.sdb#db:Form;*"	// Tabelle
#define SDB_DATABASE_REPORTS_URL "file:///*.sdb#db:Report" // TabellenOrdner
#define SDB_DATABASE_REPORT_URL "file:///*.sdb#db:Report;*"	// Tabelle
#define SDB_DATABASE_QUERIES_URL "file:///*.sdb#db:Query" //AbfrageOrdner
#define SDB_DATABASE_RELATIONS_URL "file:///*.sdb#db:Relation" //Relationen

// Eintrage fuer ein Statement sind so aufgebaut, da als erstes ein
// Queryname angegeben wird, dieser kann leer sein
// dann /t Native/NotNative /t Statement

// Marks fuer Tabellen und Abfragen
#define SDB_TABLESMARK_HEADER "db:Table"
#define SDB_TABLEMARK_HEADER "db:Table;"
#define SDB_FORMSMARK_HEADER "db:Form"
#define SDB_FORMMARK_HEADER "db:Form;"
#define SDB_REPORTSMARK_HEADER "db:Report"
#define SDB_REPORTMARK_HEADER "db:Report;"
#define SDB_QUERIESMARK_HEADER "db:Query"
#define SDB_QUERYMARK_HEADER "db:Query;"
#define SDB_STATEMENTMARK_HEADER "db:Statement;"
#define SDB_RELATIONMARK_HEADER "db:Relation"
#define SDB_STATEMENT_DELIMETER '\t'

class SbaDBDef;
DECLARE_SDBKEYCONT(SbaDBDefList, SbaDBDef*);
//==================================================================
// SbaDatabase
//==================================================================
class SbaDatabase : public SdbDatabase
{
	friend class SbaDBDef;
	friend class SbaDBDataDef;
	friend class SbaQueryDef;
	friend class SbaObject;
	friend class SbaObjectExt;
	friend class DataBrowserCtrl;
	friend class SbaDataBrowserCtrl;
	friend class SbaFieldDescGenPage;
	friend class SbaXdbDatabase;
	friend class ODatabaseAccessConnection;

	friend class SbaRelationsDocSh;
		// die RelDocShell braucht Zugriff auf AlterRelationlayout und LoadRelationLayout der Basisklasse

protected:
	SbaDBDefList aTableList,
				 aQueryList,
				 aReportList,
				 aFormList;

	SbaDatabase(SdbWorkspace* pObj):SdbDatabase(pObj){};

	void			InsertIntoList(SbaDBDef*);
	void			ReplaceInList(SbaDBDef*);
	void			RemoveFromList(SbaDBDef*);

	virtual BOOL	Create(const String& rName, const String& rTitle, const String& rConnectStr);

public:
	TYPEINFO();
	virtual BOOL AlterConnection(const String& rConnect);
	virtual BOOL Drop();
	virtual BOOL Rename(const String& rName);
	virtual BOOL AlterTitle(const String& rTitle);
	virtual BOOL Refresh(DBObject _eObj);
	// kann die Datenbank freigegeben werden
	virtual BOOL CanRelease();

	virtual SbaDBDef* CreateDBDef(DBObject eObj, const String& rName, BOOL bShowError = TRUE);
	virtual SbaDBDef* OpenDBDef(DBObject eObj, const String& aName, BOOL bShowError = TRUE);
	virtual SbaDBDef* OpenDBDef(const String& rURL, DBObject eDBObjType, BOOL bShowError = TRUE );
	virtual SbaDBDef* OpenDBDef(const String& rURL, BOOL bShowError = TRUE);

	BOOL HasObjectByURL(const String& rURL);

	// Anzeige von Objekten im Browser
	virtual void ShowDBDef(DBObject eObj, const String& rName);
	virtual void ShowDBDef(const String& rURL);
	virtual void ShowStatement(const String& rStatement, BOOL bNative);

	static void CreateDatabaseLink(const String& rDBName, const String& rTitle);
	static void DropDatabaseLink(const String& rDBName);
	static String GetDatabaseNames();
	static String GetDatabaseFilename(const String& rTitle);

	String				ShortenTableName( const String& rName, xub_StrLen nNewLength) const;
	String				CheckTableName(const String &rTableName,const SdbDatabase* pSourceDatabase) const;
	// TypeInformationen
	BOOL				IsTypeNullable(SbaFieldType eFieldType, SbaNumericSize eSizeType) const;
	SdbTypeInfo*		GetTypeInfo(SdbDatabaseType eType, BOOL bCounter = FALSE) const;
	SdbTypeInfo*		GetRowVersionTypeInfo() const;
	SdbTypeInfo*		IsTypeAvailable(SbaFieldType eFieldType, SbaNumericSize eSizeType) const;
	inline SdbTypeInfo* IsTypeAvailable(SbaFieldType eFieldType, UINT32 nLength) const;
	inline BOOL			IsTypeAvailable(SbaFieldType eFieldType) const;
	inline BOOL			IsNumericSizeAvailable(SbaNumericSize eSizeType) const;
	USHORT				CountNumericTypes() const;

	SbaFieldType		GetFieldType(const SdbColumn& rCol) const;
	SbaFieldType		GetFieldType(SdbDatabaseType eType,INT32 nLength) const;

protected:
	virtual BOOL Open();
	virtual void RemoveChildren();
	virtual void RemoveChild(SdbObj* pObj);

private:
	SbaDBDef*		CreateTableDef(const String& rName, BOOL bView, BOOL bShowError);
	SbaDBDef*		CreateQueryDef(const String& rName, BOOL bShowError);
	SbaDBDef*		CreateFormDef(const String& rName, BOOL bShowError);
	SbaDBDef*		CreateReportDef(const String& rName, BOOL bShowError);
	void			UpdateList(DBObject eObj, SbaDBDefList& rList);
};

//------------------------------------------------------------------------------
inline SdbTypeInfo* SbaDatabase::IsTypeAvailable(SbaFieldType eFieldType, UINT32 nLength) const
{
	return IsTypeAvailable(eFieldType, SbaNumericSize(nLength))	;
}
//------------------------------------------------------------------------------
inline BOOL SbaDatabase::IsTypeAvailable(SbaFieldType eFieldType) const
{
	return (eFieldType != dbNumeric) ? IsTypeAvailable(eFieldType, 0) != NULL
									 : CountNumericTypes() > 0;
}
//------------------------------------------------------------------------------
inline BOOL SbaDatabase::IsNumericSizeAvailable(SbaNumericSize eSizeType) const
{
	return IsTypeAvailable(dbNumeric, eSizeType) != NULL;
}

SV_DECL_IMPL_REF(SbaDatabase);

#endif

