/*************************************************************************
 *
 *  $RCSfile: fmtools.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:32:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_FMTOOLS_HXX
#define _SVX_FMTOOLS_HXX

#ifndef __SVX_DBENGINE_HXX__
#include <svx/dbengine.hxx>
#endif

#ifndef _MODEL_HXX
#include <usr/model.hxx>
#endif

#ifndef _USR_AGG_HXX
#include <usr/agg.hxx>
#endif

#ifndef _SV_WINTYPES_HXX //autogen
#include <vcl/wintypes.hxx>
#endif

class WSStringSequence;
class XObjectInputStreamRef;
class XObjectOutputStreamRef;
class XNumberFormatterRef;

XInterface* queryIfaceImpl(UsrUik aUIK, XInterfaceRef xRef);
//XInterface* queryIfaceImpl(UsrUik aUIK, XInterface* pRef);
XInterface* queryAggImpl(UsrUik aUIK, XAggregationRef aRef);
//XInterface* queryAggImpl(UsrUik aUIK, XAggregation* pRef);


#define QUERY_INTERFACE(XIface, xIface)									\
	(XIface*)queryIfaceImpl(XIface::getSmartUik(), xIface)

#define QUERY_INTERFACE_PTR(XIface, pIface)								\
	(XIface*)queryIfaceImpl(XIface::getSmartUik(), pIface)

#define QUERY_AGGREGATION(XIface, xIface)								\
	(XIface*)queryAggImpl(XIface::getSmartUik(), xIface)

#define QUERY_AGGREGATION_PTR(XIface, pIface)							\
	(XIface*)queryAggImpl(XIface::getSmartUik(), pIface)

#define NOTIFY_LISTENERS(listeners, XIface, method, evt)				\
{																		\
	ListenerIterator aIter(listeners);									\
	while (aIter.hasMoreElements())										\
	{																	\
		((XIface*)aIter.next())->method(evt);							\
	}																	\
}


//==================================================================
// FmDBMsgBox
// Fehleranzeige
//==================================================================
enum FmDbStatusKind
{
	 dbWarning,
	 dbReadError,
	 dbWriteError,
	 dbDeleteError,
	 dbConnectError
};


//==================================================================
// FmEnumerationByIndex
// allgemeine enumeration implementierung
//==================================================================
class FmEnumerationByIndex : public XEnumeration,
							 public UsrObject
{
	INT32 nPos;
	XIndexAccessRef m_xAccess;

public:
	FmEnumerationByIndex(XIndexAccess* _pAccess)
		:m_xAccess(_pAccess)
		,nPos(0){}

	SMART_UNO_DECLARATION(FmEnumerationByIndex, UsrObject);

	virtual XInterface* queryInterface(Uik);
	virtual XIdlClassRef getIdlClass();

	virtual BOOL hasMoreElements(void);
	virtual XInterfaceRef nextElement(void);
};


//==================================================================
// Uno Streaming
//==================================================================
const XObjectInputStreamRef& operator >> (const XObjectInputStreamRef& InStream, XubString& rStr);
const XObjectOutputStreamRef& operator << (const XObjectOutputStreamRef& OutStream, const XubString& rStr);

const XObjectInputStreamRef& operator >> (const XObjectInputStreamRef& InStream, WSStringSequence& rStr);
const XObjectOutputStreamRef& operator << (const XObjectOutputStreamRef& OutStream, const WSStringSequence& rStrSeq);


//==================================================================
// DatenbankTypeConversion
//==================================================================
class DBTypeConversion
{
public:
	static XubString toString(const UsrAny& rValue);
	static UsrAny toDBValue(const XNumberFormatterRef& xFormatter, const UsrAny& rValue, UINT16 nFieldType, UINT32 nKey = 0);
	static String toOutputString(const XNumberFormatterRef& xFormatter, const UsrAny& rValue, UINT16 nFieldType, UINT32 nKey);
	static String toInputString(const XNumberFormatterRef& xFormatter, const UsrAny& rValue, UINT16 nFieldType, UINT32 nKey);
};



#endif // _SVX_FMTOOLS_HXX

